/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.convert.log;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.OpInfo;
import kd.bos.id.ID;
import kd.bos.logorm.LogORM;
import kd.bos.metadata.botp.ConvertRuleMetadata;
import kd.bos.metadata.botp.ConvertRuleVer;
import kd.bos.orm.query.QFilter;
import kd.bos.service.botp.convert.log.ConvertLink;
import kd.bos.service.botp.convert.log.ConvertLog;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;

public class AddNewLog
extends ConvertLog {
    private String traceId;
    private String ruleId;
    private LocaleString ruleName;
    private OpInfo opInfo;
    private String sentityNumber;
    private String tentityNumber;
    private Date startTime;
    private Set<ConvertLink> convertLinks = new HashSet<ConvertLink>();

    public String getTraceId() {
        return this.traceId;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public String getRuleId() {
        return this.ruleId;
    }

    public void setRuleId(String ruleId) {
        this.ruleId = ruleId;
    }

    public LocaleString getRuleName() {
        return this.ruleName;
    }

    public void setRuleName(LocaleString ruleName) {
        this.ruleName = ruleName;
    }

    public OpInfo getOpInfo() {
        return this.opInfo;
    }

    public void setOpInfo(OpInfo opInfo) {
        this.opInfo = opInfo;
    }

    public String getSentityNumber() {
        return this.sentityNumber;
    }

    public void setSentityNumber(String sentityNumber) {
        this.sentityNumber = sentityNumber;
    }

    public String getTentityNumber() {
        return this.tentityNumber;
    }

    public void setTentityNumber(String tentityNumber) {
        this.tentityNumber = tentityNumber;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Set<ConvertLink> getConvertLinks() {
        return this.convertLinks;
    }

    public void setConvertLinks(Set<ConvertLink> convertLinks) {
        this.convertLinks = convertLinks;
    }

    public void addNewConvertLog(LogORM logORM, MainEntityType logType) {
        Set<Long> existSBillIds = this.queryExistSBillIds(logORM, logType);
        ArrayList<DynamicObject> logs = new ArrayList<DynamicObject>(this.convertLinks.size());
        for (ConvertLink link : this.getConvertLinks()) {
            if (existSBillIds.contains(link.getSbillid())) continue;
            DynamicObject convertLogObj = new DynamicObject((DynamicObjectType)logType);
            logType.getPrimaryKey().setValueFast((Object)convertLogObj, (Object)ID.genLongId());
            convertLogObj.set("status", (Object)"0");
            convertLogObj.set("taskid", (Object)this.getTaskId());
            convertLogObj.set("username", (Object)RequestContext.get().getUserName());
            OpInfo opInfo = this.getOpInfo();
            if (opInfo == null) {
                opInfo = new OpInfo();
                opInfo.setOpKey(ResManager.loadKDString((String)"\u7a7a", (String)"AddNewLog_1", (String)"bos-mservice-botp", (Object[])new Object[0]));
                opInfo.setOpName(new LocaleString(ResManager.loadKDString((String)"\u7a7a", (String)"AddNewLog_1", (String)"bos-mservice-botp", (Object[])new Object[0])));
                opInfo.setOpType(ResManager.loadKDString((String)"\u7a7a", (String)"AddNewLog_1", (String)"bos-mservice-botp", (Object[])new Object[0]));
            }
            HashSet<String> opTypes = new HashSet<String>(Arrays.asList("push", "pushandsave", "draw", "save", "submit", "audit", "unaudit", "delete"));
            convertLogObj.set("opkey", (Object)opInfo.getOpKey());
            convertLogObj.set("opname", (Object)opInfo.getOpName());
            convertLogObj.set("optype", (Object)(opTypes.contains(opInfo.getOpType()) ? opInfo.getOpType() : "others"));
            convertLogObj.set("opdesc", (Object)("traceid=" + this.getTraceId()));
            convertLogObj.set("opdate", (Object)this.getStartTime());
            convertLogObj.set("sentitynumber", (Object)this.getSentityNumber());
            convertLogObj.set("sbillno", (Object)link.getSbillno());
            convertLogObj.set("sbillid", (Object)link.getSbillid());
            convertLogObj.set("tentitynumber", (Object)this.getTentityNumber());
            convertLogObj.set("convertrulever", (Object)this.getConvertRuleVer());
            convertLogObj.set("convertrulevername", (Object)this.getRuleName());
            convertLogObj.set("convertrule", (Object)this.getRuleId());
            logs.add(convertLogObj);
        }
        logORM.insert(logs);
    }

    private Set<Long> queryExistSBillIds(LogORM logORM, MainEntityType logType) {
        HashSet<Long> existSBillIds = new HashSet<Long>();
        try (DataSet ds = logORM.queryDataSet(logType.getName(), "sbillid", new QFilter[]{new QFilter("taskid", "=", (Object)this.getTaskId())}, 0, 100000);){
            while (ds.hasNext()) {
                Row row = ds.next();
                existSBillIds.add(row.getLong("sbillid"));
            }
            HashSet<Long> hashSet = existSBillIds;
            return hashSet;
        }
    }

    private long getConvertRuleVer() {
        ConvertRuleMetadata ruleMeta;
        Map ruleVer;
        long verId = ConvertRuleVer.getLatestVerId((String)this.getRuleId());
        if (verId == 0L && !(ruleVer = ConvertRuleVer.saveAsVer(Collections.singletonList(ruleMeta = ConvertMetaServiceHelper.loadMeta((String)this.getRuleId(), (boolean)true)))).isEmpty()) {
            verId = (Long)ruleVer.values().iterator().next();
        }
        return verId;
    }
}

