/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.convert.mapping;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.botp.FieldMapItem;
import kd.bos.entity.botp.FieldSumType;
import kd.bos.entity.property.DecimalProp;
import kd.bos.service.botp.convert.SingleRuleContext;
import kd.bos.service.botp.convert.batchrequest.BatchRequestManager;
import kd.bos.service.botp.convert.getscale.IGetScale;
import kd.bos.service.botp.convert.getvaluemode.IGetValueMode;
import kd.bos.service.botp.convert.mapping.IMappingLinkField;
import kd.bos.service.botp.convert.mapping.MappingField;
import kd.bos.service.botp.convert.unionmode.IUnionMode;

public class MappingCtrlField
extends MappingField
implements IMappingLinkField {
    private String ctrlFieldKey;
    private DynamicProperty oldCtrlProp;
    private DynamicProperty ctrlProp;
    private IGetScale getScaleHandler;

    public MappingCtrlField(SingleRuleContext ruleContext, DynamicProperty oldCtrlProp, DynamicProperty ctrlProp, FieldMapItem fieldMapItem) {
        this.targetFieldProp = oldCtrlProp;
        this.oldCtrlProp = oldCtrlProp;
        this.ctrlProp = ctrlProp;
        this.fieldMapItem = fieldMapItem;
        this.ctrlFieldKey = fieldMapItem.getTargetFieldKey();
        BillEntityType mainType = ruleContext.getContext().getTargetMainType();
        IDataEntityProperty oriCtrlProp = mainType.findProperty(this.ctrlFieldKey);
        this.getScaleHandler = oriCtrlProp instanceof DecimalProp ? IGetScale.create(mainType, (DecimalProp)oriCtrlProp) : IGetScale.create(mainType, null);
        this.unionMode = IUnionMode.create(FieldSumType.First);
        IGetValueMode valueMode = IGetValueMode.create(ruleContext, fieldMapItem, oldCtrlProp);
        this.unionMode.setValueMode(valueMode);
        this.vars = new ArrayList();
        this.vars.addAll(this.unionMode.getValueMode().getVars());
    }

    public String getCtrlFieldKey() {
        return this.ctrlFieldKey;
    }

    public DynamicProperty getOldCtrlProp() {
        return this.oldCtrlProp;
    }

    public DynamicProperty getCtrlProp() {
        return this.ctrlProp;
    }

    @Override
    public synchronized void calcAndMappingValue(Map<String, DynamicProperty> fldProperties, List<DynamicObject> sourceRows, DynamicObject activeRow, BatchRequestManager batchRequestManager) {
        BigDecimal value;
        Object mapValue = this.calcMapValue(fldProperties, sourceRows);
        int scale = this.getScaleHandler.getScale(this.getOriCtrlFieldRow(activeRow));
        BigDecimal bigDecimal = value = mapValue == null ? BigDecimal.ZERO : new BigDecimal(String.valueOf(mapValue));
        if (value.scale() != scale) {
            value = value.setScale(scale, 4);
        }
        this.oldCtrlProp.setValueFast((Object)activeRow, (Object)value);
        this.ctrlProp.setValueFast((Object)activeRow, (Object)value);
    }

    private DynamicObject getOriCtrlFieldRow(DynamicObject activeRow) {
        for (DynamicObject parent = activeRow; parent != null; parent = (DynamicObject)parent.getParent()) {
            if (!parent.getDataEntityType().getProperties().containsKey((Object)this.getCtrlFieldKey())) continue;
            return parent;
        }
        return activeRow;
    }
}

