/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.convert.mapping;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.botp.FieldMapItem;
import kd.bos.entity.botp.FieldSumType;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.KDBizException;
import kd.bos.service.botp.convert.SingleRuleContext;
import kd.bos.service.botp.convert.batchrequest.BatchRequestManager;
import kd.bos.service.botp.convert.getvaluemode.IGetValueMode;
import kd.bos.service.botp.convert.mapping.IMappingField;
import kd.bos.service.botp.convert.unionmode.IUnionMode;
import kd.bos.service.botp.convert.var.IVariableMode;
import kd.bos.service.botp.convert.var.SourceFieldVariable;
import kd.bos.service.botp.convert.var.UnknowVariable;

public class MappingField
implements IMappingField {
    protected FieldMapItem fieldMapItem;
    protected DynamicProperty targetFieldProp;
    protected String joinTargetEntityKeys;
    protected IUnionMode unionMode;
    protected String sourceEntryKey;
    protected String sourceSubEntryKey;
    protected String sourceEntityKey;
    protected String joinSourceEntityKeys;
    protected List<IVariableMode> vars = new ArrayList<IVariableMode>();
    protected List<SourceFieldVariable> srcFieldVars = new ArrayList<SourceFieldVariable>(10);

    @Override
    public FieldMapItem getFieldMap() {
        return this.fieldMapItem;
    }

    @Override
    public void setFieldMap(FieldMapItem fieldMap) {
        this.fieldMapItem = fieldMap;
    }

    @Override
    public DynamicProperty getTargetFieldProp() {
        return this.targetFieldProp;
    }

    @Override
    public void setTargetFieldProp(DynamicProperty fieldProp) {
        this.targetFieldProp = fieldProp;
        EntityType entityType = (EntityType)fieldProp.getParent();
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append("billhead").append('|');
        if (entityType instanceof SubEntryType) {
            sBuilder.append(((SubEntryType)entityType).getParent().getName()).append('|');
            sBuilder.append(entityType.getName()).append('|');
        } else if (entityType instanceof EntryType) {
            sBuilder.append(entityType.getName()).append('|');
        }
        this.joinTargetEntityKeys = sBuilder.toString();
    }

    @Override
    public String getJoinTargetEntityKeys() {
        return this.joinTargetEntityKeys;
    }

    @Override
    public FieldSumType getFieldSumType() {
        FieldSumType sumType = this.fieldMapItem.getFieldSumType();
        switch (this.fieldMapItem.getFieldSumType()) {
            case Sum: {
                if (this.getTargetFieldProp() instanceof TextProp) {
                    sumType = FieldSumType.Join;
                    break;
                }
                if (this.getTargetFieldProp() instanceof DecimalProp) break;
                sumType = FieldSumType.First;
                break;
            }
            case Max: {
                if (this.getTargetFieldProp() instanceof DateTimeProp && !this.validateTimeRange()) {
                    sumType = FieldSumType.Date_Max;
                    break;
                }
                if (this.getTargetFieldProp() instanceof DecimalProp) break;
                sumType = FieldSumType.First;
                break;
            }
            case Min: {
                if (this.getTargetFieldProp() instanceof DateTimeProp && !this.validateTimeRange()) {
                    sumType = FieldSumType.Date_Min;
                    break;
                }
                if (this.getTargetFieldProp() instanceof DecimalProp) break;
                sumType = FieldSumType.First;
                break;
            }
            case Average: 
            case Count: {
                if (this.getTargetFieldProp() instanceof DecimalProp) break;
                sumType = FieldSumType.First;
                break;
            }
            case Join: {
                if (!(this.getTargetFieldProp() instanceof DecimalProp)) break;
                sumType = FieldSumType.Sum;
                break;
            }
        }
        return sumType;
    }

    private boolean validateTimeRange() {
        DynamicProperty prop = this.getTargetFieldProp();
        if (prop instanceof DateTimeProp) {
            DateTimeProp timeProp = (DateTimeProp)prop;
            return StringUtils.isNotBlank((CharSequence)timeProp.getRelateDateTimeRange());
        }
        return false;
    }

    @Override
    public IUnionMode getUnionMode() {
        return this.unionMode;
    }

    @Override
    public void setUnionMode(IUnionMode unionMode) {
        this.unionMode = unionMode;
    }

    @Override
    public String getSourceEntryKey() {
        return this.sourceEntryKey;
    }

    @Override
    public String getSourceSubEntryKey() {
        return this.sourceSubEntryKey;
    }

    @Override
    public String getSourceEntityKey() {
        return this.sourceEntityKey;
    }

    @Override
    public String getJoinSourceEntityKeys() {
        return this.joinSourceEntityKeys;
    }

    @Override
    public List<IVariableMode> getVars() {
        return this.vars;
    }

    @Override
    public List<SourceFieldVariable> getSrcFieldVars() {
        return this.srcFieldVars;
    }

    @Override
    public void initialize(SingleRuleContext ruleContext, FieldMapItem fieldMapItem, DynamicProperty fieldProp) {
        this.fieldMapItem = fieldMapItem;
        this.setTargetFieldProp(fieldProp);
        this.unionMode = IUnionMode.create(this.getFieldSumType());
        IGetValueMode valueMode = IGetValueMode.create(ruleContext, fieldMapItem, fieldProp);
        this.unionMode.setValueMode(valueMode);
        this.vars = new ArrayList<IVariableMode>();
        this.vars.addAll(this.unionMode.getValueMode().getVars());
    }

    @Override
    public void compile(SingleRuleContext ruleContext) {
        EntryType srcEntryType;
        this.srcFieldVars = new ArrayList<SourceFieldVariable>(10);
        HashSet<EntryType> srcEntryTypes = new HashSet<EntryType>(1);
        HashSet<SubEntryType> srcSubEntryTypes = new HashSet<SubEntryType>(1);
        for (IVariableMode var : this.vars) {
            if (var instanceof UnknowVariable) {
                String errMessage = String.format(ResManager.loadKDString((String)"\u8f6c\u6362\u89c4\u5219[%1$s]\u914d\u7f6e\u6709\u8bef\uff1a\u5b57\u6bb5%2$s\u7684\u6765\u6e90\u5b57\u6bb5%3$s,\u5728\u6e90\u5355\u4e0a\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u8f6c\u6362\u89c4\u5219", (String)"MappingField_0", (String)"bos-mservice-botp", (Object[])new Object[0]), ruleContext.getRule().getName(), this.targetFieldProp.getDisplayName(), var.getVar());
                throw new KDBizException(errMessage);
            }
            SourceFieldVariable srcFieldVar = (SourceFieldVariable)var;
            if (srcFieldVar == null) continue;
            this.srcFieldVars.add(srcFieldVar);
            EntityType entityType = (EntityType)srcFieldVar.getSourceField().getParent();
            if (entityType instanceof SubEntryType) {
                srcSubEntryTypes.add((SubEntryType)entityType);
                continue;
            }
            if (!(entityType instanceof EntryType)) continue;
            srcEntryTypes.add((EntryType)entityType);
        }
        if (srcEntryTypes.size() > 1) {
            this.throwCompileException(ruleContext);
        } else if (srcSubEntryTypes.size() > 1) {
            this.throwCompileException(ruleContext);
        } else if (srcEntryTypes.size() == 1 && srcSubEntryTypes.size() == 1) {
            srcEntryType = (EntryType)srcEntryTypes.iterator().next();
            SubEntryType srcSubEntryType = (SubEntryType)srcSubEntryTypes.iterator().next();
            if (!srcSubEntryType.getParent().getName().equals(srcEntryType.getName())) {
                this.throwCompileException(ruleContext);
            }
            this.sourceEntryKey = srcSubEntryType.getParent().getName();
            this.sourceEntityKey = this.sourceSubEntryKey = srcSubEntryType.getName();
        } else if (srcSubEntryTypes.size() == 1) {
            SubEntryType srcSubEntryType = (SubEntryType)srcSubEntryTypes.iterator().next();
            this.sourceEntryKey = srcSubEntryType.getParent().getName();
            this.sourceEntityKey = this.sourceSubEntryKey = srcSubEntryType.getName();
        } else if (srcEntryTypes.size() == 1) {
            srcEntryType = (EntryType)srcEntryTypes.iterator().next();
            this.sourceEntityKey = this.sourceEntryKey = srcEntryType.getName();
        } else if (!this.srcFieldVars.isEmpty()) {
            this.sourceEntityKey = ruleContext.getContext().getSourceMainType().getName();
        }
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append("billhead").append('|');
        if (StringUtils.isNotBlank((CharSequence)this.sourceSubEntryKey)) {
            sBuilder.append(this.sourceEntryKey).append('|');
            sBuilder.append(this.sourceSubEntryKey).append('|');
        } else if (StringUtils.isNotBlank((CharSequence)this.sourceEntryKey)) {
            sBuilder.append(this.sourceEntryKey).append('|');
        }
        this.joinSourceEntityKeys = sBuilder.toString();
    }

    private void throwCompileException(SingleRuleContext ruleContext) {
        HashSet<String> srcFldNames = new HashSet<String>(2);
        for (SourceFieldVariable var : this.srcFieldVars) {
            if (var.getSourceField() != null && var.getSourceField().getDisplayName() != null) {
                srcFldNames.add(var.getSourceField().getDisplayName().toString());
                continue;
            }
            srcFldNames.add(var.getVar());
        }
        String errMessage = MessageFormat.format(ResManager.loadKDString((String)"\u8f6c\u6362\u89c4\u5219[{0}]\u914d\u7f6e\u6709\u8bef\uff1a[{1}]\u53d6\u503c\u516c\u5f0f\u7528\u5230\u4e86\u591a\u4e2a\u5355\u636e\u4f53\u4e0b\u5b57\u6bb5[{2}]\uff0c\u7cfb\u7edf\u65e0\u6cd5\u540c\u65f6\u4ece\u591a\u4e2a\u5355\u636e\u4f53\u4ea4\u53c9\u53d6\u503c\u8fd0\u7b97\uff0c\u8bf7\u4fee\u6539\u4e3a\u4ece\u5355\u4e00\u5355\u636e\u4f53\u53d6\u6570\uff0c\u6216\u6539\u7528\u8f6c\u6362\u63d2\u4ef6\u7ed9\u5b57\u6bb5\u8d4b\u503c", (String)"MappingField_2", (String)"bos-mservice-botp", (Object[])new Object[0]), ruleContext.getRule().getName(), this.targetFieldProp.getDisplayName(), StringUtils.join((Object[])srcFldNames.toArray(), (String)","));
        throw new KDBizException(errMessage);
    }

    @Override
    public synchronized Object calcMapValue(Map<String, DynamicProperty> fldProperties, List<DynamicObject> sourceRows) {
        return this.unionMode.getValue(fldProperties, sourceRows);
    }

    @Override
    public synchronized void calcAndMappingValue(Map<String, DynamicProperty> fldProperties, List<DynamicObject> sourceRows, DynamicObject activeRow, BatchRequestManager batchRequestManager) {
        Object mapValue = this.calcMapValue(fldProperties, sourceRows);
        this.targetFieldProp.setValueFast((Object)activeRow, mapValue);
    }

    @Override
    public synchronized boolean batchPreCall(Map<String, DynamicProperty> fldProperties, List<DynamicObject> sourceRows, DynamicObject activeRow, BatchRequestManager batchRequestManager) {
        return this.unionMode.batchPreCall(fldProperties, sourceRows);
    }

    public String toString() {
        if (this.targetFieldProp != null) {
            return this.targetFieldProp.getName();
        }
        if (this.fieldMapItem != null) {
            return this.fieldMapItem.getTargetFieldKey();
        }
        return super.toString();
    }
}

