/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.convert.mapping;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntryType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.botp.FieldConvertType;
import kd.bos.entity.botp.FieldMapItem;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.service.botp.convert.SingleRuleContext;
import kd.bos.service.botp.convert.batchrequest.BatchRequestManager;
import kd.bos.service.botp.convert.batchrequest.MultiLangFieldSetValueRequest;
import kd.bos.service.botp.convert.getvaluemode.GetSourceFieldValue;
import kd.bos.service.botp.convert.getvaluemode.IGetValueMode;
import kd.bos.service.botp.convert.mapping.MappingField;
import kd.bos.service.botp.convert.var.IVariableMode;
import kd.bos.service.botp.convert.var.SourceFieldVariable;

public class MappingMultiLangTextField
extends MappingField {
    private IGetValueMode getSrcBillIdHandler;
    private IGetValueMode getSrcRowIdHandler;
    private MuliLangTextProp srcMulLangTextProp;
    private BasedataProp srcBasedataProp;
    private String[] srcRefBDProps;
    private IGetValueMode getSrcBDFieldIdHandler;

    @Override
    public void initialize(SingleRuleContext ruleContext, FieldMapItem fieldMapItem, DynamicProperty fieldProp) {
        super.initialize(ruleContext, fieldMapItem, fieldProp);
        if (fieldMapItem.getFieldConvertType() == FieldConvertType.SourceField && !this.vars.isEmpty()) {
            IVariableMode var = (IVariableMode)this.vars.get(0);
            IDataEntityProperty srcProp = null;
            if (var instanceof SourceFieldVariable) {
                srcProp = ((SourceFieldVariable)var).getSourceField();
            }
            if (srcProp instanceof MuliLangTextProp) {
                this.srcMulLangTextProp = (MuliLangTextProp)srcProp;
            } else if (srcProp instanceof BasedataProp) {
                this.srcBasedataProp = (BasedataProp)srcProp;
                this.srcRefBDProps = ((SourceFieldVariable)var).getRefProps();
                this.getSrcBDFieldIdHandler = new GetSourceFieldValue(ruleContext, this.srcBasedataProp.getName());
                this.getVars().addAll(this.getSrcBDFieldIdHandler.getVars());
            }
            if (srcProp != null) {
                String srcRowIdPropName = "id";
                IDataEntityType srcEntityType = srcProp.getParent();
                if (srcEntityType instanceof SubEntryType) {
                    srcRowIdPropName = String.format("%s.%s.id", srcEntityType.getParent().getName(), srcEntityType.getName());
                } else if (srcEntityType instanceof EntryType) {
                    srcRowIdPropName = String.format("%s.id", srcEntityType.getName());
                }
                this.getSrcRowIdHandler = new GetSourceFieldValue(ruleContext, srcRowIdPropName);
            }
        }
        this.getSrcBillIdHandler = new GetSourceFieldValue(ruleContext, "id");
    }

    @Override
    public synchronized void calcAndMappingValue(Map<String, DynamicProperty> fldProperties, List<DynamicObject> sourceRows, DynamicObject activeRow, BatchRequestManager batchRequestManager) {
        if (this.srcMulLangTextProp == null && this.srcBasedataProp == null) {
            Object mapValue = this.calcMapValue(fldProperties, sourceRows);
            LocaleString localeValue = new LocaleString((String)mapValue);
            this.targetFieldProp.setValueFast((Object)activeRow, (Object)localeValue);
            return;
        }
        Object srcBillId = this.getSrcBillIdHandler.getValue(fldProperties, sourceRows.get(0));
        Object srcRowId = this.getSrcRowIdHandler.getValue(fldProperties, sourceRows.get(0));
        ArrayList<Object> srcRowIds = new ArrayList<Object>(10);
        for (DynamicObject sourceRow : sourceRows) {
            srcRowIds.add(this.getSrcRowIdHandler.getValue(fldProperties, sourceRow));
        }
        MultiLangFieldSetValueRequest setValueRequest = new MultiLangFieldSetValueRequest();
        setValueRequest.setFieldMapItem(this.getFieldMap());
        setValueRequest.setTargetFieldProp(this.getTargetFieldProp());
        setValueRequest.setActiveRow(activeRow);
        setValueRequest.setSrcBillId(srcBillId);
        setValueRequest.setSrcRowId(srcRowId);
        setValueRequest.setSrcRowIds(srcRowIds);
        setValueRequest.setSrcMuliLangTextProp(this.srcMulLangTextProp);
        if (this.srcBasedataProp != null) {
            setValueRequest.setSrcBDProp(this.srcBasedataProp);
            setValueRequest.setSrcRefBDProps(this.srcRefBDProps);
            Object srcBDId = this.getSrcBDFieldIdHandler.getValue(fldProperties, sourceRows.get(0));
            setValueRequest.setSrcBDId(srcBDId);
        }
        batchRequestManager.getBatchMultiLang().getRequests().add(setValueRequest);
    }
}

