/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.convert.mapping;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.botp.FieldConvertType;
import kd.bos.entity.botp.FieldMapItem;
import kd.bos.entity.property.RefBillProp;
import kd.bos.service.botp.convert.SingleRuleContext;
import kd.bos.service.botp.convert.batchrequest.BatchRequestManager;
import kd.bos.service.botp.convert.batchrequest.RefBillFieldSetValueRequest;
import kd.bos.service.botp.convert.mapping.AbstractMappingOrgSplitField;

public class MappingRefBillField
extends AbstractMappingOrgSplitField {
    public RefBillProp getTargetFieldProp() {
        return (RefBillProp)super.getTargetFieldProp();
    }

    @Override
    public void initialize(SingleRuleContext ruleContext, FieldMapItem fieldMapItem, DynamicProperty fieldProp) {
        IDataEntityProperty srcProp;
        super.initialize(ruleContext, fieldMapItem, fieldProp);
        if (fieldMapItem.getFieldConvertType() == FieldConvertType.SourceField && (srcProp = ruleContext.getContext().getSourceMainType().findProperty(fieldMapItem.getSourceFieldKey())) instanceof RefBillProp) {
            String srcOrgFld = ((RefBillProp)srcProp).getOrgProp();
            this.initializeOrgReference(ruleContext, srcOrgFld);
        }
    }

    @Override
    public synchronized Object calcMapValue(Map<String, DynamicProperty> fldProperties, List<DynamicObject> sourceRows) {
        Object mapValue = super.calcMapValue(fldProperties, sourceRows);
        DynamicObjectType refType = (DynamicObjectType)this.getTargetFieldProp().getComplexType();
        if (refType == null) {
            return mapValue;
        }
        return this.getTargetFieldProp().convertPKValueType(refType, mapValue);
    }

    @Override
    public synchronized void calcAndMappingValue(Map<String, DynamicProperty> fldProperties, List<DynamicObject> sourceRows, DynamicObject activeRow, BatchRequestManager batchRequestManager) {
        Object id = this.calcMapValue(fldProperties, sourceRows);
        DynamicObjectType refType = (DynamicObjectType)this.getTargetFieldProp().getComplexType((Object)activeRow);
        if (refType != null && id != null) {
            id = this.getTargetFieldProp().convertPKValueType(refType, id);
        }
        if (this.getTargetFieldProp().getValueComparator().compareValue(id)) {
            this.getTargetFieldProp().getRefIdProp().setValueFast((Object)activeRow, id);
            this.getTargetFieldProp().setValueFast((Object)activeRow, null);
            return;
        }
        RefBillFieldSetValueRequest setValueRequest = new RefBillFieldSetValueRequest();
        setValueRequest.setFieldMapItem(this.getFieldMap());
        setValueRequest.setSrcOrg_GetHandler(this.srcOrgFld_GetHandler);
        setValueRequest.setTargetFieldProp((DynamicProperty)this.getTargetFieldProp());
        setValueRequest.setActiveRow(activeRow);
        setValueRequest.setSourceRefId(id);
        setValueRequest.getSourceRows().addAll(sourceRows);
        batchRequestManager.getBatchRefBill().getRequests().add(setValueRequest);
    }
}

