/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.convert.org;

import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.property.MainOrgProp;
import kd.bos.service.botp.convert.ConvertReportManager;
import kd.bos.service.botp.convert.SingleRuleContext;
import kd.bos.service.botp.convert.SingleRuleResultManager;
import kd.bos.service.botp.convert.org.GetMainOrgForDefaul;
import kd.bos.service.botp.convert.org.GetMainOrgForMapping;
import kd.bos.service.botp.convert.org.GetMainOrgForPushargs;
import kd.bos.service.botp.convert.org.GetMainOrgProcess;
import kd.bos.service.botp.convert.org.HandoverOrgManager;
import kd.bos.service.botp.convert.org.MainOrgContext;
import kd.bos.service.botp.convert.org.MainOrgResult;
import kd.bos.service.botp.convert.org.PermOrgManager;
import kd.bos.service.botp.convert.report.IBuildDetailReport;
import kd.bos.service.business.datamodel.DrawDataModel;

public class SetMainOrgManager {
    private static final String BOS_MSERVICE_BOTP = "bos-mservice-botp";
    private MainOrgContext context;
    private PermOrgManager permOrgManager;
    private HandoverOrgManager handoverOrgManager;
    private GetMainOrgProcess mappingProcess;
    private GetMainOrgProcess pushargsProcess;
    private GetMainOrgProcess defaulProcess;

    public SetMainOrgManager(SingleRuleContext ruleContext, SingleRuleResultManager ruleResultManager, MainOrgProp mainOrgProp, DrawDataModel modelProxy, Long defOrgId, IBuildDetailReport buildReport) {
        this.context = new MainOrgContext(ruleContext, ruleResultManager, mainOrgProp, modelProxy, defOrgId, buildReport);
        this.permOrgManager = new PermOrgManager(this.context);
        this.handoverOrgManager = new HandoverOrgManager();
        this.mappingProcess = new GetMainOrgForMapping(this.context, this.permOrgManager, this.handoverOrgManager);
        this.pushargsProcess = new GetMainOrgForPushargs(this.context, this.permOrgManager, this.handoverOrgManager);
        this.defaulProcess = new GetMainOrgForDefaul(this.context, this.permOrgManager, this.handoverOrgManager);
    }

    public boolean setMainOrgForModel(List<DynamicObject> sourceRows) {
        MainOrgResult result = this.getMainOrg(sourceRows);
        if (result.isFail()) {
            if (result.getFailType() == MainOrgResult.FailType.BREAK_REPORT) {
                this.context.getResultManager().getReporter().addBreakMessage(this.context.getRuleContext().getRule(), result.getFailMessage());
            }
            if (result.getFailType() == MainOrgResult.FailType.NORMAL_REPORT) {
                this.addErrorReport(sourceRows, result.getFailMessage());
            }
            this.context.getResultManager().getReporter().addBreakMessage(this.context.getRuleContext().getRule(), ResManager.loadKDString((String)"\u76ee\u6807\u5355\u4e3b\u7ec4\u7ec7\u8d4b\u503c\u5931\u8d25", (String)"CreateTargetBillAction_0", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]));
            return false;
        }
        if (result.getOrgId() != null) {
            this.context.getModelProxy().putContextVariable(this.context.getMainOrgProp().getName(), result.getOrgId());
        }
        return true;
    }

    private MainOrgResult getMainOrg(List<DynamicObject> sourceRows) {
        MainOrgResult resultFromMapping;
        MainOrgResult resultFromParam = this.checkParams(sourceRows);
        if (resultFromParam != null) {
            return resultFromParam;
        }
        this.context.getModelProxy().removeContextVariable("SELECT_ORG_ID");
        this.context.getModelProxy().removeContextVariable(this.context.getMainOrgProp().getName());
        if (this.permOrgManager.isHasRight()) {
            this.context.getModelProxy().putContextVariable("hasright", String.valueOf(true));
        }
        if ((resultFromMapping = this.mappingProcess.getMainOrgId(sourceRows)) != null) {
            return resultFromMapping;
        }
        MainOrgResult resultFromPush = this.pushargsProcess.getMainOrgId(sourceRows);
        if (resultFromPush != null) {
            return resultFromPush;
        }
        MainOrgResult resultFromDef = this.defaulProcess.getMainOrgId(sourceRows);
        if (resultFromDef != null) {
            return resultFromDef;
        }
        return this.buildFailResult();
    }

    @VisibleForTesting
    protected MainOrgResult checkParams(List<DynamicObject> sourceRows) {
        if (this.context.getMainOrgProp() == null) {
            return MainOrgResult.empty();
        }
        if (sourceRows == null || sourceRows.isEmpty()) {
            String failMessage = String.format(ResManager.loadKDString((String)"\u5173\u8054\u6e90\u5355\u4e3b\u5b9e\u4f53%s\u4e0d\u5b58\u5728\u6709\u6548\u6570\u636e\uff1b", (String)"CreateTargetBillAction_22", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]), this.context.getTargetMainType().getDisplayName().toString());
            return MainOrgResult.fail(failMessage, MainOrgResult.FailType.BREAK_REPORT);
        }
        return null;
    }

    private MainOrgResult buildFailResult() {
        if (this.context.getRuleContext().getRuleCompiler().getMappingMainOrg() == null) {
            String failMessage = String.format(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u3010%1$s\u3011\u3010%2$s\u3011\u5b57\u6bb5\u7684\u53d6\u503c\u516c\u5f0f\uff1b", (String)"CreateTargetBillAction_23", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]), this.context.getTargetMainType().getDisplayName().toString(), this.context.getMainOrgProp().getDisplayName().toString());
            return MainOrgResult.fail(failMessage, MainOrgResult.FailType.NORMAL_REPORT);
        }
        return MainOrgResult.empty();
    }

    private void addErrorReport(List<DynamicObject> sourceRows, String failMessage) {
        for (DynamicObject sourceRow : sourceRows) {
            ConvertReportManager reporter = this.context.getResultManager().getReporter();
            this.context.getBuildReport().addErrorReport(reporter, this.context.getLinkEntityMap().getSrcFldPropertys(), sourceRow, failMessage);
        }
    }
}

