/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.convert.query;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.service.botp.convert.query.BotpRefQueryParameter;

public class BotpQueryParameter {
    private String entityNumber;
    private List<String> selectFields = new ArrayList<String>();
    private DynamicObjectType queryEntityType;
    private List<DynamicSimpleProperty> queryProps = new ArrayList<DynamicSimpleProperty>();
    private Map<DynamicSimpleProperty, BotpRefQueryParameter> queryRefIdProps = new HashMap<DynamicSimpleProperty, BotpRefQueryParameter>();
    private Map<String, DynamicSimpleProperty> srcBasedataProps = new HashMap<String, DynamicSimpleProperty>();
    private boolean buildQueryType = false;

    public BotpQueryParameter(String entityNumber, boolean buildQueryType) {
        this.entityNumber = entityNumber;
        this.buildQueryType = buildQueryType;
        this.queryEntityType = new MainEntityType();
        this.queryEntityType.setName("queryObject");
    }

    public String getEntityNumber() {
        return this.entityNumber;
    }

    public String getSelectString() {
        return StringUtils.join((Object[])this.selectFields.toArray(), (String)",");
    }

    public DynamicObjectType getQueryEntityType() {
        return this.queryEntityType;
    }

    public List<DynamicSimpleProperty> getQueryProps() {
        return this.queryProps;
    }

    public Map<DynamicSimpleProperty, BotpRefQueryParameter> getQueryRefIdProps() {
        return this.queryRefIdProps;
    }

    public Map<String, DynamicSimpleProperty> getSrcBasedataProps() {
        return this.srcBasedataProps;
    }

    public void addSelectField(IDataEntityProperty srcFieldProp, String refPropName, String fldAlias) {
        if (!this.buildQueryType) {
            return;
        }
        if (srcFieldProp instanceof ISimpleProperty) {
            this.registerProperty(this.queryEntityType, (ISimpleProperty)srcFieldProp, fldAlias);
        } else if (srcFieldProp instanceof IComplexProperty) {
            this.registerProperty(this.queryEntityType, (IComplexProperty)srcFieldProp, refPropName, fldAlias);
        } else if (srcFieldProp instanceof ICollectionProperty) {
            this.registerProperty(this.queryEntityType, (ICollectionProperty)srcFieldProp, refPropName, fldAlias);
        }
    }

    private String registerProperty(DynamicObjectType dt, ISimpleProperty srcFieldProp, String fldAlias) {
        DynamicProperty sp = dt.getProperty(fldAlias);
        if (sp == null) {
            DynamicSimpleProperty property;
            Class<String> propertyType = srcFieldProp.getPropertyType();
            if (propertyType == ILocaleString.class) {
                propertyType = String.class;
            }
            if (srcFieldProp instanceof ItemClassTypeProp) {
                ItemClassTypeProp newProp = new ItemClassTypeProp();
                ItemClassTypeProp srcProp = (ItemClassTypeProp)srcFieldProp;
                newProp.setBaseEntityIds(srcProp.getBaseEntityIds());
                newProp.setComboItems(srcProp.getComboItems());
                newProp.getItemTypes().putAll(srcProp.getItemTypes());
                newProp.setName(fldAlias);
                property = newProp;
            } else {
                property = new DynamicSimpleProperty(fldAlias, propertyType, null);
            }
            property.setPrimaryKey(srcFieldProp.isPrimaryKey());
            property.setDbType(srcFieldProp.getDbType());
            sp = dt.registerSimpleProperty(property);
            this.selectFields.add(this.buildFullPropName((IDataEntityProperty)srcFieldProp) + " " + fldAlias);
            this.queryProps.add(property);
        }
        return fldAlias;
    }

    private String registerProperty(DynamicObjectType dt, IComplexProperty srcFieldProp, String refPropName, String fldAlias) {
        DynamicProperty rp;
        DynamicSimpleProperty refIdProp = this.srcBasedataProps.get(srcFieldProp.getName());
        if (refIdProp == null) {
            String refIdPropName = null;
            refIdPropName = StringUtils.isBlank((CharSequence)refPropName) ? fldAlias : srcFieldProp.getName() + "_id";
            refIdProp = new DynamicSimpleProperty(refIdPropName, ((BasedataProp)srcFieldProp).getRefIdProp().getPropertyType(), null);
            dt.registerSimpleProperty(refIdProp);
            this.selectFields.add(this.buildFullPropName((IDataEntityProperty)srcFieldProp) + " " + refIdPropName);
            this.queryProps.add(refIdProp);
            this.srcBasedataProps.put(srcFieldProp.getName(), refIdProp);
        }
        if ((rp = dt.getProperty(fldAlias)) == null) {
            MainEntityType refType;
            List<DynamicProperty> refProps;
            if (StringUtils.isBlank((CharSequence)refPropName)) {
                refPropName = "id";
            }
            if (!(refProps = this.findPropertys(refType = (MainEntityType)((BasedataProp)srcFieldProp).getComplexType(), refPropName, true)).isEmpty()) {
                DynamicProperty oldRefProp = refProps.get(refProps.size() - 1);
                DynamicSimpleProperty newRefProp = new DynamicSimpleProperty(fldAlias, oldRefProp.getPropertyType(), null);
                dt.registerSimpleProperty(newRefProp);
                BotpRefQueryParameter refQueryParameter = this.getQueryRefIdProps().get(refIdProp);
                if (refQueryParameter == null) {
                    refQueryParameter = new BotpRefQueryParameter(refType.getName(), srcFieldProp, refIdProp);
                    this.getQueryRefIdProps().put(refIdProp, refQueryParameter);
                }
                refQueryParameter.addSelectProp(refPropName, fldAlias);
            }
        }
        return fldAlias;
    }

    private String registerProperty(DynamicObjectType dt, ICollectionProperty srcFieldProp, String refPropName, String fldAlias) {
        MainEntityType refType;
        List<DynamicProperty> refProps;
        if (!(srcFieldProp instanceof MulBasedataProp)) {
            return null;
        }
        MulBasedataProp mulBasedataProp = (MulBasedataProp)srcFieldProp;
        IComplexProperty bdProp = mulBasedataProp.getRefBaseProp();
        if (bdProp == null) {
            return null;
        }
        DynamicSimpleProperty refIdProp = this.srcBasedataProps.get(srcFieldProp.getName());
        if (refIdProp == null) {
            String refIdPropName = null;
            refIdPropName = StringUtils.isBlank((CharSequence)refPropName) ? fldAlias : srcFieldProp.getName() + "_id";
            refIdProp = new DynamicSimpleProperty(refIdPropName, mulBasedataProp.getRefIdProp().getPropertyType(), null);
            dt.registerSimpleProperty(refIdProp);
            this.selectFields.add(this.buildFullPropName((IDataEntityProperty)srcFieldProp) + " " + refIdPropName);
            this.queryProps.add(refIdProp);
            this.srcBasedataProps.put(srcFieldProp.getName(), refIdProp);
        }
        DynamicProperty rp = dt.getProperty(fldAlias);
        if (StringUtils.isNotBlank((CharSequence)refPropName) && rp == null && !(refProps = this.findPropertys(refType = (MainEntityType)((BasedataProp)srcFieldProp).getComplexType(), refPropName, true)).isEmpty()) {
            DynamicProperty oldRefProp = refProps.get(refProps.size() - 1);
            DynamicSimpleProperty newRefProp = new DynamicSimpleProperty(fldAlias, oldRefProp.getPropertyType(), null);
            dt.registerSimpleProperty(newRefProp);
            BotpRefQueryParameter refQueryParameter = this.getQueryRefIdProps().get(refIdProp);
            if (refQueryParameter == null) {
                refQueryParameter = new BotpRefQueryParameter(refType.getName(), bdProp, refIdProp);
                this.getQueryRefIdProps().put(refIdProp, refQueryParameter);
            }
            refQueryParameter.addSelectProp(refPropName, fldAlias);
        }
        return fldAlias;
    }

    private String buildFullPropName(IDataEntityProperty prop) {
        if (prop.getParent() instanceof SubEntryType) {
            SubEntryType subEntryType = (SubEntryType)prop.getParent();
            return subEntryType.getParent().getName() + "." + subEntryType.getName() + "." + prop.getName();
        }
        if (prop.getParent() instanceof EntryType) {
            return prop.getParent().getName() + "." + prop.getName();
        }
        return prop.getName();
    }

    private List<DynamicProperty> findPropertys(MainEntityType mainType, String var, boolean throwError) {
        ArrayList<DynamicProperty> props = new ArrayList<DynamicProperty>();
        String[] keys = var.split("\\.");
        MainEntityType parentType = mainType;
        int forCount = 0;
        for (int i = 0; i < keys.length; ++i) {
            DynamicProperty prop = (DynamicProperty)parentType.findProperty(keys[i]);
            if (prop == null && parentType.getProperties().containsKey((Object)keys[i])) {
                prop = parentType.getProperty(keys[i]);
            }
            if (prop == null) break;
            ++forCount;
            if (prop instanceof EntryProp) {
                parentType = (EntityType)((EntryProp)prop).getItemType();
                continue;
            }
            props.add(prop);
            if (!(prop instanceof BasedataProp)) break;
            parentType = (EntityType)((BasedataProp)prop).getComplexType();
        }
        if (throwError && forCount < keys.length) {
            throw new KDException(BosErrorCode.fieldNotExist, new Object[]{mainType.getDisplayName().toString(), var});
        }
        return props;
    }
}

