/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.convert.report;

import java.util.Map;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.service.botp.convert.SingleRuleContext;
import kd.bos.service.botp.convert.getvaluemode.GetSourceFieldValue;
import kd.bos.service.botp.convert.getvaluemode.IGetValueMode;
import kd.bos.service.botp.convert.group.SourceRowId;
import kd.bos.service.botp.convert.report.BuildEntryReport;

class BuildSubEntryReport
extends BuildEntryReport {
    protected String subEntryKey;
    protected String subEntryName;
    protected IGetValueMode subEntryPKValHandler;
    protected IGetValueMode subEntrySeqValHandler;

    BuildSubEntryReport() {
    }

    @Override
    protected String getSubEntryKey() {
        return this.subEntryKey;
    }

    @Override
    protected String getSubEntryName() {
        return this.subEntryName;
    }

    @Override
    public void initialize(SingleRuleContext ruleContext, EntityType entityType) {
        super.initialize(ruleContext, (EntityType)((EntryType)entityType.getParent()));
        this.entityType = entityType;
        this.entityName = entityType.getDisplayName().toString();
        this.subEntryKey = entityType.getName();
        this.subEntryName = entityType.getDisplayName().toString();
        String fullEntityKey = entityType.getParent().getName() + "." + entityType.getName();
        this.subEntryPKValHandler = new GetSourceFieldValue(ruleContext, fullEntityKey + ".id");
        this.subEntrySeqValHandler = new GetSourceFieldValue(ruleContext, fullEntityKey + ".seq");
    }

    @Override
    public SourceRowId buildRowInfo(Map<String, DynamicProperty> fldProperties, DynamicObject sourceRow) {
        SourceRowId rowId = super.buildRowInfo(fldProperties, sourceRow);
        rowId.setSubEntryId(this.subEntryPKValHandler.getValue(fldProperties, sourceRow));
        rowId.setSubEntrySeq(this.getEntrySeq(this.subEntrySeqValHandler, fldProperties, sourceRow));
        return rowId;
    }

    @Override
    public SourceRowId buildRowInfo(Map<String, String> fldAlias, Row row) {
        SourceRowId rowId = super.buildRowInfo(fldAlias, row);
        rowId.setSubEntryId(this.subEntryPKValHandler.getValue(fldAlias, row));
        rowId.setSubEntrySeq(this.getEntrySeq(this.subEntrySeqValHandler, fldAlias, row));
        return rowId;
    }
}

