/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.convert.sort;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.service.botp.convert.SingleRuleContext;
import kd.bos.service.botp.convert.compiler.LinkEntityMap;
import kd.bos.service.botp.convert.getvaluemode.GetSourceFieldValue;
import kd.bos.service.botp.convert.getvaluemode.IGetValueMode;
import kd.bos.service.botp.convert.group.SourceRowId;
import kd.bos.service.botp.convert.sort.ISortKeyBuilder;
import kd.bos.service.botp.convert.sort.SourceRowSortKey;

class EntrySortKeyBuilder
implements ISortKeyBuilder {
    protected IGetValueMode pkValHandler;
    protected IGetValueMode entryPKValHandler;

    EntrySortKeyBuilder() {
    }

    @Override
    public void initialize(SingleRuleContext ruleContext, LinkEntityMap linkEntityMap, ListSelectedRow firstSelectedRow) {
        this.pkValHandler = new GetSourceFieldValue(ruleContext, "id");
        this.entryPKValHandler = new GetSourceFieldValue(ruleContext, linkEntityMap.getSourceEntryPKFullName());
    }

    @Override
    public SourceRowSortKey buildSortKey(ListSelectedRow selectedRow) {
        Object[] fldValues = new Object[]{selectedRow.getPrimaryKeyValue(), selectedRow.getEntryPrimaryKeyValue()};
        return new SourceRowSortKey(fldValues);
    }

    @Override
    public SourceRowSortKey buildSortKey(Map<String, DynamicProperty> fldProperties, DynamicObject sourceRow) {
        Object[] fldValues = new Object[]{this.pkValHandler.getValue(fldProperties, sourceRow), this.entryPKValHandler.getValue(fldProperties, sourceRow)};
        return new SourceRowSortKey(fldValues);
    }

    @Override
    public SourceRowSortKey buildSortKey(SourceRowId sourceRowId) {
        Object[] fldValues = new Object[]{sourceRowId.getBillId(), sourceRowId.getEntryId()};
        return new SourceRowSortKey(fldValues);
    }
}

