/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.track;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.LinkSetElement;
import kd.bos.entity.LinkSetItemElement;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.WriteBackRuleElement;
import kd.bos.entity.botp.plugin.WriteBackPlugInProxy;
import kd.bos.entity.botp.plugin.args.PreparePropertysEventArgs;
import kd.bos.entity.botp.runtime.AllBusEntityCountInfo;
import kd.bos.entity.function.FunctionManage;
import kd.bos.entity.operate.OperateLog;
import kd.bos.entity.operate.OperateProgressCache;
import kd.bos.entity.operate.OperationContext;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.param.ParameterReader;
import kd.bos.service.botp.convert.report.WritebackReport;
import kd.bos.service.botp.track.BFTrackerOpType;
import kd.bos.service.botp.track.helper.BFTrackerDbService;
import kd.bos.service.botp.track.helper.TrackerTypes;
import kd.bos.service.botp.track.helper.WRuleCompiler;
import kd.bos.service.botp.track.helper.WRuleItemCompiler;
import kd.bos.servicehelper.botp.WriteBackMetaServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.botp.CustomParamsUtil;

public class BFTrackerContext {
    private static final String BILL_PARAM_OP_EXECUTE_LOG = "opexecutelog";
    public static final String KEY_BILLID = "billid";
    private BillEntityType targetMainType;
    private BillEntityType targetSubMainType;
    private BillEntityType localSubMainType;
    private MainEntityType botpLinkLogType;
    private Map<String, EntryType> localSubEntryTypes = new HashMap<String, EntryType>(0);
    private Set<Object> targetBillIds = new HashSet<Object>(1);
    private LinkSetElement linkSet;
    private String statusFldKey;
    private Map<Long, WRuleCompiler> rules;
    private TrackerTypes trackerTypes;
    private BFTrackerOpType opType;
    private Map<String, Object> opMeta;
    private OperationContext opContext;
    private OperateOption option;
    private OperateLog operateLog;
    private FunctionManage funcLib;
    private WriteBackPlugInProxy plugInProxy;
    private BFTrackerDbService dbService;
    private Boolean isCreateReport;
    public Set<String> bfSourceEntityNumbers = new HashSet<String>(10);
    public Set<String> bfRuleCompilerd = new HashSet<String>(10);
    private AllBusEntityCountInfo allBusEntityCountInfo = new AllBusEntityCountInfo();
    private static final Log LOG = LogFactory.getLog(BFTrackerContext.class);
    private boolean botpLinkLog = true;
    private boolean ignoreNoUseSb = false;

    public boolean isIgnoreNoUseSb() {
        return this.ignoreNoUseSb;
    }

    public void setIgnoreNoUseSb(boolean ignoreNoUseSb) {
        this.ignoreNoUseSb = ignoreNoUseSb;
    }

    public boolean isBotpLinkLog() {
        return this.botpLinkLog;
    }

    public void setBotpLinkLog(boolean botpLinkLog) {
        this.botpLinkLog = botpLinkLog;
    }

    @Deprecated
    public BFTrackerContext(BillEntityType mainType, BFTrackerOpType opType, Map<String, Object> opMeta, OperationContext opContext) {
        this(mainType, opType, opMeta, opContext, OperateOption.create());
    }

    public BFTrackerContext(BillEntityType mainType, BFTrackerOpType opType, Map<String, Object> opMeta, OperationContext opContext, OperateOption option) {
        this.targetMainType = mainType;
        this.opType = opType;
        this.opMeta = opMeta;
        this.opContext = opContext;
        this.option = option;
        this.funcLib = FunctionManage.get();
        this.botpLinkLogType = this.getBotpLinkLogType();
        this.isCreateReport = WritebackReport.getIsCreateReport(mainType.getName());
        this.setCustomerParams();
        if (this.opContext != null) {
            this.operateLog = this.opContext.getOperateLog();
        } else {
            DynamicObject billParamObj = ParameterReader.getBillParameter((String)mainType.getName());
            boolean opExecuteLog = false;
            if (billParamObj != null && billParamObj.getDataEntityType().getProperties().containsKey((Object)BILL_PARAM_OP_EXECUTE_LOG)) {
                opExecuteLog = billParamObj.getBoolean(BILL_PARAM_OP_EXECUTE_LOG);
            }
            this.operateLog = OperateLog.get((boolean)opExecuteLog);
        }
    }

    public BFTrackerDbService getDbService() {
        return this.dbService;
    }

    public void setDbService(BFTrackerDbService dbService) {
        this.dbService = dbService;
    }

    public BillEntityType getTargetMainType() {
        return this.targetMainType;
    }

    public void setTargetMainType(BillEntityType targetMainType) {
        this.targetMainType = targetMainType;
    }

    public MainEntityType getBotpLinkLogType() {
        if (this.botpLinkLogType == null) {
            MainEntityType mainEntityType;
            this.botpLinkLogType = mainEntityType = EntityMetadataCache.getDataEntityType((String)"botp_lk_log");
        }
        return this.botpLinkLogType;
    }

    public void setBotpLinkLogType(BillEntityType botpLinkLogType) {
        this.botpLinkLogType = botpLinkLogType;
    }

    public Set<Object> getTargetBillIds() {
        return this.targetBillIds;
    }

    public BillEntityType getTargetSubMainType() {
        return this.targetSubMainType;
    }

    public void setTargetSubMainType(BillEntityType targetSubMainType) {
        this.targetSubMainType = targetSubMainType;
    }

    public BillEntityType getLocalSubMainType() {
        return this.localSubMainType;
    }

    public Map<String, EntryType> getLocalSubEntryTypes() {
        return this.localSubEntryTypes;
    }

    public LinkSetElement getLinkSet() {
        return this.linkSet;
    }

    public void setLinkSet(LinkSetElement linkSet) {
        this.linkSet = linkSet;
    }

    public Map<Long, WRuleCompiler> getAllCurrRules(boolean isAfterPrepareProperty) {
        Map<Object, Object> allCurrRules = new HashMap(16);
        allCurrRules = this.isIgnoreNoUseSb() ? this.getRules(isAfterPrepareProperty) : this.getRules();
        return allCurrRules;
    }

    public synchronized Map<Long, WRuleCompiler> getRules() {
        if (this.rules == null) {
            this.rules = this.loadWriteBackRules();
        }
        return this.rules;
    }

    public synchronized Map<Long, WRuleCompiler> getRules(boolean isAfterPrepareProperty) {
        if (this.rules == null) {
            this.rules = this.loadWriteBackRules(isAfterPrepareProperty);
        }
        for (Map.Entry<Long, WRuleCompiler> entry : this.rules.entrySet()) {
            WRuleCompiler wRuleCompiler = entry.getValue();
            WriteBackRuleElement rule = entry.getValue().getRule();
            if (!wRuleCompiler.isOnlyFormulas()) continue;
            Long verId = entry.getKey();
            if (CollectionUtils.isNotEmpty(this.bfSourceEntityNumbers) && !this.bfSourceEntityNumbers.contains(wRuleCompiler.getSourceEntityNumber()) || isAfterPrepareProperty) continue;
            this.rules.put(verId, new WRuleCompiler(this, verId, wRuleCompiler.getRule(), (BillEntityType)EntityMetadataCache.getDataEntityType((String)rule.getSourceEntityNumber())));
        }
        return this.rules;
    }

    public TrackerTypes getTrackerTypes() {
        return this.trackerTypes;
    }

    public void setTrackerTypes(TrackerTypes trackerTypes) {
        this.trackerTypes = trackerTypes;
    }

    public BFTrackerOpType getOpType() {
        return this.opType;
    }

    public void setOpType(BFTrackerOpType operationType) {
        this.opType = operationType;
    }

    public Map<String, Object> getOpMeta() {
        return this.opMeta;
    }

    public void setOpMeta(Map<String, Object> opMeta) {
        this.opMeta = opMeta;
    }

    public String getStatusFldKey() {
        return this.statusFldKey;
    }

    public void setStatusFldKey(String statusFldKey) {
        this.statusFldKey = statusFldKey;
    }

    public OperationContext getOpContext() {
        return this.opContext;
    }

    public void setOpContext(OperationContext opContext) {
        this.opContext = opContext;
    }

    public AllBusEntityCountInfo getAllBusEntityCountInfo() {
        return this.allBusEntityCountInfo;
    }

    public void setAllBusEntityCountInfo(AllBusEntityCountInfo allBusEntityCountInfo) {
        this.allBusEntityCountInfo = allBusEntityCountInfo;
    }

    public OperateOption getOption() {
        return this.option;
    }

    public void setOption(OperateOption option) {
        this.option = option;
    }

    public Boolean getCreateReport() {
        return this.isCreateReport;
    }

    public void setCreateReport(Boolean createReport) {
        this.isCreateReport = createReport;
    }

    public OperateLog getOperateLog() {
        if (this.operateLog == null) {
            this.operateLog = OperateLog.get((boolean)false);
        }
        return this.operateLog;
    }

    public void setOperateLog(OperateLog operateLog) {
        this.operateLog = operateLog;
    }

    public WriteBackPlugInProxy getPlugInProxy() {
        return this.plugInProxy;
    }

    public void createPlugInProxy() {
        this.plugInProxy = new WriteBackPlugInProxy(this.linkSet.getPlugIns());
        this.getPlugInProxy().setCreateReport(this.isCreateReport);
    }

    public FunctionManage getFuncLib() {
        return this.funcLib;
    }

    public void buildLocalSubMainType() {
        this.localSubEntryTypes.clear();
        this.localSubMainType = BFTrackerContext.buildLocalSubMainType(this.targetSubMainType, null, this.localSubEntryTypes);
    }

    public static BillEntityType buildLocalSubMainType(BillEntityType subMainType, Set<String> selectEntrys, Map<String, EntryType> entityTypes) {
        BillEntityType localSubMainType = null;
        try {
            localSubMainType = (BillEntityType)subMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode("", exp.getMessage()), new Object[0]);
        }
        for (IDataEntityProperty prop : localSubMainType.getProperties()) {
            if (!(prop instanceof EntryProp) || !BFTrackerContext.canBuildLocalEntryType(selectEntrys, prop.getName())) continue;
            EntryType entryType = (EntryType)((EntryProp)prop).getItemType();
            BigIntProp billIdProp = new BigIntProp();
            billIdProp.setName(KEY_BILLID);
            billIdProp.setAlias(localSubMainType.getPrimaryKey().getAlias());
            entryType.registerSimpleProperty((DynamicSimpleProperty)billIdProp);
            EntryType cloneEntryType = null;
            try {
                cloneEntryType = (EntryType)entryType.clone();
            }
            catch (CloneNotSupportedException exp) {
                throw new KDException((Throwable)exp, new ErrorCode("", exp.getMessage()), new Object[0]);
            }
            entryType.setAlias("");
            entityTypes.put(prop.getName(), cloneEntryType);
        }
        return localSubMainType;
    }

    private static boolean canBuildLocalEntryType(Set<String> selectEntrys, String entryKey) {
        if (selectEntrys == null) {
            return true;
        }
        if (selectEntrys.isEmpty()) {
            return true;
        }
        return selectEntrys.contains(entryKey);
    }

    public void preparePropertys(List<String> fieldKeys) {
        ArrayList<String> writebackFldKeys = new ArrayList<String>(4);
        if (StringUtils.isNotBlank((CharSequence)this.getStatusFldKey())) {
            writebackFldKeys.add(this.getStatusFldKey());
        }
        Map<Long, WRuleCompiler> allCurrRules = this.getAllCurrRules(true);
        for (Map.Entry<Long, WRuleCompiler> entryRule : allCurrRules.entrySet()) {
            for (WRuleItemCompiler ruleItem : entryRule.getValue().getItems().values()) {
                for (Map.Entry entry : ruleItem.getTargetFields().entrySet()) {
                    writebackFldKeys.add((String)entry.getKey());
                }
            }
        }
        for (LinkSetItemElement linkSetItem : this.getLinkSet().getItems()) {
            String linkEntryKey = linkSetItem.getLinkEntityKey();
            LinkEntryType linkEntryType = (LinkEntryType)this.getTargetMainType().getAllEntities().get(linkEntryKey);
            for (IDataEntityProperty iDataEntityProperty : linkEntryType.getProperties()) {
                if (iDataEntityProperty.getName().equalsIgnoreCase("id")) continue;
                writebackFldKeys.add(iDataEntityProperty.getName());
            }
            writebackFldKeys.addAll(linkEntryType.getCtrlFieldProps().keySet());
        }
        ArrayList plugFlds = new ArrayList(0);
        this.getPlugInProxy().firePreparePropertys(new PreparePropertysEventArgs(this.getTargetMainType(), plugFlds));
        writebackFldKeys.addAll(plugFlds);
        this.getOperateLog().info("BFTrackerContext.preparePropertys(fieldKeys), add fields:" + ((Object)writebackFldKeys).toString());
        fieldKeys.addAll(writebackFldKeys);
    }

    private void setCustomerParams() {
        Map params = CustomParamsUtil.getWriteBackParams();
        this.setBotpLinkLog((Boolean)params.get("BOS_BOTP_LINK_LOG"));
        this.setIgnoreNoUseSb((Boolean)params.get("BOS_BOTP_IGNORE_NOUSE_SB"));
    }

    private Map<Long, WRuleCompiler> loadWriteBackRules(boolean isAfterPrepareProperty) {
        List rules = WriteBackMetaServiceHelper.loadWriteBackRules((String)this.targetMainType.getName());
        ArrayList<WriteBackRuleElement> normalRules = new ArrayList<WriteBackRuleElement>();
        for (WriteBackRuleElement rule : rules) {
            if (!rule.isNormual()) continue;
            normalRules.add(rule);
        }
        try (TXHandle h = TX.notSupported();){
            HashMap<Long, WRuleCompiler> ruleCompilers = new HashMap<Long, WRuleCompiler>(normalRules.size());
            for (WriteBackRuleElement rule : normalRules) {
                Long verId = WriteBackMetaServiceHelper.saveWriteBackRuleVersion((WriteBackRuleElement)rule);
                WriteBackRuleElement ruleVer = WriteBackMetaServiceHelper.loadWriteBackRuleVersion((long)verId);
                BillEntityType sourceEntityType = null;
                WRuleCompiler ruleCompiler = null;
                ruleCompiler = isAfterPrepareProperty ? new WRuleCompiler(this, verId, ruleVer, sourceEntityType, true) : new WRuleCompiler(this, verId, ruleVer, sourceEntityType);
                ruleCompilers.put(verId, ruleCompiler);
            }
            HashMap<Long, WRuleCompiler> hashMap = ruleCompilers;
            return hashMap;
        }
    }

    private Map<Long, WRuleCompiler> loadWriteBackRules() {
        return this.loadWriteBackRules(false);
    }

    private BillEntityType getSourceEntityTypeFromCache(Map<String, BillEntityType> cacheBillEntityType, String sourceEntityNumber) {
        BillEntityType sourceEntityType;
        if (!cacheBillEntityType.containsKey(sourceEntityNumber)) {
            sourceEntityType = (BillEntityType)EntityMetadataCache.getDataEntityType((String)sourceEntityNumber);
            cacheBillEntityType.put(sourceEntityNumber, sourceEntityType);
        }
        sourceEntityType = cacheBillEntityType.get(sourceEntityNumber);
        return sourceEntityType;
    }

    public void setProgressTip(String tip) {
        String taskId = this.getOption().getVariableValue("bos_op_taskid", "");
        if (StringUtils.isBlank((CharSequence)taskId)) {
            return;
        }
        OperateProgressCache.setProgressTip((String)taskId, (String)tip);
    }
}

