/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.track;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.log.AbstractDetailLogInfo;
import kd.bos.entity.botp.log.BOTPLog;
import kd.bos.entity.botp.log.TCLogDetailInfo;
import kd.bos.entity.botp.log.TCLogRow;
import kd.bos.entity.botp.log.WBLogDetailInfo;
import kd.bos.entity.botp.log.WBLogRow;
import kd.bos.entity.botp.log.WFLogDetailInfo;
import kd.bos.entity.botp.log.WVLogDetailInfo;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.botp.track.BFTrackerBatchContext;
import kd.bos.service.botp.track.BFTrackerBatchResult;
import kd.bos.service.botp.track.BFTrackerOpContext;
import kd.bos.service.botp.track.LinkItemContext;
import kd.bos.service.botp.track.WriteBackContext;
import kd.bos.service.botp.track.bizentity.Row;
import kd.bos.service.botp.track.bizentity.RowLinkId;
import kd.bos.service.botp.track.bizentity.Sheet;
import kd.bos.service.botp.track.bizentity.Sheets;
import kd.bos.service.botp.track.bizentity.WRule;
import kd.bos.service.botp.track.bizentity.WSRow;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;

public class BFTrackerLog {
    private static final Log LOG = LogFactory.getLog(BFTrackerLog.class);
    private static final String BOS_MSERVICE_OPERATION = "bos-mservice-botp";
    private static final String FORMID_BOTP_LOG = "botp_log";
    private static final String KEY_CLOSE_LOG = "closelog";
    private static final String KEY_WRITEVALUE_LOG = "writevaluelog";
    private static final String KEY_KEEP_WRITEBACK_LOG = "writebacklog";
    private static final String KEY_ENTRY_TRACKER_SBILLID = "sbillid";
    private static final String KEY_ENTRY_TRACKER_STABLEID = "stableid";
    private static final String KEY_ENTRY_TRACKER_SID = "sid";
    private static final String KEY_ENTRY_TRACKER_TTABLEID = "ttableid";
    private static final String KEY_ENTRY_TRACKER_TID = "tid";
    private static final String KEY_WRITE_FID = "fid";
    private static final String KEY_WRITE_RULEVER = "ruleverid";
    private static final String KEY_WRITE_RULEITEM = "ruleitemid";
    private static final String KEY_WRITE_SBILLID = "wb_sbillid";
    private static final String KEY_WRITE_STABLEID = "wb_stableid";
    private static final String KEY_WRITE_SID = "wb_sid";
    private static final String KEY_WRITE_VALUE = "wb_value";
    public long taskId = DB.genGlobalLongId();
    private Date startTime = TimeServiceHelper.now();
    private long userId = RequestContext.get().getCurrUserId();
    private List<BOTPLog> toTargetLogs = new ArrayList<BOTPLog>();
    private Map<Long, List<BOTPLog>> toSourceLogs = new HashMap<Long, List<BOTPLog>>(1);
    private Map<RowLinkId, BOTPLog> wvLogs = new HashMap<RowLinkId, BOTPLog>();
    private Map<Long, RowLinkId> tcId2RowLinks = new HashMap<Long, RowLinkId>();
    private Map<Long, RowLinkId> wbId2RowLinks = new HashMap<Long, RowLinkId>();
    private Map<Long, Long> wbId2TcIds = new HashMap<Long, Long>();
    private Map<String, TableDefine> mainTableDefines = new HashMap<String, TableDefine>();
    private Map<Long, TableDefine> entryTableDefines = new HashMap<Long, TableDefine>();
    private Map<Long, String> dbRouteKeys = new HashMap<Long, String>();
    public Map<String, Map<Object, String>> allBillNos = new HashMap<String, Map<Object, String>>();
    private Boolean closeLog = null;
    private Boolean writeValueLog = null;
    private Boolean keepWriteBackLog = null;
    public static final Map<String, String> OPTYPES = new HashMap<String, String>();

    public List<BOTPLog> getToTargetLogs() {
        return this.toTargetLogs;
    }

    public List<BOTPLog> getToSourceLogs(String srcEntityNumber) {
        Long sTableId = this.loadMainTableId(srcEntityNumber);
        ArrayList<BOTPLog> logs = new ArrayList<BOTPLog>();
        for (Map.Entry<RowLinkId, BOTPLog> entry : this.wvLogs.entrySet()) {
            if (Long.compare(entry.getKey().getSTableId(), sTableId) != 0) continue;
            logs.add(entry.getValue());
        }
        List<BOTPLog> wfLogs = this.toSourceLogs.get(sTableId);
        if (wfLogs != null) {
            logs.addAll(wfLogs);
        }
        return logs;
    }

    public synchronized void addWriteBackLogs(LinkItemContext linkItemContext, BFTrackerBatchContext batchContext, BFTrackerBatchResult batchResult) {
        if (this.isCloseLog().booleanValue()) {
            return;
        }
        try {
            if (this.createBlankEntryTrackerLog(linkItemContext, batchContext, batchResult)) {
                return;
            }
            this.allBillNos = this.batchLoadBillNos(linkItemContext, batchResult.getSnapshot(), batchResult.getSheets());
            ArrayList<WBLogRow> histWRuleLogRows = new ArrayList<WBLogRow>();
            Map<RowLinkId, BOTPLog> tcLogs = this.buildTcLogs(linkItemContext, batchContext, batchResult, histWRuleLogRows);
            HashMap<Long, BOTPLog> wfLogs = new HashMap<Long, BOTPLog>(1);
            Map<RowLinkId, Map<RowLinkId, BOTPLog>> wbLogsByTc = this.buildWbLogs(linkItemContext, batchContext, batchResult, histWRuleLogRows, tcLogs, wfLogs);
            for (BOTPLog log : this.wvLogs.values()) {
                this.fillBillNo(log);
            }
            boolean existWBLog = false;
            for (Map.Entry<RowLinkId, Map<RowLinkId, BOTPLog>> entry1 : wbLogsByTc.entrySet()) {
                BOTPLog tcLog = tcLogs.get(entry1.getKey());
                if (tcLog == null) continue;
                existWBLog = false;
                for (Map.Entry<RowLinkId, BOTPLog> entry2 : entry1.getValue().entrySet()) {
                    BOTPLog wbLog = entry2.getValue();
                    WBLogDetailInfo wbLogDetailInfo = (WBLogDetailInfo)wbLog.getDetailInfo();
                    if (wbLogDetailInfo.getAddWBs().isEmpty() && wbLogDetailInfo.getDelWbIds().isEmpty()) continue;
                    BOTPLog wfLog = (BOTPLog)wfLogs.get(wbLog.getId());
                    if (wfLog != null) {
                        this.toTargetLogs.add(wbLog);
                        this.toSourceLogs.computeIfAbsent(wfLog.getSTableId(), s -> new ArrayList()).add(wfLog);
                        existWBLog = true;
                        continue;
                    }
                    LOG.info(String.format("\u53cd\u5199\u65e5\u5fd7\uff0c\u53cd\u5199\u9700\u6c42\u65e5\u5fd7[%s]\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u53cd\u5199\u7ed3\u679c\u65e5\u5fd7", wbLog.getId()));
                }
                if (!existWBLog) continue;
                this.toTargetLogs.add(tcLog);
            }
            this.tcId2RowLinks.clear();
            this.wbId2RowLinks.clear();
            this.wbId2TcIds.clear();
        }
        catch (Throwable exp) {
            LOG.error(exp);
        }
    }

    public synchronized void addRetryWriteBackLogs(LinkItemContext linkItemContext, Sheets snapshots, Sheets sheets, BOTPLog[] wbLogs) {
        try {
            for (BOTPLog wbLog : wbLogs) {
                RowLinkId rowLinkId_wb = new RowLinkId(wbLog.getSTableId(), wbLog.getSBillId(), wbLog.getTTableId(), wbLog.getTBillId());
                BOTPLog wfLog = this.createWriteFinishLog(linkItemContext, rowLinkId_wb, wbLog);
                wfLog.setRemark(ResManager.loadKDString((String)"\u91cd\u8bd5\u53cd\u5199", (String)"BFTrackerLog_6", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]));
                this.toSourceLogs.computeIfAbsent(wfLog.getSTableId(), s -> new ArrayList()).add(wfLog);
                if (StringUtils.isNotBlank((CharSequence)wbLog.getSentityNumber()) && StringUtils.isNotBlank((CharSequence)wbLog.getSBillno())) {
                    this.allBillNos.computeIfAbsent(wbLog.getSentityNumber(), s -> new HashMap()).put(wbLog.getSBillId(), wbLog.getSBillno());
                }
                if (!StringUtils.isNotBlank((CharSequence)wbLog.getTentityNumber()) || !StringUtils.isNotBlank((CharSequence)wbLog.getTBillno())) continue;
                this.allBillNos.computeIfAbsent(wbLog.getTentityNumber(), s -> new HashMap()).put(wbLog.getTBillId(), wbLog.getTBillno());
            }
            for (BOTPLog log : this.wvLogs.values()) {
                this.fillBillNo(log);
            }
        }
        catch (Throwable exp) {
            LOG.error(exp);
        }
    }

    public synchronized void addWriteValue(WriteBackContext writebackContext, WSRow wsRow, String srcFld, Object oldValue, String op, Object writeVal, Object newValue) {
        if (this.isCloseLog().booleanValue() || !this.isWriteValueLog().booleanValue()) {
            return;
        }
        try {
            Long tBillId;
            Long tMainTableId;
            RowLinkId rowLinkId;
            BOTPLog log;
            Long sMainTableId = wsRow.getSId().getMainTableId();
            Long sBillId = wsRow.getSId().getBillId();
            Long sEntryId = wsRow.getSId().getEntryId();
            String sEntityKey = writebackContext.getSrcMainType().getName();
            if (wsRow.getSrcActiveRow() != null) {
                sEntityKey = wsRow.getSrcActiveRow().getDataEntityType().getName();
            }
            if ((log = this.wvLogs.get(rowLinkId = new RowLinkId(sMainTableId, sBillId, tMainTableId = wsRow.getParent().getParent().getId().getMainTableId(), tBillId = wsRow.getParent().getParent().getId().getBillId()))) == null) {
                log = this.createWriteValueLog(writebackContext.getLinkItemContext(), rowLinkId);
                this.wvLogs.put(rowLinkId, log);
            }
            String desc = String.format("[rv=%s, ri=%s, id=%s] %s %s %s = %s", wsRow.getParent().getRuleVerId(), wsRow.getParent().getRuleItemId(), wsRow.getParent().getParent().getId().getEntryId(), oldValue, op, writeVal, newValue);
            WVLogDetailInfo wvLogDetailInfo = (WVLogDetailInfo)log.getDetailInfo();
            wvLogDetailInfo.addWriteValue(sEntityKey, sEntryId, srcFld, oldValue, newValue, desc);
        }
        catch (Throwable exp) {
            LOG.error(exp);
        }
    }

    private Map<RowLinkId, BOTPLog> buildTcLogs(LinkItemContext linkItemContext, BFTrackerBatchContext batchContext, BFTrackerBatchResult batchResult, List<WBLogRow> histWbRows) {
        RowLinkId rowLinkId;
        HashMap<RowLinkId, BOTPLog> tcLogs = new HashMap<RowLinkId, BOTPLog>(1);
        Sheets snapshots = batchResult.getSnapshot();
        for (Sheet sheet : snapshots.values()) {
            for (Row row : sheet.getRows().values()) {
                rowLinkId = new RowLinkId(row.getSId().getMainTableId(), row.getSId().getBillId(), row.getId().getMainTableId(), row.getId().getBillId());
                BOTPLog tcLog = (BOTPLog)tcLogs.get(rowLinkId);
                if (tcLog == null) {
                    tcLog = this.createEntryTrackerLog(linkItemContext, rowLinkId);
                    tcLogs.put(rowLinkId, tcLog);
                }
                TCLogRow tcRow = this.buildTcRow(row, histWbRows);
                this.tcId2RowLinks.put(tcRow.getId(), rowLinkId);
                TCLogDetailInfo tcLogDetailInfo = (TCLogDetailInfo)tcLog.getDetailInfo();
                tcLogDetailInfo.getHistRows().add(tcRow);
            }
        }
        for (Long tcId : batchResult.getDelEntryTrackerIds()) {
            BOTPLog log;
            RowLinkId rowLinkId2 = this.tcId2RowLinks.get(tcId);
            if (rowLinkId2 == null || (log = (BOTPLog)tcLogs.get(rowLinkId2)) == null || log.getDetailInfo() == null) continue;
            TCLogDetailInfo tcLogDetailInfo = (TCLogDetailInfo)log.getDetailInfo();
            tcLogDetailInfo.getDelTcIds().add(tcId);
        }
        for (DynamicObject entryTrackerObj : batchResult.getNewEntryTrackers()) {
            Long tBillId = entryTrackerObj.getLong("tbillid");
            TCLogRow tcRow = this.buildTcRow(tBillId, entryTrackerObj);
            rowLinkId = new RowLinkId(this.loadMainTableId(tcRow.getSt()), tcRow.getSb(), this.loadMainTableId(tcRow.getTt()), tcRow.getTb());
            this.tcId2RowLinks.put(tcRow.getId(), rowLinkId);
            BOTPLog log = (BOTPLog)tcLogs.get(rowLinkId);
            if (log == null) {
                log = this.createEntryTrackerLog(linkItemContext, rowLinkId);
                tcLogs.put(rowLinkId, log);
            }
            TCLogDetailInfo tcLogDetailInfo = (TCLogDetailInfo)log.getDetailInfo();
            tcLogDetailInfo.getAddRows().add(tcRow);
        }
        return tcLogs;
    }

    private Map<RowLinkId, Map<RowLinkId, BOTPLog>> buildWbLogs(LinkItemContext linkItemContext, BFTrackerBatchContext batchContext, BFTrackerBatchResult batchResult, List<WBLogRow> histWbRows, Map<RowLinkId, BOTPLog> tcLogs, Map<Long, BOTPLog> wfLogs) {
        Long tcId;
        HashMap<RowLinkId, Map<RowLinkId, BOTPLog>> wbLogsByTc = new HashMap<RowLinkId, Map<RowLinkId, BOTPLog>>(1);
        for (WBLogRow wRuleLogRow : histWbRows) {
            BOTPLog wbLog = this.createOrGetWriteBackLog(linkItemContext, tcLogs, wbLogsByTc, wfLogs, wRuleLogRow);
            if (wbLog == null) continue;
            WBLogDetailInfo wbLogDetailInfo = (WBLogDetailInfo)wbLog.getDetailInfo();
            wbLogDetailInfo.getHistWBs().add(wRuleLogRow);
        }
        for (Long wbId : batchResult.getDelWBIds()) {
            BOTPLog wbLog;
            tcId = this.wbId2TcIds.get(wbId);
            RowLinkId rowLinkId_wb = this.wbId2RowLinks.get(wbId);
            RowLinkId rowLinkId_tc = this.tcId2RowLinks.get(tcId);
            Map wbLogsByWb = (Map)wbLogsByTc.get(rowLinkId_tc);
            if (wbLogsByWb == null || (wbLog = (BOTPLog)wbLogsByWb.get(rowLinkId_wb)) == null) continue;
            WBLogDetailInfo wbLogDetailInfo = (WBLogDetailInfo)wbLog.getDetailInfo();
            wbLogDetailInfo.getDelWbIds().add(wbId);
        }
        for (DynamicObject wbItemObj : batchResult.getNewWBItems()) {
            Long tBillId;
            tcId = wbItemObj.getLong(KEY_WRITE_FID);
            RowLinkId rowLinkId_tc = this.tcId2RowLinks.get(tcId);
            Long tMainTableId = linkItemContext.getMainTableId();
            WBLogRow wbLogRow = this.buildWbRow(tMainTableId, tBillId = rowLinkId_tc.getTEntryId(), tcId, wbItemObj);
            BOTPLog wbLog = this.createOrGetWriteBackLog(linkItemContext, tcLogs, wbLogsByTc, wfLogs, wbLogRow);
            if (wbLog == null) continue;
            WBLogDetailInfo wbLogDetailInfo = (WBLogDetailInfo)wbLog.getDetailInfo();
            wbLogDetailInfo.getAddWBs().add(wbLogRow);
        }
        return wbLogsByTc;
    }

    private boolean createBlankEntryTrackerLog(LinkItemContext linkItemContext, BFTrackerBatchContext batchContext, BFTrackerBatchResult batchResult) {
        return batchResult.getDelEntryTrackerIds().isEmpty() && batchResult.getDelWBIds().isEmpty() && batchResult.getNewEntryTrackers().isEmpty() && batchResult.getNewWBItems().isEmpty();
    }

    private BOTPLog createBlankBotpLog(LinkItemContext linkItemContext, RowLinkId rowLinkId) {
        BOTPLog log = new BOTPLog();
        log.setId(DB.genGlobalLongId());
        log.setTaskId(this.taskId);
        log.setSTableId(rowLinkId.getSTableId().longValue());
        log.setSBillId(rowLinkId.getSEntryId().longValue());
        log.setTTableId(rowLinkId.getTTableId().longValue());
        log.setTBillId(rowLinkId.getTEntryId().longValue());
        if (rowLinkId.getSTableId() != null && Long.compare(0L, rowLinkId.getSTableId()) != 0) {
            log.setSentityNumber(this.loadEntityNumber(rowLinkId.getSTableId()));
            log.setSBillno(this.getBillNo(rowLinkId.getSTableId(), rowLinkId.getSEntryId()));
        }
        if (rowLinkId.getTTableId() != null && Long.compare(0L, rowLinkId.getTTableId()) != 0) {
            log.setTentityNumber(this.loadEntityNumber(rowLinkId.getTTableId()));
            log.setTBillno(this.getBillNo(rowLinkId.getTTableId(), rowLinkId.getTEntryId()));
        }
        log.setUserId(this.userId);
        log.setOpType(this.getOpType(linkItemContext.getTrackerOpContext()));
        log.setStartTime(this.startTime);
        return log;
    }

    private BOTPLog createEntryTrackerLog(LinkItemContext linkItemContext, RowLinkId rowLinkId) {
        BOTPLog log = this.createBlankBotpLog(linkItemContext, rowLinkId);
        log.setStatus("1");
        log.setLogType("T");
        TCLogDetailInfo tcLogDetailInfo = new TCLogDetailInfo();
        tcLogDetailInfo.setEntityKey(linkItemContext.getLinkSetItem().getParentEntityKey());
        tcLogDetailInfo.setLinkEntryKey(linkItemContext.getLinkSetItem().getLinkEntityKey());
        log.setDetailInfo((AbstractDetailLogInfo)tcLogDetailInfo);
        return log;
    }

    private BOTPLog createWriteBackLog(LinkItemContext linkItemContext, RowLinkId rowLinkId) {
        BOTPLog log = this.createBlankBotpLog(linkItemContext, rowLinkId);
        log.setStatus("0");
        log.setLogType("W");
        WBLogDetailInfo wbLogDetailInfo = new WBLogDetailInfo();
        String opKey = null;
        if (linkItemContext.getTrackerContext().getOpMeta() != null) {
            opKey = (String)linkItemContext.getTrackerContext().getOpMeta().get("key");
        }
        wbLogDetailInfo.setOpKey(opKey);
        wbLogDetailInfo.setOpType(linkItemContext.getTrackerOpContext().getOpController().getOpType());
        wbLogDetailInfo.setEntityKey(linkItemContext.getLinkSetItem().getParentEntityKey());
        wbLogDetailInfo.setLinkEntryKey(linkItemContext.getLinkSetItem().getLinkEntityKey());
        wbLogDetailInfo.setSdbRouteKey(this.loadDBRouteKey(log.getSTableId()));
        log.setDetailInfo((AbstractDetailLogInfo)wbLogDetailInfo);
        return log;
    }

    private BOTPLog createWriteFinishLog(LinkItemContext linkItemContext, RowLinkId rowLinkId, BOTPLog wbLog) {
        BOTPLog log = this.createBlankBotpLog(linkItemContext, rowLinkId);
        log.setParentId(wbLog.getId());
        log.setTaskId(this.taskId);
        log.setSentityNumber(wbLog.getSentityNumber());
        log.setSBillno(wbLog.getSBillno());
        log.setTentityNumber(wbLog.getTentityNumber());
        log.setTBillno(wbLog.getTBillno());
        log.setStatus("1");
        log.setLogType("F");
        WFLogDetailInfo wfLogDetailInfo = new WFLogDetailInfo();
        wfLogDetailInfo.setTdbRouteKey(linkItemContext.getTrackerContext().getTargetMainType().getDBRouteKey());
        wfLogDetailInfo.setTNumber(linkItemContext.getTrackerContext().getTargetMainType().getName());
        wfLogDetailInfo.setEntityKey(linkItemContext.getLinkSetItem().getParentEntityKey());
        wfLogDetailInfo.setLinkEntryKey(linkItemContext.getLinkSetItem().getLinkEntityKey());
        log.setDetailInfo((AbstractDetailLogInfo)wfLogDetailInfo);
        return log;
    }

    private BOTPLog createWriteValueLog(LinkItemContext linkItemContext, RowLinkId rowLinkId) {
        BOTPLog log = this.createBlankBotpLog(linkItemContext, rowLinkId);
        log.setStatus("1");
        log.setLogType("V");
        WVLogDetailInfo wvLogDetailInfo = new WVLogDetailInfo();
        wvLogDetailInfo.setTdbRouteKey(linkItemContext.getTrackerContext().getTargetMainType().getDBRouteKey());
        wvLogDetailInfo.setTNumber(linkItemContext.getTrackerContext().getTargetMainType().getName());
        log.setDetailInfo((AbstractDetailLogInfo)wvLogDetailInfo);
        return log;
    }

    private BOTPLog createOrGetWriteBackLog(LinkItemContext linkItemContext, Map<RowLinkId, BOTPLog> tcLogs, Map<RowLinkId, Map<RowLinkId, BOTPLog>> wbLogsByTc, Map<Long, BOTPLog> wfLogs, WBLogRow wbLogRow) {
        BOTPLog wfLog;
        Map wbLogsByWb;
        BOTPLog wbLog;
        Long wbId = wbLogRow.getId();
        Long tcId = wbLogRow.getTc();
        RowLinkId rowLinkId_wb = this.wbId2RowLinks.get(wbId);
        RowLinkId rowLinkId_tc = this.tcId2RowLinks.get(tcId);
        if (!this.isKeepWriteBackLog().booleanValue()) {
            String sDbRouteKey = this.loadDBRouteKey(rowLinkId_wb.getSTableId());
            if (this.equalsDatabase(linkItemContext.getTrackerContext().getTargetMainType().getDBRouteKey(), sDbRouteKey)) {
                return null;
            }
        }
        if ((wbLog = (BOTPLog)(wbLogsByWb = wbLogsByTc.computeIfAbsent(rowLinkId_tc, s -> new HashMap())).get(rowLinkId_wb)) == null) {
            wbLog = this.createWriteBackLog(linkItemContext, rowLinkId_wb);
            wbLogsByWb.put(rowLinkId_wb, wbLog);
            BOTPLog tcLog = tcLogs.get(rowLinkId_tc);
            if (tcLog != null) {
                wbLog.setParentId(tcLog.getId());
            }
        }
        if ((wfLog = wfLogs.get(wbLog.getId())) == null) {
            wfLog = this.createWriteFinishLog(linkItemContext, rowLinkId_wb, wbLog);
            wfLogs.put(wbLog.getId(), wfLog);
        }
        return wbLog;
    }

    private TCLogRow buildTcRow(Row row, List<WBLogRow> histWbRows) {
        TCLogRow entryTrackeLogRow = new TCLogRow();
        entryTrackeLogRow.setId(row.getEntryTrackerId().longValue());
        entryTrackeLogRow.setSb(row.getSId().getBillId().longValue());
        entryTrackeLogRow.setSt(row.getSId().getTableId().longValue());
        entryTrackeLogRow.setSi(row.getSId().getEntryId().longValue());
        entryTrackeLogRow.setTb(row.getId().getBillId().longValue());
        entryTrackeLogRow.setTt(row.getId().getTableId().longValue());
        entryTrackeLogRow.setTi(row.getId().getEntryId().longValue());
        for (WRule wRule : row.getWrules().values()) {
            for (WSRow wsRow : wRule.getHistorySourceRows().values()) {
                WBLogRow wbRow = this.buildWbRow(row, wRule, wsRow);
                histWbRows.add(wbRow);
            }
        }
        return entryTrackeLogRow;
    }

    private TCLogRow buildTcRow(Long tBillId, DynamicObject entryTrackerObj) {
        TCLogRow entryTrackeLogRow = new TCLogRow();
        Long tcId = (Long)entryTrackerObj.getPkValue();
        entryTrackeLogRow.setId(tcId.longValue());
        entryTrackeLogRow.setSb(entryTrackerObj.getLong(KEY_ENTRY_TRACKER_SBILLID));
        entryTrackeLogRow.setSt(entryTrackerObj.getLong(KEY_ENTRY_TRACKER_STABLEID));
        entryTrackeLogRow.setSi(entryTrackerObj.getLong(KEY_ENTRY_TRACKER_SID));
        entryTrackeLogRow.setTb(tBillId.longValue());
        entryTrackeLogRow.setTt(entryTrackerObj.getLong(KEY_ENTRY_TRACKER_TTABLEID));
        entryTrackeLogRow.setTi(entryTrackerObj.getLong(KEY_ENTRY_TRACKER_TID));
        return entryTrackeLogRow;
    }

    private WBLogRow buildWbRow(Row row, WRule wRule, WSRow wsRow) {
        WBLogRow wbLogRow = new WBLogRow();
        wbLogRow.setTc(row.getEntryTrackerId().longValue());
        wbLogRow.setId(wsRow.getWBEntryId().longValue());
        if (wsRow.getWBEntryId() != null && Long.compare(0L, wsRow.getWBEntryId()) != 0) {
            RowLinkId rowLinkId = new RowLinkId(wsRow.getSId().getMainTableId(), wsRow.getSId().getBillId(), row.getId().getMainTableId(), row.getId().getBillId());
            this.wbId2RowLinks.put(wbLogRow.getId(), rowLinkId);
            this.wbId2TcIds.put(wbLogRow.getId(), wbLogRow.getTc());
        }
        wbLogRow.setRv(wRule.getRuleVerId().longValue());
        wbLogRow.setRi(wRule.getRuleItemId().longValue());
        wbLogRow.setSb(wsRow.getSId().getBillId().longValue());
        wbLogRow.setSt(wsRow.getSId().getTableId().longValue());
        wbLogRow.setSi(wsRow.getSId().getEntryId().longValue());
        wbLogRow.setV(wsRow.getVal());
        return wbLogRow;
    }

    private WBLogRow buildWbRow(Long tMainTableId, Long tBillId, Long tcId, DynamicObject wbItemObj) {
        WBLogRow wbLogRow = new WBLogRow();
        Long wbId = (Long)wbItemObj.getPkValue();
        wbLogRow.setTc(tcId.longValue());
        wbLogRow.setId(((Long)wbItemObj.getPkValue()).longValue());
        wbLogRow.setRv(wbItemObj.getLong(KEY_WRITE_RULEVER));
        wbLogRow.setRi(wbItemObj.getLong(KEY_WRITE_RULEITEM));
        wbLogRow.setSb(wbItemObj.getLong(KEY_WRITE_SBILLID));
        wbLogRow.setSt(wbItemObj.getLong(KEY_WRITE_STABLEID));
        wbLogRow.setSi(wbItemObj.getLong(KEY_WRITE_SID));
        wbLogRow.setV(wbItemObj.getBigDecimal(KEY_WRITE_VALUE));
        Long sMainTableId = this.loadMainTableId(wbLogRow.getSt());
        RowLinkId rowLinkId = new RowLinkId(sMainTableId, wbLogRow.getSb(), tMainTableId, tBillId);
        this.wbId2RowLinks.put(wbId, rowLinkId);
        this.wbId2TcIds.put(wbId, tcId);
        return wbLogRow;
    }

    private Long loadMainTableId(String entityNumber) {
        TableDefine tableDefine = this.mainTableDefines.get(entityNumber);
        if (tableDefine == null) {
            tableDefine = EntityMetadataCache.loadTableDefine((String)entityNumber, (String)entityNumber);
            this.mainTableDefines.put(entityNumber, tableDefine);
        }
        if (tableDefine == null) {
            return 0L;
        }
        return tableDefine.getTableId();
    }

    private Long loadMainTableId(Long entryTableId) {
        TableDefine tableDefine = this.entryTableDefines.get(entryTableId);
        if (tableDefine == null) {
            tableDefine = EntityMetadataCache.loadTableDefine((Long)entryTableId);
            this.entryTableDefines.put(entryTableId, tableDefine);
        }
        if (tableDefine == null) {
            return 0L;
        }
        return this.loadMainTableId(tableDefine.getEntityNumber());
    }

    private String loadEntityNumber(Long tableId) {
        TableDefine tableDefine = EntityMetadataCache.loadTableDefine((Long)tableId);
        if (tableDefine == null) {
            return "";
        }
        return tableDefine.getEntityNumber();
    }

    private String loadDBRouteKey(Long tableId) {
        String dbRouteKey = this.dbRouteKeys.get(tableId);
        if (dbRouteKey != null) {
            return dbRouteKey;
        }
        String entityNumber = this.loadEntityNumber(tableId);
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        dbRouteKey = mainType.getDBRouteKey();
        this.dbRouteKeys.put(tableId, dbRouteKey);
        return dbRouteKey;
    }

    private Boolean isCloseLog() {
        if (this.closeLog != null) {
            return this.closeLog;
        }
        try {
            Object optionValue = SystemParamServiceHelper.getBillParameter((String)FORMID_BOTP_LOG, (String)KEY_CLOSE_LOG);
            this.closeLog = optionValue == null ? Boolean.FALSE : (Boolean)optionValue;
        }
        catch (Throwable exp) {
            LOG.error(exp);
            this.closeLog = Boolean.FALSE;
        }
        return this.closeLog;
    }

    private Boolean isWriteValueLog() {
        if (this.writeValueLog != null) {
            return this.writeValueLog;
        }
        try {
            Object optionValue = SystemParamServiceHelper.getBillParameter((String)FORMID_BOTP_LOG, (String)KEY_WRITEVALUE_LOG);
            this.writeValueLog = optionValue == null ? Boolean.FALSE : (Boolean)optionValue;
        }
        catch (Throwable exp) {
            LOG.error(exp);
            this.writeValueLog = Boolean.FALSE;
        }
        return this.writeValueLog;
    }

    private Boolean isKeepWriteBackLog() {
        if (this.keepWriteBackLog != null) {
            return this.keepWriteBackLog;
        }
        try {
            Object optionValue = SystemParamServiceHelper.getBillParameter((String)FORMID_BOTP_LOG, (String)KEY_KEEP_WRITEBACK_LOG);
            this.keepWriteBackLog = optionValue == null ? Boolean.FALSE : (Boolean)optionValue;
        }
        catch (Throwable exp) {
            LOG.error(exp);
            this.keepWriteBackLog = Boolean.FALSE;
        }
        return this.keepWriteBackLog;
    }

    private boolean equalsDatabase(String dbRouteKey1, String dbRouteKey2) {
        return StringUtils.equalsIgnoreCase((CharSequence)dbRouteKey1, (CharSequence)dbRouteKey2);
    }

    private String getOpType(BFTrackerOpContext opContext) {
        String opType = "";
        String opMetaType = null;
        if (opContext.getTrackerContext().getOpMeta() != null) {
            opMetaType = (String)opContext.getTrackerContext().getOpMeta().get("type");
        }
        if (StringUtils.isNotBlank(opMetaType) && OPTYPES.containsKey(opMetaType)) {
            return OPTYPES.get(opMetaType);
        }
        switch (opContext.getOpController().getOpType()) {
            case Save: {
                opType = "S";
                break;
            }
            case Draft: {
                opType = "S";
                break;
            }
            case Delete: {
                opType = "D";
                break;
            }
            case Audit: {
                opType = "A";
                break;
            }
            case UnAudit: {
                opType = "U";
                break;
            }
            case UnCancel: {
                opType = "V";
                break;
            }
            case Cancel: {
                opType = "I";
                break;
            }
        }
        return opType;
    }

    public Map<String, Map<Object, String>> batchLoadBillNos(LinkItemContext linkItemContext, Sheets snapshots, Sheets sheets) {
        HashMap<String, Map<Object, String>> billNos = new HashMap<String, Map<Object, String>>();
        Map tBillNos = billNos.computeIfAbsent(linkItemContext.getTrackerContext().getTargetMainType().getName(), s -> new HashMap());
        for (Sheet sheet : sheets.values()) {
            Row row;
            String tbillNo;
            if (sheet.getRows().isEmpty() || (tbillNo = this.getBillNo((row = (Row)sheet.getRows().entrySet().iterator().next().getValue()).getEntityRow())) == null) continue;
            tBillNos.put(sheet.getBillId(), tbillNo);
        }
        HashMap<Long, Set<Long>> billIds = new HashMap<Long, Set<Long>>();
        this.getSBillIdInSheets(sheets, billNos, billIds);
        this.getSBillIdInSheets(snapshots, billNos, billIds);
        for (Map.Entry entry : billIds.entrySet()) {
            String key;
            MainEntityType mainType;
            String sEntityNumber = this.loadEntityNumber((Long)entry.getKey());
            Map sBillNos = billNos.computeIfAbsent(sEntityNumber, s -> new HashMap());
            Set sBillIds = (Set)entry.getValue();
            ArrayList<Long> ids = new ArrayList<Long>(sBillIds.size());
            for (Long sBillId : sBillIds) {
                if (sBillNos.containsKey(sBillId)) continue;
                ids.add(sBillId);
            }
            if (ids.isEmpty() || !((mainType = EntityMetadataCache.getDataEntityType((String)sEntityNumber)) instanceof BillEntityType) || StringUtils.isBlank((CharSequence)(key = ((BillEntityType)mainType).getBillNo()))) continue;
            QFilter[] qFilters = new QFilter[]{new QFilter(mainType.getPrimaryKey().getName(), "in", ids)};
            String selectFields = mainType.getPrimaryKey().getName() + "," + key;
            DataSet ds = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + ".batchLoadBillNos"), (String)sEntityNumber, (String)selectFields, (QFilter[])qFilters, null);
            Throwable throwable = null;
            try {
                while (ds.hasNext()) {
                    kd.bos.algo.Row row = ds.next();
                    Long sBillId = row.getLong(0);
                    String sBillNo = row.getString(1);
                    sBillNos.put(sBillId, sBillNo);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ds == null) continue;
                if (throwable != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ds.close();
            }
        }
        return billNos;
    }

    private void getSBillIdInSheets(Sheets sheets, Map<String, Map<Object, String>> billNos, Map<Long, Set<Long>> billIds) {
        for (Sheet sheet : sheets.values()) {
            for (Row row : sheet.getRows().values()) {
                billIds.computeIfAbsent(row.getId().getMainTableId(), s -> new HashSet()).add(row.getId().getBillId());
                billIds.computeIfAbsent(row.getSId().getMainTableId(), s -> new HashSet()).add(row.getSId().getBillId());
                for (WRule wRule : row.getWrules().values()) {
                    for (WSRow wsRow : wRule.getHistorySourceRows().values()) {
                        billIds.computeIfAbsent(wsRow.getSId().getMainTableId(), s -> new HashSet()).add(wsRow.getSId().getBillId());
                    }
                    for (WSRow wsRow : wRule.getExecuteSourceRows().values()) {
                        String sBillNo = this.getBillNo(wsRow.getSrcActiveRow());
                        if (sBillNo != null) {
                            Map sBillNos = billNos.computeIfAbsent(this.loadEntityNumber(wsRow.getSId().getMainTableId()), s -> new HashMap());
                            sBillNos.put(wsRow.getSId().getBillId(), sBillNo);
                            continue;
                        }
                        Set sBillIds = billIds.computeIfAbsent(wsRow.getSId().getMainTableId(), s -> new HashSet());
                        sBillIds.add(wsRow.getSId().getBillId());
                    }
                }
            }
        }
    }

    private void fillBillNo(BOTPLog log) {
        if (Long.compare(0L, log.getSTableId()) != 0) {
            log.setSentityNumber(this.loadEntityNumber(log.getSTableId()));
            log.setSBillno(this.getBillNo(log.getSTableId(), (Long)log.getSBillId()));
        }
        if (Long.compare(0L, log.getTTableId()) != 0) {
            log.setTentityNumber(this.loadEntityNumber(log.getTTableId()));
            log.setTBillno(this.getBillNo(log.getTTableId(), (Long)log.getTBillId()));
        }
    }

    private String getBillNo(DynamicObject activeRow) {
        BillEntityType mainType;
        String key;
        if (activeRow == null) {
            return null;
        }
        DynamicObject head = null;
        if (activeRow.getDataEntityType() instanceof MainEntityType) {
            head = activeRow;
        } else {
            for (DynamicObject parent = (DynamicObject)activeRow.getParent(); parent != null; parent = (DynamicObject)parent.getParent()) {
                if (!(parent.getDataEntityType() instanceof MainEntityType)) continue;
                head = parent;
                break;
            }
        }
        if (head == null) {
            return null;
        }
        if (head.getDataEntityType() instanceof BillEntityType && (key = (mainType = (BillEntityType)head.getDataEntityType()).getBillNo()) != null && mainType.getProperties().containsKey((Object)key)) {
            return head.getString(key);
        }
        return null;
    }

    public String getBillNo(Long tableId, Long billId) {
        String entityNumber = this.loadEntityNumber(tableId);
        return this.getBillNo(entityNumber, billId);
    }

    public String getBillNo(String entityNumber, Long billId) {
        Map<Object, String> sBillNos = this.allBillNos.get(entityNumber);
        if (sBillNos == null) {
            return null;
        }
        return sBillNos.get(billId);
    }

    static {
        OPTYPES.put("save", "S");
        OPTYPES.put("delete", "D");
        OPTYPES.put("submit", "B");
        OPTYPES.put("unsubmit", "C");
        OPTYPES.put("audit", "A");
        OPTYPES.put("unaudit", "U");
        OPTYPES.put("invalid", "I");
        OPTYPES.put("valid", "V");
    }
}

