/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.track;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.EntryInfo;
import kd.bos.dataentity.entity.PkSnapshot;
import kd.bos.dataentity.entity.PkSnapshotSet;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.LinkSetItemElement;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.property.LinkEntryProp;
import kd.bos.service.botp.track.BFTrackerContext;
import kd.bos.service.botp.track.BFTrackerOpContext;
import kd.bos.service.botp.track.bizentity.AED;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;

public class LinkItemContext {
    private static final String LINK_ITEM_CONTEXT_SPLIT_PAGE = "LinkItemContext.splitPage(dataEntities)";
    private BFTrackerContext trackerContext;
    private BFTrackerOpContext trackerOpContext;
    private LinkSetItemElement linkSetItem;
    private Long mainTableId;
    private Long entityTableId;
    private EntityType entityType;
    private LinkEntryType linkEntryType;
    private LinkEntryProp linkEntryProp;
    private String entryKey;
    private EntryType entryType;
    private Set<String> targetEntityKeys = new HashSet<String>();
    private boolean splitPageFlag;
    private int pageIndex = 0;
    public static final int PAGESIZE = 2000;
    private int rowIndex = 0;
    private Set<Long> currPageEntryIds = new HashSet<Long>(0);
    private Set<Long> currPageEntryOids = new HashSet<Long>(0);
    private List<Long> otherPageEntryIds = new ArrayList<Long>(0);

    public static LinkItemContext create(BFTrackerContext trackerContext, BFTrackerOpContext trackerOpContext, LinkSetItemElement linkSetItem) {
        LinkItemContext linkItemContext = new LinkItemContext();
        linkItemContext.setTrackerContext(trackerContext);
        linkItemContext.setTrackerOpContext(trackerOpContext);
        TableDefine tableDefine = ConvertMetaServiceHelper.loadTableDefine((String)trackerContext.getTargetMainType().getName(), (String)linkSetItem.getParentEntityKey());
        Long tableId = tableDefine.getTableId();
        linkItemContext.setLinkSetItem(linkSetItem);
        linkItemContext.setEntityTableId(tableId);
        linkItemContext.setMainTableId(trackerContext.getDbService().loadMainTableId(tableId));
        EntityType parentEntity = (EntityType)trackerContext.getTargetSubMainType().getAllEntities().get(linkSetItem.getParentEntityKey());
        LinkEntryType linkEntity = (LinkEntryType)trackerContext.getTargetSubMainType().getAllEntities().get(linkSetItem.getLinkEntityKey());
        linkItemContext.setEntityType(parentEntity);
        linkItemContext.setLinkEntryType(linkEntity);
        if (parentEntity != null && linkEntity != null) {
            linkItemContext.setLinkEntryProp((LinkEntryProp)parentEntity.getProperties().get((Object)linkEntity.getName()));
        }
        linkItemContext.getTargetEntityKeys().clear();
        linkItemContext.getTargetEntityKeys().add(linkSetItem.getLinkEntityKey());
        String parentEntityKey = linkSetItem.getParentEntityKey();
        IDataEntityType parentType = (IDataEntityType)trackerContext.getTargetMainType().getAllEntities().get(parentEntityKey);
        if (parentType instanceof SubEntryType) {
            linkItemContext.setEntryKey(((EntryType)parentType).getParent().getName());
        } else if (parentType instanceof EntryType) {
            linkItemContext.setEntryKey(parentType.getName());
        }
        if (StringUtils.isNotBlank((CharSequence)linkItemContext.getEntryKey()) && trackerContext.getTargetSubMainType().getAllEntities().containsKey(linkItemContext.getEntryKey())) {
            linkItemContext.setEntryType((EntryType)trackerContext.getTargetSubMainType().getAllEntities().get(linkItemContext.getEntryKey()));
        }
        while (parentType != null) {
            linkItemContext.getTargetEntityKeys().add(parentType.getName());
            parentType = parentType.getParent();
        }
        return linkItemContext;
    }

    public BFTrackerContext getTrackerContext() {
        return this.trackerContext;
    }

    public void setTrackerContext(BFTrackerContext trackerContext) {
        this.trackerContext = trackerContext;
    }

    public BFTrackerOpContext getTrackerOpContext() {
        return this.trackerOpContext;
    }

    public void setTrackerOpContext(BFTrackerOpContext trackerOpContext) {
        this.trackerOpContext = trackerOpContext;
    }

    public LinkSetItemElement getLinkSetItem() {
        return this.linkSetItem;
    }

    public void setLinkSetItem(LinkSetItemElement linkSetItem) {
        this.linkSetItem = linkSetItem;
    }

    public boolean isLinkHead() {
        return Long.compare(this.mainTableId, this.entityTableId) == 0;
    }

    public boolean isLinkEntry() {
        return StringUtils.equalsIgnoreCase((CharSequence)this.entryKey, (CharSequence)this.linkSetItem.getParentEntityKey());
    }

    public boolean isLinkSubEntry() {
        return !this.isLinkHead() && !this.isLinkEntry();
    }

    public boolean isEmpty() {
        return this.currPageEntryIds.isEmpty() && this.currPageEntryOids.isEmpty() && this.otherPageEntryIds.isEmpty();
    }

    public Long getMainTableId() {
        return this.mainTableId;
    }

    public void setMainTableId(Long mainTableId) {
        this.mainTableId = mainTableId;
    }

    public Long getEntityTableId() {
        return this.entityTableId;
    }

    public void setEntityTableId(Long entityTableId) {
        this.entityTableId = entityTableId;
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    public void setEntityType(EntityType entityType) {
        this.entityType = entityType;
    }

    public LinkEntryType getLinkEntryType() {
        return this.linkEntryType;
    }

    public void setLinkEntryType(LinkEntryType linkEntryType) {
        this.linkEntryType = linkEntryType;
    }

    public LinkEntryProp getLinkEntryProp() {
        return this.linkEntryProp;
    }

    public void setLinkEntryProp(LinkEntryProp linkEntryProp) {
        this.linkEntryProp = linkEntryProp;
    }

    public String getEntryKey() {
        return this.entryKey;
    }

    public void setEntryKey(String entryKey) {
        this.entryKey = entryKey;
    }

    public EntryType getEntryType() {
        return this.entryType;
    }

    public void setEntryType(EntryType entryType) {
        this.entryType = entryType;
    }

    public Set<String> getTargetEntityKeys() {
        return this.targetEntityKeys;
    }

    public int getTotalRows() {
        return this.currPageEntryIds.size() + this.currPageEntryOids.size() + this.otherPageEntryIds.size();
    }

    public void splitPage(DynamicObject[] dataEntities) {
        boolean existSnapshot;
        this.trackerContext.getOperateLog().beginMothed(LINK_ITEM_CONTEXT_SPLIT_PAGE, null);
        this.splitPageFlag = false;
        this.pageIndex = 1;
        this.currPageEntryIds.clear();
        this.currPageEntryOids.clear();
        this.otherPageEntryIds.clear();
        boolean bl = existSnapshot = !this.trackerContext.getDbService().readSnapshot(this.trackerOpContext.getBillIds(), this.entityTableId).isEmpty();
        if (!existSnapshot && this.getLinkEntryProp() == null) {
            String logMsg = String.format("return, beacuse of existSnapshot = %s, linkEntryProp = %s ", existSnapshot, this.getLinkEntryProp() == null);
            this.trackerContext.getOperateLog().endMothed(LINK_ITEM_CONTEXT_SPLIT_PAGE, logMsg);
            return;
        }
        if (this.isLinkHead()) {
            for (DynamicObject obj : dataEntities) {
                this.currPageEntryIds.add((Long)obj.getPkValue());
                if (!obj.getDataEntityState().getFromDatabase()) continue;
                this.currPageEntryOids.add((Long)obj.getPkValue());
            }
            return;
        }
        boolean readMoreEntryIds = true;
        if (this.getEntityType() != null) {
            readMoreEntryIds = false;
            DynamicProperty entryProp = this.trackerContext.getTargetSubMainType().getProperty(this.getEntryKey());
            DynamicProperty subEntryProp = !this.isLinkSubEntry() ? null : this.getEntryType().getProperty(this.linkSetItem.getParentEntityKey());
            for (DynamicObject obj : dataEntities) {
                this.addOids(obj);
                this.addEntryIds(obj, (IDataEntityProperty)entryProp, (IDataEntityProperty)subEntryProp);
                if (!existSnapshot) continue;
                readMoreEntryIds = readMoreEntryIds || this.isReadMoreEntryIds(obj);
            }
        }
        if (readMoreEntryIds) {
            this.trackerContext.buildLocalSubMainType();
            List<Long> allEntryIds = this.readOtherEntryIds();
            this.addOtherEntryIds(allEntryIds);
        } else {
            List<Long> histEntryIds = this.readHistoryEntryIds();
            this.currPageEntryOids.addAll(histEntryIds);
        }
        this.splitPageFlag = this.otherPageEntryIds.size() > 2000 || this.currPageEntryIds.size() + this.currPageEntryOids.size() > 0 && !this.otherPageEntryIds.isEmpty();
        this.trackerContext.getOperateLog().endMothed(LINK_ITEM_CONTEXT_SPLIT_PAGE, null);
    }

    public boolean isSplitPage() {
        return this.splitPageFlag;
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    public void setPageIndex(int pageIndex) {
        this.pageIndex = pageIndex;
    }

    public Set<Long> getCurrPageEntryIds() {
        return this.currPageEntryIds;
    }

    public Set<Long> getCurrPageEntryOids() {
        return this.currPageEntryOids;
    }

    public Set<Long> getNextPageEntryIds() {
        int endIndex = Math.min(this.rowIndex + 2000, this.otherPageEntryIds.size());
        if (endIndex == 0) {
            return new HashSet<Long>(0);
        }
        HashSet<Long> nextPageEntryIds = new HashSet<Long>(this.otherPageEntryIds.subList(this.rowIndex, endIndex));
        this.rowIndex = endIndex;
        ++this.pageIndex;
        return nextPageEntryIds;
    }

    private void addOids(DynamicObject obj) {
        PkSnapshotSet pkSnapshotSet = obj.getDataEntityState().getPkSnapshotSet();
        if (pkSnapshotSet != null) {
            for (PkSnapshot pkSnapshot : pkSnapshotSet.Snapshots) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)pkSnapshot.TableName, (CharSequence)this.getEntityType().getAlias())) continue;
                if (pkSnapshot.Oids == null) break;
                for (Object oid : pkSnapshot.Oids) {
                    this.currPageEntryOids.add((Long)oid);
                }
            }
        }
    }

    private void addEntryIds(DynamicObject obj, IDataEntityProperty entryProp, IDataEntityProperty subEntryProp) {
        DynamicObjectCollection rows = (DynamicObjectCollection)entryProp.getValueFast((Object)obj);
        for (DynamicObject row : rows) {
            if (subEntryProp == null) {
                Long entryId = (Long)row.getPkValue();
                this.currPageEntryIds.add(entryId);
                continue;
            }
            DynamicObjectCollection subRows = (DynamicObjectCollection)subEntryProp.getValueFast((Object)row);
            for (DynamicObject subRow : subRows) {
                Long subEntryId = (Long)subRow.getPkValue();
                this.currPageEntryIds.add(subEntryId);
            }
        }
    }

    private void addOtherEntryIds(List<Long> allEntryIds) {
        for (Long entryId : allEntryIds) {
            if (this.currPageEntryIds.contains(entryId) || this.currPageEntryOids.contains(entryId)) continue;
            this.otherPageEntryIds.add(entryId);
        }
    }

    private boolean isReadMoreEntryIds(DynamicObject obj) {
        if (obj.getDataEntityState().getEntryInfos() == null) {
            return false;
        }
        EntryInfo entryInfo = (EntryInfo)obj.getDataEntityState().getEntryInfos().get(this.getEntryKey());
        if (entryInfo == null) {
            return false;
        }
        if (entryInfo.getRowCount() == null || entryInfo.getPageSize() > entryInfo.getRowCount()) {
            return false;
        }
        return this.trackerContext.getDbService().existSnapshot(new Long[]{(Long)obj.getPkValue()});
    }

    private List<Long> readOtherEntryIds() {
        Set<Long> entryIds = this.trackerOpContext.getOpController().readOtherEntryIds(this, this.trackerOpContext.getBillIds());
        Set<Long> snapshotEntryIds = this.trackerOpContext.getOpController().readSnapshotOtherEntryIds(this, this.trackerOpContext.getBillIds());
        AED aed = new AED();
        for (Long entryId : entryIds) {
            if (snapshotEntryIds.contains(entryId)) {
                aed.getEditList().add(new Tuple((Object)entryId, (Object)entryId));
                continue;
            }
            aed.getAddList().add(entryId);
        }
        for (Long entryId : snapshotEntryIds) {
            if (entryIds.contains(entryId)) continue;
            aed.getDeleteList().add(entryId);
        }
        ArrayList<Long> allEntryIds = new ArrayList<Long>(aed.getDeleteList().size() + aed.getEditList().size() + aed.getAddList().size());
        allEntryIds.addAll(aed.getDeleteList());
        for (Tuple tuple : aed.getEditList()) {
            allEntryIds.add((Long)tuple.item1);
        }
        allEntryIds.addAll(aed.getAddList());
        return allEntryIds;
    }

    private List<Long> readHistoryEntryIds() {
        Set<Long> snapshotEntryIds = this.trackerOpContext.getOpController().readSnapshotOtherEntryIds(this, this.trackerOpContext.getBillIds());
        ArrayList<Long> allEntryIds = new ArrayList<Long>(snapshotEntryIds);
        return allEntryIds;
    }
}

