/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.track;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntryType;
import kd.bos.service.botp.track.BFTrackerContext;
import kd.bos.service.botp.track.BFTrackerResult;
import kd.bos.service.botp.track.LinkItemContext;
import kd.bos.service.botp.track.helper.BFTrackerDbService;
import kd.bos.service.botp.track.helper.WRuleCompiler;

public class WriteBackContext {
    private BFTrackerContext trackerContext;
    private LinkItemContext linkItemContext;
    private BFTrackerResult trackerResult;
    private BFTrackerDbService dbService;
    private Map<Long, WRuleCompiler> rules = new HashMap<Long, WRuleCompiler>();
    private BillEntityType srcMainType;
    private BillEntityType srcSubMainType;
    private Map<String, EntryType> srcEntryTypes = new HashMap<String, EntryType>(1);
    private List<String> srcSelectFields;
    private Set<Long> srcBillIds = new HashSet<Long>();
    private Map<Long, Set<Long>> srcEntryIds = new HashMap<Long, Set<Long>>(1);

    public WriteBackContext(BFTrackerContext trackerContext, LinkItemContext linkItemContext, BFTrackerResult trackerResult, BFTrackerDbService dbService) {
        this.trackerContext = trackerContext;
        this.linkItemContext = linkItemContext;
        this.trackerResult = trackerResult;
        this.dbService = dbService;
    }

    public Map<Long, WRuleCompiler> getRules() {
        return this.rules;
    }

    public void setRules(Map<Long, WRuleCompiler> rules) {
        this.rules.clear();
        this.rules.putAll(rules);
        this.srcMainType = this.rules.entrySet().iterator().next().getValue().getSourceMainType();
        this.srcEntryTypes.clear();
        this.srcBillIds.clear();
        this.srcEntryIds.clear();
    }

    public BFTrackerContext getTrackerContext() {
        return this.trackerContext;
    }

    public BFTrackerResult getTrackerResult() {
        return this.trackerResult;
    }

    public LinkItemContext getLinkItemContext() {
        return this.linkItemContext;
    }

    public void setLinkItemContext(LinkItemContext linkItemContext) {
        this.linkItemContext = linkItemContext;
    }

    public BFTrackerDbService getDbService() {
        return this.dbService;
    }

    public BillEntityType getSrcMainType() {
        return this.srcMainType;
    }

    public BillEntityType getSrcSubMainType() {
        return this.srcSubMainType;
    }

    public void setSrcSubMainType(BillEntityType srcSubMainType) {
        this.srcSubMainType = srcSubMainType;
    }

    public String buildSrcBillInfoKey() {
        if (this.srcSubMainType != null && StringUtils.isNotBlank((CharSequence)this.srcSubMainType.getExtendName())) {
            return this.srcSubMainType.getExtendName();
        }
        return this.srcMainType.getName();
    }

    public Map<String, EntryType> getSrcEntryTypes() {
        return this.srcEntryTypes;
    }

    public List<String> getSrcSelectFields() {
        return this.srcSelectFields;
    }

    public void setSrcSelectFields(List<String> srcSelectFields) {
        this.srcSelectFields = srcSelectFields;
    }

    public Set<Long> getSrcBillIds() {
        return this.srcBillIds;
    }

    public Map<Long, Set<Long>> getSrcEntryIds() {
        return this.srcEntryIds;
    }
}

