/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.track.actions;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import kd.bos.context.RequestContext;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.botp.track.BFTrackerBatchContext;
import kd.bos.service.botp.track.BFTrackerBatchResult;
import kd.bos.service.botp.track.BFTrackerContext;
import kd.bos.service.botp.track.BFTrackerOpContext;
import kd.bos.service.botp.track.BFTrackerResult;
import kd.bos.service.botp.track.LinkItemContext;
import kd.bos.service.botp.track.actions.AbstractTrackAction;
import kd.bos.service.botp.track.actions.BuildCurrBillTrackerAction;
import kd.bos.service.botp.track.actions.BuildLinkUpNodesAction;
import kd.bos.service.botp.track.actions.BuildSheetAction;
import kd.bos.service.botp.track.actions.BuildWRulesAction;
import kd.bos.service.botp.track.actions.CalcRealAmountAction;
import kd.bos.service.botp.track.actions.ExecuteWriteLogicAction;
import kd.bos.service.botp.track.actions.LoadCurrRuleVersAction;
import kd.bos.service.botp.track.actions.LoadSnapRuleVersAction;
import kd.bos.service.botp.track.actions.OutputSnapshotLogAction;
import kd.bos.service.botp.track.actions.SyncEntryTrackerAction;
import kd.bos.service.botp.track.helper.BillTrackerBuilder;

public class BFTrackBatchExecuter
implements Callable<BFTrackerBatchResult> {
    private RequestContext rc;
    private static Log log = LogFactory.getLog(BFTrackBatchExecuter.class);
    private BFTrackerContext trackerContext;
    private BFTrackerOpContext trackerOpContext;
    private LinkItemContext linkItemContext;
    private BillTrackerBuilder billTrackerHelper;
    private BFTrackerResult trackerResult;
    private BFTrackerBatchContext batchContext;
    private List<AbstractTrackAction> actions = new ArrayList<AbstractTrackAction>(0);
    private boolean syncExecute = false;

    public boolean isSyncExecute() {
        return this.syncExecute;
    }

    public void setSyncExecute(boolean syncExecute) {
        this.syncExecute = syncExecute;
    }

    public BFTrackBatchExecuter(RequestContext rc, BFTrackerContext trackerContext, BFTrackerOpContext trackerOpContext, LinkItemContext linkItemContext, BFTrackerBatchContext batchContext, BFTrackerResult trackerResult, BillTrackerBuilder billTrackerHelper) {
        this.rc = rc;
        this.trackerContext = trackerContext;
        this.trackerOpContext = trackerOpContext;
        this.linkItemContext = linkItemContext;
        this.batchContext = batchContext;
        this.trackerResult = trackerResult;
        this.billTrackerHelper = billTrackerHelper;
        this.actions = this.createActions();
    }

    @Override
    public BFTrackerBatchResult call() throws Exception {
        if (!this.isSyncExecute()) {
            RequestContext.copyAndSet((RequestContext)this.rc);
        }
        BFTrackerBatchResult batchResult = new BFTrackerBatchResult();
        try {
            batchResult = this.doActions();
        }
        catch (KDBizException ex) {
            batchResult.setException(ex);
            this.trackerOpContext.setSkipNextBatch(true);
        }
        catch (Throwable ex) {
            batchResult.setException(ex);
            this.trackerOpContext.setSkipNextBatch(true);
            log.error(ex);
        }
        return batchResult;
    }

    public BFTrackerBatchResult doActions() {
        if (this.trackerContext.getOperateLog().isWriteLog()) {
            String logMsg = String.format("BFTrackBatchExecuter.doActions() begin: entity = %s, batch = %s, entryIds = %s, entryOids = %s,  other page entryIds count = %s", this.linkItemContext.getLinkSetItem().getParentEntityKey(), this.batchContext.getBatchIndex(), this.linkItemContext.getCurrPageEntryIds().size(), this.linkItemContext.getCurrPageEntryOids().size(), this.batchContext.getEntryIds() == null ? 0 : this.batchContext.getEntryIds().size());
            this.trackerContext.getOperateLog().beginMothed("BFTrackBatchExecuter.doActions()", logMsg);
        }
        BFTrackerBatchResult batchResult = new BFTrackerBatchResult();
        for (AbstractTrackAction action : this.actions) {
            action.action(this.batchContext, batchResult);
        }
        batchResult.setSuccess(true);
        batchResult.clearMemory();
        if (this.trackerContext.getOperateLog().isWriteLog()) {
            this.trackerContext.getOperateLog().endMothed("BFTrackBatchExecuter.doActions()", null);
        }
        return batchResult;
    }

    private List<AbstractTrackAction> createActions() {
        ArrayList<AbstractTrackAction> list = new ArrayList<AbstractTrackAction>();
        list.add(new BuildSheetAction(this.trackerContext, this.trackerOpContext, this.linkItemContext, this.trackerResult, this.billTrackerHelper));
        list.add(new BuildCurrBillTrackerAction(this.trackerContext, this.trackerOpContext, this.linkItemContext, this.trackerResult, this.billTrackerHelper));
        list.add(new SyncEntryTrackerAction(this.trackerContext, this.trackerOpContext, this.linkItemContext, this.trackerResult, this.billTrackerHelper));
        list.add(new BuildLinkUpNodesAction(this.trackerContext, this.trackerOpContext, this.linkItemContext, this.trackerResult, this.billTrackerHelper));
        list.add(new LoadCurrRuleVersAction(this.trackerContext, this.trackerOpContext, this.linkItemContext, this.trackerResult, this.billTrackerHelper));
        list.add(new BuildWRulesAction(this.trackerContext, this.trackerOpContext, this.linkItemContext, this.trackerResult, this.billTrackerHelper));
        list.add(new LoadSnapRuleVersAction(this.trackerContext, this.trackerOpContext, this.linkItemContext, this.trackerResult, this.billTrackerHelper));
        list.add(new CalcRealAmountAction(this.trackerContext, this.trackerOpContext, this.linkItemContext, this.trackerResult, this.billTrackerHelper));
        list.add(new ExecuteWriteLogicAction(this.trackerContext, this.trackerOpContext, this.linkItemContext, this.trackerResult, this.billTrackerHelper));
        list.add(new OutputSnapshotLogAction(this.trackerContext, this.trackerOpContext, this.linkItemContext, this.trackerResult, this.billTrackerHelper));
        return list;
    }
}

