/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.track.actions;

import java.util.HashSet;
import kd.bos.service.botp.track.BFTrackerContext;
import kd.bos.service.botp.track.BFTrackerOpContext;
import kd.bos.service.botp.track.BFTrackerResult;
import kd.bos.service.botp.track.LinkItemContext;
import kd.bos.service.botp.track.actions.AbstractTrackAction;
import kd.bos.service.botp.track.bizentity.Row;
import kd.bos.service.botp.track.bizentity.Sheet;
import kd.bos.service.botp.track.bizentity.Sheets;
import kd.bos.service.botp.track.helper.BillTrackerBuilder;

public class BuildSheetAction
extends AbstractTrackAction {
    public BuildSheetAction(BFTrackerContext trackerContext, BFTrackerOpContext trackerOpContext, LinkItemContext linkItemContext, BFTrackerResult trackerResult, BillTrackerBuilder billTrackerBuilder) {
        super(trackerContext, trackerOpContext, linkItemContext, trackerResult, billTrackerBuilder);
    }

    @Override
    protected void doAction() {
        Sheets sheets = null;
        Sheets snapshot = null;
        if (this.batchContext.getEntryIds() == null) {
            sheets = this.opController.createSheets(this.linkItemContext, this.trackerOpContext.getDataEntities());
            HashSet<Long> entryIds = new HashSet<Long>(this.linkItemContext.getCurrPageEntryIds());
            entryIds.addAll(this.linkItemContext.getCurrPageEntryOids());
            snapshot = this.opController.createSubSnapshotSheets(this.linkItemContext, entryIds);
        } else {
            sheets = this.opController.createSubSheets(this.linkItemContext, this.trackerOpContext.getDataEntities(), this.trackerOpContext.getBillIds(), this.batchContext.getEntryIds());
            snapshot = this.trackerOpContext.getOpController().createSubSnapshotSheets(this.linkItemContext, this.batchContext.getEntryIds());
        }
        this.batchResult.setSheets(sheets);
        this.batchResult.setSnapshot(snapshot);
        if (sheets.isEmpty() && snapshot.isEmpty()) {
            this.batchResult.setSkipNextAction(true);
        }
        if (!snapshot.isEmpty()) {
            this.trackerOpContext.setHasSnapshot(true);
            HashSet<Long> srcMainTableIds = new HashSet<Long>(1);
            HashSet<Long> srcBillIds = new HashSet<Long>(1);
            for (Sheet histSheet : snapshot.values()) {
                for (Row row : histSheet.getRows().values()) {
                    srcMainTableIds.add(row.getSId().getMainTableId());
                    srcBillIds.add(row.getSId().getBillId());
                }
            }
            this.trackerOpContext.getHistSrcMainTableIds().addAll(srcMainTableIds);
            this.trackerOpContext.getHistSrcBillIds().addAll(srcBillIds);
        }
    }
}

