/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.track.actions;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.Tuple;
import kd.bos.service.botp.track.BFTrackerContext;
import kd.bos.service.botp.track.BFTrackerOpContext;
import kd.bos.service.botp.track.BFTrackerResult;
import kd.bos.service.botp.track.LinkItemContext;
import kd.bos.service.botp.track.actions.AbstractTrackAction;
import kd.bos.service.botp.track.bizentity.AED;
import kd.bos.service.botp.track.bizentity.Row;
import kd.bos.service.botp.track.bizentity.WRule;
import kd.bos.service.botp.track.helper.BillTrackerBuilder;
import kd.bos.service.botp.track.helper.SheetSync;
import kd.bos.service.botp.track.helper.WRuleCompiler;

public class CalcRealAmountAction
extends AbstractTrackAction {
    public CalcRealAmountAction(BFTrackerContext trackerContext, BFTrackerOpContext trackerOpContext, LinkItemContext linkItemContext, BFTrackerResult trackerResult, BillTrackerBuilder billTrackerBuilder) {
        super(trackerContext, trackerOpContext, linkItemContext, trackerResult, billTrackerBuilder);
    }

    @Override
    protected void doAction() {
        AED<Row> aedRows = this.batchResult.getAEDRows();
        Map<Long, WRuleCompiler> allRuleVers = this.trackerOpContext.getAllRuleVers();
        List<WRule> lstWRules = this.mergeWRuleWithHistory(aedRows);
        SheetSync.calcRealAmount(allRuleVers, lstWRules);
        this.batchResult.setWRules(lstWRules);
    }

    private List<WRule> mergeWRuleWithHistory(AED<Row> aedRows) {
        WRule wRule;
        AED<WRule> aedWRule = SheetSync.syncWRules(aedRows);
        int size = aedWRule.getDeleteList().size() + aedWRule.getEditList().size() + aedWRule.getAddList().size();
        ArrayList<WRule> wrules = new ArrayList<WRule>(size);
        for (WRule wRule2 : aedWRule.getDeleteList()) {
            wRule = WRule.mergeHistoryRow(null, wRule2);
            wrules.add(wRule);
        }
        for (Tuple tuple : aedWRule.getEditList()) {
            WRule currWRule = (WRule)tuple.item1;
            WRule snapWRule = (WRule)tuple.item2;
            WRule wRule2 = WRule.mergeHistoryRow(currWRule, snapWRule);
            wrules.add(wRule2);
        }
        for (WRule wRule3 : aedWRule.getAddList()) {
            wRule = WRule.mergeHistoryRow(wRule3, null);
            wrules.add(wRule);
        }
        return wrules;
    }
}

