/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.track.actions;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.botp.WriteBackType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.DataMutex;
import kd.bos.service.botp.track.BFTrackerContext;
import kd.bos.service.botp.track.BFTrackerOpContext;
import kd.bos.service.botp.track.BFTrackerResult;
import kd.bos.service.botp.track.LinkItemContext;
import kd.bos.service.botp.track.WriteBackContext;
import kd.bos.service.botp.track.WriteBackEngine;
import kd.bos.service.botp.track.actions.AbstractTrackAction;
import kd.bos.service.botp.track.bizentity.Row;
import kd.bos.service.botp.track.bizentity.WRule;
import kd.bos.service.botp.track.bizentity.WSRow;
import kd.bos.service.botp.track.helper.BillTrackerBuilder;
import kd.bos.service.botp.track.helper.TrackerTypes;
import kd.bos.service.botp.track.helper.WRuleCompiler;
import kd.bos.service.botp.track.helper.WRuleItemCompiler;
import kd.bos.servicehelper.DBServiceHelper;

public class ExecuteWriteLogicAction
extends AbstractTrackAction {
    private static Log log = LogFactory.getLog(ExecuteWriteLogicAction.class);
    private Map<Long, WRuleCompiler> allRuleVers = new HashMap<Long, WRuleCompiler>();
    private Map<String, Map<Long, WRuleCompiler>> dctRuleBySrcBill = new HashMap<String, Map<Long, WRuleCompiler>>();

    public ExecuteWriteLogicAction(BFTrackerContext trackerContext, BFTrackerOpContext trackerOpContext, LinkItemContext linkItemContext, BFTrackerResult trackerResult, BillTrackerBuilder billTrackerBuilder) {
        super(trackerContext, trackerOpContext, linkItemContext, trackerResult, billTrackerBuilder);
    }

    @Override
    protected void doAction() {
        this.allRuleVers = this.trackerOpContext.getAllRuleVers();
        this.dctRuleBySrcBill = this.trackerOpContext.getRuleBySrcBill();
        Map<String, List<WRule>> dctWRules = this.splitBySourceBill(this.batchResult.getWRules());
        this.execWriteLogicUnit(this.linkItemContext, dctWRules);
    }

    private Map<String, List<WRule>> splitBySourceBill(List<WRule> lstWRules) {
        BigDecimal zero = new BigDecimal(0);
        HashMap<String, List<WRule>> dctWRules = new HashMap<String, List<WRule>>();
        for (WRule wRule : lstWRules) {
            WRuleCompiler ruleCompiler = this.allRuleVers.get(wRule.getRuleVerId());
            WRuleItemCompiler itemCompiler = ruleCompiler.getItems().get(wRule.getRuleItemId());
            if (wRule.getExecuteSourceRows().isEmpty() || itemCompiler.getItem().getWriteBackType() != WriteBackType.Cover && wRule.getExecuteSourceRows().size() == 1 && wRule.getExecuteSourceRows().getTotalVal() != null && wRule.getExecuteSourceRows().getTotalVal().compareTo(zero) == 0) continue;
            String srcEntityNumber = ruleCompiler.getSourceEntityNumber();
            if (!dctWRules.containsKey(srcEntityNumber)) {
                ArrayList list = new ArrayList();
                dctWRules.put(srcEntityNumber, list);
            }
            ((List)dctWRules.get(srcEntityNumber)).add(wRule);
        }
        return dctWRules;
    }

    private void execWriteLogicUnit(LinkItemContext linkItemContext, Map<String, List<WRule>> dctWRules) {
        WriteBackContext writeBackContext = new WriteBackContext(this.trackerContext, linkItemContext, this.trackerResult, this.trackerContext.getDbService());
        WriteBackEngine writeBackEngine = new WriteBackEngine(writeBackContext);
        for (Map.Entry<String, List<WRule>> entry : dctWRules.entrySet()) {
            String srcEntityNumber = entry.getKey();
            List<WRule> wRules = entry.getValue();
            Map<Long, WRuleCompiler> rules = this.dctRuleBySrcBill.get(srcEntityNumber);
            writeBackEngine.doWriteBack(rules, wRules);
            this.applyWBSnap(wRules);
            if (!Boolean.parseBoolean(this.trackerContext.getOption().getVariableValue("isopenintentlocks", "false"))) continue;
            for (WRule wRule : wRules) {
                Row parent = wRule.getParent();
                Long pkId = parent.getSId().getEntryId();
                try {
                    DataMutex dataMutex = DataMutex.create();
                    Throwable throwable = null;
                    try {
                        dataMutex.releaseIntent(srcEntityNumber, String.valueOf(pkId));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (dataMutex == null) continue;
                        if (throwable != null) {
                            try {
                                dataMutex.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        dataMutex.close();
                    }
                }
                catch (IOException e) {
                    log.info(e.getMessage());
                }
            }
        }
    }

    private void applyWBSnap(List<WRule> lstWRules) {
        for (WRule wRule : lstWRules) {
            if (wRule.getExecuteSourceRows().size() == 0) continue;
            ArrayList<Long> ids = new ArrayList<Long>(wRule.getHistorySourceRows().values().size());
            for (WSRow wsRow : wRule.getHistorySourceRows().values()) {
                ids.add(wsRow.getWBEntryId());
            }
            this.batchResult.getDelWBIds().addAll(ids);
            this.trackerResult.addDelWBSnapIds(ids);
            ArrayList<DynamicObject> wbSnapRows = new ArrayList<DynamicObject>(wRule.getResultSourceRows().values().size());
            for (WSRow wsRow : wRule.getResultSourceRows().values()) {
                DynamicObject wbSnapRow = this.buildWBSnapRow(wsRow);
                wbSnapRows.add(wbSnapRow);
            }
            this.batchResult.getNewWBItems().addAll(wbSnapRows);
            this.trackerResult.addNewWBSnaps(wbSnapRows);
        }
    }

    private DynamicObject buildWBSnapRow(WSRow wsRow) {
        TrackerTypes trackerTypes = this.trackerContext.getTrackerTypes();
        BillEntityType wbSnapType = trackerTypes.getWbItemType();
        DynamicObject wbSnapRow = new DynamicObject((DynamicObjectType)wbSnapType);
        long wbEntryId = DBServiceHelper.genGlobalLongId();
        wsRow.setWBEntryId(wbEntryId);
        trackerTypes.getWB_idProp().setValueFast((Object)wbSnapRow, (Object)wbEntryId);
        trackerTypes.getWB_fid().setValueFast((Object)wbSnapRow, (Object)wsRow.getParent().getParent().getEntryTrackerId());
        trackerTypes.getWB_ruleVerIdProp().setValueFast((Object)wbSnapRow, (Object)wsRow.getParent().getRuleVerId());
        trackerTypes.getWB_ruleItemIdProp().setValueFast((Object)wbSnapRow, (Object)wsRow.getParent().getRuleItemId());
        trackerTypes.getWB_sBillIdProp().setValueFast((Object)wbSnapRow, (Object)wsRow.getSId().getBillId());
        trackerTypes.getWB_sTableIdProp().setValueFast((Object)wbSnapRow, (Object)wsRow.getSId().getTableId());
        trackerTypes.getWB_sIdProp().setValueFast((Object)wbSnapRow, (Object)wsRow.getSId().getEntryId());
        trackerTypes.getWB_valueProp().setValueFast((Object)wbSnapRow, (Object)wsRow.getVal());
        return wbSnapRow;
    }
}

