/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.track.actions;

import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.BillEntityType;
import kd.bos.service.botp.track.BFTrackerContext;
import kd.bos.service.botp.track.BFTrackerOpContext;
import kd.bos.service.botp.track.BFTrackerResult;
import kd.bos.service.botp.track.LinkItemContext;
import kd.bos.service.botp.track.actions.AbstractTrackAction;
import kd.bos.service.botp.track.bizentity.AED;
import kd.bos.service.botp.track.bizentity.Row;
import kd.bos.service.botp.track.helper.BillTrackerBuilder;
import kd.bos.service.botp.track.helper.SheetSync;
import kd.bos.service.botp.track.helper.TrackerTypes;
import kd.bos.servicehelper.DBServiceHelper;

public class SyncEntryTrackerAction
extends AbstractTrackAction {
    public SyncEntryTrackerAction(BFTrackerContext trackerContext, BFTrackerOpContext trackerOpContext, LinkItemContext linkItemContext, BFTrackerResult trackerResult, BillTrackerBuilder billTrackerBuilder) {
        super(trackerContext, trackerOpContext, linkItemContext, trackerResult, billTrackerBuilder);
    }

    @Override
    protected void doAction() {
        AED<Row> aedRows = SheetSync.syncRows(this.batchResult.getSheets(), this.batchResult.getSnapshot());
        this.applyEntryTracker(aedRows);
        this.batchResult.setAEDRows(aedRows);
        if (this.trackerContext.getOperateLog().isWriteLog()) {
            String logMsg = String.format("SyncEntryTrackerAction.doAction(), batch = %s, add %s rows, modify %s rows, delete %s rows", this.batchContext.getBatchIndex(), aedRows.getAddList().size(), aedRows.getEditList().size(), aedRows.getDeleteList().size());
            this.trackerContext.getOperateLog().info(logMsg);
        }
    }

    private void applyEntryTracker(AED<Row> aed) {
        ArrayList<DynamicObject> trackerObjs = new ArrayList<DynamicObject>(aed.getAddList().size());
        for (Row row : aed.getAddList()) {
            DynamicObject trackerObj = this.buildNewEntryTracker(row);
            trackerObjs.add(trackerObj);
        }
        this.batchResult.getNewEntryTrackers().addAll(trackerObjs);
        this.trackerResult.addNewEntryTrackers(trackerObjs);
        ArrayList<Long> delIds = new ArrayList<Long>(aed.getDeleteList().size());
        ArrayList<DynamicObject> delTrackerObjs = new ArrayList<DynamicObject>(aed.getDeleteList().size());
        for (Row row : aed.getDeleteList()) {
            delIds.add(row.getEntryTrackerId());
            DynamicObject trackerObj = this.buildEntryTracker(row);
            delTrackerObjs.add(trackerObj);
        }
        this.batchResult.getDelEntryTrackerIds().addAll(delIds);
        this.trackerResult.addDelEntryTrackerIds(delIds);
        this.trackerResult.addDelEntryTrackers(delTrackerObjs);
    }

    private DynamicObject buildNewEntryTracker(Row row) {
        TrackerTypes trackerTypes = this.trackerContext.getTrackerTypes();
        BillEntityType trackerType = trackerTypes.getEntryTrackerType();
        DynamicObject trackerObj = new DynamicObject((DynamicObjectType)trackerType);
        long trackerId = DBServiceHelper.genGlobalLongId();
        row.setEntryTrackerId(trackerId);
        trackerTypes.getTC_idProp().setValueFast((Object)trackerObj, (Object)trackerId);
        trackerTypes.getTC_tBillIdProp().setValueFast((Object)trackerObj, (Object)row.getId().getBillId());
        trackerTypes.getTC_tTableIdProp().setValueFast((Object)trackerObj, (Object)row.getId().getTableId());
        trackerTypes.getTC_tIdProp().setValueFast((Object)trackerObj, (Object)row.getId().getEntryId());
        trackerTypes.getTC_sBillIdProp().setValueFast((Object)trackerObj, (Object)row.getSId().getBillId());
        trackerTypes.getTC_sTableIdProp().setValueFast((Object)trackerObj, (Object)row.getSId().getTableId());
        trackerTypes.getTC_sIdProp().setValueFast((Object)trackerObj, (Object)row.getSId().getEntryId());
        return trackerObj;
    }

    private DynamicObject buildEntryTracker(Row row) {
        TrackerTypes trackerTypes = this.trackerContext.getTrackerTypes();
        BillEntityType trackerType = trackerTypes.getEntryTrackerType();
        DynamicObject trackerObj = new DynamicObject((DynamicObjectType)trackerType);
        trackerTypes.getTC_idProp().setValueFast((Object)trackerObj, (Object)row.getEntryTrackerId());
        trackerTypes.getTC_tBillIdProp().setValueFast((Object)trackerObj, (Object)row.getId().getBillId());
        trackerTypes.getTC_tTableIdProp().setValueFast((Object)trackerObj, (Object)row.getId().getTableId());
        trackerTypes.getTC_tIdProp().setValueFast((Object)trackerObj, (Object)row.getId().getEntryId());
        trackerTypes.getTC_sBillIdProp().setValueFast((Object)trackerObj, (Object)row.getSId().getBillId());
        trackerTypes.getTC_sTableIdProp().setValueFast((Object)trackerObj, (Object)row.getSId().getTableId());
        trackerTypes.getTC_sIdProp().setValueFast((Object)trackerObj, (Object)row.getSId().getEntryId());
        return trackerObj;
    }
}

