/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.track.distlogic;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.service.botp.track.distlogic.AbstractDistributeLogic;
import kd.bos.service.botp.track.distlogic.DistributeRow;

public class TopDownLogic
extends AbstractDistributeLogic {
    private BigDecimal zero = new BigDecimal(0);

    @Override
    public void Distribute() {
        ArrayList<DistributeRow> lstPositive = new ArrayList<DistributeRow>();
        ArrayList<DistributeRow> lstNegative = new ArrayList<DistributeRow>();
        for (DistributeRow row : this.getDistributeRows()) {
            if (row.getMaxAmount().compareTo(this.zero) >= 0) {
                lstPositive.add(row);
                continue;
            }
            lstNegative.add(row);
        }
        if (this.getTotalAmount().compareTo(this.zero) == 0) {
            for (DistributeRow row : this.getDistributeRows()) {
                row.setDistAmount(this.zero);
            }
        } else if (this.getTotalAmount().compareTo(this.zero) > 0) {
            this.distributeWithPriority(lstNegative, lstPositive);
        } else {
            this.distributeWithPriority(lstPositive, lstNegative);
        }
    }

    private void distributeWithPriority(List<DistributeRow> firsList, List<DistributeRow> secondList) {
        BigDecimal rowAmount;
        int rowsCount = firsList.size() + secondList.size();
        int seqForAll = 1;
        BigDecimal hadDistAmount = this.zero;
        for (DistributeRow item : firsList) {
            rowAmount = item.getMaxAmount();
            if (seqForAll == rowsCount || this.isOver(hadDistAmount.add(rowAmount))) {
                rowAmount = this.getTotalAmount().subtract(hadDistAmount);
            }
            item.setDistAmount(rowAmount);
            hadDistAmount = hadDistAmount.add(rowAmount);
            ++seqForAll;
        }
        for (DistributeRow item : secondList) {
            rowAmount = item.getMaxAmount();
            if (seqForAll == rowsCount || this.isOver(hadDistAmount.add(rowAmount))) {
                rowAmount = this.getTotalAmount().subtract(hadDistAmount);
            }
            item.setDistAmount(rowAmount);
            hadDistAmount = hadDistAmount.add(rowAmount);
            ++seqForAll;
        }
    }

    private boolean isOver(BigDecimal hadDistAmount) {
        if (this.getTotalAmount().compareTo(this.zero) >= 0) {
            return hadDistAmount.compareTo(this.getTotalAmount()) >= 0;
        }
        return hadDistAmount.compareTo(this.getTotalAmount()) <= 0;
    }
}

