/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.track.getvaluemode;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.property.EntryProp;

public class FieldVariable {
    private String var;
    private String[] keyItems;
    private IDataEntityProperty fieldProp;
    private String fullPropName;

    public FieldVariable(String var, String[] keyItems, IDataEntityProperty fieldProp) {
        this.var = var;
        this.keyItems = keyItems;
        this.fieldProp = fieldProp;
        ArrayList<String> propNames = new ArrayList<String>(Arrays.asList(keyItems));
        if (fieldProp instanceof EntryProp) {
            EntryType entryType;
            propNames.remove(0);
            if (keyItems.length == 1) {
                entryType = (EntryType)((EntryProp)this.fieldProp).getItemType();
                this.fieldProp = entryType.getPrimaryKey();
            } else {
                entryType = (EntryType)((EntryProp)this.fieldProp).getItemType();
                IDataEntityProperty subProp = entryType.findProperty(keyItems[1]);
                if (subProp == null) {
                    subProp = entryType.findProperty(var);
                }
                if (subProp != null) {
                    this.fieldProp = subProp;
                }
            }
        }
        if (this.fieldProp.getParent() instanceof SubEntryType) {
            SubEntryType subEntryType = (SubEntryType)this.fieldProp.getParent();
            this.fullPropName = subEntryType.getParent().getName() + "." + subEntryType.getName() + "." + StringUtils.join((Object[])propNames.toArray(), (String)".");
        } else {
            this.fullPropName = this.fieldProp.getParent() instanceof EntryType ? this.fieldProp.getParent().getName() + "." + StringUtils.join((Object[])propNames.toArray(), (String)".") : var;
        }
    }

    public String getVar() {
        return this.var;
    }

    public String[] getKeyItems() {
        return this.keyItems;
    }

    public IDataEntityProperty getFieldProp() {
        return this.fieldProp;
    }

    public String getFullPropName() {
        return this.fullPropName;
    }

    public LinkedHashSet<String> getBelongEntityKeys() {
        LinkedHashSet<String> entityKeys = new LinkedHashSet<String>();
        IDataEntityType parentType = this.fieldProp.getParent();
        entityKeys.add(parentType.getName());
        while (parentType.getParent() != null) {
            parentType = parentType.getParent();
            entityKeys.add(parentType.getName());
        }
        return entityKeys;
    }
}

