/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.track.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.botp.BOTPLogService;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.botp.BillCloseType;
import kd.bos.entity.botp.log.BOTPLog;
import kd.bos.entity.botp.log.WFLogDetailInfo;
import kd.bos.entity.botp.plugin.args.AfterSaveSourceBillEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeSaveSourceBillEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.dataentity.ShardingHinter;
import kd.bos.orm.query.QFilter;
import kd.bos.service.botp.track.BFTrackerContext;
import kd.bos.service.botp.track.BFTrackerResult;
import kd.bos.service.botp.track.bizentity.BillCloseItem;
import kd.bos.service.botp.track.bizentity.SourceBillInfo;
import kd.bos.service.botp.track.helper.BFTrackerDbService;
import kd.bos.service.botp.track.helper.SaveTrackerAnsy;
import kd.bos.servicehelper.botp.BOTPLogServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.xdb.hint.ShardingHintContext;

public interface ISaveTracker {
    public static final Log log = LogFactory.getLog(ISaveTracker.class);

    public static ISaveTracker get() {
        return new SaveTrackerAnsy();
    }

    public void saveBeforeTrans(BFTrackerContext var1, BFTrackerResult var2, BFTrackerDbService var3);

    default public void saveBeginTrans(BFTrackerContext trackerContext, BFTrackerResult trackerResult, BFTrackerDbService dbService) {
    }

    public void saveTrans(BFTrackerContext var1, BFTrackerResult var2, BFTrackerDbService var3);

    default public void saveAfterTrans(BFTrackerContext trackerContext, BFTrackerResult trackerResult, BFTrackerDbService dbService) {
    }

    default public void rollbackSave(BFTrackerContext trackerContext, BFTrackerResult trackerResult, BFTrackerDbService dbService) {
    }

    default public void saveFinally(BFTrackerContext trackerContext, BFTrackerResult trackerResult, BFTrackerDbService dbService) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveEntryTrackers(BFTrackerContext trackerContext, BFTrackerResult trackerResult, BFTrackerDbService dbService) {
        ShardingHintContext ctx;
        if (trackerContext.getOperateLog().isWriteLog()) {
            trackerContext.getOperateLog().info(String.format("saveEntryTrackers(add %s row, del %s row, del %s wb_row, add %s wb_row", trackerResult.getNewEntryTrackers().size(), trackerResult.getDelEntryTrackerIds().size(), trackerResult.getDelWBSnapIds().size(), trackerResult.getNewWBSnaps().size()));
        }
        if ((ctx = ShardingHinter.tryHint((IDataEntityType)trackerContext.getTargetMainType(), (Object[])trackerContext.getTargetBillIds().toArray())) != null) {
            try {
                ctx.set();
                dbService.saveEntryTrackers(trackerResult.getNewEntryTrackers());
                dbService.deleteEntryTrackers(trackerResult.getDelEntryTrackerIds());
                trackerResult.saveBotpLinkLog.addBotpLinkLog(trackerContext, trackerResult, null, trackerResult.getDelEntryTrackers(), dbService, RequestContext.get().getTraceId());
                dbService.deleteWBSnap(trackerResult.getDelWBSnapIds());
                dbService.saveWBSnap(trackerResult.getNewWBSnaps());
            }
            finally {
                ctx.close();
            }
        } else {
            dbService.saveEntryTrackers(trackerResult.getNewEntryTrackers());
            dbService.deleteEntryTrackers(trackerResult.getDelEntryTrackerIds());
            trackerResult.saveBotpLinkLog.addBotpLinkLog(trackerContext, trackerResult, null, trackerResult.getDelEntryTrackers(), dbService, RequestContext.get().getTraceId());
            dbService.deleteWBSnap(trackerResult.getDelWBSnapIds());
            dbService.saveWBSnap(trackerResult.getNewWBSnaps());
        }
        if (!trackerResult.getTrackerLog().getToTargetLogs().isEmpty()) {
            String dbRouteKey = trackerContext.getTrackerTypes().getEntryTrackerType().getDBRouteKey();
            BOTPLog[] toTargetLogs = trackerResult.getTrackerLog().getToTargetLogs().toArray(new BOTPLog[0]);
            BOTPLogServiceHelper.addLogs((String)dbRouteKey, (BOTPLog[])toTargetLogs, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteEntryTrackers(BFTrackerContext trackerContext, BFTrackerResult trackerResult, BFTrackerDbService dbService) {
        ShardingHintContext ctx;
        if (trackerContext.getOperateLog().isWriteLog()) {
            trackerContext.getOperateLog().info(String.format("deleteEntryTrackers(del %s row, del %s wb_row", trackerResult.getDelEntryTrackerIds().size(), trackerResult.getDelWBSnapIds().size()));
        }
        if ((ctx = ShardingHinter.tryHint((IDataEntityType)trackerContext.getTargetMainType(), (Object[])trackerContext.getTargetBillIds().toArray())) != null) {
            try {
                ctx.set();
                dbService.deleteEntryTrackers(trackerResult.getDelEntryTrackerIds());
                dbService.deleteWBSnap(trackerResult.getDelWBSnapIds());
                trackerResult.saveBotpLinkLog.addBotpLinkLog(trackerContext, trackerResult, null, trackerResult.getDelEntryTrackers(), dbService, RequestContext.get().getTraceId());
                trackerResult.getDelWBSnapIds().clear();
                trackerResult.getDelEntryTrackerIds().clear();
                trackerResult.getDelEntryTrackers().clear();
            }
            finally {
                ctx.close();
            }
        } else {
            dbService.deleteEntryTrackers(trackerResult.getDelEntryTrackerIds());
            dbService.deleteWBSnap(trackerResult.getDelWBSnapIds());
            trackerResult.saveBotpLinkLog.addBotpLinkLog(trackerContext, trackerResult, null, trackerResult.getDelEntryTrackers(), dbService, RequestContext.get().getTraceId());
            trackerResult.getDelWBSnapIds().clear();
            trackerResult.getDelEntryTrackerIds().clear();
            trackerResult.getDelEntryTrackers().clear();
        }
    }

    public static void saveBillTrackers(BFTrackerContext trackerContext, BFTrackerResult trackerResult, BFTrackerDbService dbService) {
        if (trackerContext.getOperateLog().isWriteLog()) {
            trackerContext.getOperateLog().info(String.format("saveBillTrackers(add %s bill, del %s bill", trackerResult.getNewBillTrackers().size(), trackerResult.getDelBillTrackerIds().size()));
        }
        dbService.saveBillTrackers(trackerResult.getNewBillTrackers());
        dbService.deleteBillTrackers(trackerResult.getDelBillTrackerIds());
        trackerResult.saveBotpLinkLog.addBotpLinkLog(trackerContext, trackerResult, trackerResult.getDelBillTrackers(), null, dbService, RequestContext.get().getTraceId());
        trackerContext.getOperateLog().important(ResManager.loadKDString((String)"\u53cd\u5199\u5f15\u64ce\uff0c\u540c\u6b65\u4fdd\u5b58\u5173\u8054\u5173\u7cfb\u5b8c\u6bd5", (String)"ISaveTracker_0", (String)"bos-mservice-botp", (Object[])new Object[0]));
    }

    public static void saveBillTrackers(BFTrackerContext trackerContext, BFTrackerResult trackerResult, BFTrackerDbService dbService, String sTraceId) {
        if (trackerContext.getOperateLog().isWriteLog()) {
            trackerContext.getOperateLog().info(String.format("saveBillTrackers(add %s bill, del %s bill", trackerResult.getNewBillTrackers().size(), trackerResult.getDelBillTrackerIds().size()));
        }
        dbService.saveBillTrackers(trackerResult.getNewBillTrackers());
        dbService.deleteBillTrackers(trackerResult.getDelBillTrackerIds());
        trackerContext.getOperateLog().important(ResManager.loadKDString((String)"\u53cd\u5199\u5f15\u64ce\uff0c\u540c\u6b65\u4fdd\u5b58\u5173\u8054\u5173\u7cfb\u5b8c\u6bd5", (String)"ISaveTracker_0", (String)"bos-mservice-botp", (Object[])new Object[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveSourceBill(BFTrackerContext trackerContext, SourceBillInfo sourceBillInfo) {
        BillEntityType srcMainType = sourceBillInfo.getSubMainType();
        Object[] srcBillObjs = sourceBillInfo.getHeadObjs();
        if (trackerContext.getOperateLog().isWriteLog() && srcMainType != null && srcBillObjs != null && srcBillObjs.length > 0) {
            trackerContext.getOperateLog().info(String.format("saveSourceBill(%s, %s, %s)", srcMainType.getName(), srcBillObjs.length, srcBillObjs[0].getPkValue()));
        }
        ISaveTracker.fireBeforeSaveSourceBill(trackerContext, srcMainType, (DynamicObject[])srcBillObjs);
        BusinessDataWriter.save((IDataEntityType)srcMainType, (Object[])srcBillObjs);
        ShardingHintContext ctx = null;
        if (srcBillObjs != null && srcMainType != null && ShardingHinter.isSharding((String)srcMainType.getAlias())) {
            Object[] pks = new Object[srcBillObjs.length];
            for (int i = 0; i < srcBillObjs.length; ++i) {
                pks[i] = srcBillObjs[i].getPkValue();
            }
            ctx = ShardingHinter.tryHint((IDataEntityType)srcMainType, (Object[])pks);
            if (ctx != null) {
                ctx.set();
            }
        }
        try {
            int rowCount = 0;
            Map<EntityType, List<DynamicObject>> entryRows = sourceBillInfo.nextPageEntryRowObjs();
            while (entryRows != null) {
                for (Map.Entry<EntityType, List<DynamicObject>> entry : entryRows.entrySet()) {
                    Object[] rows = entry.getValue().toArray(new DynamicObject[0]);
                    rowCount += rows.length;
                    BusinessDataWriter.save((IDataEntityType)((IDataEntityType)entry.getKey()), (Object[])rows);
                }
                entryRows = sourceBillInfo.nextPageEntryRowObjs();
            }
        }
        finally {
            if (ctx != null) {
                ctx.close();
            }
        }
        ISaveTracker.updateBillCloseStatus(trackerContext, (MainEntityType)srcMainType, (DynamicObject[])srcBillObjs, sourceBillInfo.getBillCloseItems());
        ISaveTracker.fireAfterSaveSourceBill(trackerContext, srcMainType, (DynamicObject[])srcBillObjs);
        if (srcMainType != null && srcBillObjs != null && srcBillObjs.length > 0) {
            String msg = String.format(ResManager.loadKDString((String)"\u53cd\u5199\u5f15\u64ce\uff0c\u540c\u6b65\u4fdd\u5b58\u6e90\u5355\u5b8c\u6bd5\uff1a%1$s, %2$s(%3$s bills)", (String)"ISaveTracker_1", (String)"bos-mservice-botp", (Object[])new Object[0]), srcMainType.getName(), srcBillObjs[0].getPkValue(), srcBillObjs.length);
            trackerContext.getOperateLog().important(msg);
        }
    }

    public static void updateBillCloseStatus(BFTrackerContext trackerContext, MainEntityType srcSubMainType, DynamicObject[] srcBillObjs, Set<BillCloseItem> billCloseItems) {
        if (billCloseItems.isEmpty()) {
            return;
        }
        HashMap closeFldGroup = new HashMap();
        for (BillCloseItem item : billCloseItems) {
            if (!closeFldGroup.containsKey(item.getBillCloseField())) {
                closeFldGroup.put(item.getBillCloseField(), new ArrayList());
            }
            ((List)closeFldGroup.get(item.getBillCloseField())).add(item);
        }
        HashSet closeBillIds = new HashSet();
        for (Map.Entry entry : closeFldGroup.entrySet()) {
            BillCloseItem billCloseItem = (BillCloseItem)((List)entry.getValue()).get(0);
            HashSet<Long> allBillIds = new HashSet<Long>(srcBillObjs.length);
            for (DynamicObject srcBill : srcBillObjs) {
                allBillIds.add((Long)srcBill.getPkValue());
            }
            QFilter qFilter = new QFilter("id", "in", (Object)allBillIds.toArray());
            IDataEntityProperty prop = srcSubMainType.findProperty(billCloseItem.getEntryCloseField());
            String propName = prop.getName();
            if (prop.getParent() instanceof SubEntryType) {
                propName = prop.getParent().getParent().getName() + "." + prop.getParent().getName() + "." + prop.getName();
            } else if (prop.getParent() instanceof EntryType) {
                propName = prop.getParent().getName() + "." + prop.getName();
            }
            if (billCloseItem.getBillCloseType() == BillCloseType.OneRowClosed) {
                qFilter.and(new QFilter(propName, "=", (Object)billCloseItem.getEntryCloseSuccesStatus()));
            } else {
                qFilter.and(new QFilter(propName, "!=", (Object)billCloseItem.getEntryCloseSuccesStatus()));
                closeBillIds.addAll(allBillIds);
            }
            ORM orm = ORM.create();
            try (DataSet ds = orm.queryDataSet("ISaveTracker", srcSubMainType.getName(), "id", new QFilter[]{qFilter});){
                while (ds.hasNext()) {
                    Row row = ds.next();
                    Long id = row.getLong("id");
                    if (billCloseItem.getBillCloseType() == BillCloseType.OneRowClosed) {
                        closeBillIds.add(id);
                        continue;
                    }
                    closeBillIds.remove(id);
                }
            }
            for (DynamicObject srcBillObj : srcBillObjs) {
                Long id = srcBillObj.getLong("id");
                if (closeBillIds.contains(id)) {
                    srcBillObj.set(billCloseItem.getBillCloseField(), (Object)billCloseItem.getBillCloseSuccesStatus());
                    continue;
                }
                srcBillObj.set(billCloseItem.getBillCloseField(), (Object)billCloseItem.getBillCloseFailStatus());
            }
            BusinessDataWriter.save((IDataEntityType)srcSubMainType, (Object[])srcBillObjs);
            closeBillIds.clear();
        }
    }

    public static void saveWriteBackLogs(BFTrackerContext trackerContext, SourceBillInfo sourceBillInfo) {
        if (sourceBillInfo.getWbLogs().isEmpty()) {
            log.info(String.format("\u53cd\u5199\u65e5\u5fd7\uff0c\u672a\u751f\u6210\u6e90\u5355%s\u7684\u53cd\u5199\u7ed3\u679c\u3001\u53cd\u5199\u503c\u53d8\u5316\u65e5\u5fd7", sourceBillInfo.getMainType().getName()));
            return;
        }
        log.info(String.format("\u53cd\u5199\u65e5\u5fd7\uff0c\u5171\u751f\u6210\u6e90\u5355%s\u7684\u53cd\u5199\u7ed3\u679c\u3001\u53cd\u5199\u503c\u53d8\u5316\u65e5\u5fd7%s\u6761", sourceBillInfo.getMainType().getName(), sourceBillInfo.getWbLogs().size()));
        String dbRouteKey = sourceBillInfo.getSubMainType().getDBRouteKey();
        BOTPLog[] toSourceLogs = sourceBillInfo.getWbLogs().toArray(new BOTPLog[0]);
        BOTPLogServiceHelper.addLogs((String)dbRouteKey, (BOTPLog[])toSourceLogs, null);
    }

    public static void updateWBLogFinishStatus(BFTrackerContext trackerContext, SourceBillInfo sourceBillInfo) {
        HashSet<Long> wbLogIds = new HashSet<Long>(sourceBillInfo.getWbLogs().size());
        HashSet<Long> wfLogIds = new HashSet<Long>(sourceBillInfo.getWbLogs().size());
        for (BOTPLog log : sourceBillInfo.getWbLogs()) {
            if (!(log.getDetailInfo() instanceof WFLogDetailInfo)) continue;
            wbLogIds.add(log.getParentId());
            wfLogIds.add(log.getId());
        }
        if (!wbLogIds.isEmpty()) {
            Object writebacklog = SystemParamServiceHelper.getBillParameter((String)"botp_log", (String)"writebacklog");
            if (writebacklog == null || !((Boolean)writebacklog).booleanValue()) {
                BOTPLogService service = new BOTPLogService();
                service.deleteWBLogs(trackerContext.getTargetMainType().getDBRouteKey(), wbLogIds.toArray(new Long[0]));
                service.delete(sourceBillInfo.getSubMainType().getDBRouteKey(), wfLogIds.toArray(new Long[0]));
            } else {
                BOTPLogServiceHelper.updateLogStatus((String)trackerContext.getTargetMainType().getDBRouteKey(), (Long[])wbLogIds.toArray(new Long[0]), (String)"1", (OperateOption)OperateOption.create());
            }
        }
    }

    public static BeforeSaveSourceBillEventArgs fireBeforeSaveSourceBill(BFTrackerContext trackerContext, BillEntityType srcSubMainType, DynamicObject[] srcDataEntities) {
        BeforeSaveSourceBillEventArgs eventArgs = new BeforeSaveSourceBillEventArgs(srcSubMainType, srcDataEntities);
        trackerContext.getPlugInProxy().fireBeforeSaveSourceBill(eventArgs);
        return eventArgs;
    }

    public static AfterSaveSourceBillEventArgs fireAfterSaveSourceBill(BFTrackerContext trackerContext, BillEntityType srcSubMainType, DynamicObject[] srcDataEntities) {
        AfterSaveSourceBillEventArgs eventArgs = new AfterSaveSourceBillEventArgs(srcSubMainType, srcDataEntities);
        trackerContext.getPlugInProxy().fireAfterSaveSourceBill(eventArgs);
        return eventArgs;
    }

    public static BeforeSaveSourceBillEventArgs ansyFireBeforeSaveSourceBill(BFTrackerContext trackerContext, BillEntityType srcSubMainType, DynamicObject[] srcDataEntities) {
        BeforeSaveSourceBillEventArgs eventArgs = new BeforeSaveSourceBillEventArgs(srcSubMainType, srcDataEntities);
        eventArgs.setNewThread(true);
        trackerContext.getPlugInProxy().fireBeforeSaveSourceBill(eventArgs);
        return eventArgs;
    }

    public static AfterSaveSourceBillEventArgs ansyFireAfterSaveSourceBill(BFTrackerContext trackerContext, BillEntityType srcSubMainType, DynamicObject[] srcDataEntities) {
        AfterSaveSourceBillEventArgs eventArgs = new AfterSaveSourceBillEventArgs(srcSubMainType, srcDataEntities);
        eventArgs.setNewThread(true);
        trackerContext.getPlugInProxy().fireAfterSaveSourceBill(eventArgs);
        return eventArgs;
    }
}

