/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.track.helper;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.log.AbstractDetailLogInfo;
import kd.bos.entity.botp.log.BOTPLog;
import kd.bos.entity.botp.log.ErrLogDetailInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.dataentity.ShardingHinter;
import kd.bos.service.botp.track.BFTrackerContext;
import kd.bos.service.botp.track.BFTrackerResult;
import kd.bos.service.botp.track.bizentity.BillCloseItem;
import kd.bos.service.botp.track.bizentity.BillTracker;
import kd.bos.service.botp.track.bizentity.SourceBillInfo;
import kd.bos.service.botp.track.helper.BFTrackerDbService;
import kd.bos.service.botp.track.helper.ISaveTracker;
import kd.bos.service.botp.track.helper.SaveTrackerAnsyResult;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.botp.BOTPLogServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.xdb.hint.ShardingHintContext;

public class SaveTrackerRunnable
implements Runnable,
Callable<SaveTrackerAnsyResult> {
    private static final Log log = LogFactory.getLog(SaveTrackerRunnable.class);
    private RequestContext rc;
    private static final String OPNAME_SAVEBILLTRACKER = "billtracker";
    private static final String OPNAME_SAVESRCBILL = "srcbill";
    private String opName;
    private BFTrackerContext trackerContext;
    private List<BillTracker> saveBillTrackers;
    private List<Long> delBillTrackerIds;
    private SourceBillInfo sourceBillInfo;
    private BillEntityType srcSubMainType;
    private DynamicObject[] srcDataEntities;
    private Map<EntityType, DynamicObject[]> srcEntryRows;
    private Set<BillCloseItem> billCloseItems;
    private BFTrackerResult bfTrackerResult;
    private BFTrackerDbService dbService;
    private String sTraceId;

    public void saveBillTracker(RequestContext rc, BFTrackerContext trackerContext, List<BillTracker> saveBillTrackers, List<Long> delBillTrackerIds) {
        this.rc = rc;
        this.opName = OPNAME_SAVEBILLTRACKER;
        this.trackerContext = trackerContext;
        this.saveBillTrackers = saveBillTrackers;
        this.delBillTrackerIds = delBillTrackerIds;
    }

    public void saveBillTracker(RequestContext rc, BFTrackerContext trackerContext, List<BillTracker> saveBillTrackers, List<Long> delBillTrackerIds, BFTrackerResult bfTrackerResult, BFTrackerDbService dbService, String sTraceId) {
        this.saveBillTracker(rc, trackerContext, saveBillTrackers, delBillTrackerIds);
        this.bfTrackerResult = bfTrackerResult;
        this.dbService = dbService;
        this.sTraceId = sTraceId;
    }

    public void saveSrcBill(RequestContext rc, BFTrackerContext trackerContext, BillEntityType srcSubMainType, DynamicObject[] srcDataEntities, Set<BillCloseItem> billCloseItems) {
        this.rc = rc;
        this.opName = OPNAME_SAVESRCBILL;
        this.trackerContext = trackerContext;
        this.srcSubMainType = srcSubMainType;
        this.srcDataEntities = srcDataEntities;
        this.billCloseItems = billCloseItems;
    }

    public void saveSrcBill(RequestContext rc, BFTrackerContext trackerContext, BillEntityType srcSubMainType, DynamicObject[] srcDataEntities, Map<EntityType, DynamicObject[]> srcEntryRows, Set<BillCloseItem> billCloseItems) {
        this.rc = rc;
        this.opName = OPNAME_SAVESRCBILL;
        this.trackerContext = trackerContext;
        this.srcSubMainType = srcSubMainType;
        this.srcDataEntities = srcDataEntities;
        this.srcEntryRows = srcEntryRows;
        this.billCloseItems = billCloseItems;
    }

    public void saveSrcBill(RequestContext rc, BFTrackerContext trackerContext, BillEntityType srcSubMainType, DynamicObject[] srcDataEntities, Map<EntityType, DynamicObject[]> srcEntryRows, Set<BillCloseItem> billCloseItems, BFTrackerResult bfTrackerResult, BFTrackerDbService dbService) {
        this.saveSrcBill(rc, trackerContext, srcSubMainType, srcDataEntities, srcEntryRows, billCloseItems);
        this.bfTrackerResult = bfTrackerResult;
        this.dbService = dbService;
    }

    public SourceBillInfo getSourceBillInfo() {
        return this.sourceBillInfo;
    }

    public void setSourceBillInfo(SourceBillInfo sourceBillInfo) {
        this.sourceBillInfo = sourceBillInfo;
    }

    public boolean isSaveBillTracker() {
        return StringUtils.equals((CharSequence)this.opName, (CharSequence)OPNAME_SAVEBILLTRACKER);
    }

    public boolean isSaveSrcBill() {
        return StringUtils.equals((CharSequence)this.opName, (CharSequence)OPNAME_SAVESRCBILL);
    }

    @Override
    public SaveTrackerAnsyResult call() throws Exception {
        SaveTrackerAnsyResult saveResult = new SaveTrackerAnsyResult();
        try {
            saveResult = this.save();
        }
        catch (Throwable ex) {
            saveResult.setException(ex);
            log.error(ex);
            this.writeBOTPErrorLog(ex);
        }
        finally {
            if (this.sourceBillInfo != null && this.isSaveSrcBill()) {
                this.sourceBillInfo.releaseDataMutex(new StringBuilder());
            }
        }
        return saveResult;
    }

    @Override
    public void run() {
        try {
            this.save();
        }
        catch (Throwable ex) {
            log.error(ex);
            this.writeBOTPErrorLog(ex);
            throw ex;
        }
        finally {
            if (this.sourceBillInfo != null && this.isSaveSrcBill()) {
                this.sourceBillInfo.releaseDataMutex(new StringBuilder());
            }
        }
    }

    private SaveTrackerAnsyResult save() {
        RequestContext.copyAndSet((RequestContext)this.rc);
        if (this.isSaveSrcBill()) {
            this.saveSrcBill();
        } else if (this.isSaveBillTracker()) {
            this.saveBillTracker();
        }
        SaveTrackerAnsyResult saveResult = new SaveTrackerAnsyResult();
        saveResult.setSuccess(true);
        return saveResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveSrcBill() {
        try (TXHandle h = TX.requiresNew();){
            try {
                ISaveTracker.ansyFireBeforeSaveSourceBill(this.trackerContext, this.srcSubMainType, this.srcDataEntities);
                if (this.srcDataEntities != null) {
                    SaveServiceHelper.save((IDataEntityType)this.srcSubMainType, (Object[])this.srcDataEntities);
                }
                if (this.srcEntryRows != null) {
                    ShardingHintContext ctx = null;
                    if (this.srcDataEntities != null && this.srcSubMainType != null && ShardingHinter.isSharding((String)this.srcSubMainType.getAlias())) {
                        Object[] pks = new Object[this.srcDataEntities.length];
                        for (int i = 0; i < this.srcDataEntities.length; ++i) {
                            pks[i] = this.srcDataEntities[i].getPkValue();
                        }
                        ctx = ShardingHinter.tryHint((IDataEntityType)this.srcSubMainType, (Object[])pks);
                        ctx.set();
                    }
                    try {
                        for (Map.Entry<EntityType, DynamicObject[]> entry : this.srcEntryRows.entrySet()) {
                            SaveServiceHelper.save((IDataEntityType)((IDataEntityType)entry.getKey()), (Object[])entry.getValue());
                        }
                    }
                    finally {
                        if (ctx != null) {
                            ctx.close();
                        }
                    }
                }
                ISaveTracker.updateBillCloseStatus(this.trackerContext, (MainEntityType)this.srcSubMainType, this.srcDataEntities, this.billCloseItems);
                ISaveTracker.ansyFireAfterSaveSourceBill(this.trackerContext, this.srcSubMainType, this.srcDataEntities);
                ISaveTracker.saveWriteBackLogs(this.trackerContext, this.sourceBillInfo);
            }
            catch (Throwable exp) {
                h.markRollback();
                throw exp;
            }
        }
        ISaveTracker.updateWBLogFinishStatus(this.trackerContext, this.sourceBillInfo);
        if (this.srcSubMainType != null && this.srcDataEntities != null && this.srcDataEntities.length > 0) {
            String msg = String.format(ResManager.loadKDString((String)"\u53cd\u5199\u5f15\u64ce\uff0c\u5f02\u6b65\u4fdd\u5b58\u6e90\u5355\u5b8c\u6bd5\uff1a%1$s, %2$s(%3$s bills)", (String)"SaveTrackerRunnable_0", (String)"bos-mservice-botp", (Object[])new Object[0]), this.srcSubMainType.getName(), this.srcDataEntities[0].getPkValue(), this.srcDataEntities.length);
            log.info(msg);
        }
    }

    private void saveBillTracker() {
        IDataEntityType billTrackerType = OrmUtils.getDataEntityType(BillTracker.class);
        try (TXHandle h = TX.requiresNew();){
            if (this.saveBillTrackers != null && !this.saveBillTrackers.isEmpty()) {
                SaveServiceHelper.save((IDataEntityType)billTrackerType, (Object[])this.saveBillTrackers.toArray());
            }
            if (this.delBillTrackerIds != null && !this.delBillTrackerIds.isEmpty()) {
                DeleteServiceHelper.delete((IDataEntityType)billTrackerType, (Object[])this.delBillTrackerIds.toArray());
                this.bfTrackerResult.saveBotpLinkLog.addBotpLinkLog(this.trackerContext, this.bfTrackerResult, this.bfTrackerResult.getDelBillTrackers(), null, this.dbService, this.sTraceId);
            }
        }
        log.info("\u53cd\u5199\u5f15\u64ce\uff0c\u5f02\u6b65\u4fdd\u5b58\u5173\u8054\u5173\u7cfb\u5b8c\u6bd5");
    }

    private void writeBOTPErrorLog(Throwable exp) {
        if (!this.isSaveSrcBill()) {
            return;
        }
        if (this.trackerContext == null || this.sourceBillInfo == null) {
            return;
        }
        HashSet<Long> wbLogIds = new HashSet<Long>(this.sourceBillInfo.getWbLogs().size());
        for (BOTPLog wfLog : this.sourceBillInfo.getWbLogs()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)wfLog.getLogType(), (CharSequence)"F")) continue;
            wbLogIds.add(wfLog.getParentId());
        }
        if (!wbLogIds.isEmpty()) {
            BOTPLogServiceHelper.updateLogStatus((String)this.trackerContext.getTargetMainType().getDBRouteKey(), (Long[])wbLogIds.toArray(new Long[0]), (String)"2", (OperateOption)OperateOption.create());
        }
        Date currTime = TimeServiceHelper.now();
        ArrayList<BOTPLog> errLogs = new ArrayList<BOTPLog>(this.sourceBillInfo.getWbLogs().size());
        for (BOTPLog wfLog : this.sourceBillInfo.getWbLogs()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)wfLog.getLogType(), (CharSequence)"F")) continue;
            BOTPLog errLog = new BOTPLog();
            errLog.setTaskId(wfLog.getTaskId());
            errLog.setParentId(wfLog.getParentId());
            errLog.setSentityNumber(wfLog.getSentityNumber());
            errLog.setSBillno(wfLog.getSBillno());
            errLog.setSTableId(wfLog.getSTableId());
            errLog.setSBillId(wfLog.getSBillId());
            errLog.setTentityNumber(wfLog.getTentityNumber());
            errLog.setTBillno(wfLog.getTBillno());
            errLog.setTTableId(wfLog.getTTableId());
            errLog.setTBillId(wfLog.getTBillId());
            errLog.setUserId(wfLog.getUserId());
            errLog.setStartTime(wfLog.getStartTime());
            errLog.setEndTime(currTime);
            errLog.setOpType(wfLog.getOpType());
            errLog.setLogType("E");
            errLog.setStatus("2");
            ErrLogDetailInfo errorDetails = new ErrLogDetailInfo(exp);
            errLog.setDetailInfo((AbstractDetailLogInfo)errorDetails);
            errLogs.add(errLog);
        }
        if (!errLogs.isEmpty()) {
            this.fillErrLogId(errLogs);
            BOTPLogServiceHelper.addLogs((String)this.trackerContext.getTargetMainType().getDBRouteKey(), (BOTPLog[])errLogs.toArray(new BOTPLog[0]), (OperateOption)OperateOption.create());
        }
    }

    private void fillErrLogId(List<BOTPLog> errLogs) {
        long[] ids = DB.genGlobalLongIds((int)errLogs.size());
        for (int i = 0; i < errLogs.size(); ++i) {
            errLogs.get(i).setId(ids[i]);
        }
    }
}

