/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.track.helper;

import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.botp.track.BFTrackerContext;
import kd.bos.service.botp.track.BFTrackerResult;
import kd.bos.service.botp.track.bizentity.SourceBillInfo;
import kd.bos.service.botp.track.helper.BFTrackerDbService;
import kd.bos.service.botp.track.helper.ISaveTracker;
import kd.bos.service.botp.track.helper.SaveTrackerAnsy;

class SaveTrackerSync
extends SaveTrackerAnsy {
    SaveTrackerSync() {
    }

    @Override
    protected void saveBillTrackerDiffDB(BFTrackerContext trackerContext, BFTrackerResult trackerResult, BFTrackerDbService dbService) {
        try (TXHandle h = TX.requiresNew();){
            ISaveTracker.saveBillTrackers(trackerContext, trackerResult, dbService);
        }
    }

    @Override
    protected void saveSourceBillDiffDB(BFTrackerContext trackerContext, BFTrackerResult trackerResult, SourceBillInfo sourceBillInfo, BFTrackerDbService dbService) {
        try (TXHandle h = TX.requiresNew();){
            ISaveTracker.saveSourceBill(trackerContext, sourceBillInfo);
            ISaveTracker.saveWriteBackLogs(trackerContext, sourceBillInfo);
        }
        h = TX.requiresNew();
        var6_6 = null;
        try {
            ISaveTracker.updateWBLogFinishStatus(trackerContext, sourceBillInfo);
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
        finally {
            if (h != null) {
                if (var6_6 != null) {
                    try {
                        h.close();
                    }
                    catch (Throwable throwable) {
                        var6_6.addSuppressed(throwable);
                    }
                } else {
                    h.close();
                }
            }
        }
    }
}

