/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.track.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.botp.ConvertDataService;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.WriteBackType;
import kd.bos.entity.botp.plugin.args.AfterCalcWriteValueEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeCreateArticulationRowEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeExecWriteBackRuleEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeTrackEventArgs;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.botp.runtime.BFRowLinkUpNode;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.service.botp.track.BFTrackerContext;
import kd.bos.service.botp.track.LinkItemContext;
import kd.bos.service.botp.track.bizentity.AED;
import kd.bos.service.botp.track.bizentity.Row;
import kd.bos.service.botp.track.bizentity.RowId;
import kd.bos.service.botp.track.bizentity.RowLinkId;
import kd.bos.service.botp.track.bizentity.Sheet;
import kd.bos.service.botp.track.bizentity.WRule;
import kd.bos.service.botp.track.bizentity.WRuleItemId;
import kd.bos.service.botp.track.bizentity.WSRow;
import kd.bos.service.botp.track.distlogic.DistributeRow;
import kd.bos.service.botp.track.distlogic.TopDownLogic;
import kd.bos.service.botp.track.helper.BFTrackerDbService;
import kd.bos.service.botp.track.helper.WRuleCompiler;
import kd.bos.service.botp.track.helper.WRuleItemCompiler;
import kd.bos.service.botp.track.helper.WRuleItemFunBatchPreCall;
import kd.bos.servicehelper.DBServiceHelper;

public class SheetBuilder {
    private BFTrackerContext trackerContext;
    private BFTrackerDbService dbService;
    protected Map<Long, Set<String>> sourceEntityKeys = new HashMap<Long, Set<String>>();
    private Map<String, BigDecimal> sRowLeavingAmount = new HashMap<String, BigDecimal>();

    public SheetBuilder(BFTrackerContext trackerContext, BFTrackerDbService dbService) {
        this.trackerContext = trackerContext;
        this.dbService = dbService;
    }

    public Sheet createSheet(LinkItemContext linkItemContext, DynamicObject dataEntity) {
        ExtendedDataEntity[] extEntityRows;
        Long billId = this.getPKValue(dataEntity);
        Sheet sheet = new Sheet();
        sheet.setBillId(billId);
        BeforeTrackEventArgs eventArgs = new BeforeTrackEventArgs(dataEntity);
        this.trackerContext.getPlugInProxy().fireBeforeTrack(eventArgs);
        if (eventArgs.isCancel()) {
            return sheet;
        }
        this.sRowLeavingAmount.clear();
        ExtendedDataEntitySet extDataSet = new ExtendedDataEntitySet();
        extDataSet.Parse(new DynamicObject[]{dataEntity}, (MainEntityType)this.trackerContext.getTargetSubMainType());
        for (ExtendedDataEntity extEntityRow : extEntityRows = extDataSet.FindByEntityKey(linkItemContext.getEntityType().getName())) {
            this.createEntityRow(linkItemContext, sheet, extEntityRow.getDataEntity());
        }
        return sheet;
    }

    private void createEntityRow(LinkItemContext linkItemContext, Sheet sheet, DynamicObject entityRow) {
        Long entityId = this.getPKValue(entityRow);
        DynamicObjectCollection linkEntryRows = (DynamicObjectCollection)linkItemContext.getLinkEntryProp().getValue((Object)entityRow);
        BeforeCreateArticulationRowEventArgs eventArgs = new BeforeCreateArticulationRowEventArgs(linkItemContext.getEntityType(), entityRow, linkEntryRows);
        this.trackerContext.getPlugInProxy().fireBeforeCreateArticulationRow(eventArgs);
        if (eventArgs.isCancel()) {
            return;
        }
        if (!SheetBuilder.isPush(linkItemContext.getLinkEntryType(), linkEntryRows)) {
            return;
        }
        if (!eventArgs.isCancelReDistributeAmount()) {
            this.reDistributeAmountFields(linkItemContext, entityRow, linkEntryRows);
        }
        for (DynamicObject linkEntryRow : linkEntryRows) {
            this.createLinkRow(linkItemContext, sheet, entityRow, entityId, linkEntryRow);
        }
    }

    private void createLinkRow(LinkItemContext linkItemContext, Sheet sheet, DynamicObject entityRow, long entityId, DynamicObject linkEntryRow) {
        Row row = new Row();
        row.setId(new RowId(linkItemContext.getMainTableId(), sheet.getBillId(), linkItemContext.getEntityTableId(), entityId));
        Long sBillId = SheetBuilder.getLongValue(linkEntryRow, (IDataEntityProperty)linkItemContext.getLinkEntryType().getSBillIdProp());
        Long sTableId = SheetBuilder.getLongValue(linkEntryRow, (IDataEntityProperty)linkItemContext.getLinkEntryType().getSTableIdProp());
        Long sId = SheetBuilder.getLongValue(linkEntryRow, (IDataEntityProperty)linkItemContext.getLinkEntryType().getSIdProp());
        Long sMainTableId = this.dbService.loadMainTableId(sTableId);
        row.setSId(new RowId(sMainTableId, sBillId, sTableId, sId));
        row.setEntityRow(entityRow);
        row.setLinkEntryRow(linkEntryRow);
        RowLinkId linkId = new RowLinkId(sTableId, sId, linkItemContext.getEntityTableId(), entityId);
        sheet.getRows().put(linkId, row);
    }

    public void createWRules(LinkItemContext linkItemContext, Map<Long, WRuleCompiler> currRuleVers, Map<RowId, BFRowLinkUpNode> rowLinkUpNodes, AED<Row> aedRows) {
        BeforeExecWriteBackRuleEventArgs eventArgs = new BeforeExecWriteBackRuleEventArgs();
        for (WRuleCompiler wRuleCompiler : currRuleVers.values()) {
            for (WRuleItemCompiler itemCompiler : wRuleCompiler.getItems().values()) {
                eventArgs.setContext(wRuleCompiler.getRule(), itemCompiler.getItem());
                this.trackerContext.getPlugInProxy().fireBeforeExecWriteBackRule(eventArgs);
                itemCompiler.setCancelByPlug(eventArgs.isCancel());
            }
        }
        ArrayList<Row> rows = new ArrayList<Row>(aedRows.getAddList().size() + aedRows.getEditList().size());
        rows.addAll(aedRows.getAddList());
        for (Tuple<Row, Row> tuple : aedRows.getEditList()) {
            Row row = (Row)tuple.item1;
            rows.add(row);
        }
        RowDataModel rowDataModel = new RowDataModel(linkItemContext.getLinkEntryType().getName(), (MainEntityType)this.trackerContext.getTargetSubMainType());
        WRuleItemFunBatchPreCall.createWRulePreCall(rows, rowDataModel, currRuleVers, linkItemContext);
        for (Row row : rows) {
            rowDataModel.setRowContext(row.getLinkEntryRow());
            for (WRuleCompiler ruleCompiler : currRuleVers.values()) {
                for (WRuleItemCompiler itemCompiler : ruleCompiler.getItems().values()) {
                    this.createWRule(linkItemContext, rowLinkUpNodes, rowDataModel, row, ruleCompiler, itemCompiler);
                }
            }
        }
    }

    private void createWRule(LinkItemContext linkItemContext, Map<RowId, BFRowLinkUpNode> rowLinkUpNodes, RowDataModel rowDataModel, Row row, WRuleCompiler ruleCompiler, WRuleItemCompiler itemCompiler) {
        if (itemCompiler.isCancelByPlug() || !this.isValidRuleItem(linkItemContext, rowDataModel, itemCompiler)) {
            return;
        }
        WRule wRule = new WRule();
        wRule.setRuleVerId(ruleCompiler.getVerId());
        wRule.setRuleItemId(itemCompiler.getItemId());
        BigDecimal val = itemCompiler.calcFormula(rowDataModel);
        Object cVal = itemCompiler.calcCoverVal(rowDataModel);
        wRule.setVal(val);
        wRule.setCVal(cVal);
        WRuleItemId id = new WRuleItemId(ruleCompiler.getVerId(), itemCompiler.getItemId());
        row.getWrules().put(id, wRule);
        this.createWRows(linkItemContext, rowLinkUpNodes, row, wRule, ruleCompiler, itemCompiler);
    }

    private void createWRows(LinkItemContext linkItemContext, Map<RowId, BFRowLinkUpNode> rowLinkUpNodes, Row row, WRule wRule, WRuleCompiler ruleCompiler, WRuleItemCompiler itemCompiler) {
        ArrayList<BFRowId> sRowIds = new ArrayList<BFRowId>();
        Long sRowMainTableId = this.dbService.loadMainTableId(row.getSId().getTableId());
        if (sRowMainTableId.equals(ruleCompiler.getSrcMainTableId())) {
            sRowIds.add(row.getSId());
        } else {
            BFRowLinkUpNode node = rowLinkUpNodes.get((Object)row.getSId());
            List sNodes = node.findSourceNodes(ruleCompiler.getSrcMainTableId());
            for (BFRowLinkUpNode sNode : sNodes) {
                sRowIds.add(sNode.getRowId());
            }
        }
        for (BFRowId rowId : sRowIds) {
            if (!this.isCommitEntity(rowId, ruleCompiler, itemCompiler)) continue;
            Object wsRow = new WSRow();
            RowId sId = new RowId(rowId.getMainTableId(), rowId.getBillId(), rowId.getTableId(), rowId.getEntryId());
            ((WSRow)wsRow).setSId(sId);
            ((WSRow)wsRow).setVal(wRule.getVal());
            ((WSRow)wsRow).setCVal(wRule.getCVal());
            wRule.getCurrSourceRows().put(sId, (WSRow)wsRow);
        }
        if (wRule.getCurrSourceRows().size() > 1) {
            for (Object wsRow : wRule.getCurrSourceRows().values()) {
                ((WSRow)wsRow).setVal(BigDecimal.ZERO);
            }
        }
        AfterCalcWriteValueEventArgs eventArgs = new AfterCalcWriteValueEventArgs(linkItemContext.getEntityType(), row.getEntityRow(), ruleCompiler.getRule(), itemCompiler.getItem(), wRule.getVal(), wRule.getCVal());
        for (Object wsRow : wRule.getCurrSourceRows().values()) {
            eventArgs.getSrcRowVal().put(((WSRow)wsRow).getSId(), ((WSRow)wsRow).getVal());
        }
        this.trackerContext.getPlugInProxy().fireAfterCalcWriteValue(eventArgs);
        if (wRule.getCurrSourceRows().size() > 1 && itemCompiler.getItem().getWriteBackType() != WriteBackType.Cover) {
            boolean assign = false;
            for (WSRow wsRow : wRule.getCurrSourceRows().values()) {
                BigDecimal plugValue = (BigDecimal)eventArgs.getSrcRowVal().get((Object)wsRow.getSId());
                if (plugValue == null || BigDecimal.ZERO.compareTo(plugValue) == 0) continue;
                assign = true;
                break;
            }
            if (!assign) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5408\u5e76\u4e0b\u63a8\u540e\u8de8\u7ea7\u53cd\u5199\uff0c\u5fc5\u987b\u81ea\u884c\u5f00\u53d1\u63d2\u4ef6\u5206\u914d\u53cd\u5199\u91cf\uff0c\u4e14\u5206\u914d\u603b\u989d\u4e0e\u8ba1\u7b97\u989d\u76f8\u7b49", (String)"SheetBuilder_0", (String)"bos-mservice-botp", (Object[])new Object[0]));
            }
        }
        for (Object wsRow : wRule.getCurrSourceRows().values()) {
            if (!eventArgs.getSrcRowVal().containsKey((Object)((WSRow)wsRow).getSId())) continue;
            ((WSRow)wsRow).setVal((BigDecimal)eventArgs.getSrcRowVal().get((Object)((WSRow)wsRow).getSId()));
        }
    }

    private void reDistributeAmountFields(LinkItemContext linkItemContext, DynamicObject entityRow, DynamicObjectCollection linkEntryRows) {
        for (Map.Entry entry : linkItemContext.getLinkEntryType().getCtrlFieldProps().entrySet()) {
            String ctrlFieldKey = (String)entry.getKey();
            DynamicProperty ctrlField = (DynamicProperty)linkItemContext.getEntityType().findProperty(ctrlFieldKey);
            DynamicProperty ctrlField_new = (DynamicProperty)entry.getValue();
            DynamicProperty ctrlField_old = (DynamicProperty)linkItemContext.getLinkEntryType().getOldCtrlFieldProps().get(ctrlFieldKey);
            if (linkEntryRows.size() == 1) {
                ctrlField_new.setValueFast(linkEntryRows.get(0), ctrlField.getValueFast((Object)entityRow));
                continue;
            }
            this.reDistributeAmountField(linkItemContext, ctrlField, ctrlField_old, ctrlField_new, entityRow, linkEntryRows);
        }
    }

    private void reDistributeAmountField(LinkItemContext linkItemContext, DynamicProperty ctrlField, DynamicProperty ctrlField_old, DynamicProperty ctrlField_new, DynamicObject entityRow, DynamicObjectCollection linkEntryRows) {
        BigDecimal distributeAmount;
        DynamicProperty sTableIdProp = linkItemContext.getLinkEntryType().getSTableIdProp();
        DynamicProperty sIdProp = linkItemContext.getLinkEntryType().getSIdProp();
        boolean isHasLinkCopy = false;
        BigDecimal entityRowAmount = (BigDecimal)ctrlField.getValue((Object)entityRow);
        BigDecimal linkRowsAmount = new BigDecimal(0);
        TopDownLogic distributeLogic = new TopDownLogic();
        for (DynamicObject linkEntryRow : linkEntryRows) {
            BigDecimal oldAmount = (BigDecimal)ctrlField_old.getValue((Object)linkEntryRow);
            distributeAmount = (BigDecimal)ctrlField_new.getValue((Object)linkEntryRow);
            linkRowsAmount = linkRowsAmount.add(distributeAmount);
            String cid = String.format("%s,%d,%d", ctrlField.getName(), (Long)sTableIdProp.getValueFast((Object)linkEntryRow), (Long)sIdProp.getValueFast((Object)linkEntryRow));
            BigDecimal leafAmount = this.sRowLeavingAmount.get(cid);
            if (leafAmount != null) {
                isHasLinkCopy = true;
            } else {
                leafAmount = oldAmount;
            }
            distributeLogic.getDistributeRows().add(new DistributeRow(leafAmount));
            this.sRowLeavingAmount.put(cid, leafAmount.subtract(distributeAmount));
        }
        distributeLogic.setTotalAmount(entityRowAmount);
        if (!isHasLinkCopy && entityRowAmount.compareTo(linkRowsAmount) == 0) {
            return;
        }
        distributeLogic.Distribute();
        int i = 0;
        for (DynamicObject linkEntryRow : linkEntryRows) {
            distributeAmount = (BigDecimal)ctrlField_new.getValueFast((Object)linkEntryRow);
            BigDecimal reDistributeAmount = distributeLogic.getDistributeRows().get(i).getDistAmount();
            String cid = String.format("%s,%d,%d", ctrlField.getName(), (Long)sTableIdProp.getValueFast((Object)linkEntryRow), (Long)sIdProp.getValueFast((Object)linkEntryRow));
            ctrlField_new.setValueFast((Object)linkEntryRow, (Object)reDistributeAmount);
            BigDecimal leafAmount = this.sRowLeavingAmount.get(cid);
            if (leafAmount != null) {
                if ((leafAmount = leafAmount.subtract(reDistributeAmount).add(distributeAmount)).compareTo(new BigDecimal(0)) < 0) {
                    leafAmount = new BigDecimal(0);
                }
                this.sRowLeavingAmount.put(cid, leafAmount);
            }
            ++i;
        }
    }

    private static boolean isPush(LinkEntryType linkEntryType, DynamicObjectCollection linkEntryRows) {
        if (linkEntryRows.size() == 0) {
            return false;
        }
        Long sid = SheetBuilder.getLongValue((DynamicObject)linkEntryRows.get(0), (IDataEntityProperty)linkEntryType.getSIdProp());
        return sid != null && Long.compare(sid, 0L) != 0;
    }

    private boolean isValidRuleItem(LinkItemContext linkItemContext, RowDataModel rowDataModel, WRuleItemCompiler itemCompiler) {
        if (itemCompiler.getItem().isDisabled() || !linkItemContext.getTargetEntityKeys().contains(itemCompiler.getTargetEntityKey())) {
            return false;
        }
        return itemCompiler.checkWriteCondition(rowDataModel);
    }

    private boolean isCommitEntity(BFRowId sRowId, WRuleCompiler ruleCompiler, WRuleItemCompiler itemCompiler) {
        Set<String> entityKeys = this.getSourceEntitys(ruleCompiler.getSourceMainType(), sRowId.getTableId());
        return entityKeys.contains(itemCompiler.getSourceEntityKey());
    }

    private Set<String> getSourceEntitys(BillEntityType srcMainType, Long sTableId) {
        return this.sourceEntityKeys.computeIfAbsent(sTableId, key -> {
            HashSet<String> newEntitys = new HashSet<String>();
            ConvertDataService reader = new ConvertDataService();
            TableDefine tableDefine = reader.loadTableDefine(key);
            for (EntityType entityType = (EntityType)srcMainType.getAllEntities().get(tableDefine.getEntityKey()); entityType != null; entityType = (EntityType)entityType.getParent()) {
                newEntitys.add(entityType.getName());
            }
            return newEntitys;
        });
    }

    private Long getPKValue(DynamicObject dataEntity) {
        Long id = (Long)dataEntity.getPkValue();
        if (id == null || Long.compare(id, 0L) == 0) {
            id = DBServiceHelper.genGlobalLongId();
            dataEntity.set((IDataEntityProperty)dataEntity.getDataEntityType().getPrimaryKey(), (Object)id);
        }
        return id;
    }

    private static Long getLongValue(DynamicObject obj, IDataEntityProperty prop) {
        if (obj == null) {
            return null;
        }
        Object value = prop.getValueFast((Object)obj);
        if (value == null) {
            return null;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        return Long.valueOf(value.toString());
    }
}

