/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.track.helper;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.service.botp.track.BFTrackerContext;
import kd.bos.service.botp.track.LinkItemContext;
import kd.bos.service.botp.track.bizentity.Row;
import kd.bos.service.botp.track.bizentity.RowId;
import kd.bos.service.botp.track.bizentity.RowLinkId;
import kd.bos.service.botp.track.bizentity.Sheet;
import kd.bos.service.botp.track.bizentity.Sheets;
import kd.bos.service.botp.track.bizentity.WRule;
import kd.bos.service.botp.track.bizentity.WRuleItemId;
import kd.bos.service.botp.track.bizentity.WSRow;
import kd.bos.service.botp.track.helper.BFTrackerDbService;
import kd.bos.service.botp.track.helper.TrackerTypes;

public class SheetSnapBuilder {
    private BFTrackerContext trackerContext;
    private BFTrackerDbService dbService;
    private TrackerTypes trackerTypes;

    public SheetSnapBuilder(BFTrackerContext trackerContext, BFTrackerDbService dbService) {
        this.trackerContext = trackerContext;
        this.dbService = dbService;
        this.trackerTypes = this.trackerContext.getTrackerTypes();
    }

    public Sheets createSheets(LinkItemContext linkItemContext, Map<Long, List<DynamicObject>> snapshotObjs) {
        Sheets sheets = new Sheets(linkItemContext.getLinkSetItem().getParentEntityKey(), linkItemContext.getLinkSetItem().getLinkEntityKey());
        for (Map.Entry<Long, List<DynamicObject>> entry : snapshotObjs.entrySet()) {
            Long billId = entry.getKey();
            List<DynamicObject> list = entry.getValue();
            Sheet sheet = new Sheet();
            sheet.setBillId(billId);
            sheets.put(billId, sheet);
            for (DynamicObject snapshotObj : list) {
                this.createRow(sheet, linkItemContext.getMainTableId(), linkItemContext.getEntityTableId(), snapshotObj);
            }
        }
        return sheets;
    }

    private void createRow(Sheet sheet, Long mainTableId, Long tableId, DynamicObject snapshotObj) {
        Long sBillId = (Long)this.trackerTypes.getSS_sBillIdProp().getValueFast((Object)snapshotObj);
        Long sTableId = (Long)this.trackerTypes.getSS_sTableIdProp().getValueFast((Object)snapshotObj);
        Long sId = (Long)this.trackerTypes.getSS_sIdProp().getValueFast((Object)snapshotObj);
        Long tId = (Long)this.trackerTypes.getSS_tIdProp().getValueFast((Object)snapshotObj);
        Long sMainTableId = this.dbService.loadMainTableId(sTableId);
        RowLinkId linkId = new RowLinkId(sTableId, sId, tableId, tId);
        Row row = (Row)sheet.getRows().get(linkId);
        if (row == null) {
            row = new Row();
            row.setEntryTrackerId((Long)snapshotObj.getPkValue());
            RowId rowId = new RowId(mainTableId, sheet.getBillId(), tableId, tId);
            row.setId(rowId);
            RowId sRowId = new RowId(sMainTableId, sBillId, sTableId, sId);
            row.setSId(sRowId);
            sheet.getRows().put(linkId, row);
        }
        DynamicObjectCollection wbEntryRows = (DynamicObjectCollection)this.trackerTypes.getSS_wbEntryProp().getValueFast((Object)snapshotObj);
        for (DynamicObject wbEntryRow : wbEntryRows) {
            this.createWRule(row, wbEntryRow);
        }
    }

    private void createWRule(Row row, DynamicObject wbEntryRow) {
        Long ruleVerId = (Long)this.trackerTypes.getSS_ruleVerIdProp().getValueFast((Object)wbEntryRow);
        Long ruleItemId = (Long)this.trackerTypes.getSS_ruleItemIdProp().getValueFast((Object)wbEntryRow);
        WRuleItemId itemId = new WRuleItemId(ruleVerId, ruleItemId);
        WRule wRule = (WRule)row.getWrules().get(itemId);
        if (wRule == null) {
            wRule = new WRule();
            wRule.setRuleItemId(ruleItemId);
            wRule.setRuleVerId(ruleVerId);
            row.getWrules().put(itemId, wRule);
        }
        Long wb_SBillId = (Long)this.trackerTypes.getSS_wbEntry_sBillIdProp().getValueFast((Object)wbEntryRow);
        Long wb_STableId = (Long)this.trackerTypes.getSS_wbEntry_sTableIdProp().getValueFast((Object)wbEntryRow);
        Long wb_SId = (Long)this.trackerTypes.getSS_wbEntry_sIdProp().getValueFast((Object)wbEntryRow);
        BigDecimal wb_value = (BigDecimal)this.trackerTypes.getSS_wbEntry_valueProp().getValueFast((Object)wbEntryRow);
        Long wb_SMainTableId = this.dbService.loadMainTableId(wb_STableId);
        WSRow wsRow = new WSRow();
        wsRow.setWBEntryId((Long)wbEntryRow.getPkValue());
        RowId sId = new RowId(wb_SMainTableId, wb_SBillId, wb_STableId, wb_SId);
        wsRow.setSId(sId);
        wsRow.setVal(wb_value);
        wRule.getHistorySourceRows().put(sId, wsRow);
    }
}

