/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.track.helper;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.service.botp.track.bizentity.AED;
import kd.bos.service.botp.track.bizentity.Row;
import kd.bos.service.botp.track.bizentity.RowId;
import kd.bos.service.botp.track.bizentity.RowLinkId;
import kd.bos.service.botp.track.bizentity.Sheet;
import kd.bos.service.botp.track.bizentity.Sheets;
import kd.bos.service.botp.track.bizentity.WRule;
import kd.bos.service.botp.track.bizentity.WRuleItemId;
import kd.bos.service.botp.track.bizentity.WRules;
import kd.bos.service.botp.track.bizentity.WSRow;
import kd.bos.service.botp.track.bizentity.WSRows;
import kd.bos.service.botp.track.helper.WRuleCompiler;
import kd.bos.service.botp.track.helper.WRuleItemCompiler;

public class SheetSync {
    private SheetSync() {
        throw new IllegalStateException(ResManager.loadKDString((String)"\u4e0d\u53ef\u5b9e\u4f8b\u5316\u7684\u7c7b", (String)"SheetSync_0", (String)"bos-mservice-botp", (Object[])new Object[0]));
    }

    public static AED<Row> syncRows(Sheets sheets, Sheets snapshot) {
        AED<Sheet> r1 = SheetSync.syncSheet(sheets, snapshot);
        AED<Row> r2 = new AED<Row>();
        for (Sheet sheet : r1.getAddList()) {
            r2.getAddList().addAll(sheet.getRows().values());
        }
        for (Tuple tuple : r1.getEditList()) {
            SheetSync.syncRow((Sheet)tuple.item1, (Sheet)tuple.item2, r2);
        }
        for (Sheet sheet : r1.getDeleteList()) {
            r2.getDeleteList().addAll(sheet.getRows().values());
        }
        return r2;
    }

    private static AED<Sheet> syncSheet(Sheets sheets, Sheets snapshot) {
        AED<Sheet> aed = new AED<Sheet>();
        for (Sheet sheet : sheets.values()) {
            Sheet sheetSnap = (Sheet)snapshot.get(sheet.getBillId());
            if (sheetSnap != null) {
                aed.getEditList().add((Tuple<Sheet, Sheet>)new Tuple((Object)sheet, (Object)sheetSnap));
                continue;
            }
            aed.getAddList().add(sheet);
        }
        for (Sheet sheetSnap : snapshot.values()) {
            Sheet sheet = (Sheet)sheets.get(sheetSnap.getBillId());
            if (sheet != null) continue;
            aed.getDeleteList().add(sheetSnap);
        }
        return aed;
    }

    private static void syncRow(Sheet sheet, Sheet sheetSnap, AED<Row> aed) {
        RowLinkId linkId;
        for (Map.Entry item : sheet.getRows().entrySet()) {
            linkId = (RowLinkId)item.getKey();
            Row row = (Row)item.getValue();
            Row rowSnap = (Row)sheetSnap.getRows().get(linkId);
            if (rowSnap != null) {
                row.setEntryTrackerId(rowSnap.getEntryTrackerId());
                rowSnap.setEntityRow(row.getEntityRow());
                rowSnap.setLinkEntryRow(row.getLinkEntryRow());
                aed.getEditList().add((Tuple<Row, Row>)new Tuple((Object)row, (Object)rowSnap));
                continue;
            }
            aed.getAddList().add(row);
        }
        for (Map.Entry item : sheetSnap.getRows().entrySet()) {
            linkId = (RowLinkId)item.getKey();
            Row rowSnap = (Row)item.getValue();
            Row row = (Row)sheet.getRows().get(linkId);
            if (row != null) continue;
            aed.getDeleteList().add(rowSnap);
        }
    }

    public static AED<WRule> syncWRules(AED<Row> aedRows) {
        AED<WRule> r = new AED<WRule>();
        for (Row row : aedRows.getAddList()) {
            r.getAddList().addAll(row.getWrules().values());
        }
        for (Row row : aedRows.getDeleteList()) {
            r.getDeleteList().addAll(row.getWrules().values());
        }
        for (Tuple tuple : aedRows.getEditList()) {
            Row currRow = (Row)tuple.item1;
            Row snapRow = (Row)tuple.item2;
            SheetSync.syncWRule(currRow.getWrules(), snapRow.getWrules(), r);
        }
        return r;
    }

    private static void syncWRule(WRules currWRules, WRules snapWRules, AED<WRule> r) {
        WRuleItemId ruleItemId;
        for (Map.Entry item : currWRules.entrySet()) {
            ruleItemId = (WRuleItemId)item.getKey();
            WRule currWRule = (WRule)item.getValue();
            WRule snapWRule = (WRule)snapWRules.get(ruleItemId);
            if (snapWRule != null) {
                r.getEditList().add((Tuple<WRule, WRule>)new Tuple((Object)currWRule, (Object)snapWRule));
                continue;
            }
            r.getAddList().add(currWRule);
        }
        for (Map.Entry item : snapWRules.entrySet()) {
            ruleItemId = (WRuleItemId)item.getKey();
            WRule snapWRule = (WRule)item.getValue();
            WRule currWRule = (WRule)currWRules.get(ruleItemId);
            if (currWRule != null) continue;
            r.getDeleteList().add(snapWRule);
        }
    }

    public static void calcRealAmount(Map<Long, WRuleCompiler> rules, List<WRule> lstWRules) {
        BigDecimal rollBack = new BigDecimal(-1);
        for (WRule wRule : lstWRules) {
            WSRow execRow;
            wRule.getResultSourceRows().clear();
            wRule.getResultSourceRows().putAll(wRule.getCurrSourceRows());
            AED<WSRow> aed = SheetSync.syncWSRow(wRule.getCurrSourceRows(), wRule.getHistorySourceRows());
            for (WSRow wSRow : aed.getDeleteList()) {
                execRow = new WSRow(wSRow);
                execRow.setVal(execRow.getVal().multiply(rollBack));
                WRuleCompiler rule = rules.get(wRule.getRuleVerId());
                WRuleItemCompiler ruleItem = rule.getItems().get(wRule.getRuleItemId());
                execRow.setCVal(IFieldHandle.getFieldDefaultValue(null, (DynamicProperty)ruleItem.getSourceField()));
                wRule.getExecuteSourceRows().put(execRow.getSId(), execRow);
            }
            for (Tuple tuple : aed.getEditList()) {
                WSRow currRow = (WSRow)tuple.item1;
                WSRow snapRow = (WSRow)tuple.item2;
                BigDecimal val = currRow.getVal().subtract(snapRow.getVal());
                WSRow execRow2 = new WSRow(currRow);
                execRow2.setVal(val);
                wRule.getExecuteSourceRows().put(execRow2.getSId(), execRow2);
            }
            for (WSRow wSRow : aed.getAddList()) {
                execRow = new WSRow(wSRow);
                wRule.getExecuteSourceRows().put(execRow.getSId(), execRow);
            }
        }
    }

    private static AED<WSRow> syncWSRow(WSRows currWSRows, WSRows snapWSRows) {
        RowId sId;
        AED<WSRow> aed = new AED<WSRow>();
        for (Map.Entry item : currWSRows.entrySet()) {
            sId = (RowId)((Object)item.getKey());
            WSRow currRow = (WSRow)item.getValue();
            WSRow snapRow = (WSRow)snapWSRows.get((Object)sId);
            if (snapRow != null) {
                aed.getEditList().add((Tuple<WSRow, WSRow>)new Tuple((Object)currRow, (Object)snapRow));
                continue;
            }
            aed.getAddList().add(currRow);
        }
        for (Map.Entry item : snapWSRows.entrySet()) {
            sId = (RowId)((Object)item.getKey());
            WSRow snapRow = (WSRow)item.getValue();
            WSRow currRow = (WSRow)currWSRows.get((Object)sId);
            if (currRow != null) continue;
            aed.getDeleteList().add(snapRow);
        }
        return aed;
    }
}

