/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.track.helper;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.botp.track.LinkItemContext;
import kd.bos.service.botp.track.bizentity.Row;
import kd.bos.service.botp.track.getvaluemode.ReplaceVerValue;
import kd.bos.service.botp.track.helper.WRuleCompiler;
import kd.bos.service.botp.track.helper.WRuleItemCompiler;

public class WRuleItemFunBatchPreCall {
    private static Log log = LogFactory.getLog(WRuleItemFunBatchPreCall.class);

    public static void createWRulePreCall(List<Row> rows, RowDataModel rowDataModel, Map<Long, WRuleCompiler> currRuleVers, LinkItemContext linkItemContext) {
        try {
            HashMap<String, Boolean> preCallMap = new HashMap<String, Boolean>(16);
            for (Row row : rows) {
                String key = WRuleItemFunBatchPreCall.getKey(row);
                if (preCallMap.get(key) != null && !((Boolean)preCallMap.get(key)).booleanValue()) continue;
                rowDataModel.setRowContext(row.getLinkEntryRow());
                boolean isCreateWRulePreCall = false;
                for (WRuleCompiler ruleCompiler : currRuleVers.values()) {
                    for (WRuleItemCompiler itemCompiler : ruleCompiler.getItems().values()) {
                        if (!WRuleItemFunBatchPreCall.createWRulePreCall(linkItemContext, rowDataModel, itemCompiler)) continue;
                        isCreateWRulePreCall = true;
                    }
                }
                preCallMap.put(key, isCreateWRulePreCall);
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }

    private static String getKey(Row row) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(row.getSId().getMainTableId());
        stringBuilder.append(row.getSId().getTableId());
        stringBuilder.append(row.getId().getMainTableId());
        stringBuilder.append(row.getId().getTableId());
        return stringBuilder.toString();
    }

    private static boolean createWRulePreCall(LinkItemContext linkItemContext, RowDataModel rowDataModel, WRuleItemCompiler itemCompiler) {
        if (itemCompiler.isCancelByPlug() || itemCompiler.getItem().isDisabled() || !linkItemContext.getTargetEntityKeys().contains(itemCompiler.getTargetEntityKey())) {
            return false;
        }
        return WRuleItemFunBatchPreCall.checkWriteConditionPreCall(itemCompiler, rowDataModel) || WRuleItemFunBatchPreCall.calcFormulaPreCall(itemCompiler, rowDataModel);
    }

    private static boolean calcFormulaPreCall(WRuleItemCompiler itemCompiler, RowDataModel rowDataModel) {
        ReplaceVerValue replaceVerValue = itemCompiler.getReplaceVerValue();
        boolean isBatchPreCall = itemCompiler.getFormulaExecuter().batchPreCall(rowDataModel, replaceVerValue);
        return isBatchPreCall;
    }

    private static boolean checkWriteConditionPreCall(WRuleItemCompiler itemCompiler, RowDataModel rowDataModel) {
        return itemCompiler.getGridFilterExecuter().batchPreCall(rowDataModel) || itemCompiler.getExpressionExecuter().batchPreCall(rowDataModel);
    }
}

