/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.track.opcontroller;

import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.botp.WriteBackRuleElement;
import kd.bos.entity.botp.runtime.BFRowLinkUpNode;
import kd.bos.service.botp.track.BFTrackerContext;
import kd.bos.service.botp.track.BFTrackerOpType;
import kd.bos.service.botp.track.LinkItemContext;
import kd.bos.service.botp.track.bizentity.AED;
import kd.bos.service.botp.track.bizentity.Row;
import kd.bos.service.botp.track.bizentity.RowId;
import kd.bos.service.botp.track.bizentity.Sheets;
import kd.bos.service.botp.track.bizentity.WRule;
import kd.bos.service.botp.track.helper.BFTrackerDbService;
import kd.bos.service.botp.track.helper.WRuleCompiler;
import kd.bos.service.botp.track.opcontroller.AbstractOpController;
import kd.bos.service.botp.track.opcontroller.AuditController;
import kd.bos.service.botp.track.opcontroller.CancelController;
import kd.bos.service.botp.track.opcontroller.DeleteController;
import kd.bos.service.botp.track.opcontroller.DraftController;
import kd.bos.service.botp.track.opcontroller.SaveController;
import kd.bos.service.botp.track.opcontroller.UnAuditController;

public interface IOpController {
    default public BFTrackerOpType getOpType() {
        return BFTrackerOpType.Save;
    }

    default public void setOpType(BFTrackerOpType opType) {
    }

    public void setContext(BFTrackerContext var1, BFTrackerDbService var2);

    public Set<Long> readOtherEntryIds(LinkItemContext var1, Long[] var2);

    public Set<Long> readSnapshotOtherEntryIds(LinkItemContext var1, Long[] var2);

    public Sheets createSheets(LinkItemContext var1, DynamicObject[] var2);

    public Sheets createSubSheets(LinkItemContext var1, DynamicObject[] var2, Long[] var3, Set<Long> var4);

    public Sheets createSubSnapshotSheets(LinkItemContext var1, Set<Long> var2);

    public void createWRules(LinkItemContext var1, Map<Long, WRuleCompiler> var2, Map<RowId, BFRowLinkUpNode> var3, AED<Row> var4);

    public boolean isOpValidRule(WriteBackRuleElement var1);

    public void checkCanWriteBack(WRule var1);

    public void calcRealAmount(WRule var1);

    public static IOpController create(BFTrackerOpType opType) {
        AbstractOpController op = null;
        switch (opType) {
            case Draft: {
                op = new DraftController();
                break;
            }
            case Save: {
                op = new SaveController();
                break;
            }
            case Audit: {
                op = new AuditController();
                break;
            }
            case UnAudit: {
                op = new UnAuditController();
                break;
            }
            case Delete: {
                op = new DeleteController();
                break;
            }
            case Cancel: {
                op = new CancelController();
                break;
            }
            default: {
                op = new DraftController();
            }
        }
        op.setOpType(opType);
        return op;
    }
}

