/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.track.wblogicunit;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.service.botp.track.WriteBackContext;
import kd.bos.service.botp.track.bizentity.RowId;
import kd.bos.service.botp.track.bizentity.WRule;
import kd.bos.service.botp.track.bizentity.WSRow;
import kd.bos.service.botp.track.helper.WBizRuleCompiler;
import kd.bos.service.botp.track.helper.WRuleCompiler;
import kd.bos.service.botp.track.wblogicunit.AbstractWriteBackLogicUnit;

class BizRuleLogic
extends AbstractWriteBackLogicUnit {
    public BizRuleLogic(WriteBackContext writeBackContext) {
        super(writeBackContext);
    }

    @Override
    public void doWriteBack(RowDataModel rowDataModel, List<WRule> wRules) {
        Map<Long, Map<RowId, List<WSRow>>> dctRules = this.splitByRule(wRules);
        for (Map.Entry<Long, Map<RowId, List<WSRow>>> entryRule : dctRules.entrySet()) {
            Long ruleVerId = entryRule.getKey();
            WRuleCompiler ruleCompiler = this.writeBackContext.getRules().get(ruleVerId);
            Map<RowId, List<WSRow>> dctRule = entryRule.getValue();
            this.execBizRuleLogic(rowDataModel, ruleCompiler, dctRule);
        }
    }

    private Map<Long, Map<RowId, List<WSRow>>> splitByRule(List<WRule> wRules) {
        HashMap<Long, Map<RowId, List<WSRow>>> dctRules = new HashMap<Long, Map<RowId, List<WSRow>>>();
        for (WRule wRule : wRules) {
            Long ruleVerId = wRule.getRuleVerId();
            Map dctRule = dctRules.computeIfAbsent(ruleVerId, v -> new HashMap());
            for (WSRow wsRow : wRule.getExecuteSourceRows().values()) {
                List listRow = dctRule.computeIfAbsent(wsRow.getSId(), v -> new ArrayList());
                listRow.add(wsRow);
            }
        }
        return dctRules;
    }

    private void execBizRuleLogic(RowDataModel rowDataModel, WRuleCompiler ruleCompiler, Map<RowId, List<WSRow>> dctRule) {
        if (ruleCompiler.getBizRules().size() == 0) {
            return;
        }
        for (WBizRuleCompiler bizRuleCompiler : ruleCompiler.getBizRules()) {
            for (Map.Entry<RowId, List<WSRow>> entryRow : dctRule.entrySet()) {
                WSRow wsRow = entryRow.getValue().get(0);
                DynamicObject activeRow = wsRow.getSrcActiveRow();
                rowDataModel.setRowContext(activeRow);
                bizRuleCompiler.doAction(rowDataModel, activeRow);
            }
        }
    }
}

