/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.track.wblogicunit;

import java.math.BigDecimal;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.service.botp.track.WriteBackContext;
import kd.bos.service.botp.track.bizentity.WSRow;
import kd.bos.service.botp.track.getvaluemode.FieldValueTypeConvert;
import kd.bos.service.botp.track.helper.WRuleItemCompiler;
import kd.bos.service.botp.track.wblogicunit.IWriteBack;

class WriteBackCover
implements IWriteBack {
    private Class<?> fldValType;
    private FieldValueTypeConvert valueTypeConvert;

    WriteBackCover() {
    }

    @Override
    public void setFieldValueType(Class<?> fldValType) {
        this.fldValType = fldValType;
    }

    @Override
    public void setFieldValueTypeConvert(FieldValueTypeConvert valueTypeConvert) {
        this.valueTypeConvert = valueTypeConvert;
    }

    @Override
    public void doWriteBack(RowDataModel rowDataModel, String srcFldKey, BigDecimal val, Object cval, int scale) {
        Object newValue = this.valueTypeConvert.convert(cval, this.fldValType);
        rowDataModel.setValue(srcFldKey, newValue);
    }

    @Override
    public void doWriteBack(WriteBackContext writebackContext, WRuleItemCompiler ruleItemCompiler, RowDataModel rowDataModel, WSRow wsRow, int scale) {
        String srcFldKey = ruleItemCompiler.getItem().getSourceCommitFieldKey();
        Object cval = wsRow.getCVal();
        Object oldValue = rowDataModel.getValue(srcFldKey);
        Object newValue = this.valueTypeConvert.convert(cval, this.fldValType);
        newValue = this.valueTypeConvert.convert(newValue, rowDataModel.getMainEntityType().findProperty(srcFldKey));
        rowDataModel.setValue(srcFldKey, newValue);
        writebackContext.getTrackerResult().getTrackerLog().addWriteValue(writebackContext, wsRow, srcFldKey, oldValue, "c", newValue, newValue);
    }
}

