/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.operation.bizrule;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.operate.OperateLog;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.service.operation.bizrule.PushAndSaveExecuter;
import kd.bos.servicehelper.TimeServiceHelper;

class PushAndSaveLog {
    private static final String METHOD_EXECUTE = "PushAndSaveExecuter.execute(objs)";
    private static final String METHOD_DOEXECUTE = "PushAndSaveExecuter.doExecute(objs,pushArgs)";
    private static final String METHOD_PUSH = "PushAndSaveExecuter.doPush(objs,pushArgs)";
    private static final String METHOD_EXECETEOPERATE = "PushAndSaveExecuter.do%s()";
    private static final int BILLID_COUNT_LOG = 100;
    private PushAndSaveExecuter executer;
    private OperateLog operateLog;
    private long startTime = TimeServiceHelper.now().getTime();

    public OperateLog getOperateLog() {
        if (this.operateLog == null) {
            this.operateLog = OperateLog.get((boolean)false);
        }
        return this.operateLog;
    }

    public PushAndSaveLog(PushAndSaveExecuter executer, OperateLog operateLog) {
        this.executer = executer;
        this.operateLog = operateLog;
    }

    public void execute_begin(DynamicObject[] objs) {
        if (!this.getOperateLog().isWriteLog()) {
            return;
        }
        this.getOperateLog().beginMothed(METHOD_EXECUTE, METHOD_EXECUTE);
    }

    public void execute_end(DynamicObject[] objs) {
        Object[] billIds = new Object[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            billIds[i] = objs[i].getPkValue();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("PushAndSaveExecuter.execute(");
        sb.append(this.executer.getSourceBill()).append(",");
        sb.append(this.executer.getTargetBill()).append(",");
        sb.append(this.executer.getRuleId()).append(",");
        sb.append(this.executer.getTargetOperation()).append(",");
        if (this.executer.oneByOne) {
            sb.append("one by one,");
        }
        sb.append(this.buildIdString(billIds));
        sb.append(") \r\n");
        sb.append("cost ").append(TimeServiceHelper.now().getTime() - this.startTime).append(" ms \r\n");
        sb.append("auto push failed bills:");
        if (this.executer.getPushFailBillIds().isEmpty()) {
            sb.append(" null.");
        } else {
            sb.append(this.buildIdString(this.executer.getPushFailBillIds().toArray()));
        }
        List errorInfos = this.executer.getOperationResult().getAllErrorInfo();
        if (!errorInfos.isEmpty()) {
            sb.append("\r\n");
            for (OperateErrorInfo errInfo : errorInfos) {
                sb.append(errInfo.getMessage()).append(" \r\n");
            }
        }
        if (this.getOperateLog().isWriteLog()) {
            this.getOperateLog().endMothed(METHOD_EXECUTE, sb.toString());
        } else {
            this.getOperateLog().important(sb.toString());
        }
    }

    public void doExecute_begin(DynamicObject[] objs, PushArgs pushArgs) {
        this.getOperateLog().beginMothed(METHOD_DOEXECUTE, "PushAndSaveExecuter.doExecute(objs, pushArgs) begin");
    }

    public void doExecute_end(String log) {
        this.getOperateLog().endMothed(METHOD_DOEXECUTE, log);
    }

    public void push_begin(DynamicObject[] objs, PushArgs pushArgs) {
        this.getOperateLog().beginMothed(METHOD_PUSH, "PushAndSaveExecuter.doPush() begin.");
    }

    public void push_end(DynamicObject[] objs, ConvertOperationResult pushResult) {
        if (!this.getOperateLog().isWriteLog()) {
            return;
        }
        String endInfo = String.format("PushAndSaveExecuter.doPush() end. result isSuccess:=%s; message:=%s; target bill:=%s", pushResult.isSuccess(), pushResult.getMessage(), pushResult.getCachePageIds().size());
        this.getOperateLog().endMothed(METHOD_PUSH, endInfo);
    }

    public void executeOperate_begin(String opKey, DynamicObject[] targetBillObjs) {
        if (!this.getOperateLog().isWriteLog()) {
            return;
        }
        Object[] targetBillIds = new Object[targetBillObjs.length];
        for (int i = 0; i < targetBillObjs.length; ++i) {
            targetBillIds[i] = targetBillObjs[i].getPkValue();
        }
        this.executeOperate_begin(opKey, targetBillIds);
    }

    public void executeOperate_begin(String opKey, Object[] targetBillIds) {
        if (!this.getOperateLog().isWriteLog()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("PushAndSaveExecuter.do").append(opKey).append("(");
        sb.append(this.executer.getTargetBill()).append(",");
        sb.append(this.buildIdString(targetBillIds));
        sb.append(")");
        this.getOperateLog().beginMothed(String.format(METHOD_EXECETEOPERATE, opKey), sb.toString());
    }

    public void executeOperate_end(String opKey, DynamicObject[] targetBillObjs, OperationResult opResult) {
        if (!this.getOperateLog().isWriteLog()) {
            return;
        }
        Object[] targetBillIds = new Object[targetBillObjs.length];
        for (int i = 0; i < targetBillObjs.length; ++i) {
            targetBillIds[i] = targetBillObjs[i].getPkValue();
        }
        this.executeOperate_end(opKey, targetBillIds, opResult);
    }

    public void executeOperate_end(String opKey, Object[] targetBillIds, OperationResult opResult) {
        if (!this.getOperateLog().isWriteLog()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("PushAndSaveExecuter.do").append(opKey).append("(");
        sb.append(this.executer.getTargetBill()).append(",");
        sb.append(this.buildIdString(targetBillIds));
        sb.append("), ");
        if (opResult == null) {
            sb.append("result is null");
        } else {
            List errInfos = opResult.getAllErrorOrValidateInfo();
            sb.append("result: isSuccess:=").append(opResult.isSuccess()).append(",");
            sb.append(" Success bill count:=").append(opResult.getSuccessPkIds().size()).append(",");
            sb.append("error message:=").append(errInfos.isEmpty() ? opResult.getMessage() : ((IOperateInfo)errInfos.get(0)).getMessage());
        }
        this.getOperateLog().endMothed(String.format(METHOD_EXECETEOPERATE, opKey), sb.toString());
    }

    private String buildIdString(Object[] billIds) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < billIds.length; ++i) {
            if (i >= 100) {
                sb.append("...");
                break;
            }
            if (i > 0) {
                sb.append(",");
            }
            sb.append(billIds[i]);
        }
        sb.append("]");
        sb.append("total ").append(billIds.length).append(" bills");
        return sb.toString();
    }
}

