/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.botp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.ListDcxmlBinder;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.designer.botp.BillTreeBuildParameter;
import kd.bos.designer.botp.ConvertRuleEdit;
import kd.bos.designer.botp.EntityParseHelper;
import kd.bos.designer.botp.GetRuleHelper;
import kd.bos.designer.botp.PlugPolicyHelper;
import kd.bos.designer.botp.RuleCacheHelper;
import kd.bos.designer.botp.SelectBasedataValue;
import kd.bos.designer.botp.SetRuleHelper;
import kd.bos.designer.botp.extcontrol.domain.ExtControlEditDomain;
import kd.bos.designer.botp.extcontrol.domain.ExtControlLockDomain;
import kd.bos.designer.property.ComboItemsEditPlugin;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.botp.CRBizRuleElement;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.botp.CRFormula;
import kd.bos.entity.botp.CRValByConditions;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.botp.FieldConvertType;
import kd.bos.entity.botp.GroupByMode;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.property.PictureProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

class FieldEventHandler {
    private static final String BOS_DESIGNER_PLUGIN = "bos-botp-formplugin";
    private static Log log = LogFactory.getLog(FieldEventHandler.class);
    private static final String SWITCH_TREE_NODE = "switchTreeNode";
    private IFormView view;
    private ConvertRuleEdit plugin;
    private ExtControlLockDomain extControlDomain;
    private ExtControlEditDomain extControlEditDomain;

    public FieldEventHandler(IFormView view, ConvertRuleEdit plugin, ExtControlLockDomain extControlDomain, ExtControlEditDomain extControlEditDomain) {
        this.view = view;
        this.plugin = plugin;
        this.extControlDomain = extControlDomain;
        this.extControlEditDomain = extControlEditDomain;
    }

    private IFormView getView() {
        return this.view;
    }

    private IDataModel getModel() {
        return this.view.getModel();
    }

    public void addClickListeners() {
        this.plugin.addClickListeners(new String[]{"frunconditiondesc"});
        this.plugin.addClickListeners(new String[]{"advfilterenable"});
        this.plugin.addClickListeners(new String[]{"filterexprdesc"});
        this.plugin.addClickListeners(new String[]{"fsourcefieldname", "ffieldformuladesc"});
        this.plugin.addClickListeners(new String[]{"g_billadd", "g_billdel", "g_entryadd", "g_entrydel", "g_subentryadd", "g_subentrydel"});
        this.plugin.addClickListeners(new String[]{"br_bizruledesc"});
        this.plugin.addClickListeners(new String[]{"advanced_conditions"});
    }

    public void addHyperLinkClickListener() {
        EntryGrid fieldMapGrid = (EntryGrid)this.getView().getControl("fieldmappolicy");
        fieldMapGrid.addHyperClickListener((HyperLinkClickListener)this.plugin);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if ("ftargetentrykey".equalsIgnoreCase(key)) {
            String targetEntryKey = (String)this.getModel().getValue("ftargetentrykey");
            SetRuleHelper setRuleHelper = new SetRuleHelper(this.getView(), this.plugin, this.extControlDomain, this.extControlEditDomain);
            setRuleHelper.changeTgtLinkEntity(targetEntryKey);
            this.getModel().setValue("ftargetsubentrykey", (Object)"");
        } else if ("fsourceentrykey".equalsIgnoreCase(key)) {
            String sourceEntryKey = (String)this.getModel().getValue("fsourceentrykey");
            SetRuleHelper setRuleHelper = new SetRuleHelper(this.getView(), this.plugin, this.extControlDomain, this.extControlEditDomain);
            setRuleHelper.changeSrcLinkEntity(sourceEntryKey);
            this.getModel().setValue("fsourcesubentrykey", (Object)"");
        } else if ("fconverttype".equalsIgnoreCase(key)) {
            for (ChangeData changeData : e.getChangeSet()) {
                this.convertTypeChanged(changeData.getRowIndex());
            }
        } else if (StringUtils.isNotBlank((CharSequence)key) && key.startsWith("g_")) {
            String oldValue = (String)e.getChangeSet()[0].getOldValue();
            String newValue = (String)e.getChangeSet()[0].getNewValue();
            String isSwitchTreeNodeStr = this.getView().getPageCache().get(SWITCH_TREE_NODE);
            boolean isSwitchTreeNode = StringUtils.isNotBlank((CharSequence)isSwitchTreeNodeStr) && Boolean.parseBoolean(isSwitchTreeNodeStr);
            boolean isPopUpTips = String.valueOf(GroupByMode.GroupByField.getValue()).equals(oldValue) && !oldValue.equals(newValue) && !isSwitchTreeNode;
            this.groupByChanged(key, isPopUpTips);
        } else if ("frunconditiondesc".equalsIgnoreCase(key)) {
            this.doClearFieldValue("fruncondition", e.getChangeSet());
        } else if ("fsourcefieldname".equals(key)) {
            this.doClearFieldValue("fsourcefield", e.getChangeSet());
        } else if ("ffieldformuladesc".equals(key)) {
            this.doClearFieldValue("ffieldformula", e.getChangeSet());
        } else if ("br_bizruledesc".equalsIgnoreCase(key)) {
            this.doClearFieldValue("br_bizruleitem", e.getChangeSet());
        } else if ("checkbaseenable".equalsIgnoreCase(key)) {
            boolean isEnable = Boolean.parseBoolean(this.getView().getModel().getValue("checkbaseenable").toString());
            this.getView().setVisible(Boolean.valueOf(isEnable), new String[]{"mulcombobaseenable"});
            if (isEnable) {
                SetRuleHelper helper = new SetRuleHelper(this.getView(), this.plugin, this.extControlDomain, this.extControlEditDomain);
                helper.fillCheckBaseEnableCombo();
            }
        } else if ("fautosave".equalsIgnoreCase(key)) {
            SetRuleHelper helper = new SetRuleHelper(this.getView(), this.plugin, this.extControlDomain, this.extControlEditDomain);
            helper.setBillPushAttr();
        } else if ("advanced_conditions".equalsIgnoreCase(key)) {
            SetRuleHelper helper = new SetRuleHelper(this.getView(), this.plugin, this.extControlDomain, this.extControlEditDomain);
            helper.setFilterAp();
        } else if ("advfilterenable".equalsIgnoreCase(key)) {
            int row = this.getModel().getEntryCurrentRowIndex("adv_filter");
            String runConditionJson = (String)this.getModel().getValue("advfilterjson", row);
            if (StringUtils.isNotBlank((CharSequence)runConditionJson)) {
                CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)runConditionJson, CRCondition.class);
                Boolean enable = (Boolean)this.getModel().getValue("advfilterenable", row);
                condition.setEnabled(enable.booleanValue());
                this.getModel().setValue("advfilterjson", (Object)SerializationUtils.toJsonString((Object)condition));
            }
        } else if ("filterexprdesc".equalsIgnoreCase(key)) {
            this.doClearFieldValue("advfilterjson", e.getChangeSet());
            this.doClearFieldValue("advfilterdesc", e.getChangeSet());
        }
    }

    public void Click(String sourceFldKey) {
        if ("frunconditiondesc".equals(sourceFldKey)) {
            String conditionJson = (String)this.getModel().getValue("fruncondition");
            MainEntityType mainType = this.plugin.getRuleFormHelper().getSrcMainType();
            HashSet<String> selectedEntity = new HashSet<String>();
            selectedEntity.add(mainType.getName());
            BillTreeBuildParameter parameter = new BillTreeBuildParameter(mainType);
            parameter.getForbidClassTypes().add(AttachmentProp.class);
            parameter.getForbidClassTypes().add(PictureProp.class);
            parameter.getSelectedEntity().addAll(selectedEntity);
            TreeNode billTreeNode = EntityParseHelper.buildBillTreeNodes(parameter);
            String fldNodes = SerializationUtils.toJsonString((Object)billTreeNode);
            this.showConditionForm(conditionJson, mainType.getName(), true, fldNodes, sourceFldKey);
        } else if ("fsourcefieldname".equals(sourceFldKey)) {
            this.doClickSourceField();
        } else if ("ffieldformuladesc".equals(sourceFldKey)) {
            this.doClickFieldFormula();
        } else if (StringUtils.isNotBlank((CharSequence)sourceFldKey) && sourceFldKey.startsWith("g_")) {
            this.groupByClick(sourceFldKey);
        } else if ("br_bizruledesc".equalsIgnoreCase(sourceFldKey)) {
            this.doClickBizRule();
        } else if ("filterexprdesc".equals(sourceFldKey)) {
            int row = this.getModel().getEntryCurrentRowIndex("adv_filter");
            String runConditionJson = (String)this.getModel().getValue("advfilterjson", row);
            MainEntityType mainType = this.plugin.getRuleFormHelper().getSrcMainType();
            BillTreeBuildParameter parameter = new BillTreeBuildParameter(mainType);
            parameter.getForbidClassTypes().add(AttachmentProp.class);
            parameter.getForbidClassTypes().add(PictureProp.class);
            TreeNode billTreeNode = EntityParseHelper.buildBillTreeNodes(parameter);
            String fldNodes = SerializationUtils.toJsonString((Object)billTreeNode);
            this.showFilterAdvConditionForm(runConditionJson, mainType.getName(), false, fldNodes, sourceFldKey);
        }
    }

    public void itemClick(ItemClickEvent e) {
        String itemKey = e.getItemKey();
        if (itemKey.equalsIgnoreCase("btnaddaction")) {
            this.doShowNewBizRule();
        } else if (itemKey.equalsIgnoreCase("btnmodifyaction")) {
            this.doClickBizRule();
        } else if (itemKey.equalsIgnoreCase("btnaddplug")) {
            PlugPolicyHelper.showAddPlugForm(this.view, this.plugin);
        } else if (itemKey.equalsIgnoreCase("btnaddjsplug")) {
            PlugPolicyHelper.showAddJSPlugForm(this.view, this.plugin);
        } else if (itemKey.equalsIgnoreCase("btnaddtsplug")) {
            PlugPolicyHelper.showAddTSPlugForm(this.view, this.plugin);
        } else if (itemKey.equalsIgnoreCase("selectts")) {
            PlugPolicyHelper.openPluginJavaScript(this.view, this.plugin);
        } else if (itemKey.equalsIgnoreCase("btnmodifyplug")) {
            PlugPolicyHelper.showModifyPlugForm(this.view, this.plugin);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"bar_billtype_test", (CharSequence)itemKey)) {
            this.doTestBillTypeMap();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"bar_billtype_newentry", (CharSequence)itemKey)) {
            int row = this.getModel().getEntryCurrentRowIndex("billtypemappolicy");
            this.getModel().setValue("billtypemapitemid", (Object)Uuid16.create().toString(), row);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent e) {
        String fieldKey = e.getFieldName();
        int row = e.getRowIndex();
        if ("fclearsourcefield".equalsIgnoreCase(fieldKey)) {
            SetRuleHelper setRuleHelper = new SetRuleHelper(this.view, this.plugin, this.extControlDomain, this.extControlEditDomain);
            setRuleHelper.clearSourceField(row);
        }
    }

    public void closedCallBack(String sourceFldKey, Object returnData) {
        if ("frunconditiondesc".equals(sourceFldKey)) {
            String json = (String)returnData;
            this.receiveCondition(json, "", "fruncondition", "frunconditiondesc");
        } else if ("fsourcefieldname".equals(sourceFldKey)) {
            MainEntityType mainType = this.plugin.getRuleFormHelper().getSrcMainType();
            this.receiveSelectField(mainType, (String)returnData, "fieldmappolicy", "fsourcefield", "fsourcefieldname");
        } else if ("ffieldformuladesc".equals(sourceFldKey)) {
            if (returnData instanceof ListSelectedRowCollection) {
                this.doReceiceFieldConstant((ListSelectedRowCollection)returnData);
            } else {
                this.doReceiveFieldFormula((String)returnData);
            }
        } else if (StringUtils.isNotBlank((CharSequence)sourceFldKey) && sourceFldKey.startsWith("groupby_")) {
            this.groupAddRow(sourceFldKey, returnData);
        } else if ("btnaddaction".equalsIgnoreCase(sourceFldKey)) {
            this.doReceiveNewBizRule((String)returnData);
        } else if ("br_bizruledesc".equalsIgnoreCase(sourceFldKey)) {
            this.doReceiveBizRule((String)returnData);
        } else if ("btnaddplug".equalsIgnoreCase(sourceFldKey)) {
            PlugPolicyHelper.receiveNewPlug(this.view, this.plugin, returnData);
        } else if ("btnaddjsplug".equalsIgnoreCase(sourceFldKey)) {
            PlugPolicyHelper.receiveNewJSPlug(this.view, this.plugin, returnData);
        } else if ("btnaddtsplug".equalsIgnoreCase(sourceFldKey)) {
            PlugPolicyHelper.receiveNewTSPlug(this.view, this.plugin, returnData);
        } else if ("selectts".equalsIgnoreCase(sourceFldKey)) {
            PlugPolicyHelper.selectTSPlug(this.view, this.plugin, returnData);
        } else if ("btnmodifyplug".equalsIgnoreCase(sourceFldKey)) {
            PlugPolicyHelper.receiveModifyPlug(this.view, this.plugin, returnData);
        } else if ("filterexprdesc".equalsIgnoreCase(sourceFldKey)) {
            String json = (String)returnData;
            this.receiveFilterCondition(json, "adv_filter", "advfilterjson", "filterexprdesc");
        }
    }

    private void doClearFieldValue(String key, ChangeData[] changeDatas) {
        for (ChangeData changeData : changeDatas) {
            if (!StringUtils.isBlank((Object)changeData.getNewValue())) continue;
            this.getModel().setValue(key, null, changeData.getRowIndex());
        }
    }

    private void doClickSourceField() {
        MainEntityType targetMainType = this.plugin.getRuleFormHelper().getTgtMainType();
        String entityKey = "fieldmappolicy";
        String targetFieldKey = "ftargetfield";
        String convertTypeFieldKey = "fconverttype";
        String sourceCtlKey = "fsourcefieldname";
        int row = this.getModel().getEntryCurrentRowIndex(entityKey);
        String convertType = (String)this.getModel().getValue(convertTypeFieldKey, row);
        if (StringUtils.isBlank((CharSequence)convertType) || FieldConvertType.SourceField.getValue() != Integer.parseInt(convertType)) {
            return;
        }
        String targetFieldValue = (String)this.getModel().getValue(targetFieldKey, row);
        IDataEntityProperty targetProperty = targetMainType.findProperty(targetFieldValue);
        if (targetProperty == null) {
            return;
        }
        MainEntityType sourceMainType = this.plugin.getRuleFormHelper().getSrcMainType();
        BillTreeBuildParameter parameter = new BillTreeBuildParameter(sourceMainType, null, targetProperty);
        parameter.setIncludePKField(true);
        if (targetProperty instanceof TextProp) {
            parameter.getForbidClassTypes().add(ItemClassProp.class);
        }
        TreeNode srcBillNode = EntityParseHelper.buildBillTreeNodes(parameter);
        this.showSelectFieldForm(srcBillNode, sourceCtlKey);
    }

    private void showSelectFieldForm(TreeNode srcBillNode, String sourceCtrlKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_selectfield");
        String nodesJson = SerializationUtils.toJsonString((Object)srcBillNode);
        showParameter.getCustomParams().put("treenodes", nodesJson);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this.plugin, sourceCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void receiveSelectField(MainEntityType mainType, String returnPropName, String entityKey, String sourceCtrlKey, String descFldKey) {
        if (StringUtils.isBlank((CharSequence)returnPropName)) {
            return;
        }
        String fieldCaption = EntityParseHelper.buildPropFullCaption((EntityType)mainType, returnPropName);
        if (StringUtils.isBlank((CharSequence)entityKey)) {
            this.getModel().setValue(sourceCtrlKey, (Object)returnPropName);
            this.getModel().setValue(descFldKey, (Object)fieldCaption);
        } else {
            int row = this.getModel().getEntryCurrentRowIndex(entityKey);
            this.getModel().setValue(sourceCtrlKey, (Object)returnPropName, row);
            this.getModel().setValue(descFldKey, (Object)fieldCaption, row);
        }
    }

    private void doShowNewBizRule() {
        String bizRuleJson = "";
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_updatedataservice");
        showParameter.getCustomParams().put("crbizruleelement", bizRuleJson);
        showParameter.getCustomParams().put("targetentitynumber", this.plugin.getRuleFormHelper().getTargetEntityNumber());
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this.plugin, "btnaddaction"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void doReceiveNewBizRule(String returnData) {
        if (StringUtils.isBlank((CharSequence)returnData)) {
            return;
        }
        String bizRuleJson = returnData;
        CRBizRuleElement bizRule = (CRBizRuleElement)SerializationUtils.fromJsonString((String)bizRuleJson, CRBizRuleElement.class);
        String entityKey = "bizrulepolicy";
        this.getModel().createNewEntryRow(entityKey);
        int row = this.getModel().getEntryRowCount(entityKey) - 1;
        this.getModel().setValue("br_id", (Object)bizRule.getId(), row);
        this.getModel().setValue("br_bizruleitem", (Object)bizRuleJson, row);
        this.getModel().setValue("br_bizruledesc", (Object)bizRule.getDescription().toString(), row);
    }

    private void doClickBizRule() {
        String entityKey = "bizrulepolicy";
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(entityKey);
        int row = grid.getEntryState().getFocusRow();
        if (row == -1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u884c\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"ConvertRuleEdit_76", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String bizRuleJson = (String)this.getModel().getValue("br_bizruleitem", row);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_updatedataservice");
        showParameter.getCustomParams().put("crbizruleelement", bizRuleJson);
        showParameter.getCustomParams().put("targetentitynumber", this.plugin.getRuleFormHelper().getTargetEntityNumber());
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this.plugin, "br_bizruledesc"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void doReceiveBizRule(String returnData) {
        if (StringUtils.isBlank((CharSequence)returnData)) {
            return;
        }
        String bizRuleJson = returnData;
        CRBizRuleElement bizRule = (CRBizRuleElement)SerializationUtils.fromJsonString((String)bizRuleJson, CRBizRuleElement.class);
        String entityKey = "bizrulepolicy";
        int row = this.getModel().getEntryCurrentRowIndex(entityKey);
        this.getModel().setValue("br_bizruleitem", (Object)bizRuleJson, row);
        this.getModel().setValue("br_bizruledesc", (Object)bizRule.getDescription().toString(), row);
    }

    private void doClickFieldFormula() {
        String formula;
        String convertType;
        String entityKey = "fieldmappolicy";
        String targetFld = "ftargetfield";
        String convertTypeFld = "fconverttype";
        String formulaFld = "ffieldformula";
        String formulaDescFld = "ffieldformuladesc";
        MainEntityType targetMainType = this.plugin.getRuleFormHelper().getTgtMainType();
        int row = this.getModel().getEntryCurrentRowIndex(entityKey);
        String targetPropName = (String)this.getModel().getValue(targetFld, row);
        IDataEntityProperty targetProperty = targetMainType.findProperty(targetPropName);
        if (targetProperty == null || !this.isPropertySupportFieldFormula(targetProperty)) {
            return;
        }
        String billNodeJson = RuleCacheHelper.getSourceBillTreeNode(this.plugin);
        boolean isHideItemClassProp = targetProperty instanceof TextProp;
        boolean isHideItemClassPropByCache = RuleCacheHelper.isHideItemClassProp(this.plugin);
        if (StringUtils.isBlank((CharSequence)billNodeJson) || isHideItemClassProp && !isHideItemClassPropByCache || !isHideItemClassProp && isHideItemClassPropByCache) {
            MainEntityType sourceMainType = this.plugin.getRuleFormHelper().getSrcMainType();
            BillTreeBuildParameter parameter = new BillTreeBuildParameter(sourceMainType);
            parameter.setIncludePKField(true);
            if (isHideItemClassProp) {
                parameter.getForbidClassTypes().add(ItemClassProp.class);
            }
            RuleCacheHelper.setIsHideItemClassProp(this.plugin, isHideItemClassProp);
            TreeNode billTreeNode = EntityParseHelper.buildBillTreeNodes(parameter);
            billNodeJson = RuleCacheHelper.putSourceBillTreeNode(this.plugin, billTreeNode);
        }
        if (StringUtils.isBlank((CharSequence)(convertType = (String)this.getModel().getValue(convertTypeFld, row)))) {
            return;
        }
        if (FieldConvertType.Formula.getValue() == Integer.parseInt(convertType)) {
            formula = (String)this.getModel().getValue(formulaFld, row);
            if (StringUtils.isBlank((CharSequence)formula)) {
                CRFormula crFormula = new CRFormula();
                formula = SerializationUtils.toJsonString((Object)crFormula);
            }
            this.showFormulaForm(formula, this.plugin.getRuleFormHelper().getSrcMainType().getName(), billNodeJson, formulaDescFld);
        } else if (FieldConvertType.ByCondition.getValue() == Integer.parseInt(convertType)) {
            formula = (String)this.getModel().getValue(formulaFld, row);
            if (StringUtils.isBlank((CharSequence)formula)) {
                CRValByConditions valByConditions = new CRValByConditions();
                formula = SerializationUtils.toJsonString((Object)valByConditions);
            }
            this.showValByConditionForm(formula, billNodeJson, formulaDescFld, targetProperty);
        } else if (FieldConvertType.CONSTANT.getValue() == Integer.parseInt(convertType)) {
            CloseCallBack closeCallBack;
            this.trySetInitOrgFuncIdForOrgProp(targetProperty, this.getView().getFormShowParameter());
            this.trySetConstantFormula();
            if (targetProperty instanceof ItemClassProp) {
                closeCallBack = new CloseCallBack((IFormPlugin)this.plugin, formulaDescFld);
                DynamicObjectCollection dynamicObjects = (DynamicObjectCollection)this.getModel().getDataEntity(true).get("fieldmappolicy");
                CRFormula crFormula = null;
                for (DynamicObject dynamicObject : dynamicObjects) {
                    if (!StringUtils.equals((CharSequence)((ItemClassProp)targetProperty).getTypePropName(), (CharSequence)dynamicObject.get("ftargetfield").toString()) || StringUtils.isEmpty((CharSequence)((String)dynamicObject.get("ffieldformula")))) continue;
                    crFormula = (CRFormula)SerializationUtils.fromJsonString((String)((String)dynamicObject.get("ffieldformula")), CRFormula.class);
                }
                if (crFormula != null) {
                    SelectBasedataValue.get().showF7List(crFormula.getExpression(), this.getView(), closeCallBack);
                } else {
                    SelectBasedataValue.get().showF7List((BasedataProp)targetProperty, this.getView(), closeCallBack);
                }
            } else if (targetProperty instanceof BasedataProp) {
                closeCallBack = new CloseCallBack((IFormPlugin)this.plugin, formulaDescFld);
                SelectBasedataValue.get().showF7List((BasedataProp)targetProperty, this.getView(), closeCallBack);
            } else if (targetProperty instanceof ComboProp) {
                this.showComboForm((ComboProp)targetProperty, formulaDescFld);
            }
        }
    }

    private void trySetInitOrgFuncIdForOrgProp(IDataEntityProperty targetProperty, FormShowParameter formShowParameter) {
        try {
            if (targetProperty instanceof OrgProp && StringUtils.isNotBlank((CharSequence)((OrgProp)targetProperty).getOrgFunc())) {
                formShowParameter.getCustomParams().put("initOrgFuncId", ((OrgProp)targetProperty).getOrgFunc());
            }
        }
        catch (Exception e) {
            log.warn("trySetInitOrgFuncIdForOrgProp eror is " + e);
        }
    }

    private void trySetConstantFormula() {
        try {
            int row = this.getModel().getEntryCurrentRowIndex("fieldmappolicy");
            Object formula = this.getModel().getValue("ffieldformula", row);
            if (StringUtils.isNotBlank((Object)formula)) {
                this.getView().getFormShowParameter().setCustomParam("CONSTANT_CRFORMULA_JSON", formula);
            }
        }
        catch (Exception e) {
            log.warn("trySetConstantFormula eror is " + e);
        }
    }

    private boolean isPropertySupportFieldFormula(IDataEntityProperty targetProperty) {
        return !(targetProperty instanceof AttachmentProp);
    }

    private void doReceiceFieldConstant(ListSelectedRowCollection returnData) {
        if (StringUtils.isBlank((Object)returnData) || returnData.size() == 0) {
            return;
        }
        CRFormula formula = new CRFormula();
        formula.setExprTran(returnData.get(0).getName());
        formula.setExpression(returnData.get(0).getPrimaryKeyValue().toString());
        String json = SerializationUtils.toJsonString((Object)formula);
        String entityKey = "fieldmappolicy";
        String formulaFld = "ffieldformula";
        String formulaDescFld = "ffieldformuladesc";
        if (StringUtils.isBlank((CharSequence)entityKey)) {
            this.getModel().setValue(formulaFld, (Object)json);
            this.getModel().setValue(formulaDescFld, (Object)formula.getExprTran());
        } else {
            int row = this.getModel().getEntryCurrentRowIndex(entityKey);
            this.getModel().setValue(formulaFld, (Object)json, row);
            this.getModel().setValue(formulaDescFld, (Object)formula.getExprTran(), row);
        }
    }

    private void doReceiveFieldFormula(String returnData) {
        if (StringUtils.isBlank((CharSequence)returnData)) {
            return;
        }
        String entityKey = "fieldmappolicy";
        String convertTypeFld = "fconverttype";
        String formulaFld = "ffieldformula";
        String formulaDescFld = "ffieldformuladesc";
        int row = this.getModel().getEntryCurrentRowIndex(entityKey);
        String convertType = (String)this.getModel().getValue(convertTypeFld, row);
        if (FieldConvertType.Formula.getValue() == Integer.parseInt(convertType) || FieldConvertType.CONSTANT.getValue() == Integer.parseInt(convertType)) {
            this.receiveFormula(returnData, entityKey, formulaFld, formulaDescFld);
        } else {
            this.receiveValByCondition(returnData, entityKey, formulaFld, formulaDescFld);
        }
    }

    private void showComboForm(ComboProp comboProp, String sourceCtrlKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("ide_comboitemsselect");
        showParameter.getCustomParams().put("comboProp", this.getComboItems(comboProp));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this.plugin, sourceCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private Object getComboItems(ComboProp comboProp) {
        List items = comboProp.getComboItems();
        ComboToJsonSerializer comboJson = new ComboToJsonSerializer();
        comboJson.setItems(items);
        ArrayList<IDataEntityType> dts = new ArrayList<IDataEntityType>();
        dts.add(OrmUtils.getDataEntityType(ComboItemsEditPlugin.ComboJsonSerializer.class));
        DcJsonSerializer serializer = new DcJsonSerializer((DcBinder)new ListDcxmlBinder(false, dts));
        Map mapCombo = serializer.serializeToMap((Object)comboJson, null);
        return mapCombo.containsKey("Items") ? mapCombo.get("Items") : items;
    }

    private void showFormulaForm(String formulaJson, String entityNumber, String fieldNodes, String sourceCtrlKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_formula");
        showParameter.getCustomParams().put("formula", formulaJson);
        showParameter.getCustomParams().put("entitynumber", entityNumber);
        showParameter.getCustomParams().put("treenodes", fieldNodes);
        String funcsXML = RuleCacheHelper.getFuncsXML(this.plugin);
        showParameter.getCustomParams().put("functiontypes", funcsXML);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this.plugin, sourceCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void receiveFormula(String formulaJson, String entryEntityKey, String formulaFldKey, String descFldKey) {
        if (StringUtils.isNotBlank((CharSequence)formulaJson)) {
            CRFormula formula = (CRFormula)SerializationUtils.fromJsonString((String)formulaJson, CRFormula.class);
            if (StringUtils.isBlank((CharSequence)entryEntityKey)) {
                this.getModel().setValue(formulaFldKey, (Object)formulaJson);
                this.getModel().setValue(descFldKey, (Object)formula.getExprDesc());
            } else {
                int row = this.getModel().getEntryCurrentRowIndex(entryEntityKey);
                this.getModel().setValue(formulaFldKey, (Object)formulaJson, row);
                this.getModel().setValue(descFldKey, (Object)formula.getExprDesc(), row);
            }
        }
    }

    private void showValByConditionForm(String json, String fieldNodes, String sourceCtrlKey, IDataEntityProperty targetProperty) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_valbycondition");
        showParameter.getCustomParams().put("crvalbyconditions", json);
        showParameter.getCustomParams().put("entitynumber", this.plugin.getRuleFormHelper().getSrcMainType().getName());
        showParameter.getCustomParams().put("treenodes", fieldNodes);
        if (targetProperty instanceof BasedataProp) {
            showParameter.getCustomParams().put("baseentityid", ((BasedataProp)targetProperty).getBaseEntityId());
            this.trySetInitOrgFuncIdForOrgProp(targetProperty, showParameter);
        }
        String funcsXML = RuleCacheHelper.getFuncsXML(this.plugin);
        showParameter.getCustomParams().put("functiontypes", funcsXML);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this.plugin, sourceCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void receiveValByCondition(String json, String entryEntityKey, String formulaFldKey, String descFldKey) {
        if (StringUtils.isNotBlank((CharSequence)json)) {
            CRValByConditions valByConditions = (CRValByConditions)SerializationUtils.fromJsonString((String)json, CRValByConditions.class);
            if (StringUtils.isBlank((CharSequence)entryEntityKey)) {
                this.getModel().setValue(formulaFldKey, (Object)json);
                this.getModel().setValue(descFldKey, (Object)valByConditions.getDescription());
            } else {
                int row = this.getModel().getEntryCurrentRowIndex(entryEntityKey);
                this.getModel().setValue(formulaFldKey, (Object)json, row);
                this.getModel().setValue(descFldKey, (Object)valByConditions.getDescription(), row);
            }
        }
    }

    private void showFilterAdvConditionForm(String conditionJson, String entityNumber, boolean onlyHeadFields, String fieldNodes, String sourceCtrlKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_filteradv_condition");
        showParameter.getCustomParams().put("formula", conditionJson);
        showParameter.getCustomParams().put("entitynumber", entityNumber);
        showParameter.getCustomParams().put("onlyheadfield", String.valueOf(onlyHeadFields));
        showParameter.getCustomParams().put("treenodes", fieldNodes);
        String funcsXML = RuleCacheHelper.getFuncsXML(this.plugin);
        showParameter.getCustomParams().put("functiontypes", funcsXML);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this.plugin, sourceCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void showConditionForm(String conditionJson, String entityNumber, boolean onlyHeadFields, String fieldNodes, String sourceCtrlKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_condition");
        showParameter.getCustomParams().put("formula", conditionJson);
        showParameter.getCustomParams().put("entitynumber", entityNumber);
        showParameter.getCustomParams().put("onlyheadfield", String.valueOf(onlyHeadFields));
        showParameter.getCustomParams().put("treenodes", fieldNodes);
        String funcsXML = RuleCacheHelper.getFuncsXML(this.plugin);
        showParameter.getCustomParams().put("functiontypes", funcsXML);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this.plugin, sourceCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void receiveCondition(String conditionJson, String entryEntityKey, String conditionFldKey, String descFldKey) {
        if (StringUtils.isNotBlank((CharSequence)conditionJson)) {
            CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)conditionJson, CRCondition.class);
            if (StringUtils.isBlank((CharSequence)entryEntityKey)) {
                this.getModel().setValue(conditionFldKey, (Object)conditionJson);
                this.getModel().setValue(descFldKey, (Object)condition.getExprDesc());
            } else {
                int row = this.getModel().getEntryCurrentRowIndex(entryEntityKey);
                this.getModel().setValue(conditionFldKey, (Object)conditionJson, row);
                this.getModel().setValue(descFldKey, (Object)condition.getExprDesc(), row);
            }
        }
    }

    private void receiveFilterCondition(String conditionJson, String entryEntityKey, String conditionFldKey, String descFldKey) {
        if (StringUtils.isNotBlank((CharSequence)conditionJson)) {
            CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)conditionJson, CRCondition.class);
            if (StringUtils.isBlank((CharSequence)entryEntityKey)) {
                this.getModel().setValue(conditionFldKey, (Object)conditionJson);
                this.getModel().setValue(descFldKey, (Object)condition.getExprDesc());
            } else {
                int row = this.getModel().getEntryCurrentRowIndex(entryEntityKey);
                this.getModel().setValue(conditionFldKey, (Object)conditionJson, row);
                this.getModel().setValue(descFldKey, (Object)condition.getExprTran(), row);
                this.getModel().setValue("ft_id", (Object)condition.getId(), row);
                this.getModel().setValue("advfilterdesc", (Object)condition.getDescription(), row);
            }
        }
    }

    private void convertTypeChanged(int row) {
        String convertType = (String)this.getModel().getValue("fconverttype", row);
        if (StringUtils.isBlank((CharSequence)convertType)) {
            return;
        }
        if (FieldConvertType.SourceField.getValue() == Integer.parseInt(convertType)) {
            this.getModel().setValue("ffieldformula", (Object)"", row);
            this.getModel().setValue("ffieldformuladesc", (Object)"", row);
        } else {
            this.getModel().setValue("fsourcefield", (Object)"", row);
            this.getModel().setValue("fsourcefieldname", (Object)"", row);
            this.getModel().setValue("ffieldformula", (Object)"", row);
            this.getModel().setValue("ffieldformuladesc", (Object)"", row);
        }
    }

    public void groupByChanged(String key, boolean isPopUpTips) {
        if ("g_billcombo".equalsIgnoreCase(key)) {
            String value = (String)this.getModel().getValue(key);
            this.setEnable(String.valueOf(GroupByMode.GroupByField.getValue()).equals(value), "g_billentry", "g_billadd", "g_billdel");
            String confirmTip = ResManager.loadKDString((String)"\u8c03\u6574\u5206\u5355\u7b56\u7565\u5c06\u6e05\u9664\u5206\u5355\u4f9d\u636e\u5b57\u6bb5\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ConvertRuleEdit_100", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
            this.confirmClearEntryData("g_billdel", value, confirmTip, isPopUpTips);
        } else if ("g_entrycombo".equalsIgnoreCase(key)) {
            String value = (String)this.getModel().getValue(key);
            this.setEnable(String.valueOf(GroupByMode.GroupByField.getValue()).equals(value), "g_entry", "g_entryadd", "g_entrydel");
            String confirmTip = ResManager.loadKDString((String)"\u8c03\u6574\u5355\u636e\u4f53\u884c\u5408\u5e76\u7b56\u7565\u5c06\u6e05\u9664\u5206\u5355\u4f9d\u636e\u5b57\u6bb5\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ConvertRuleEdit_101", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
            this.confirmClearEntryData("g_entrydel", value, confirmTip, isPopUpTips);
        } else if ("g_subentrycombo".equalsIgnoreCase(key)) {
            String value = (String)this.getModel().getValue(key);
            this.setEnable(String.valueOf(GroupByMode.GroupByField.getValue()).equals(value), "g_subentry", "g_subentryadd", "g_subentrydel");
            String confirmTip = ResManager.loadKDString((String)"\u8c03\u6574\u5b50\u5355\u636e\u4f53\u884c\u5408\u5e76\u7b56\u7565\u5c06\u6e05\u9664\u5206\u5355\u4f9d\u636e\u5b57\u6bb5\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ConvertRuleEdit_102", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
            this.confirmClearEntryData("g_subentrydel", value, confirmTip, isPopUpTips);
        }
    }

    private void confirmClearEntryData(String delType, String value, String confirmTip, boolean isPopUpTips) {
        if (!String.valueOf(GroupByMode.GroupByField.getValue()).equals(value) && isPopUpTips) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(delType);
            this.getView().showConfirm(confirmTip, MessageBoxOptions.YesNo, confirmCallBacks);
        }
    }

    public void setEnable(Boolean value, String ... ctlKeys) {
        HashMap<String, Object> enableMap = new HashMap<String, Object>();
        enableMap.put("policy", "");
        enableMap.put("enable", value);
        enableMap.put("keys", ctlKeys);
        ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("setEnable", enableMap);
    }

    public void groupByClick(String sourceFldKey) {
        switch (sourceFldKey) {
            case "g_billadd": 
            case "g_entryadd": 
            case "g_subentryadd": {
                GetRuleHelper getRuleHelper = new GetRuleHelper(this.view, this.plugin, this.extControlDomain);
                HashSet<String> selectEntitys = getRuleHelper.getSourceLinkEntitys();
                BillTreeBuildParameter parameter = new BillTreeBuildParameter(this.plugin.getRuleFormHelper().getSrcMainType());
                parameter.getSelectedEntity().addAll(selectEntitys);
                parameter.setIncludePKField(true);
                parameter.getForbidClassTypes().add(AttachmentProp.class);
                parameter.getForbidClassTypes().add(PictureProp.class);
                parameter.getForbidRefPropFieldTypes().add(MulBasedataProp.class);
                TreeNode srcBillNode = EntityParseHelper.buildBillTreeNodes(parameter);
                String gEntryKey = "";
                if ("g_billadd".equals(sourceFldKey)) {
                    gEntryKey = "g_billentry";
                } else if ("g_entryadd".equals(sourceFldKey)) {
                    gEntryKey = "g_entry";
                } else if ("g_subentryadd".equals(sourceFldKey)) {
                    gEntryKey = "g_subentry";
                }
                this.showSelectFieldForm(srcBillNode, "groupby_" + gEntryKey);
                break;
            }
            case "g_billdel": 
            case "g_entrydel": 
            case "g_subentrydel": {
                String key = this.groupByDelToEntry(sourceFldKey);
                EntryGrid grid = (EntryGrid)this.getView().getControl(key);
                int[] selectRows = grid.getEntryState().getSelectedRows();
                if (selectRows == null || selectRows.length <= 0) break;
                this.getModel().deleteEntryRows(key, selectRows);
                break;
            }
        }
    }

    public String groupByDelToEntry(String delKey) {
        String entryKey = "";
        if ("g_billdel".equalsIgnoreCase(delKey)) {
            entryKey = "g_billentry";
        }
        if ("g_entrydel".equalsIgnoreCase(delKey)) {
            entryKey = "g_entry";
        }
        if ("g_subentrydel".equalsIgnoreCase(delKey)) {
            entryKey = "g_subentry";
        }
        return entryKey;
    }

    public void groupAddRow(String g_entryKey, Object returnData) {
        String entryKey = g_entryKey.substring(8);
        String fieldKey = "";
        String fieldName = "";
        MainEntityType srcMainType = this.plugin.getRuleFormHelper().getSrcMainType();
        if ("g_billentry".equals(entryKey)) {
            fieldKey = "g_billentrykey";
            fieldName = "g_billentryname";
        } else if ("g_entry".equals(entryKey)) {
            fieldKey = "g_entrykey";
            fieldName = "g_entryname";
        } else if ("g_subentry".equals(entryKey)) {
            fieldKey = "g_subentrykey";
            fieldName = "g_subentryname";
        }
        if (!StringUtils.isBlank((Object)returnData)) {
            String fieldCaption = EntityParseHelper.buildPropFullCaption((EntityType)srcMainType, (String)returnData);
            int row = this.getModel().createNewEntryRow(entryKey);
            this.getModel().setValue(fieldKey, returnData, row);
            this.getModel().setValue(fieldName, (Object)fieldCaption, row);
        }
    }

    public void doTestBillTypeMap() {
        if (this.plugin.getRuleFormHelper().getSrcMainType() == null) {
            return;
        }
        String sourceEntityNumber = this.plugin.getRuleFormHelper().getSrcMainType().getName();
        if (this.plugin.getRuleFormHelper().getTgtMainType() == null) {
            return;
        }
        String targetEntityNumber = this.plugin.getRuleFormHelper().getTgtMainType().getName();
        GetRuleHelper helper = new GetRuleHelper(this.getView(), this.plugin, this.extControlDomain);
        ConvertRuleElement rule = new ConvertRuleElement();
        helper.getBillTypeMapPolicy(rule);
        String billTypeMapPolicy = SerializationUtils.toJsonString((Object)rule.getBillTypeMapPolicy());
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_billtypemaptest");
        showParameter.getCustomParams().put("billtypemappolicy", billTypeMapPolicy);
        showParameter.getCustomParams().put("sourceentitynumber", sourceEntityNumber);
        showParameter.getCustomParams().put("targetentitynumber", targetEntityNumber);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public static class ComboToJsonSerializer {
        private List<ValueMapItem> items = new ArrayList<ValueMapItem>();

        @CollectionPropertyAttribute(collectionItemPropertyType=ValueMapItem.class)
        public List<ValueMapItem> getItems() {
            return this.items;
        }

        public void setItems(List<ValueMapItem> items) {
            this.items = items;
        }
    }
}

