/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.botp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ILocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.metadata.DesignMeta;
import kd.bos.metadata.botp.ConvertRuleMetadata;
import kd.bos.metadata.botp.ConvertRuleTemplate;
import kd.bos.metadata.botp.DesignConvertRuleMeta;
import kd.bos.metadata.botp.common.RuleIsvHelper;
import kd.bos.metadata.dao.MetadataSerializer;
import kd.bos.metadata.lang.LangWriter;

class RuleTreeNode {
    private static final String BOS_DESIGNER_PLUGIN = "bos-botp-formplugin";
    private String id;
    private String name;
    private String parentId;
    private String devType;
    private String designJson;
    private boolean defRule;
    private boolean enabled;
    private boolean canModify;
    private boolean newed;
    private boolean changed;
    private boolean deleted;
    private List<Map<String, Map<String, Object>>> localeItems = new ArrayList<Map<String, Map<String, Object>>>();
    private Set<String> localeIds = new HashSet<String>();
    private Map<String, RuleTreeNode> children;

    @Deprecated
    public RuleTreeNode() {
    }

    public RuleTreeNode(String id, String name, String parentId, String devType, String designJson) {
        this.id = id;
        this.name = name;
        this.parentId = parentId;
        this.devType = devType;
        this.designJson = designJson;
        this.newed = false;
        this.changed = false;
        this.deleted = false;
        this.children = new HashMap<String, RuleTreeNode>();
    }

    public List<Map<String, Map<String, Object>>> getLocaleItems() {
        return this.localeItems;
    }

    public void setLocaleItems(List<Map<String, Map<String, Object>>> localeItems) {
        this.localeItems = localeItems;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public String getDevType() {
        return this.devType;
    }

    public void setDevType(String devType) {
        this.devType = devType;
    }

    public String getDesignJson() {
        return this.designJson;
    }

    public void setDesignJson(String xml) {
        this.designJson = xml;
    }

    public Map<String, RuleTreeNode> getChildren() {
        return this.children;
    }

    public boolean isDefRule() {
        return this.defRule;
    }

    public void setDefRule(boolean defRule) {
        this.defRule = defRule;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Set<String> getLocaleIds() {
        return this.localeIds;
    }

    public void setLocaleIds(Set<String> localeIds) {
        this.localeIds = localeIds;
    }

    public boolean isCanModify() {
        return this.canModify;
    }

    public void setCanModify(boolean canModify) {
        this.canModify = canModify;
    }

    public boolean isNewed() {
        return this.newed;
    }

    public void setNewed(boolean newed) {
        this.newed = newed;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public static RuleTreeNode BuildRuleTree(List<ConvertRuleMetadata> ruleMetadatas) {
        RuleTreeNode rootNode = new RuleTreeNode("0", ResManager.loadKDString((String)"\u5168\u90e8\u89c4\u5219", (String)"ConvertRuleEdit_48", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), "", "0", "");
        String currentIsv = RuleIsvHelper.getUserIsv();
        HashMap<String, ConvertRuleMetadata> ruleMap = new HashMap<String, ConvertRuleMetadata>(16);
        for (ConvertRuleMetadata ruleMetadata : ruleMetadatas) {
            ruleMap.put(ruleMetadata.getId(), ruleMetadata);
        }
        HashMap<String, RuleTreeNode> nodes = new HashMap<String, RuleTreeNode>(16);
        for (ConvertRuleMetadata ruleMetadata : ruleMetadatas) {
            ConvertRuleMetadata parentRuleMeta = null;
            if (StringUtils.isNotBlank((CharSequence)ruleMetadata.getParentId())) {
                parentRuleMeta = (ConvertRuleMetadata)ruleMap.get(ruleMetadata.getParentId());
            }
            RuleTreeNode node = RuleTreeNode.buildRuleNode(parentRuleMeta, ruleMetadata, currentIsv);
            nodes.put(ruleMetadata.getId(), node);
        }
        for (RuleTreeNode node : nodes.values()) {
            if (StringUtils.isBlank((CharSequence)node.getParentId())) {
                rootNode.children.put(node.getId(), node);
                continue;
            }
            RuleTreeNode parentNode = (RuleTreeNode)nodes.get(node.getParentId());
            if (parentNode == null) continue;
            parentNode.getChildren().put(node.getId(), node);
        }
        return rootNode;
    }

    public static RuleTreeNode buildRuleNode(ConvertRuleMetadata parentRuleMeta, ConvertRuleMetadata ruleMetadata, String currentIsv) {
        ConvertRuleTemplate template = new ConvertRuleTemplate();
        boolean isKingdee = RuleIsvHelper.isKindeeIsv();
        if (isKingdee && StringUtils.isBlank((CharSequence)ruleMetadata.getIsv())) {
            ruleMetadata.setIsv(currentIsv);
        }
        String xml = template.buildDiffXml(ruleMetadata, parentRuleMeta, false);
        DesignConvertRuleMeta designMeta = (DesignConvertRuleMeta)ruleMetadata.convertToDesignMeta(xml);
        String designJson = SerializationUtils.toJsonString((Object)designMeta);
        RuleTreeNode node = new RuleTreeNode(ruleMetadata.getId(), ruleMetadata.getName().toString(), ruleMetadata.getParentId(), ruleMetadata.getDevType(), designJson);
        node.setDefRule(ruleMetadata.getRuleElement().isDefRule());
        node.setEnabled(ruleMetadata.getRuleElement().isEnabled());
        List localeItems = ruleMetadata.getLocaleItems();
        HashSet<String> localeIds = new HashSet<String>(10);
        ArrayList<Map<String, Map<String, Object>>> list = new ArrayList<Map<String, Map<String, Object>>>(10);
        for (Map localeMap : localeItems) {
            HashMap v = new HashMap(16);
            for (Map.Entry data : localeMap.entrySet()) {
                localeIds.addAll(((ILocaleValue)data.getValue()).keySet());
                Map map = (Map)data.getValue();
                v.put(data.getKey(), map);
            }
            list.add(v);
        }
        node.setLocaleItems(list);
        node.setLocaleIds(localeIds);
        node.setCanModify(StringUtils.equals((CharSequence)ruleMetadata.getIsv(), (CharSequence)currentIsv));
        return node;
    }

    public TreeNode buildTreeNodes() {
        TreeNode currNode = new TreeNode();
        currNode.setId(this.id);
        currNode.setText(this.buildTreeNodeName());
        currNode.setIsOpened(true);
        currNode.setChildren(new ArrayList());
        for (RuleTreeNode child : this.children.values()) {
            TreeNode childNode = child.buildTreeNodes();
            currNode.addChild(childNode);
        }
        return currNode;
    }

    public TreeNode buildTreeNode() {
        TreeNode currNode = new TreeNode();
        currNode.setId(this.id);
        currNode.setText(this.buildTreeNodeName());
        currNode.setParentid(this.getParentId());
        currNode.setChildren(new ArrayList());
        currNode.setIsOpened(true);
        return currNode;
    }

    public ConvertRuleMetadata deserialize(RuleTreeNode rootNode) {
        RuleTreeNode parentRuleNode;
        if (StringUtils.isBlank((CharSequence)this.designJson)) {
            return null;
        }
        DesignConvertRuleMeta designMeta = (DesignConvertRuleMeta)SerializationUtils.fromJsonString((String)this.designJson, DesignConvertRuleMeta.class);
        String xml = designMeta.getDataXml();
        ConvertRuleMetadata parentRuleMeta = null;
        if (StringUtils.isNotBlank((CharSequence)this.getParentId()) && (parentRuleNode = rootNode.searchRule(this.getParentId())) != null) {
            parentRuleMeta = parentRuleNode.deserialize(rootNode);
        }
        ConvertRuleTemplate template = new ConvertRuleTemplate();
        ConvertRuleMetadata ruleMetadata = template.getMetadata(xml, parentRuleMeta);
        String modelType = ruleMetadata.getModelType();
        MetadataSerializer serializer = new MetadataSerializer(modelType);
        String curLocaleId = RequestContext.get().getLang().name();
        List<Map<String, Map<String, Object>>> localeItems = this.localeItems;
        Set<String> localIds = this.localeIds;
        LangWriter writer = new LangWriter(serializer.getBinder(), (Object)ruleMetadata, localeItems);
        localIds.remove(null);
        localIds.remove(curLocaleId);
        writer.setLoaceValue(new ArrayList<String>(localIds));
        ruleMetadata.convertFromDesignMeta((DesignMeta)designMeta);
        ruleMetadata.getRuleElement().setDefRule(this.defRule);
        return ruleMetadata;
    }

    public List<RuleTreeNode> mergeAllChildren() {
        ArrayList<RuleTreeNode> allList = new ArrayList<RuleTreeNode>();
        for (RuleTreeNode rule : this.children.values()) {
            allList.add(rule);
            allList.addAll(rule.mergeAllChildren());
        }
        return allList;
    }

    public RuleTreeNode searchRule(String ruleId) {
        if (this.id.equalsIgnoreCase(ruleId)) {
            return this;
        }
        List<RuleTreeNode> allChildren = this.mergeAllChildren();
        for (RuleTreeNode rule : allChildren) {
            if (!rule.getId().equals(ruleId)) continue;
            return rule;
        }
        return null;
    }

    private String buildTreeNodeName() {
        String status = "";
        status = this.isEnabled() ? ResManager.loadKDString((String)"\u5df2\u542f\u7528", (String)"ConvertRuleEdit_49", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5df2\u505c\u7528", (String)"ConvertRuleEdit_50", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
        String dev = "";
        dev = StringUtils.equals((CharSequence)this.getDevType(), (CharSequence)"2") ? ResManager.loadKDString((String)"\u6269\u5c55", (String)"ConvertRuleEdit_55", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]) : (StringUtils.equals((CharSequence)this.getDevType(), (CharSequence)"1") ? ResManager.loadKDString((String)"\u7ee7\u627f", (String)"ConvertRuleEdit_56", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u539f\u59cb", (String)"ConvertRuleEdit_57", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        return String.format("%s(%s,%s)", this.getName(), dev, status);
    }
}

