/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.botp;

import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.CRFormula;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.validate.BillStatus;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;

final class SelectBasedataValue {
    private static Log logger = LogFactory.getLog(SelectBasedataValue.class);

    SelectBasedataValue() {
    }

    public static SelectBasedataValue get() {
        return new SelectBasedataValue();
    }

    protected void showF7List(BasedataProp bdProp, IFormView view, CloseCallBack closeCallBack) {
        Objects.requireNonNull(bdProp);
        if (bdProp.getBaseEntityId() == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u591a\u7c7b\u522b\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u3002", (String)"SelectBasedataValue_0", (String)"bos-botp-formplugin", (Object[])new Object[0]));
            return;
        }
        if (FormMetadataCache.getListFormConfig((String)bdProp.getBaseEntityId()) == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u57fa\u7840\u8d44\u6599\u672a\u8bbe\u8ba1F7\u5217\u8868\u3002", (String)"SelectBasedataValue_1", (String)"bos-botp-formplugin", (Object[])new Object[0]));
            return;
        }
        this.showF7List(bdProp.getBaseEntityId(), view, closeCallBack);
    }

    protected void showF7List(String bdEntityNumber, IFormView view, CloseCallBack closeCallBack) {
        BasedataEntityType bdType = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)bdEntityNumber);
        this.showF7List(bdType, view, closeCallBack);
    }

    protected void showF7List(BasedataEntityType bdType, IFormView view, CloseCallBack closeCallBack) {
        ListShowParameter para = null;
        para = ShowFormHelper.createShowListForm((String)bdType.getName(), (boolean)false);
        if (para == null) {
            return;
        }
        para.setCloseCallBack(closeCallBack);
        QFilter filter = null;
        if (StringUtils.isNotBlank((CharSequence)bdType.getBillStatus())) {
            filter = new QFilter(bdType.getBillStatus(), "=", (Object)BillStatus.C);
        }
        if (bdType.getProperties().containsKey((Object)"enable")) {
            QFilter forbidFilter = new QFilter("enable", "=", (Object)"1");
            if (filter == null) {
                filter = forbidFilter;
            } else {
                filter.and(forbidFilter);
            }
        }
        if (filter != null) {
            para.getListFilterParameter().getQFilters().add(filter);
        }
        this.trySetSelectRow(view, para);
        this.trySetInitOrgFuncId(view, para);
        view.showForm((FormShowParameter)para);
    }

    private void trySetInitOrgFuncId(IFormView view, ListShowParameter para) {
        try {
            Object initOrgFuncId = view.getFormShowParameter().getCustomParams().get("initOrgFuncId");
            if (StringUtils.isBlank(initOrgFuncId)) {
                return;
            }
            para.setCustomParam("initOrgFuncId", initOrgFuncId);
        }
        catch (Exception e) {
            logger.warn("trySetInitOrgFuncId eror is " + e);
        }
    }

    private void trySetSelectRow(IFormView view, ListShowParameter para) {
        try {
            Object formula = view.getFormShowParameter().getCustomParams().get("CONSTANT_CRFORMULA_JSON");
            if (StringUtils.isBlank(formula)) {
                return;
            }
            CRFormula crFormula = (CRFormula)SerializationUtils.fromJsonString((String)String.valueOf(formula), CRFormula.class);
            if (StringUtils.isNotBlank((CharSequence)crFormula.getExpression())) {
                para.setSelectedRow((Object)crFormula.getExpression());
            }
        }
        catch (Exception e) {
            logger.warn("trySetSelectRow eror is " + e);
        }
    }
}

