/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.botp;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.BillTreeBuildParameter;
import kd.bos.designer.botp.EntityParseHelper;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.UnitConvertDTO;
import kd.bos.entity.botp.CRBizRuleElement;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.RefProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.rule.IBizRuleEditor;
import kd.bos.metadata.form.rule.FormRuleActionType;
import kd.bos.metadata.form.rule.FormRuleActionTypeCache;
import kd.bos.util.CollectionUtils;

public class UpdateDataServiceEdit
extends AbstractFormPlugin {
    private static final String BOS_BOTP_FORMPLUGIN = "bos-botp-formplugin";
    public static final String FormId_UpdateDataService = "botp_updatedataservice";
    public static final String CustParam_CRBizRuleElement = "crbizruleelement";
    public static final String CustParam_HidePreCondition = "hideprecondition";
    public static final String CustParam_TargetEntityNumber = "targetentitynumber";
    private static final String KEY_ACTIONID = "actionid";
    private static final String KEY_PRECONDITION = "precondition";
    private static final String KEY_PRECONDITION_DESC = "preconditiondesc";
    private static final String KEY_DESCRIPTION = "description";
    private static final String KEY_SERVIC_EEDIT_PANEL = "formrulepanel";
    private static final String KEY_BTN_OK = "btnok";
    private static final String KEY_BTN_CANCEL = "btncancel";
    private static final String CACHEKEY_SERVICE_PAGEID = "servicepageid";
    private static final String CACHEKEY_FIELD_NODES = "fieldnodes";
    private static final String ACTIONID_PLEASE_SELECTONE = "@none";
    private static final String ACTIONID_FILLQTYACTION = "FillQtyAction";
    private static Log log = LogFactory.getLog(UpdateDataServiceEdit.class);

    public void initialize() {
        this.addClickListeners(new String[]{KEY_BTN_OK, KEY_BTN_CANCEL});
        this.addClickListeners(new String[]{KEY_PRECONDITION_DESC});
    }

    public void afterCreateNewData(EventObject e) {
        CRBizRuleElement bizRule = this.getInputBizRule();
        this.setBizRule(bizRule);
    }

    public void afterBindData(EventObject e) {
        boolean hide;
        super.afterBindData(e);
        this.fillActionTypeCombo();
        String hidePreCondition = (String)this.getView().getFormShowParameter().getCustomParam(CustParam_HidePreCondition);
        if (StringUtils.isNotBlank((CharSequence)hidePreCondition) && (hide = Boolean.parseBoolean(hidePreCondition))) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_PRECONDITION_DESC});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String oldValue = (String)e.getChangeSet()[0].getOldValue();
        String newValue = (String)e.getChangeSet()[0].getNewValue();
        if (e.getProperty().getName().equalsIgnoreCase(KEY_ACTIONID)) {
            FormRuleActionType actionType = this.getActionType(newValue);
            if (actionType == null) {
                this.closeServiceEditForm();
            } else {
                this.getModel().setValue(KEY_DESCRIPTION, (Object)actionType.getDesc());
                this.showServiceEditForm(actionType.getFormid(), newValue, oldValue, null);
            }
        } else if (StringUtils.equals((CharSequence)e.getProperty().getName(), (CharSequence)KEY_PRECONDITION_DESC) && StringUtils.isBlank((CharSequence)newValue)) {
            this.getModel().setValue(KEY_PRECONDITION, null);
        }
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        if (KEY_BTN_OK.equalsIgnoreCase(source.getKey())) {
            this.closeAndreturnData();
        } else if (KEY_BTN_CANCEL.equalsIgnoreCase(source.getKey())) {
            this.getView().close();
        } else if (source.getKey().equalsIgnoreCase(KEY_PRECONDITION_DESC)) {
            this.showPreConditionForm();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getActionId().equalsIgnoreCase(KEY_PRECONDITION_DESC)) {
            this.receivePreCondition(closedCallBackEvent);
        }
    }

    private void closeAndreturnData() {
        CRBizRuleElement bizRule = this.getOutputBizRule();
        String json = SerializationUtils.toJsonString((Object)bizRule);
        this.getView().returnDataToParent((Object)json);
        this.getView().close();
    }

    private CRBizRuleElement getInputBizRule() {
        String json = (String)this.getView().getFormShowParameter().getCustomParam(CustParam_CRBizRuleElement);
        if (StringUtils.isBlank((CharSequence)json)) {
            return new CRBizRuleElement();
        }
        CRBizRuleElement bizRule = (CRBizRuleElement)SerializationUtils.fromJsonString((String)json, CRBizRuleElement.class);
        return bizRule;
    }

    private CRBizRuleElement getOutputBizRule() {
        String pageId;
        CRBizRuleElement bizRule = this.getInputBizRule();
        String desc = (String)this.getModel().getValue(KEY_DESCRIPTION);
        bizRule.getDescription().setItem(Lang.defaultLang().toString(), (Object)desc);
        String preCondJson = (String)this.getModel().getValue(KEY_PRECONDITION);
        if (StringUtils.isNotBlank((CharSequence)preCondJson)) {
            CRCondition preCondition = (CRCondition)SerializationUtils.fromJsonString((String)preCondJson, CRCondition.class);
            bizRule.setPreCondition(preCondition);
        } else {
            bizRule.setPreCondition(null);
        }
        String actionId = (String)this.getModel().getValue(KEY_ACTIONID);
        if (!ACTIONID_PLEASE_SELECTONE.equals(actionId)) {
            bizRule.setActionId(actionId);
            FormRuleActionType actionType = this.getActionType(actionId);
            if (actionType != null) {
                bizRule.setRunActionClass(actionType.getConvertServiceClass());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(pageId = this.getPageCache().get(CACHEKEY_SERVICE_PAGEID)))) {
            IFormView serviceView = this.getView().getView(pageId);
            FormViewPluginProxy pluginProxy = (FormViewPluginProxy)serviceView.getService(FormViewPluginProxy.class);
            IBizRuleEditor bizRuleEditor = null;
            for (IFormPlugin plugin : pluginProxy.getPlugIns()) {
                if (!(plugin instanceof IBizRuleEditor)) continue;
                bizRuleEditor = (IBizRuleEditor)plugin;
            }
            if (bizRuleEditor != null) {
                String serviceConfig = bizRuleEditor.getOutConfig();
                this.validateServiceConfig(actionId, serviceConfig);
                bizRule.setParameters(serviceConfig);
            }
        }
        return bizRule;
    }

    private void validateServiceConfig(String actionId, String serviceConfig) {
        if (ACTIONID_FILLQTYACTION.equals(actionId)) {
            this.validateFillQtyActionConfig(serviceConfig);
        }
    }

    private void validateFillQtyActionConfig(String serviceConfig) {
        JSONObject configMap = JSON.parseObject((String)serviceConfig);
        String configListJson = (String)configMap.get("Expression");
        if (StringUtils.isBlank((CharSequence)configListJson)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5bf9\u5e94\u6570\u91cf\u5b57\u6bb5\u3002", (String)"UpdateDataServiceEdit_1", (String)BOS_BOTP_FORMPLUGIN, (Object[])new Object[0]));
        }
        List unitConvertDTOs = JSON.parseArray((String)configListJson, UnitConvertDTO.class);
        if (unitConvertDTOs.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5bf9\u5e94\u6570\u91cf\u5b57\u6bb5\u3002", (String)"UpdateDataServiceEdit_1", (String)BOS_BOTP_FORMPLUGIN, (Object[])new Object[0]));
        }
        for (UnitConvertDTO unitConvertDto : unitConvertDTOs) {
            if (!StringUtils.isBlank((CharSequence)unitConvertDto.getSrcQtyField()) && !StringUtils.isBlank((CharSequence)unitConvertDto.getDistQtyField())) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u5bf9\u5e94\u6570\u91cf\u5b57\u6bb5\u914d\u7f6e\u4e0d\u6b63\u786e\u3002", (String)"UpdateDataServiceEdit_2", (String)BOS_BOTP_FORMPLUGIN, (Object[])new Object[0]));
        }
    }

    private void setBizRule(CRBizRuleElement bizRule) {
        String actionId;
        this.getModel().setValue(KEY_DESCRIPTION, (Object)bizRule.getDescription().toString());
        String preCondJson = "";
        if (bizRule.getPreCondition() != null) {
            preCondJson = SerializationUtils.toJsonString((Object)bizRule.getPreCondition());
            this.getModel().setValue(KEY_PRECONDITION, (Object)preCondJson);
            this.getModel().setValue(KEY_PRECONDITION_DESC, (Object)bizRule.getPreCondition().getExprDesc());
        }
        if (StringUtils.isBlank((CharSequence)(actionId = bizRule.getActionId()))) {
            actionId = ACTIONID_PLEASE_SELECTONE;
        }
        this.getModel().setValue(KEY_ACTIONID, (Object)actionId);
        FormRuleActionType actionType = this.getActionType(actionId);
        if (actionType != null) {
            this.showServiceEditForm(actionType.getFormid(), actionId, "", bizRule.getParameters());
        }
    }

    private void showServiceEditForm(String formId, String serviceTypeId, String oldserviceTypeId, String expression) {
        this.closeServiceEditForm();
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.getOpenStyle().setTargetKey(KEY_SERVIC_EEDIT_PANEL);
        formShowParameter.setFormId(formId);
        formShowParameter.setParentFormId(this.getView().getFormShowParameter().getParentFormId());
        formShowParameter.getCustomParams().put("serviceTypeId", serviceTypeId);
        formShowParameter.getCustomParams().put("value", expression);
        formShowParameter.getCustomParams().put("InContainer", ShowType.InContainer);
        formShowParameter.setCustomParam("context", this.buildDesignContext());
        formShowParameter.setCustomParam("metaType", (Object)"entitymeta");
        this.getView().showForm(formShowParameter);
        this.getPageCache().put(CACHEKEY_SERVICE_PAGEID, formShowParameter.getPageId());
    }

    private void closeServiceEditForm() {
        IFormView serviceView;
        String pageId = this.getPageCache().get(CACHEKEY_SERVICE_PAGEID);
        if (pageId != null && (serviceView = this.getView().getView(pageId)) != null) {
            serviceView.close();
            this.getView().sendFormAction(serviceView);
        }
        this.getPageCache().remove(CACHEKEY_SERVICE_PAGEID);
    }

    private void showPreConditionForm() {
        String conditionJson = (String)this.getModel().getValue(KEY_PRECONDITION);
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam(CustParam_TargetEntityNumber);
        String fieldNodes = this.getPageCache().get(CACHEKEY_FIELD_NODES);
        if (StringUtils.isBlank((CharSequence)fieldNodes)) {
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            BillTreeBuildParameter parameter = new BillTreeBuildParameter(mainType);
            parameter.setOnlyPhysicsField(false);
            parameter.getForbidRefPropFieldTypes().add(MulBasedataProp.class);
            TreeNode rootNode = EntityParseHelper.buildBillTreeNodes(parameter);
            fieldNodes = SerializationUtils.toJsonString((Object)rootNode);
            this.getPageCache().put(CACHEKEY_FIELD_NODES, fieldNodes);
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_condition");
        showParameter.getCustomParams().put("formula", conditionJson);
        showParameter.getCustomParams().put("entitynumber", entityNumber);
        showParameter.getCustomParams().put("treenodes", fieldNodes);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_PRECONDITION_DESC));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void receivePreCondition(ClosedCallBackEvent e) {
        String preCondJson;
        if (e.getReturnData() != null && StringUtils.isNotBlank((CharSequence)(preCondJson = (String)e.getReturnData()))) {
            CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)preCondJson, CRCondition.class);
            this.getModel().setValue(KEY_PRECONDITION, (Object)preCondJson);
            this.getModel().setValue(KEY_PRECONDITION_DESC, (Object)condition.getExprDesc());
        }
    }

    private FormRuleActionType getActionType(String actionId) {
        return FormRuleActionTypeCache.geFormRuleActionType((String)actionId);
    }

    private void fillActionTypeCombo() {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(10);
        ComboItem blankItem = new ComboItem();
        blankItem.setValue(ACTIONID_PLEASE_SELECTONE);
        blankItem.setCaption(new LocaleString(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u670d\u52a1\u7c7b\u578b", (String)"UpdateDataServiceEdit_0", (String)BOS_BOTP_FORMPLUGIN, (Object[])new Object[0])));
        comboItems.add(blankItem);
        List formRuleActionTypes = FormRuleActionTypeCache.getAllFormRuleActionTypes();
        for (FormRuleActionType actionType : formRuleActionTypes) {
            if (StringUtils.isBlank((CharSequence)actionType.getConvertServiceClass())) continue;
            ComboItem comboItem = new ComboItem();
            comboItem.setValue(actionType.getId());
            comboItem.setCaption(new LocaleString(Lang.get().toString(), actionType.getDesc()));
            comboItems.add(comboItem);
        }
        ComboEdit comboField = (ComboEdit)this.getView().getControl(KEY_ACTIONID);
        comboField.setComboItems(comboItems);
    }

    private List<Map<String, Object>> buildDesignContext() {
        ArrayList<Map<String, Object>> metaItems = new ArrayList<Map<String, Object>>(10);
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam(CustParam_TargetEntityNumber);
        String entityId = MetadataDao.getIdByNumber((String)entityNumber, (MetaCategory)MetaCategory.Entity);
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        BillTreeBuildParameter billTreeBuildParameter = new BillTreeBuildParameter(mainType);
        for (EntityItem item : entityMetadata.getItems()) {
            IDataEntityProperty prop = mainType.findProperty(item.getKey());
            if (prop != null && billTreeBuildParameter.isFormDisVisitField(prop)) continue;
            HashMap<String, String> entityItem = new HashMap<String, String>();
            entityItem.put("_Type_", item.getClass().getSimpleName());
            entityItem.put("Id", item.getId());
            entityItem.put("ParentId", item.getParentId());
            entityItem.put("Key", item.getKey());
            entityItem.put("Name", item.getName().toString());
            try {
                if (item instanceof BasedataField) {
                    entityItem.put("BaseEntityId", ((BasedataField)item).getBaseEntityId());
                    List refProps = ((BasedataField)item).getRefProps();
                    if (CollectionUtils.isNotEmpty((Collection)refProps)) {
                        ArrayList list = new ArrayList(refProps.size());
                        for (RefProp refProp : refProps) {
                            if (refProp == null) continue;
                            LinkedHashMap<String, String> hashMap = new LinkedHashMap<String, String>(2);
                            hashMap.put("_Type", "RefProp");
                            hashMap.put("Name", refProp.getName());
                            list.add(hashMap);
                        }
                        entityItem.put("RefProps", (String)JSONArray.parseArray((String)JSON.toJSONString(list)));
                    }
                }
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
            metaItems.add(entityItem);
        }
        return metaItems;
    }
}

