/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.botp.command;

import kd.bos.designer.botp.command.AbstractCommand;
import kd.bos.designer.botp.command.BotpCommand;
import kd.bos.designer.botp.command.HelpCommand;
import kd.bos.designer.botp.command.NotFoundCommand;
import kd.bos.designer.botp.command.ShowCommand;
import kd.bos.designer.botp.command.SqlCommand;
import kd.bos.designer.botp.command.WriteruleCommand;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;

public class BotpCommandFactory {
    private IDataModel dataModel;
    private IFormView formView;

    public BotpCommandFactory(IDataModel dataModel, IFormView formView) {
        this.dataModel = dataModel;
        this.formView = formView;
    }

    public BotpCommand newInstance(String command) {
        AbstractCommand botpCommand;
        switch (command) {
            case "show": {
                botpCommand = new ShowCommand(this.dataModel, this.formView);
                break;
            }
            case "help": {
                botpCommand = new HelpCommand(this.dataModel, this.formView);
                break;
            }
            case "writerule": {
                botpCommand = new WriteruleCommand(this.dataModel, this.formView);
                break;
            }
            case "sql": {
                botpCommand = new SqlCommand(this.dataModel, this.formView);
                break;
            }
            default: {
                botpCommand = new NotFoundCommand(this.dataModel, this.formView);
            }
        }
        return botpCommand;
    }
}

