/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.botp.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.designer.botp.command.AbstractCommand;
import kd.bos.designer.botp.command.CommandPageUtil;
import kd.bos.entity.botp.ExcessCheckType;
import kd.bos.entity.botp.WriteBackBizRule;
import kd.bos.entity.botp.WriteBackFormula;
import kd.bos.entity.botp.WriteBackRuleElement;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.metadata.botp.WriteBackRuleMetadata;
import kd.bos.metadata.botp.WriteBackRuleReader;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.WriteBackMetaServiceHelper;

public class WriteruleCommand
extends AbstractCommand {
    private WriteBackRuleReader writeBackRuleReader = new WriteBackRuleReader();

    public WriteruleCommand(IDataModel dataModel, IFormView formView) {
        super(dataModel, formView);
    }

    @Override
    public void command(String[] params) {
        boolean version = this.analyseParamForVersion(params);
        if (version) {
            this.commandRuleVersion(params);
            return;
        }
        QFilter[] qFilter = new QFilter[]{new QFilter("sourceentitynumber", "=", (Object)this.getSourceEntityNumber()), new QFilter("targetentitynumber", "=", (Object)this.getTargetEntityNumber())};
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"botp_writebackrule", (String)"id", (QFilter[])qFilter);
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return;
        }
        List ids = Arrays.stream(dynamicObjects).map(dynamicObject -> dynamicObject.get("id").toString()).collect(Collectors.toList());
        List ruleMetadatas = this.writeBackRuleReader.loadMetas(ids, true, true);
        boolean isDescription = this.analyseParamForDescription(params);
        Optional<String> optional = this.analyseParamForId(params);
        for (WriteBackRuleMetadata ruleMetadata : ruleMetadatas) {
            if (optional.isPresent() && !optional.get().equals(ruleMetadata.getId())) continue;
            this.showWriteBackRuleMessage(isDescription, ruleMetadata.getRuleElement());
        }
    }

    private void showWriteBackRuleMessage(boolean isDescription, WriteBackRuleElement ruleElement) {
        String status = "1".equals(ruleElement.getCustStatus()) ? ResManager.loadKDString((String)"\u542f\u7528", (String)"WriteruleCommand_0", (String)"bos-botp-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7981\u7528", (String)"WriteruleCommand_1", (String)"bos-botp-formplugin", (Object[])new Object[0]);
        CommandPageUtil.addCommandResult(this.dataModel, ruleElement.getName() + "<" + status + ">: " + ruleElement.getId());
        if (isDescription) {
            String condition;
            for (WriteBackFormula formula : ruleElement.getFormulas()) {
                condition = formula.getCondition() == null ? ResManager.loadKDString((String)"\u65e0", (String)"WriteruleCommand_3", (String)"bos-botp-formplugin", (Object[])new Object[0]) : formula.getCondition().getExprTran();
                String formulaDesc = formula.getFormula() == null ? ResManager.loadKDString((String)"\u65e0", (String)"WriteruleCommand_3", (String)"bos-botp-formplugin", (Object[])new Object[0]) : formula.getFormula().getExprTran();
                String result = String.format(ResManager.loadKDString((String)"- \u53cd\u5199\u516c\u5f0f  \u6761\u4ef6: %1$s | \u6e90\u5355\u5b57\u6bb5: %2$s | \u76ee\u6807\u516c\u5f0f: %3$s", (String)"WriteruleCommand_2", (String)"bos-botp-formplugin", (Object[])new Object[0]), condition, formula.getSourceCommitFieldKey(), formulaDesc);
                CommandPageUtil.addCommandResult(this.dataModel, result);
            }
            for (WriteBackBizRule bizRule : ruleElement.getBizRules()) {
                condition = bizRule.getPreCondition() == null ? ResManager.loadKDString((String)"\u65e0", (String)"WriteruleCommand_3", (String)"bos-botp-formplugin", (Object[])new Object[0]) : bizRule.getPreCondition().getExprTran();
                String bizRuleTrue = bizRule.getBizRuleTrue() == null ? ResManager.loadKDString((String)"\u65e0", (String)"WriteruleCommand_3", (String)"bos-botp-formplugin", (Object[])new Object[0]) : bizRule.getBizRuleTrue().getDescription().getLocaleValue();
                String bizRuleFalse = bizRule.getBizRuleFalse() == null ? ResManager.loadKDString((String)"\u65e0", (String)"WriteruleCommand_3", (String)"bos-botp-formplugin", (Object[])new Object[0]) : bizRule.getBizRuleFalse().getDescription().getLocaleValue();
                String result = String.format(ResManager.loadKDString((String)"- \u4e1a\u52a1\u89c4\u5219  \u6761\u4ef6: %1$s | \u6761\u4ef6\u4e3a\u771f: %2$s | \u6761\u4ef6\u4e3a\u5047: %3$s", (String)"WriteruleCommand_6", (String)"bos-botp-formplugin", (Object[])new Object[0]), condition, bizRuleTrue, bizRuleFalse);
                CommandPageUtil.addCommandResult(this.dataModel, result);
            }
            String excessCheckDesc = String.format(ResManager.loadKDString((String)"- \u8d85\u989d\u68c0\u67e5 \u68c0\u67e5\u65b9\u5f0f: %1$s | \u63cf\u8ff0: %2$s", (String)"WriteruleCommand_9", (String)"bos-botp-formplugin", (Object[])new Object[0]), ExcessCheckType.desc((ExcessCheckType)ruleElement.getExcessCheckType()), ruleElement.getExcessCheckMessage());
            CommandPageUtil.addCommandResult(this.dataModel, excessCheckDesc);
        }
    }

    private void commandRuleVersion(String ... params) {
        boolean isDescription = this.analyseParamForDescription(params);
        Optional<String> optional = this.analyseParamForId(params);
        if (!optional.isPresent()) {
            return;
        }
        WriteBackRuleMetadata ruleMetadata = this.writeBackRuleReader.loadMeta(optional.get(), true, true);
        WriteBackRuleElement ruleElement = ruleMetadata.getRuleElement();
        List<Long> ruleVars = this.getRuleVars(ruleElement);
        for (Long ruleVar : ruleVars) {
            WriteBackRuleElement ruleElementVer = WriteBackMetaServiceHelper.loadWriteBackRuleVersion((long)ruleVar);
            CommandPageUtil.addCommandResult(this.dataModel, String.format(ResManager.loadKDString((String)"\u53cd\u5199\u89c4\u5219\u5386\u53f2\u7248\u672c: %1$s | oriVersion: %2$s | extVersion: %3$s", (String)"WriteruleCommand_11", (String)"bos-botp-formplugin", (Object[])new Object[0]), ruleVar, ruleElement.getOriVersion(), ruleElement.getExtVersion()));
            this.showWriteBackRuleMessage(isDescription, ruleElementVer);
        }
    }

    private List<Long> getRuleVars(WriteBackRuleElement ruleElement) {
        String ruleId = ruleElement.getId();
        long oriVersion = ruleElement.getOriVersion();
        long extVersion = ruleElement.getExtVersion();
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append("SELECT FVerId ");
        sBuilder.append("FROM T_BOTP_WriteBackRuleVer ");
        sBuilder.append("WHERE FRuleId = ? ");
        Object[] sqlParams = new SqlParameter[]{new SqlParameter(":FRuleId", 12, (Object)ruleId)};
        ArrayList<Long> ids = new ArrayList<Long>();
        ResultSetHandler action = rs -> {
            Long id1 = 0L;
            while (rs.next()) {
                id1 = rs.getLong("FVerId");
                ids.add(id1);
            }
            return id1;
        };
        DB.query((DBRoute)DBRoute.meta, (String)sBuilder.toString(), (Object[])sqlParams, (ResultSetHandler)action);
        return ids;
    }
}

