/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.botp.extcontrol.domain;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.designer.botp.extcontrol.common.PageLockModel;
import kd.bos.designer.botp.extcontrol.domain.ExtControlDomain;
import kd.bos.designer.botp.extcontrol.domain.ExtControlEditDomain;
import kd.bos.designer.botp.extcontrol.model.BuildRuleLockExtControlModel;
import kd.bos.designer.botp.extcontrol.model.FieldMappingLockExtControlModel;
import kd.bos.designer.botp.extcontrol.model.LockExtControlModel;
import kd.bos.designer.botp.extcontrol.model.factory.ExtControlModelFactory;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.botp.common.RuleIsvHelper;
import org.apache.commons.collections4.CollectionUtils;

public class ExtControlLockDomain
extends ExtControlDomain {
    private List<LockExtControlModel> extControlModelListenter;
    private List<FieldMappingLockExtControlModel> fieldMappingLockExtControlModels;
    private List<BuildRuleLockExtControlModel> buildRuleLockExtControlModels;
    private ExtControlEditDomain extControlEditDomain;
    private Supplier<String> getRuleIsvFunc;

    public ExtControlLockDomain(Supplier<String> getRuleIsvFunc, Supplier<Boolean> isRootNodeFunc) {
        this.getRuleIsvFunc = getRuleIsvFunc;
        this.extControlEditDomain = new ExtControlEditDomain(getRuleIsvFunc, isRootNodeFunc);
        this.extControlModelListenter = ExtControlModelFactory.getLockModelListener();
        this.fieldMappingLockExtControlModels = ExtControlModelFactory.getFieldMappingModelListener();
        this.buildRuleLockExtControlModels = ExtControlModelFactory.getBuildRuleLockModelListener();
    }

    private boolean enableLockability() {
        if (RuleIsvHelper.isKindeeIsv()) {
            return false;
        }
        String userIsv = RuleIsvHelper.getUserIsv();
        if (userIsv == null) {
            return true;
        }
        return userIsv.equals(this.getRuleIsvFunc.get());
    }

    void lockControls(IFormView parentView) {
        this.lockControlsForExtBtn(parentView, true);
        if (!this.enableLockability()) {
            return;
        }
        for (LockExtControlModel value : this.extControlModelListenter) {
            value.extendLock(parentView);
        }
    }

    private void lockControlsForExtBtn(IFormView parentView, boolean isLock) {
        if (!RuleIsvHelper.isKindeeIsv()) {
            for (BuildRuleLockExtControlModel buildRuleLockExtControlModel : this.buildRuleLockExtControlModels) {
                PageLockModel pageLocksForBuildRule = buildRuleLockExtControlModel.getPageLocksForBuildRule(parentView);
                parentView.setEnable(Boolean.valueOf(!isLock), pageLocksForBuildRule.getLockFields());
            }
        }
    }

    void releaseControls(IFormView parentView) {
        this.lockControlsForExtBtn(parentView, false);
        if (!this.enableLockability()) {
            return;
        }
        for (LockExtControlModel value : this.extControlModelListenter) {
            value.extendUnlock(parentView);
        }
    }

    public void beforeTreeNodeChange(AbstractFormPlugin plugin, String buttonKey) {
        if (this.checkItemButton(buttonKey)) {
            this.beforeTreeNodeChange(plugin);
        }
    }

    public void afterTreeNodeChange(AbstractFormPlugin plugin, String buttonKey) {
        if (this.checkItemButton(buttonKey)) {
            this.afterTreeNodeChange(plugin);
        }
    }

    private boolean checkItemButton(String buttonKey) {
        return "btnnewrule".equalsIgnoreCase(buttonKey) || "tbncopy".equalsIgnoreCase(buttonKey) || "btnext".equalsIgnoreCase(buttonKey) || "btninherit".equalsIgnoreCase(buttonKey) || "btndelete".equalsIgnoreCase(buttonKey);
    }

    public void beforeTreeNodeChange(AbstractFormPlugin plugin) {
        this.releaseControls(plugin.getView());
        this.extControlEditDomain.closeExtControlEdit(plugin);
    }

    public void afterTreeNodeChange(AbstractFormPlugin plugin) {
        this.lockControls(plugin.getView());
    }

    public boolean stopAndTipsHyperLink(HyperLinkClickEvent e, IFormView parentView) {
        if (!this.enableLockability()) {
            return false;
        }
        List pageLockModels4NoLink = this.extControlModelListenter.stream().map(lockModel -> lockModel.extendNoLink(parentView)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(pageLockModels4NoLink) && e.getSource() instanceof EntryGrid) {
            EntryGrid grid = (EntryGrid)e.getSource();
            for (PageLockModel pageLock : pageLockModels4NoLink) {
                if (!pageLock.getEntryGridNumber().equals(grid.getEntryKey()) || !pageLock.getNoLinkNums().contains(e.getFieldName()) || !pageLock.getLockRows().contains(e.getRowIndex())) continue;
                parentView.showTipNotification(ResManager.loadKDString((String)"\u5df2\u63a7\u5236\u51fa\u5382\u89c4\u5219\u7981\u6b62\u64cd\u4f5c\u3002", (String)"ExtControlLockDomain_0", (String)"bos-botp-formplugin", (Object[])new Object[0]));
                return true;
            }
        }
        return false;
    }

    public boolean stopAndTipsButton(BeforeItemClickEvent evt, IFormView parentView) {
        if (!this.enableLockability()) {
            return false;
        }
        List pageLocks = this.extControlModelListenter.stream().map(lockModel -> lockModel.extendButtonTip(parentView)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        String itemKey = evt.getItemKey();
        for (PageLockModel pageLock : pageLocks) {
            Map<String, Set<Integer>> buttonForLockRows = pageLock.getButtonForLockRows();
            if (!buttonForLockRows.containsKey(itemKey)) continue;
            EntryGrid entryGrid = (EntryGrid)parentView.getControl(pageLock.getEntryGridNumber());
            int[] selectRows = entryGrid.getSelectRows();
            if (selectRows == null || selectRows.length == 0) {
                return false;
            }
            int currentRow = selectRows[0];
            if (!buttonForLockRows.get(itemKey).contains(currentRow)) continue;
            evt.setCancel(true);
            parentView.showTipNotification(ResManager.loadKDString((String)"\u5df2\u63a7\u5236\u51fa\u5382\u89c4\u5219\u7981\u6b62\u64cd\u4f5c\u3002", (String)"ExtControlLockDomain_0", (String)"bos-botp-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    public Set<Integer> getLockRowsFromFieldMapping(IFormView parentView) {
        HashSet<Integer> allLockRows = new HashSet<Integer>();
        if (!this.enableLockability()) {
            return allLockRows;
        }
        for (FieldMappingLockExtControlModel fieldMappingLockExtControlModel : this.fieldMappingLockExtControlModels) {
            PageLockModel pageLocksFromField = fieldMappingLockExtControlModel.getPageLocksFromField(parentView);
            Set<Integer> lockRows = pageLocksFromField.getLockRows();
            allLockRows.addAll(lockRows);
        }
        return allLockRows;
    }
}

