/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.botp.extcontrol.domain;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.designer.botp.extcontrol.common.PageLockModel;
import kd.bos.designer.botp.extcontrol.domain.WBExtControlDomain;
import kd.bos.designer.botp.extcontrol.model.LockExtControlModel;
import kd.bos.designer.botp.extcontrol.model.factory.ExtControlModelFactory;
import kd.bos.entity.botp.extcontrol.ExtControlElement;
import kd.bos.entity.botp.extcontrol.ExtControlParam;
import kd.bos.entity.botp.extcontrol.enums.ExtControlModelEnum;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.metadata.botp.common.RuleIsvHelper;

public class WBExtControlLockDomain
extends WBExtControlDomain {
    private List<LockExtControlModel> extControlModelListenter;
    private Supplier<String> getRuleIsvFunc;

    public WBExtControlLockDomain(Supplier<String> getRuleIsvFunc) {
        this.getRuleIsvFunc = getRuleIsvFunc;
        this.extControlModelListenter = ExtControlModelFactory.getWBLockModelListener();
    }

    private boolean enableLockability() {
        if (RuleIsvHelper.isKindeeIsv()) {
            return false;
        }
        String userIsv = RuleIsvHelper.getUserIsv();
        if (userIsv == null) {
            return true;
        }
        return userIsv.equals(this.getRuleIsvFunc.get());
    }

    public void lockControls(IFormView parentView) {
        if (!this.enableLockability()) {
            return;
        }
        for (LockExtControlModel model : this.extControlModelListenter) {
            model.extendLock(parentView);
        }
    }

    public boolean stopAndTipsButton(BeforeItemClickEvent evt, IFormView parentView) {
        if (!this.enableLockability()) {
            return false;
        }
        List pageLocks = this.extControlModelListenter.stream().map(lockModel -> lockModel.extendButtonTip(parentView)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        String itemKey = evt.getItemKey();
        for (PageLockModel pageLock : pageLocks) {
            Map<String, Set<Integer>> buttonForLockRows = pageLock.getButtonForLockRows();
            if (!buttonForLockRows.containsKey(itemKey)) continue;
            EntryGrid entryGrid = (EntryGrid)parentView.getControl(pageLock.getEntryGridNumber());
            int[] selectRows = entryGrid.getSelectRows();
            if (selectRows == null || selectRows.length == 0) {
                return false;
            }
            int currentRow = selectRows[0];
            if (!buttonForLockRows.get(itemKey).contains(currentRow)) continue;
            evt.setCancel(true);
            parentView.showTipNotification(ResManager.loadKDString((String)"\u5df2\u63a7\u5236\u51fa\u5382\u89c4\u5219\u7981\u6b62\u64cd\u4f5c\u3002", (String)"ExtControlLockDomain_0", (String)"bos-botp-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    public boolean stopAndTipsButtonForExtBtn(BeforeItemClickEvent evt, IFormView parentView, List<ExtControlElement> elements) {
        if (RuleIsvHelper.isKindeeIsv()) {
            return false;
        }
        Optional<ExtControlElement> extControlElement = elements.stream().filter(element -> element.getModelType() == ExtControlModelEnum.BASE_INFO_WB.getType()).filter(element -> element.getType() == 1).findFirst();
        if (!extControlElement.isPresent()) {
            return false;
        }
        HashSet<String> keys = new HashSet<String>();
        for (ExtControlParam.Param param : extControlElement.get().getExtControlParam().getParams()) {
            if (!param.isEnable()) continue;
            keys.add(param.getKey());
        }
        String itemKey = evt.getItemKey();
        if (keys.contains(itemKey)) {
            evt.setCancel(true);
            parentView.showTipNotification(ResManager.loadKDString((String)"\u5df2\u63a7\u5236\u51fa\u5382\u89c4\u5219\u7981\u6b62\u64cd\u4f5c\u3002", (String)"ExtControlLockDomain_0", (String)"bos-botp-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }
}

