/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.botp.extcontrol.helper;

import java.util.Optional;
import java.util.function.Consumer;
import kd.bos.designer.botp.extcontrol.common.ExtControlConstant;
import kd.bos.entity.botp.extcontrol.ExtControlParam;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.field.FieldEdit;

public class ControlHelper
implements ExtControlConstant {
    private IFormView formView;
    private ExtControlParam extControlParam;

    public ControlHelper(IFormView formView, ExtControlParam extControlParam) {
        this.formView = formView;
        this.extControlParam = extControlParam;
    }

    public static Optional<Control> createControl(IFormView formView, String key) {
        if (key.startsWith("check_global_col")) {
            FieldEdit fieldEdit = new FieldEdit();
            fieldEdit.setKey(key);
            fieldEdit.setView(formView);
            fieldEdit.setModel(formView.getModel());
            return Optional.of(fieldEdit);
        }
        return Optional.empty();
    }

    public void buildGlobalCondition(Container flexPanel) {
        for (ExtControlParam.Param param : this.extControlParam.getParams()) {
            this.buildFieldEdit(flexPanel, "check_global_col", param);
        }
    }

    public void buildMultiSelectContext(Container flexPanel) {
        for (ExtControlParam.Param param : this.extControlParam.getParams()) {
            Container flexMultiSelectRow = new Container();
            flexMultiSelectRow.setKey("flex_multi_select_row" + param.getKey());
            flexMultiSelectRow.setView(this.formView);
            flexPanel.getItems().add(flexMultiSelectRow);
            this.buildChildContainer(flexMultiSelectRow, "flex_table_data", param, container -> this.buildLabel((Container)container, "text_table_data", param));
            this.buildChildContainer(flexMultiSelectRow, "flex_table_data_col_1", param, container -> this.buildFieldEdit((Container)container, "flex_table_data_col_1", param));
            this.buildChildContainer(flexMultiSelectRow, "flex_table_data_col_2", param, container -> this.buildFieldEdit((Container)container, "flex_table_data_col_2", param));
            this.buildChildContainer(flexMultiSelectRow, "flex_table_data_col_3", param, container -> this.buildFieldEdit((Container)container, "flex_table_data_col_3", param));
        }
    }

    private void buildChildContainer(Container flexMultiSelectRow, String key, ExtControlParam.Param param, Consumer<Container> consumer) {
        Container flexTableData = new Container();
        flexTableData.setKey(key + param.getKey());
        flexTableData.setView(this.formView);
        flexMultiSelectRow.getItems().add(flexTableData);
        consumer.accept(flexTableData);
    }

    private void buildLabel(Container container, String key, ExtControlParam.Param param) {
        Label label = new Label();
        label.setKey(key + param.getKey());
        label.setView(this.formView);
        container.getItems().add(label);
    }

    private void buildFieldEdit(Container container, String key, ExtControlParam.Param param) {
        FieldEdit fieldEdit = new FieldEdit();
        fieldEdit.setKey(key + param.getKey());
        fieldEdit.setView(this.formView);
        fieldEdit.setModel(this.formView.getModel());
        container.getItems().add(fieldEdit);
    }
}

