/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.botp.extcontrol.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.designer.botp.extcontrol.common.ExtControlConstant;
import kd.bos.designer.botp.extcontrol.model.ViewExtControlModel;
import kd.bos.designer.botp.extcontrol.model.factory.ExtControlModelFactory;
import kd.bos.entity.botp.extcontrol.ExtControlElement;
import kd.bos.entity.botp.extcontrol.ExtControlParam;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class DataHelper
implements ExtControlConstant {
    private static final String FORMID_CONVERTRULE_EXTCONTROL_XML = "botp_convertrul_extcontrol_xml";
    private Map<String, ViewExtControlModel> extControlModelByTabKey;

    private Map<String, ViewExtControlModel> getExtControlModelByTabKey() {
        if (this.extControlModelByTabKey == null) {
            List<ViewExtControlModel> extControlModelListenter = ExtControlModelFactory.getViewModelListener();
            this.extControlModelByTabKey = extControlModelListenter.stream().collect(Collectors.toMap(ViewExtControlModel::getTabKeyInParentView, view -> view));
        }
        return this.extControlModelByTabKey;
    }

    public List<ExtControlElement> getExtControlElements(IFormView parentView) {
        String json = parentView.getPageCache().get(FORMID_CONVERTRULE_EXTCONTROL_XML);
        if (StringUtils.isBlank((CharSequence)json)) {
            return new ArrayList<ExtControlElement>(0);
        }
        List elements = SerializationUtils.fromJsonStringToList((String)json, ExtControlElement.class);
        return elements;
    }

    public void refreshExtControlElements(IFormView parentView, List<ExtControlElement> elements) {
        parentView.getPageCache().put(FORMID_CONVERTRULE_EXTCONTROL_XML, SerializationUtils.toJsonString(elements));
    }

    public void loadView(AbstractFormPlugin formPlugin, ViewExtControlModel extControlFlexModel) {
        List<ExtControlElement> elements = this.getExtControlElements(formPlugin.getView().getParentView());
        if (CollectionUtils.isEmpty(elements)) {
            return;
        }
        Optional<ExtControlElement> elementForGlobalCondition = elements.stream().filter(extControlElement -> extControlElement.getType() == ExtControlElement.TypeEnum.GLOBAL_CONDITION.getType()).filter(extControlElement -> extControlElement.getModelType() == extControlFlexModel.getModelEnum().getType()).findFirst();
        Optional<ExtControlElement> elementForMultiSelect = elements.stream().filter(extControlElement -> extControlElement.getType() == ExtControlElement.TypeEnum.MULTISELECT_CONDITION.getType()).filter(extControlElement -> extControlElement.getModelType() == extControlFlexModel.getModelEnum().getType()).findFirst();
        elementForGlobalCondition.ifPresent(extControlElement -> {
            List params = extControlElement.getExtControlParam().getParams();
            for (ExtControlParam.Param param : params) {
                formPlugin.getView().getModel().setValue(param.getKey(), (Object)param.isEnable());
            }
        });
        elementForMultiSelect.ifPresent(extControlElement -> {
            DynamicObjectCollection entryEntity = formPlugin.getView().getModel().getEntryEntity("flex_multi_select_entry");
            Map<Object, DynamicObject> entryDataById = entryEntity.stream().collect(Collectors.toMap(data -> data.get("text_table_title_number"), data -> data));
            List params = extControlElement.getExtControlParam().getParams();
            for (ExtControlParam.Param param : params) {
                DynamicObject data2 = entryDataById.get(param.getKey());
                if (data2 == null) continue;
                formPlugin.getView().getModel().setValue("check_table_title_col_1", (Object)param.isEnable(), (Integer)data2.get("seq") - 1);
                formPlugin.getView().getModel().setValue("check_table_title_col_3", (Object)param.isMustInput(), (Integer)data2.get("seq") - 1);
                formPlugin.getView().getModel().setValue("check_table_title_col_4", (Object)param.isNoDelete(), (Integer)data2.get("seq") - 1);
            }
        });
    }

    void doReceiveXML(AbstractFormPlugin parentFormPlugin, String childPageId) {
        IFormView childFormView = parentFormPlugin.getView().getView(childPageId);
        if (childFormView == null) {
            return;
        }
        String tabKey = this.getTabKeyFromPageCache(parentFormPlugin);
        ViewExtControlModel extControlModel = this.getExtControlModelByTabKey().get(tabKey);
        this.appendElement(parentFormPlugin, childFormView, extControlModel);
    }

    private String getTabKeyFromPageCache(AbstractFormPlugin parentFormPlugin) {
        String tabKey = parentFormPlugin.getPageCache().get("tab_select_before");
        if (StringUtils.isBlank((CharSequence)tabKey)) {
            tabKey = "tbpage_base";
        }
        return tabKey;
    }

    private void appendElement(AbstractFormPlugin parentFormPlugin, IFormView childFormView, ViewExtControlModel viewModel) {
        List<ExtControlElement> elements = this.getExtControlElements(parentFormPlugin.getView());
        HashMap<Integer, ExtControlElement> collect = new HashMap<Integer, ExtControlElement>(elements.size());
        for (ExtControlElement element : elements) {
            if (collect.containsKey(element.hashCode())) {
                throw new RuntimeException("botp extcontrol error, DataHelper#appendElement duplicate primary key");
            }
            collect.put(element.hashCode(), element);
        }
        ExtControlElement globalCondition = this.buildMeta4GlobalCondition(childFormView, viewModel);
        ExtControlElement multiSelect = this.buildMeta4MultiSelect(childFormView, viewModel);
        collect.put(globalCondition.hashCode(), globalCondition);
        collect.put(multiSelect.hashCode(), multiSelect);
        if (CollectionUtils.isEmpty((Collection)globalCondition.getExtControlParam().getParams())) {
            collect.remove(globalCondition.hashCode());
        }
        if (CollectionUtils.isEmpty((Collection)multiSelect.getExtControlParam().getParams())) {
            collect.remove(multiSelect.hashCode());
        }
        this.refreshExtControlElements(parentFormPlugin.getView(), new ArrayList<ExtControlElement>(collect.values()));
    }

    private ExtControlElement buildMeta4GlobalCondition(IFormView childFormView, ViewExtControlModel viewModel) {
        DynamicObject dataEntity = childFormView.getModel().getDataEntity(true);
        ExtControlElement extControlElement = ExtControlElement.createNewInstanceByGlobalCondition((int)viewModel.getModelEnum().getType());
        Container container = (Container)childFormView.getControl("flex_global_condition");
        List items = container.getItems();
        for (Control item : items) {
            Boolean ischeck = (Boolean)dataEntity.get(item.getKey());
            if (!ischeck.booleanValue()) continue;
            extControlElement.getExtControlParam().addParam(new ExtControlParam.Param(item.getKey(), ischeck.booleanValue()));
        }
        return extControlElement;
    }

    private ExtControlElement buildMeta4MultiSelect(IFormView childFormView, ViewExtControlModel viewModel) {
        ExtControlElement extControlElement = ExtControlElement.createNewInstanceByMultiSelect((int)viewModel.getModelEnum().getType());
        DynamicObjectCollection entryEntity = childFormView.getModel().getEntryEntity("flex_multi_select_entry");
        for (DynamicObject dynamicObject : entryEntity) {
            Boolean ischeckForEdit = (Boolean)dynamicObject.get("check_table_title_col_1");
            Boolean isMustInput = (Boolean)dynamicObject.get("check_table_title_col_3");
            Boolean isNoDelete = (Boolean)dynamicObject.get("check_table_title_col_4");
            if (!ischeckForEdit.booleanValue() && !isMustInput.booleanValue() && !isNoDelete.booleanValue()) continue;
            extControlElement.getExtControlParam().addParam(new ExtControlParam.Param((String)dynamicObject.get("text_table_title_number"), ischeckForEdit.booleanValue(), isMustInput.booleanValue(), isNoDelete.booleanValue()));
        }
        return extControlElement;
    }
}

