/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.botp.extcontrol.helper;

import dm.jdbc.util.IDGenerator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.designer.botp.common.RuleFormConst;
import kd.bos.designer.botp.common.RuleFormHelper;
import kd.bos.designer.botp.extcontrol.common.ExtControlConstant;
import kd.bos.designer.botp.extcontrol.helper.DataHelper;
import kd.bos.designer.botp.extcontrol.model.ViewExtControlModel;
import kd.bos.designer.botp.extcontrol.model.factory.ExtControlModelFactory;
import kd.bos.entity.botp.extcontrol.ExtControlParam;
import kd.bos.entity.botp.extcontrol.enums.ExtControlModelEnum;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import org.apache.commons.lang3.StringUtils;

public class ShowFormHelper
implements ExtControlConstant,
RuleFormConst {
    private static final String CHILD_PAGEID = "child_pageid";
    private AbstractFormPlugin formPlugin;
    private DataTransferHelper dataTransferHelper;
    private DataHelper dataHelper;
    private RuleFormHelper ruleFormHelper;
    private Map<String, ViewExtControlModel> extControlModelByTabKey;

    public ShowFormHelper(AbstractFormPlugin formPlugin) {
        this.formPlugin = formPlugin;
        this.dataTransferHelper = new DataTransferHelper();
        this.dataHelper = new DataHelper();
        this.ruleFormHelper = new RuleFormHelper(formPlugin);
    }

    private Map<String, ViewExtControlModel> getExtControlModelByTabKey() {
        if (this.extControlModelByTabKey == null) {
            List<ViewExtControlModel> extControlModelListenter = ExtControlModelFactory.getViewModelListener();
            this.extControlModelByTabKey = extControlModelListenter.stream().collect(Collectors.toMap(ViewExtControlModel::getTabKeyInParentView, view -> view));
        }
        return this.extControlModelByTabKey;
    }

    public void unshowExtCloseFlex(boolean close) {
        this.dataHelper.doReceiveXML(this.formPlugin, this.getChildPageId());
        this.clearChildPageId();
        if (close) {
            this.formPlugin.getPageCache().put("PAGECACHE_KEY_FLEX_SHOW", Boolean.FALSE.toString());
            this.formPlugin.getView().setVisible(Boolean.valueOf(false), new String[]{"flex_extclose"});
            this.formPlugin.getView().setVisible(Boolean.valueOf(false), new String[]{"button_down_extclose"});
            this.formPlugin.getView().setVisible(Boolean.valueOf(true), new String[]{"button_up_extclose"});
        }
    }

    public void showExtControlFlex(String formId) {
        this.formPlugin.getPageCache().put("PAGECACHE_KEY_FLEX_SHOW", Boolean.TRUE.toString());
        this.formPlugin.getView().setVisible(Boolean.valueOf(true), new String[]{"flex_extclose"});
        FormShowParameter flexFormParameter = this.getFormShowParameter(formId);
        flexFormParameter.getCustomParams().put("tab_select", this.formPlugin.getPageCache().get("tab_select"));
        this.formPlugin.getView().showForm(flexFormParameter);
        this.formPlugin.getView().setVisible(Boolean.valueOf(true), new String[]{"button_down_extclose"});
        this.formPlugin.getView().setVisible(Boolean.valueOf(false), new String[]{"button_up_extclose"});
    }

    private FormShowParameter getFormShowParameter(String formId) {
        FormShowParameter flexFormParameter = new FormShowParameter();
        flexFormParameter.setFormId(formId);
        flexFormParameter.getOpenStyle().setTargetKey("flex_extclose");
        flexFormParameter.getOpenStyle().setShowType(ShowType.InContainer);
        flexFormParameter.setPageId(this.getChildPageId());
        this.dataTransferHelper.tryBuildBillTypeMapping(flexFormParameter);
        this.dataTransferHelper.tryBuildFieldMapping(flexFormParameter);
        this.dataTransferHelper.tryBuildAttachmentMapping(flexFormParameter);
        this.dataTransferHelper.tryBuildExtendPlugin(flexFormParameter);
        this.dataTransferHelper.tryBuildBusinessRule(flexFormParameter);
        this.dataTransferHelper.tryBuildAdvDataRange(flexFormParameter);
        return flexFormParameter;
    }

    public String getChildPageId() {
        String childPageId = this.formPlugin.getPageCache().get(CHILD_PAGEID);
        if (StringUtils.isNotBlank((CharSequence)childPageId)) {
            return childPageId;
        }
        childPageId = IDGenerator.generateStrId();
        this.formPlugin.getPageCache().put(CHILD_PAGEID, childPageId);
        return childPageId;
    }

    private void clearChildPageId() {
        this.formPlugin.getPageCache().remove(CHILD_PAGEID);
    }

    class DataTransferHelper {
        DataTransferHelper() {
        }

        private void tryBuildBillTypeMapping(FormShowParameter flexFormParameter) {
            ViewExtControlModel viewExtControlModel = (ViewExtControlModel)ShowFormHelper.this.getExtControlModelByTabKey().get(this.getTabKeyFromPageCache());
            if (ExtControlModelEnum.BILLTYPE_MAPING != viewExtControlModel.getModelEnum()) {
                return;
            }
            ExtControlParam extControlParam = new ExtControlParam();
            Map<String, ComboItem> comboItemMap = ShowFormHelper.this.ruleFormHelper.buildSourceBillTypeItems();
            DynamicObjectCollection entryEntity = ShowFormHelper.this.formPlugin.getView().getModel().getEntryEntity("billtypemappolicy");
            for (DynamicObject dynamicObject : entryEntity) {
                String fieldKey = (String)dynamicObject.get("billtypemapitemid");
                String fieldName = (String)dynamicObject.get("sourcebilltype");
                ComboItem comboItem = comboItemMap.get(fieldName);
                if (comboItem == null) continue;
                extControlParam.addParam(new ExtControlParam.Param(fieldKey, comboItem.getCaption().getLocaleValue()));
            }
            flexFormParameter.getCustomParams().put("formparameter_customparam_billtypemapping", SerializationUtils.toJsonString((Object)extControlParam));
        }

        private void tryBuildFieldMapping(FormShowParameter flexFormParameter) {
            ViewExtControlModel viewExtControlModel = (ViewExtControlModel)ShowFormHelper.this.getExtControlModelByTabKey().get(this.getTabKeyFromPageCache());
            if (ExtControlModelEnum.FIELD_MAPING != viewExtControlModel.getModelEnum()) {
                return;
            }
            ExtControlParam extControlParam = new ExtControlParam();
            DynamicObjectCollection entryEntity = ShowFormHelper.this.formPlugin.getView().getModel().getEntryEntity("fieldmappolicy");
            for (DynamicObject dynamicObject : entryEntity) {
                String fieldKey = (String)dynamicObject.get("ftargetfield");
                String fieldName = (String)dynamicObject.get("ftargetfieldname");
                extControlParam.addParam(new ExtControlParam.Param(fieldKey, fieldName));
            }
            flexFormParameter.getCustomParams().put("formparameter_customparam_fieldmapping", SerializationUtils.toJsonString((Object)extControlParam));
        }

        private void tryBuildAttachmentMapping(FormShowParameter flexFormParameter) {
            ViewExtControlModel viewExtControlModel = (ViewExtControlModel)ShowFormHelper.this.getExtControlModelByTabKey().get(this.getTabKeyFromPageCache());
            if (ExtControlModelEnum.ATTACHMENT_MAPPING != viewExtControlModel.getModelEnum()) {
                return;
            }
            Object currentAttachment = ShowFormHelper.this.formPlugin.getView().getFormShowParameter().getCustomParam("TargetBill");
            flexFormParameter.getCustomParams().put("TargetBill", currentAttachment);
        }

        private void tryBuildExtendPlugin(FormShowParameter flexFormParameter) {
            ViewExtControlModel viewExtControlModel = (ViewExtControlModel)ShowFormHelper.this.getExtControlModelByTabKey().get(this.getTabKeyFromPageCache());
            if (ExtControlModelEnum.EXTEND_PLUGIN != viewExtControlModel.getModelEnum()) {
                return;
            }
            ExtControlParam extControlParam = new ExtControlParam();
            DynamicObjectCollection entryEntity = ShowFormHelper.this.formPlugin.getView().getModel().getEntryEntity("pluginpolicy");
            for (DynamicObject dynamicObject : entryEntity) {
                String fieldKey = (String)dynamicObject.get("f_pl_classname");
                String fieldName = (String)dynamicObject.get("f_pl_classname");
                extControlParam.addParam(new ExtControlParam.Param(fieldKey, fieldName));
            }
            flexFormParameter.getCustomParams().put("formparameter_customparam_extendplugin", SerializationUtils.toJsonString((Object)extControlParam));
        }

        private void tryBuildBusinessRule(FormShowParameter flexFormParameter) {
            ViewExtControlModel viewExtControlModel = (ViewExtControlModel)ShowFormHelper.this.getExtControlModelByTabKey().get(this.getTabKeyFromPageCache());
            if (ExtControlModelEnum.BUSINESS_RULE != viewExtControlModel.getModelEnum()) {
                return;
            }
            ExtControlParam extControlParam = new ExtControlParam();
            DynamicObjectCollection entryEntity = ShowFormHelper.this.formPlugin.getView().getModel().getEntryEntity("bizrulepolicy");
            for (DynamicObject dynamicObject : entryEntity) {
                String fieldKey = (String)dynamicObject.get("br_id");
                String fieldName = (String)dynamicObject.get("br_bizruledesc");
                extControlParam.addParam(new ExtControlParam.Param(fieldKey, fieldName));
            }
            flexFormParameter.getCustomParams().put("formparameter_customparam_businessrule", SerializationUtils.toJsonString((Object)extControlParam));
        }

        private void tryBuildAdvDataRange(FormShowParameter flexFormParameter) {
            ViewExtControlModel viewExtControlModel = (ViewExtControlModel)ShowFormHelper.this.getExtControlModelByTabKey().get(this.getTabKeyFromPageCache());
            if (ExtControlModelEnum.ADVDATA_RANGE != viewExtControlModel.getModelEnum()) {
                return;
            }
            ExtControlParam extControlParam = new ExtControlParam();
            DynamicObjectCollection entryEntity = ShowFormHelper.this.formPlugin.getView().getModel().getEntryEntity("adv_filter");
            for (DynamicObject dynamicObject : entryEntity) {
                String fieldKey = (String)dynamicObject.get("ft_id");
                String fieldName = (String)dynamicObject.get("filterexprdesc");
                extControlParam.addParam(new ExtControlParam.Param(fieldKey, fieldName));
            }
            flexFormParameter.getCustomParams().put("formparameter_customparam_datarange", SerializationUtils.toJsonString((Object)extControlParam));
        }

        private String getTabKeyFromPageCache() {
            String tabKey = ShowFormHelper.this.formPlugin.getPageCache().get("tab_select");
            if (StringUtils.isBlank((CharSequence)tabKey)) {
                tabKey = "tbpage_base";
            }
            return tabKey;
        }
    }
}

