/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.botp.extcontrol.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.designer.botp.extcontrol.common.WBExtControlConstant;
import kd.bos.designer.botp.extcontrol.model.WBViewExtControlModel;
import kd.bos.designer.botp.extcontrol.model.factory.ExtControlModelFactory;
import kd.bos.entity.botp.extcontrol.ExtControlElement;
import kd.bos.entity.botp.extcontrol.ExtControlParam;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class WBDataHelper
implements WBExtControlConstant {
    private static final String FORMID_CONVERTRULE_EXTCONTROL_XML = "botp_convertrul_extcontrol_xml";
    private List<WBViewExtControlModel> wbViewModelListener;

    private List<WBViewExtControlModel> getWBViewModelListener() {
        if (this.wbViewModelListener == null) {
            this.wbViewModelListener = ExtControlModelFactory.getWBViewModelListener();
        }
        return this.wbViewModelListener;
    }

    public List<ExtControlElement> getExtControlElements(IFormView parentView) {
        String json = parentView.getPageCache().get(FORMID_CONVERTRULE_EXTCONTROL_XML);
        if (StringUtils.isBlank((CharSequence)json)) {
            return new ArrayList<ExtControlElement>(0);
        }
        List elements = SerializationUtils.fromJsonStringToList((String)json, ExtControlElement.class);
        return elements;
    }

    public void refreshExtControlElements(IFormView parentView, List<ExtControlElement> elements) {
        parentView.getPageCache().put(FORMID_CONVERTRULE_EXTCONTROL_XML, SerializationUtils.toJsonString(elements));
    }

    public void loadView(AbstractFormPlugin formPlugin, List<WBViewExtControlModel> wbViewExtControlModels) {
        List<ExtControlElement> elements = this.getExtControlElements(formPlugin.getView().getParentView());
        if (CollectionUtils.isEmpty(elements)) {
            return;
        }
        HashMap<Integer, ExtControlElement> globalContainerElementsByModelType = new HashMap<Integer, ExtControlElement>();
        HashMap<Integer, ExtControlElement> multiSelectElementsByModelType = new HashMap<Integer, ExtControlElement>();
        for (ExtControlElement element : elements) {
            int modelType = element.getModelType();
            int type = element.getType();
            if (type == ExtControlElement.TypeEnum.GLOBAL_CONDITION.getType()) {
                globalContainerElementsByModelType.put(modelType, element);
            }
            if (type != ExtControlElement.TypeEnum.MULTISELECT_CONDITION.getType()) continue;
            multiSelectElementsByModelType.put(modelType, element);
        }
        for (WBViewExtControlModel wbViewExtControlModel : wbViewExtControlModels) {
            ExtControlElement multiSelectElement;
            ExtControlElement globalContainerElement = (ExtControlElement)globalContainerElementsByModelType.get(wbViewExtControlModel.getModelEnum().getType());
            if (globalContainerElement != null) {
                List params = globalContainerElement.getExtControlParam().getParams();
                for (ExtControlParam.Param param : params) {
                    formPlugin.getView().getModel().setValue(param.getKey(), (Object)param.isEnable());
                }
            }
            if ((multiSelectElement = (ExtControlElement)multiSelectElementsByModelType.get(wbViewExtControlModel.getModelEnum().getType())) == null) continue;
            DynamicObjectCollection entryEntity = formPlugin.getView().getModel().getEntryEntity(wbViewExtControlModel.getEntryKey());
            Map<Object, DynamicObject> entryDataById = entryEntity.stream().collect(Collectors.toMap(data -> data.get(wbViewExtControlModel.getTableColumn4Number()), data -> data));
            List params = multiSelectElement.getExtControlParam().getParams();
            for (ExtControlParam.Param param : params) {
                DynamicObject data2 = entryDataById.get(param.getKey());
                if (data2 == null) continue;
                formPlugin.getView().getModel().setValue(wbViewExtControlModel.getTableColumn4EnableEdit(), (Object)param.isEnable(), (Integer)data2.get("seq") - 1);
                if (!StringUtils.isNotBlank((CharSequence)wbViewExtControlModel.getTableColumn4ProhibitDelete())) continue;
                formPlugin.getView().getModel().setValue(wbViewExtControlModel.getTableColumn4ProhibitDelete(), (Object)param.isNoDelete(), (Integer)data2.get("seq") - 1);
            }
        }
    }

    void doReceiveXML(AbstractFormPlugin parentFormPlugin, String childPageId) {
        IFormView childFormView = parentFormPlugin.getView().getView(childPageId);
        if (childFormView == null) {
            return;
        }
        Map<Integer, ExtControlElement> extControlElementMaps = this.getExtControlElementMaps(parentFormPlugin);
        for (WBViewExtControlModel wbViewModel : this.getWBViewModelListener()) {
            this.appendElement(childFormView, wbViewModel, extControlElementMaps);
        }
        this.refreshExtControlElements(parentFormPlugin.getView(), new ArrayList<ExtControlElement>(extControlElementMaps.values()));
    }

    private Map<Integer, ExtControlElement> getExtControlElementMaps(AbstractFormPlugin parentFormPlugin) {
        List<ExtControlElement> elements = this.getExtControlElements(parentFormPlugin.getView());
        HashMap<Integer, ExtControlElement> collect = new HashMap<Integer, ExtControlElement>(elements.size());
        for (ExtControlElement element : elements) {
            if (collect.containsKey(element.hashCode())) {
                throw new RuntimeException("botp extcontrol error, WBDataHelper#appendElement duplicate primary key");
            }
            collect.put(element.hashCode(), element);
        }
        return collect;
    }

    private void appendElement(IFormView childFormView, WBViewExtControlModel wbViewModel, Map<Integer, ExtControlElement> collect) {
        Optional<ExtControlElement> globalCondition = this.buildMeta4GlobalCondition(childFormView, wbViewModel);
        globalCondition.ifPresent(extControlElement -> collect.put(extControlElement.hashCode(), (ExtControlElement)extControlElement));
        Optional<ExtControlElement> multiSelect = this.buildMeta4MultiSelect(childFormView, wbViewModel);
        multiSelect.ifPresent(extControlElement -> collect.put(extControlElement.hashCode(), (ExtControlElement)extControlElement));
    }

    private Optional<ExtControlElement> buildMeta4GlobalCondition(IFormView childFormView, WBViewExtControlModel wbViewModel) {
        if (StringUtils.isBlank((CharSequence)wbViewModel.getGlobalContainer())) {
            return Optional.empty();
        }
        DynamicObject dataEntity = childFormView.getModel().getDataEntity(true);
        ExtControlElement extControlElement = ExtControlElement.createNewInstanceByGlobalCondition((int)wbViewModel.getModelEnum().getType());
        Container container = (Container)childFormView.getControl(wbViewModel.getGlobalContainer());
        List items = container.getItems();
        for (Control item : items) {
            Boolean ischeck = (Boolean)dataEntity.get(item.getKey());
            if (!ischeck.booleanValue()) continue;
            extControlElement.getExtControlParam().addParam(new ExtControlParam.Param(item.getKey(), ischeck.booleanValue()));
        }
        return Optional.of(extControlElement);
    }

    private Optional<ExtControlElement> buildMeta4MultiSelect(IFormView childFormView, WBViewExtControlModel wbViewModel) {
        ExtControlElement extControlElement = ExtControlElement.createNewInstanceByMultiSelect((int)wbViewModel.getModelEnum().getType());
        DynamicObjectCollection entryEntity = childFormView.getModel().getEntryEntity(wbViewModel.getEntryKey());
        for (DynamicObject dynamicObject : entryEntity) {
            Boolean ischeckForEdit = (Boolean)dynamicObject.get(wbViewModel.getTableColumn4EnableEdit());
            Boolean prohibitDelete = false;
            if (StringUtils.isNotBlank((CharSequence)wbViewModel.getTableColumn4ProhibitDelete())) {
                prohibitDelete = (Boolean)dynamicObject.get(wbViewModel.getTableColumn4ProhibitDelete());
            }
            if (!ischeckForEdit.booleanValue() && !prohibitDelete.booleanValue()) continue;
            extControlElement.getExtControlParam().addParam(new ExtControlParam.Param((String)dynamicObject.get(wbViewModel.getTableColumn4Number()), ischeckForEdit.booleanValue(), false, prohibitDelete.booleanValue()));
        }
        return Optional.of(extControlElement);
    }
}

