/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.botp.extcontrol.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.BillTreeBuildParameter;
import kd.bos.designer.botp.EntityParseHelper;
import kd.bos.designer.botp.FieldSeqComparator;
import kd.bos.designer.botp.extcontrol.helper.CarryParamDataHelper;
import kd.bos.designer.botp.extcontrol.model.ViewExtControlModel;
import kd.bos.designer.botp.extcontrol.model.factory.ExtControlModelFactory;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.extcontrol.ExtControlElement;
import kd.bos.entity.botp.extcontrol.ExtControlParam;
import kd.bos.entity.botp.extcontrol.enums.ExtControlModelEnum;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.EntryGridColAllCheckedEvent;
import kd.bos.form.control.events.EntryGridColAllCheckedListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.login.LoginClientEnum;
import kd.bos.service.ServiceFactory;

public class CarryParamEdit
extends AbstractFormPlugin
implements TabSelectListener,
EntryGridBindDataListener,
EntryGridColAllCheckedListener {
    private ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
    private static final String FILEDNUMBER_FOR_BTN_CREATE_RULE = "btn_create_rule";
    private static final String FILEDNUMBER_FOR_BTN_CARRY_CREATE_RULE = "btn_carry_create_rule";
    private static final String BTN_SAVE = "btnok";
    private CarryParamDataHelper carryParamDataHelper = new CarryParamDataHelper();
    private Map<String, ViewExtControlModel> extControlModelByTabKey;
    private Map<String, String> tabMap;
    private Map<String, Integer> typeMap;

    public void initialize() {
        this.addClickListeners(new String[]{BTN_SAVE});
        List<ViewExtControlModel> extControlModelListenter = ExtControlModelFactory.getViewMustInputModelListener();
        this.extControlModelByTabKey = extControlModelListenter.stream().collect(Collectors.toMap(ViewExtControlModel::getTabKeyInParentView, view -> view));
        this.tabMap = new HashMap<String, String>(10);
        this.typeMap = new HashMap<String, Integer>(10);
        this.tabMap.put("tbpage_base", "entryentity_base");
        this.typeMap.put("tbpage_base", ExtControlModelEnum.BASE_INFO.getType());
        this.tabMap.put("tbpage_link", "entryentity_link");
        this.typeMap.put("tbpage_link", ExtControlModelEnum.LINK_ENTRY.getType());
        this.tabMap.put("tbpage_fieldmap", "entryentity_fieldmap");
        this.typeMap.put("tbpage_fieldmap", ExtControlModelEnum.FIELD_MAPING.getType());
        this.tabMap.put("tabpage_billtype", "entryentity_billtype");
        this.typeMap.put("tabpage_billtype", ExtControlModelEnum.BILLTYPE_MAPING.getType());
        this.tabMap.put("tabpageap", "entryentity_attch");
        this.typeMap.put("tabpageap", ExtControlModelEnum.ATTACHMENT_MAPPING.getType());
        this.tabMap.put("tbpage_groupby", "entryentity_group");
        this.typeMap.put("tbpage_groupby", ExtControlModelEnum.BILL_GROUP.getType());
        this.tabMap.put("tbpage_filter", "entryentity_filter");
        this.typeMap.put("tbpage_filter", ExtControlModelEnum.DATA_RANGE.getType());
        this.tabMap.put("tbpage_updatedata", "entryentity_biz");
        this.typeMap.put("tbpage_updatedata", ExtControlModelEnum.BUSINESS_RULE.getType());
        this.tabMap.put("tbpage_plugin", "entryentity_plugin");
        this.typeMap.put("tbpage_plugin", ExtControlModelEnum.EXTEND_PLUGIN.getType());
        this.tabMap.put("tbpage_option", "entryentity_option");
        this.typeMap.put("tbpage_option", ExtControlModelEnum.ADVANCED_OPTION.getType());
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity_link");
        entryGrid.addColAllCheckedListener((EntryGridColAllCheckedListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        String sourceBill = (String)this.getView().getFormShowParameter().getCustomParam("fsourcebill");
        String targetBill = (String)this.getView().getFormShowParameter().getCustomParam("ftargetbill");
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)sourceBill) || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)targetBill)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u6e90\u5355\u4e0e\u76ee\u6807\u5355\uff0c\u65e0\u6cd5\u52a0\u8f7d\u914d\u7f6e\u4fe1\u606f\u3002", (String)"CarryParamEdit_0", (String)"bos-botp-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject data = this.carryParamDataHelper.loadData(sourceBill, targetBill);
        String mustInputJson = null;
        if (data != null) {
            Boolean disableCreateRule = this.carryParamDataHelper.isDisableCreateRule(data);
            Boolean enableCarryCreateRule = this.carryParamDataHelper.isEnableCarryCreateRule(data);
            this.getModel().setValue(FILEDNUMBER_FOR_BTN_CREATE_RULE, (Object)disableCreateRule);
            this.getModel().setValue(FILEDNUMBER_FOR_BTN_CARRY_CREATE_RULE, (Object)enableCarryCreateRule);
            mustInputJson = this.carryParamDataHelper.getMustInputJson(data);
        }
        MainEntityType targetMainType = EntityMetadataCache.getDataEntityType((String)targetBill);
        this.buildFields(targetMainType);
        List<Object> elements = new ArrayList<ExtControlElement>();
        if (org.apache.commons.lang3.StringUtils.isNotBlank(mustInputJson)) {
            elements = SerializationUtils.fromJsonStringToList(mustInputJson, ExtControlElement.class);
        }
        this.createBaseTapPage(elements);
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        if (BTN_SAVE.equals(source.getKey())) {
            this.save();
        }
    }

    public void tabSelected(TabSelectEvent evt) {
        String a = "sd";
    }

    private void save() {
        String mustInputJson;
        Boolean enableCarryCreateRule;
        String sourceBill = (String)this.getView().getFormShowParameter().getCustomParam("fsourcebill");
        String targetBill = (String)this.getView().getFormShowParameter().getCustomParam("ftargetbill");
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)sourceBill) || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)targetBill)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u6e90\u5355\u4e0e\u76ee\u6807\u5355\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", (String)"CarryParamEdit_1", (String)"bos-botp-formplugin", (Object[])new Object[0]));
            return;
        }
        Boolean disableCreateRule = (Boolean)this.getModel().getValue(FILEDNUMBER_FOR_BTN_CREATE_RULE);
        boolean result = this.carryParamDataHelper.updateData(sourceBill, targetBill, disableCreateRule, enableCarryCreateRule = (Boolean)this.getModel().getValue(FILEDNUMBER_FOR_BTN_CARRY_CREATE_RULE), mustInputJson = this.generateElements());
        if (result) {
            this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u51fa\u5382\u7ba1\u63a7\u8bbe\u7f6e\u4fdd\u5b58\u6210\u529f\u3002", (String)"CarryParamEdit_2", (String)"bos-botp-formplugin", (Object[])new Object[0]));
            this.getView().sendFormAction(this.getView().getParentView());
            this.getView().close();
            this.addLog();
            return;
        }
        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u51fa\u5382\u7ba1\u63a7\u8bbe\u7f6e\u4fdd\u5b58\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"CarryParamEdit_3", (String)"bos-botp-formplugin", (Object[])new Object[0]));
    }

    private void addLog() {
        this.logService.addLog(this.initAppLogInfo());
    }

    private AppLogInfo initAppLogInfo() {
        OpLogAppInfo logInfo = new OpLogAppInfo();
        logInfo.setUserID(Long.valueOf(RequestContext.get().getCurrUserId()));
        logInfo.setOrgID(Long.valueOf(RequestContext.get().getOrgId()));
        logInfo.setBizAppID("botp");
        logInfo.setBizObjID("botp_extclose_new_pop");
        logInfo.setOpTime(new Date());
        LoginClientEnum loginClient = LoginClientEnum.getLoginClientByValue((String)RequestContext.get().getClient());
        if (loginClient != null) {
            logInfo.setClientType(loginClient.getDesc());
            logInfo.setClientName(loginClient.getDesc());
        }
        logInfo.setClientIP(RequestContext.get().getLoginIP());
        MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u4fdd\u5b58", "CarryParamEdit_4", "bos-botp-formplugin");
        logInfo.setOpName("save", opNameBridge);
        MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u51fa\u5382\u7ba1\u63a7\u8bbe\u7f6e\u4fdd\u5b58\u6210\u529f", "CarryParamEdit_5", "bos-botp-formplugin");
        logInfo.setOpDesc(opDescBridge, new String[0]);
        logInfo.setAccountId(RequestContext.get().getAccountId());
        logInfo.setTenantId(RequestContext.get().getTenantId());
        logInfo.setLanguage(Lang.get().name());
        return logInfo;
    }

    private void createBaseTapPage(List<ExtControlElement> elements) {
        Map<String, Boolean> map = this.getValueFromElement(elements);
        for (Map.Entry<String, String> entry : this.tabMap.entrySet()) {
            DynamicObjectCollection rows = this.getModel().getEntryEntity(this.tabMap.get(entry.getKey()));
            rows.clear();
            ViewExtControlModel model = this.extControlModelByTabKey.get(entry.getKey());
            ExtControlParam extControlParam = model.buildParamExtclose4MultiSelectRow(this.getView().getFormShowParameter());
            if (extControlParam.getParams().size() > 0) {
                this.getModel().batchCreateNewEntryRow(this.tabMap.get(entry.getKey()), extControlParam.getParams().size());
            }
            String[] tap = this.tabMap.get(entry.getKey()).split("_");
            for (int i = 0; i < extControlParam.getParams().size(); ++i) {
                this.getModel().setValue(tap[1] + "_field_number", (Object)((ExtControlParam.Param)extControlParam.getParams().get(i)).getKey(), i);
                this.getModel().setValue(tap[1] + "_field_name", (Object)((ExtControlParam.Param)extControlParam.getParams().get(i)).getDesc(), i);
                this.getModel().setValue(tap[1] + "_field_must", (Object)this.getMustInputValue(((ExtControlParam.Param)extControlParam.getParams().get(i)).getKey(), map), i);
                if (!"fsourceentrykey".equals(((ExtControlParam.Param)extControlParam.getParams().get(i)).getKey()) && !"ftargetentrykey".equals(((ExtControlParam.Param)extControlParam.getParams().get(i)).getKey())) continue;
                this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"link_field_must"});
                this.setLockMapCache("link_field_must", i);
            }
        }
    }

    private void buildFields(MainEntityType targetMainType) {
        BillTreeBuildParameter billTreeBuildParameter = new BillTreeBuildParameter(targetMainType);
        ArrayList<IDataEntityProperty> allFields = new ArrayList<IDataEntityProperty>(16);
        for (EntityType entityType : targetMainType.getAllEntities().values()) {
            for (IDataEntityProperty property : entityType.getFields().values()) {
                if (!(property instanceof IFieldHandle) || !((IFieldHandle)property).isConvertTote() || !EntityParseHelper.isSupportConvField(targetMainType, property) || billTreeBuildParameter.isFormDisVisitField(property)) continue;
                allFields.add(property);
            }
        }
        allFields.sort(new FieldSeqComparator(targetMainType));
        ExtControlParam extControlParam = new ExtControlParam();
        for (IDataEntityProperty property : allFields) {
            DynamicProperty field = (DynamicProperty)property;
            String targetFieldKey = field.getName();
            String targetFieldName = EntityParseHelper.buildPropFullCaption(property);
            extControlParam.addParam(new ExtControlParam.Param(targetFieldKey, targetFieldName));
        }
        this.getView().getFormShowParameter().setCustomParam("formparameter_customparam_mustinput_fieldmapping", (Object)SerializationUtils.toJsonString((Object)extControlParam));
    }

    private Boolean getMustInputValue(String fieldNumber, Map<String, Boolean> map) {
        if (fieldNumber.equals("fsourceentrykey") || fieldNumber.equals("ftargetentrykey")) {
            return true;
        }
        if (map.containsKey(fieldNumber)) {
            return map.get(fieldNumber);
        }
        return false;
    }

    private Map<String, Boolean> getValueFromElement(List<ExtControlElement> elements) {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>(16);
        for (ExtControlElement element : elements) {
            for (ExtControlParam.Param param : element.getExtControlParam().getParams()) {
                map.put(param.getKey(), param.isEnable());
            }
        }
        return map;
    }

    private String generateElements() {
        ArrayList<ExtControlElement> elements = new ArrayList<ExtControlElement>(10);
        for (Map.Entry<String, String> entry : this.tabMap.entrySet()) {
            ExtControlElement extControlElement = ExtControlElement.createNewInstanceByMultiSelect((int)this.typeMap.get(entry.getKey()));
            DynamicObjectCollection entryEntity = this.getView().getModel().getEntryEntity(this.tabMap.get(entry.getKey()));
            String[] tap = this.tabMap.get(entry.getKey()).split("_");
            for (DynamicObject dynamicObject : entryEntity) {
                Boolean ischeckForEdit = (Boolean)dynamicObject.get(tap[1] + "_field_must");
                if (!ischeckForEdit.booleanValue()) continue;
                extControlElement.getExtControlParam().addParam(new ExtControlParam.Param((String)dynamicObject.get(tap[1] + "_field_number"), ischeckForEdit.booleanValue()));
            }
            elements.add(extControlElement);
        }
        return SerializationUtils.toJsonString(elements);
    }

    public void entryGridColAllChecked(EntryGridColAllCheckedEvent e) {
        boolean oldValue;
        int i;
        e.setCancel(true);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity_link");
        int startIndex = 0;
        int endIndex = entryGrid.getModel().getEntryRowCount("entryentity_link");
        String locks = this.getPageCache().get("lockMap");
        Map lockMap = (Map)SerializationUtils.fromJsonString((String)locks, Map.class);
        List rows = (List)lockMap.get(e.getColKey());
        HashSet<Integer> rowSet = new HashSet<Integer>(16);
        if (rows != null) {
            for (i = startIndex; i < endIndex; ++i) {
                if (rows.contains(i) || (oldValue = ((Boolean)this.getModel().getValue(e.getColKey(), i)).booleanValue()) == e.isChecked()) continue;
                this.getModel().setValue(e.getColKey(), (Object)e.isChecked(), i);
                rowSet.add(i);
            }
        } else {
            for (i = startIndex; i < endIndex; ++i) {
                oldValue = (Boolean)this.getModel().getValue(e.getColKey(), i);
                if (oldValue == e.isChecked()) continue;
                this.getModel().setValue(e.getColKey(), (Object)e.isChecked(), i);
                rowSet.add(i);
            }
        }
        String changeRows = this.getPageCache().get("changeRows");
        HashSet<Integer> changeRowsSet = null;
        if (StringUtils.isNotBlank((CharSequence)changeRows)) {
            changeRowsSet = (HashSet<Integer>)SerializationUtils.fromJsonString((String)changeRows, Set.class);
        }
        if (changeRowsSet == null) {
            changeRowsSet = new HashSet<Integer>();
        }
        changeRowsSet.addAll(rowSet);
        this.getPageCache().put("changeRows", SerializationUtils.toJsonString(changeRowsSet));
        this.setGridColAllValue("entryentity_link", e.getColKey(), e.isChecked());
    }

    private void setGridColAllValue(String entryGrid, String colKey, boolean checked) {
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap<String, Object> ret = new HashMap<String, Object>(2);
        ret.put("c", colKey);
        ret.put("v", checked);
        clientViewProxy.invokeControlMethod(entryGrid, "setGridColAllValue", new Object[]{ret});
    }

    private void setLockMapCache(String feature, int i) {
        Map<String, HashSet<Integer>> lockMap = new HashMap(16);
        HashSet<Integer> rows = new HashSet<Integer>(10);
        String lock = this.getPageCache().get("lockMap");
        if (StringUtils.isNotBlank((CharSequence)lock) && (lockMap = (Map)SerializationUtils.fromJsonString((String)lock, Map.class)).get(feature) != null) {
            rows = new HashSet((Collection)lockMap.get(feature));
        }
        rows.add(i);
        lockMap.put(feature, rows);
        this.getPageCache().put("lockMap", SerializationUtils.toJsonString(lockMap));
    }
}

