/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.botp;

import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.logorm.LogORM;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.time.DateUtils;

public class BotpLinkLogClearTask
extends AbstractTask {
    private static final Log LOG = LogFactory.getLog(BotpLinkLogClearTask.class);
    private static final String FORMID_BOTP_LINK_LOG = "botp_lk_log";
    private static final String KEY_ID = "id";
    protected static final int BATCH_COUNT = 2000;
    protected static final String STORAGE_DAYS_KEY = "storageDays";
    protected static final int STORAGE_DAYS_DEFAULT = 90;
    private int storageDays;

    public void execute(RequestContext rc, Map<String, Object> params) throws KDException {
        LOG.info("\u6e05\u7406\u5220\u9664\u5173\u8054\u5173\u7cfb\u8bb0\u5f55\u65e5\u5fd7\uff1a\u5f00\u59cb");
        Date startTime = TimeServiceHelper.now();
        Object storageDaysParam = params.get(STORAGE_DAYS_KEY);
        if (StringUtils.isNotBlank((Object)storageDaysParam)) {
            this.storageDays = Integer.parseInt(storageDaysParam.toString());
        }
        if (this.storageDays <= 0) {
            this.storageDays = 90;
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)FORMID_BOTP_LINK_LOG);
        QFilter qFilter = new QFilter("opdate", "<", (Object)DateUtils.addDays((Date)new Date(), (int)(-this.storageDays)));
        QFilter[] filters = new QFilter[]{qFilter};
        int count = 0;
        for (int batchCount = 0; batchCount < 1000; ++batchCount) {
            ArrayList<Object> deleteIds = new ArrayList<Object>(2000);
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"BotpLinkLogClearTaskbotp_lk_log", (String)FORMID_BOTP_LINK_LOG, (String)KEY_ID, (QFilter[])filters, (String)"", (int)2000);){
                while (ds.hasNext()) {
                    if (!ds.hasNext()) {
                        break;
                    }
                    for (Row row : ds) {
                        deleteIds.add(row.get(KEY_ID));
                    }
                }
            }
            if (CollectionUtils.isEmpty(deleteIds)) break;
            int currentCount = deleteIds.size();
            LogORM logORM = LogORM.create();
            QFilter delFilter = new QFilter(KEY_ID, "in", deleteIds);
            QFilter[] delFilters = new QFilter[]{delFilter};
            logORM.delete(FORMID_BOTP_LINK_LOG, delFilters);
            count += currentCount;
        }
        Date endTime = TimeServiceHelper.now();
        long ms = (endTime.getTime() - startTime.getTime()) / 1000L;
        LOG.info(String.format("\u6e05\u7406\u5220\u9664\u5173\u8054\u5173\u7cfb\u8bb0\u5f55\u65e5\u5fd7\u7ed3\u675f\uff0c\u8017\u65f6%s\u79d2\uff0c\u5220\u9664%s\u6761", ms, count));
    }
}

