/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.botp;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.botp.BOTPLogService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.log.BOTPLog;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;

public class BotpLogClearTask
extends AbstractTask {
    private static final Log LOG = LogFactory.getLog(BotpLogClearTask.class);
    private static final String FORMID_BOTP_LOG = "botp_log";
    private static final String KEY_NORMAL_KEEP_DAYS = "normallogkeepdays";
    private static final String KEY_ERR_KEEP_DAYS = "errlogkeepdays";
    private static final String BOS_BOTP_FORMPLUGIN = "bos-botp-formplugin";
    private static final int PROCESS_100 = 1000000;
    private static final int PROCESS_80 = 800000;
    private static final int PROCESS_20 = 200000;
    private static final int PROCESS_1 = 10000;
    private static final int MS_ONE_DAY = 86400000;
    private static final int BATCH_SIZE = 100000;
    private static final int MAX_BATCH = 100;
    private Date currTime = TimeServiceHelper.now();
    private int progress = 0;
    private int dbCount = 0;
    private int dbFinished = 0;
    private Set<String> dbRouteKeys = new HashSet<String>(0);
    private int normalKeepDays = 10;
    private int errKeepDays = 60;

    public void execute(RequestContext rc, Map<String, Object> params) throws KDException {
        LOG.info("\u6e05\u7406\u5355\u636e\u8f6c\u6362\u548c\u53cd\u5199\u65e5\u5fd7\uff1a\u5f00\u59cb");
        this.dbRouteKeys = this.loadDBRouteKeys();
        if (!this.dbRouteKeys.isEmpty()) {
            this.dbCount = this.dbRouteKeys.size();
            this.loadSysParameters();
            for (String dbRouteKey : this.dbRouteKeys) {
                this.clearLogs(dbRouteKey);
            }
            for (String dbRouteKey : this.dbRouteKeys) {
                this.clearTrackerLogs(dbRouteKey);
                this.progress += 200000 / this.dbCount / 10000;
                this.feedbackProgress(this.progress);
            }
        }
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("success", "true");
        this.feedbackCustomdata(result);
        Date endTime = TimeServiceHelper.now();
        long ms = (endTime.getTime() - this.currTime.getTime()) / 1000L;
        LOG.info(String.format("\u6e05\u7406\u5355\u636e\u8f6c\u6362\u548c\u53cd\u5199\u65e5\u5fd7\uff1a\u7ed3\u675f\uff0c\u8017\u65f6%1$s\u79d2\uff0c\u6b63\u5e38\u65e5\u5fd7\u4fdd\u7559%2$s\u5929\uff0c\u5f02\u5e38\u65e5\u5fd7\u4fdd\u7559%3$s\u5929", ms, this.normalKeepDays, this.errKeepDays));
    }

    private Set<String> loadDBRouteKeys() {
        HashSet<String> numbers = new HashSet<String>();
        BOTPLogService service = new BOTPLogService();
        try (DataSet ds = ORM.create().queryDataSet(((Object)((Object)this)).getClass().getSimpleName() + "#loadDBRouteKeys", "botp_logdb", "number", null);){
            while (ds.hasNext()) {
                Row row = ds.next();
                String dbRouteKey = row.getString("number");
                if (!service.existBotpLogTable(dbRouteKey).booleanValue()) continue;
                numbers.add(dbRouteKey);
            }
        }
        return numbers;
    }

    private void loadSysParameters() {
        try {
            Object day2;
            Object day1 = SystemParamServiceHelper.getBillParameter((String)FORMID_BOTP_LOG, (String)KEY_NORMAL_KEEP_DAYS);
            if (day1 != null) {
                this.normalKeepDays = Integer.parseInt((String)day1);
            }
            if ((day2 = SystemParamServiceHelper.getBillParameter((String)FORMID_BOTP_LOG, (String)KEY_ERR_KEEP_DAYS)) != null) {
                this.errKeepDays = Integer.parseInt((String)day2);
            }
        }
        catch (Throwable exp) {
            LOG.error(exp);
        }
    }

    private void clearLogs(String dbRouteKey) {
        this.feedbackProgress(this.progress, String.format(ResManager.loadKDString((String)"\u6b63\u5728\u6e05\u7406\u6570\u636e\u5e93\u3010%1$s, %2$s/%3$s\u3011\u7684\u65e5\u5fd7", (String)"BotpLogClearTask_5", (String)BOS_BOTP_FORMPLUGIN, (Object[])new Object[0]), dbRouteKey, this.dbFinished + 1, this.dbCount), null);
        this.clearOverTimeLogs(dbRouteKey);
        this.progress += 200000 / this.dbCount / 10000;
        this.feedbackProgress(this.progress);
        this.clearPushLogs(dbRouteKey);
        this.progress += 200000 / this.dbCount / 10000;
        this.feedbackProgress(this.progress);
        this.clearWriteValueLogs(dbRouteKey);
        this.progress += 200000 / this.dbCount / 10000;
        this.feedbackProgress(this.progress);
        this.clearWriteFinishLogs(dbRouteKey);
        ++this.dbFinished;
        this.progress = 800000 * this.dbFinished / this.dbCount / 10000;
        this.feedbackProgress(this.progress);
    }

    private void clearOverTimeLogs(String dbRouteKey) {
        Date lastTime = this.calcBeforeTime(this.errKeepDays);
        BOTPLogService service = new BOTPLogService();
        service.delete(dbRouteKey, lastTime, null);
    }

    private void clearPushLogs(String dbRouteKey) {
        Date lastTime = this.calcBeforeTime(this.normalKeepDays);
        BOTPLogService service = new BOTPLogService();
        service.delete(dbRouteKey, lastTime, "P");
    }

    private void clearWriteValueLogs(String dbRouteKey) {
        Date lastTime = this.calcBeforeTime(this.normalKeepDays);
        BOTPLogService service = new BOTPLogService();
        service.delete(dbRouteKey, lastTime, "V");
    }

    private void clearWriteFinishLogs(String dbRouteKey) {
        Date lastTime = this.calcBeforeTime(this.normalKeepDays);
        SqlParameter paramStartTime = new SqlParameter("", 91, (Object)lastTime);
        SqlParameter paramLogType = new SqlParameter("", 1, (Object)"F");
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fid, fttableid, fparentid from t_botp_log where fstarttime < ? and flogtype = ?", new Object[]{paramStartTime, paramLogType});
        ResultSetHandler<List<BOTPLog>> action = new ResultSetHandler<List<BOTPLog>>(){

            public List<BOTPLog> handle(ResultSet rs) throws SQLException {
                ArrayList<BOTPLog> logList = new ArrayList<BOTPLog>(10);
                int size = 0;
                while (rs.next()) {
                    BOTPLog log = new BOTPLog();
                    log.setId(rs.getLong("fid"));
                    log.setTTableId(rs.getLong("fttableid"));
                    log.setParentId(rs.getLong("fparentid"));
                    logList.add(log);
                    if (++size < 100000) continue;
                    break;
                }
                return logList;
            }
        };
        DBRoute dbRoute = new DBRoute(dbRouteKey);
        BOTPLogService service = new BOTPLogService();
        int count = 0;
        while (count < 100) {
            ++count;
            List logs = (List)DB.query((DBRoute)dbRoute, (SqlBuilder)sqlBuilder, (ResultSetHandler)action);
            if (logs.isEmpty()) break;
            HashMap<Long, List> logsByTT = new HashMap<Long, List>();
            for (BOTPLog bOTPLog : logs) {
                logsByTT.computeIfAbsent(bOTPLog.getTTableId(), s -> new ArrayList()).add(bOTPLog);
            }
            for (Map.Entry entry : logsByTT.entrySet()) {
                try {
                    HashSet<Long> wfLogIds = new HashSet<Long>(logs.size());
                    HashSet<Long> wbLogIds = new HashSet<Long>(logs.size());
                    for (BOTPLog log : (List)entry.getValue()) {
                        wfLogIds.add(log.getId());
                        wbLogIds.add(log.getParentId());
                    }
                    Long ttableId = (Long)entry.getKey();
                    TableDefine tableDefine = EntityMetadataCache.loadTableDefine((Long)ttableId);
                    MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)tableDefine.getEntityNumber());
                    service.delete(mainType.getDBRouteKey(), wbLogIds.toArray(new Long[0]));
                    service.delete(dbRouteKey, wfLogIds.toArray(new Long[0]));
                }
                catch (Throwable exp) {
                    LOG.error(exp);
                }
            }
        }
    }

    private void clearTrackerLogs(String dbRouteKey) {
        Date lastTime = this.calcBeforeTime(this.normalKeepDays);
        SqlParameter paramStartTime = new SqlParameter("", 91, (Object)lastTime);
        SqlParameter paramLogType = new SqlParameter("", 1, (Object)"T");
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select t1.fid from t_botp_log t1 left join t_botp_log t2 on (t1.fid = t2.fparentid and t2.fid = 0) where t1.fstarttime < ? and t1.flogtype = ?", new Object[]{paramStartTime, paramLogType});
        ResultSetHandler<Set<Long>> action = new ResultSetHandler<Set<Long>>(){

            public Set<Long> handle(ResultSet rs) throws SQLException {
                HashSet<Long> idSet = new HashSet<Long>(16);
                int size = 0;
                while (rs.next()) {
                    idSet.add(rs.getLong("fid"));
                    if (++size < 100000) continue;
                    break;
                }
                return idSet;
            }
        };
        DBRoute dbRoute = new DBRoute(dbRouteKey);
        BOTPLogService service = new BOTPLogService();
        for (int count = 0; count < 100; ++count) {
            Set tcLogIds = (Set)DB.query((DBRoute)dbRoute, (SqlBuilder)sqlBuilder, (ResultSetHandler)action);
            if (tcLogIds.isEmpty()) break;
            service.delete(dbRouteKey, tcLogIds.toArray(new Long[0]));
        }
    }

    private Date calcBeforeTime(int beforeDays) {
        long beforeTime = beforeDays * 86400000;
        return new Date(this.currTime.getTime() - beforeTime);
    }
}

