/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.botp;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.operate.IEntityOperate;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.BOTPLogServiceHelper;
import kd.bos.util.HttpClientUtils;
import kd.bos.util.JSONUtils;

public class BotpLogListPlugin
extends AbstractListPlugin {
    private static final Log LOG = LogFactory.getLog(BotpLogListPlugin.class);
    private static final String BOS_BOTP_FORMPLUGIN = "bos-botp-formplugin";
    private static final String KEY_DBROUTEKEY_ID = "dbroutekey.id";
    private static final String KEY_DBROUTEKEY_NUMBER = "dbroutekey.number";
    private static final String KEY_BAR_VIEW = "bar_view";
    private static final String OPKEY_FIXWB = "fixwb";
    private static final String OPKEY_CLEARLOG = "clearlog";
    private static final String CACHE_KEY_DBROUTEKEY = "dbroutekey";
    private static final String CACHE_KEY_DBLIST = "dblist";
    private String dbRouteKey;
    private BOTPLogListDataProvider listDataProvider;

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if (e.getOperationResult() != null && e.getOperationResult().isSuccess()) {
            if (StringUtils.equalsIgnoreCase((CharSequence)e.getOperateKey(), (CharSequence)OPKEY_FIXWB)) {
                HashSet<Long> wbLogIds = new HashSet<Long>();
                for (ListSelectedRow selectedRow : this.getSelectedRows()) {
                    wbLogIds.add((Long)selectedRow.getPrimaryKeyValue());
                }
                if (wbLogIds.isEmpty()) {
                    OperateErrorInfo errorInfo = new OperateErrorInfo("nodata", ErrorLevel.Error, null);
                    errorInfo.setMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u672a\u5b8c\u6210\u7684\u53cd\u5199\u9700\u6c42\uff0c\u7136\u540e\u518d\u8bd5\u3002", (String)"BotpLogListPlugin_0", (String)BOS_BOTP_FORMPLUGIN, (Object[])new Object[0]));
                    e.getOperationResult().addErrorInfo(errorInfo);
                    e.getOperationResult().setShowMessage(true);
                    return;
                }
                String dbRoute = this.getPageCache().get(CACHE_KEY_DBROUTEKEY);
                if (StringUtils.isBlank((CharSequence)dbRoute)) {
                    dbRoute = DBRoute.main.getRouteKey();
                }
                OperationResult opResult = BOTPLogServiceHelper.retryWriteBack((String)dbRoute, (Long[])wbLogIds.toArray(new Long[0]), (OperateOption)OperateOption.create());
                e.getOperationResult().setBillCount(opResult.getBillCount());
                e.getOperationResult().getSuccessPkIds().clear();
                e.getOperationResult().getSuccessPkIds().addAll(opResult.getSuccessPkIds());
                e.getOperationResult().getAllErrorInfo().addAll(opResult.getAllErrorInfo());
                e.getOperationResult().setShowMessage(true);
                if (!opResult.getSuccessPkIds().isEmpty()) {
                    IEntityOperate op = (IEntityOperate)e.getSource();
                    op.setCancelRefresh(false);
                }
            } else if (StringUtils.equalsIgnoreCase((CharSequence)e.getOperateKey(), (CharSequence)OPKEY_CLEARLOG)) {
                this.dispatchClearLogTask();
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)OPKEY_CLEARLOG)) {
            ((IListView)this.getView()).refresh();
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (StringUtils.equals((CharSequence)evt.getItemKey(), (CharSequence)KEY_BAR_VIEW)) {
            this.showLog();
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        List filterColumnList = args.getFilterContainerInitEvent().getCommonFilterColumns();
        for (FilterColumn filterCol : filterColumnList) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)filterCol.getFieldName(), (CharSequence)KEY_DBROUTEKEY_NUMBER) || !(filterCol instanceof CommonFilterColumn)) continue;
            CommonFilterColumn dbRouteFilter = (CommonFilterColumn)filterCol;
            Map<String, String> dbRoutes = this.getDbInstanceList();
            for (ComboItem item : dbRouteFilter.getComboItems()) {
                if (item.getCaption() == null) continue;
                String number = item.getCaption().toString().trim();
                String name = dbRoutes.get(number);
                if (name != null) {
                    item.setCaption(new LocaleString(name));
                }
                dbRouteFilter.setDefaultValue(item.getValue());
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        ArrayList<QFilter> list = new ArrayList<QFilter>(4);
        for (int i = e.getQFilters().size() - 1; i >= 0; --i) {
            QFilter[] filters = ((QFilter)e.getQFilters().get(i)).recombine();
            for (int j = 0; j < filters.length; ++j) {
                if (StringUtils.equals((CharSequence)filters[j].getProperty(), (CharSequence)KEY_DBROUTEKEY_ID)) {
                    DynamicObject logDB;
                    Object dbId = filters[j].getValue();
                    if (dbId != null && (logDB = BusinessDataServiceHelper.loadSingleFromCache((Object)dbId, (String)"botp_logdb")) != null) {
                        this.dbRouteKey = logDB.getString("number");
                        if (this.listDataProvider != null) {
                            this.listDataProvider.setDbRoutekey(this.dbRouteKey);
                        }
                        this.getPageCache().put(CACHE_KEY_DBROUTEKEY, this.dbRouteKey);
                    }
                    e.getQFilters().remove(i);
                    continue;
                }
                list.add(filters[j]);
            }
        }
        e.getQFilters().addAll(list);
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        this.listDataProvider = new BOTPLogListDataProvider();
        if (StringUtils.isNotBlank((CharSequence)this.dbRouteKey)) {
            this.listDataProvider.setDbRoutekey(this.dbRouteKey);
        }
        args.setListDataProvider((IListDataProvider)this.listDataProvider);
    }

    private void dispatchClearLogTask() {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId("bos");
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        jobInfo.setlName(new LocaleString("clear_botp_log"));
        jobInfo.setId("1ZA+DD0R9H7R");
        jobInfo.setTaskDefineId("1ZA+MR+D0O/A");
        jobInfo.setTaskClassname("kd.bos.form.plugin.botp.BotpLogClearTask");
        HashMap params = new HashMap();
        jobInfo.setParams(params);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, OPKEY_CLEARLOG);
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setCaption(ResManager.loadKDString((String)"\u6e05\u7406\u8fc7\u671f\u65e5\u5fd7", (String)"BotpLogListPlugin_3", (String)BOS_BOTP_FORMPLUGIN, (Object[])new Object[0]));
        jobFormInfo.setCloseCallBack(closeCallBack);
        jobFormInfo.setCanBackground(true);
        jobFormInfo.setCanStop(true);
        JobForm.dispatch((JobFormInfo)jobFormInfo, (IFormView)this.getView());
    }

    private void showLog() {
        IListView view = (IListView)this.getView();
        if (view.getCurrentSelectedRowInfo() == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u67e5\u770b\u7684\u65e5\u5fd7\u3002", (String)"BotpLogListPlugin_1", (String)BOS_BOTP_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        if (view.getSelectedRows().size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u52fe\u9009\u5355\u6761\u67e5\u770b\u3002", (String)"BotpLogListPlugin_2", (String)BOS_BOTP_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        Object logId = view.getCurrentSelectedRowInfo().getPrimaryKeyValue();
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.setFormId(view.getBillFormId());
        billShowParameter.setPkId(logId);
        billShowParameter.setBillStatus(BillOperationStatus.VIEW);
        billShowParameter.setHasRight(true);
        billShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        String dbRouteKey = this.getPageCache().get(CACHE_KEY_DBROUTEKEY);
        billShowParameter.getCustomParams().put("botp_log_dbroutekey", dbRouteKey);
        this.getView().showForm((FormShowParameter)billShowParameter);
    }

    private Map<String, String> getDbInstanceList() {
        String cacheValue = this.getPageCache().get(CACHE_KEY_DBLIST);
        if (StringUtils.isNotBlank((CharSequence)cacheValue)) {
            return (Map)SerializationUtils.fromJsonString((String)cacheValue, Map.class);
        }
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-type", "application/json;charset=UTF-8");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("dataCenterId", RequestContext.get().getAccountId());
        String host = System.getProperty("mc.server.url");
        JSONArray data = new JSONArray();
        if (StringUtils.isNotBlank((CharSequence)host)) {
            try {
                JSONObject resp;
                String e = JSONUtils.toString(params);
                String sHttpResponse = HttpClientUtils.postjson((String)(host + "/kapi/app/mc/GetDbInstanceListService"), header, (String)e);
                if (StringUtils.isNotBlank((CharSequence)sHttpResponse) && (resp = JSONObject.parseObject((String)sHttpResponse)).getInteger("errorcode") == 100) {
                    data = resp.getJSONArray("data");
                }
            }
            catch (Exception arg6) {
                LOG.error("getDbInstanceList\uff1a" + arg6.getMessage(), (Throwable)arg6);
            }
        }
        HashMap<String, String> map = new HashMap<String, String>();
        if (data.size() > 0) {
            for (Object instance : data) {
                JSONObject image = (JSONObject)instance;
                String number = (String)image.get((Object)"number");
                String name = (String)image.get((Object)"name");
                map.put(number, name);
            }
        }
        cacheValue = SerializationUtils.toJsonString(map);
        this.getPageCache().put(CACHE_KEY_DBLIST, cacheValue);
        return map;
    }

    static class BOTPLogListDataProvider
    extends ListDataProvider {
        private String dbRoutekey;

        BOTPLogListDataProvider() {
        }

        public String getDbRoutekey() {
            return this.dbRoutekey;
        }

        public void setDbRoutekey(String dbRoutekey) {
            this.dbRoutekey = dbRoutekey;
        }

        public DynamicObjectCollection getData(int start, int end) {
            if (StringUtils.isNotBlank((CharSequence)this.dbRoutekey)) {
                this.changeDBRoute();
                DynamicObjectCollection rows = super.getData(start, end);
                return rows;
            }
            return new DynamicObjectCollection((DynamicObjectType)((MainEntityType)this.getQueryBuilder().getReturnEntityType()), null);
        }

        public int getRealCount() {
            if (StringUtils.isNotBlank((CharSequence)this.dbRoutekey)) {
                this.changeDBRoute();
                return super.getRealCount();
            }
            return 0;
        }

        public int getMaxCount() {
            if (StringUtils.isNotBlank((CharSequence)this.dbRoutekey)) {
                this.changeDBRoute();
                return super.getMaxCount();
            }
            return 0;
        }

        private void changeDBRoute() {
            if (!StringUtils.equals((CharSequence)this.dbRoutekey, (CharSequence)this.getEntityType().getDBRouteKey())) {
                try {
                    MainEntityType cloneMainType = (MainEntityType)this.getQueryBuilder().getEntityType().clone();
                    cloneMainType.setDBRouteKey(this.dbRoutekey);
                    this.getQueryBuilder().setEntityType((IDataEntityType)cloneMainType);
                    this.setEntityType((EntityType)cloneMainType);
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    // empty catch block
                }
            }
        }
    }
}

