/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.botp;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.data.ParameterHelper;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.ConvertBill;
import kd.bos.entity.botp.ConvertOpType;
import kd.bos.entity.botp.runtime.BeforeDrawArgs;
import kd.bos.entity.botp.runtime.BeforeDrawOpResult;
import kd.bos.entity.botp.runtime.ConvertOpParameter;
import kd.bos.entity.botp.runtime.ConvertOpRule;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.param.BillParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.Steps;
import kd.bos.form.control.events.PullRefreshEvent;
import kd.bos.form.control.events.PullRefreshListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.botp.layout.BotpLayoutManager;
import kd.bos.form.plugin.botp.layout.LayoutConfigItem;
import kd.bos.list.ListShowParameter;
import kd.bos.list.MobileList;
import kd.bos.list.MobileListShowParameter;
import kd.bos.list.events.EndSelectEvent;
import kd.bos.list.events.ListSelectedListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.cardentry.CardEntryFieldAp;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import org.apache.commons.collections4.CollectionUtils;

public class ConvertOpMobFormEdit
extends AbstractFormPlugin
implements PullRefreshListener,
ListSelectedListener {
    private static Log log = LogFactory.getLog(ConvertOpMobFormEdit.class);
    private static final String RULEID_LIST = "ruleIdList";
    private static final String SOURCE_BILL = "sourceBill";
    private static final String RULE_ID = "ruleId";
    private static final String MOB_FORM_SHOW_PARAMETER = "mobFormShowParameter";
    private static final String STEPSAP = "stepsap";
    private static final String FILTER_PARAMETER = "listFilterParameter";
    private static final String PRIMARY_FIELD = "primaryField";
    private static final String SECOND_FIELD = "secondField";
    private static final String ICON_FIELD = "iconField";
    private static final String SHOW_MODAL = "showModal";
    private static final String PAGE_ROW = "pageRow";
    private static final String SHOW_FREQUENT = "showFrequent";
    private static final String CANCEL = "cancel";
    private static final String UPSTEP_1 = "upstep1";
    private static final String NEXTSTEP_1 = "nextstep1";
    private static final String CREATE = "create";
    private static final String UPSTEP_2 = "upstep2";
    private static final String NEXTSTEP_2 = "nextstep2";
    private static final String MTOOLBARAP = "mtoolbarap";
    private static final String FLEXPANELAP = "flexpanelap";
    private static final String MOBILELISTAP = "mobilelistap";
    private static final String ENTRYENTITY = "entryentity";
    private static final String ENTRYENTITY1 = "entryentity1";
    private static final String CARDENTRYROW = "cardentryrowap";
    private static final String CARDENTRYROW1 = "cardentryrowap1";
    private final String RADIOGROUPFIELD = "radiogroupfield";
    private final String RADIOGROUPFIELD1 = "radiogroupfield1";
    private static final String CUSTPARAM_OPPARAM = "opparam";
    private static final String PANELRADIO1 = "panelradio1";
    private static final String HIDEDRAWFORM = "hideDrawForm";
    private ConvertOpParameter opParameter;
    private static final String BOS_FORM_BUSINESS = "bos-botp-formplugin";
    private BotpLayoutManager botpLayoutManager = new BotpLayoutManager();

    public void initialize() {
        super.initialize();
        String sourceBill = this.getPageCache().get(SOURCE_BILL);
        String ruleId = this.getPageCache().get(RULE_ID);
        String paramStr = this.getPageCache().get(MOB_FORM_SHOW_PARAMETER);
        if (StringUtils.isNotBlank((CharSequence)sourceBill) && StringUtils.isNotBlank((CharSequence)ruleId) && StringUtils.isNotBlank((CharSequence)paramStr)) {
            Map mobParamMap = (Map)SerializationUtils.fromJsonString((String)paramStr, Map.class);
            this.initMobileList(sourceBill, mobParamMap);
        } else {
            String defSourceBill = this.getConvertOpParamter().getDefSourceBill();
            FormShowParameter param = this.getView().getFormShowParameter();
            this.initMobileList(defSourceBill, param, true);
        }
    }

    private void initMobileList(String formId, FormShowParameter parameter, boolean isInit) {
        ListShowParameter listFilterParameter;
        if (isInit) {
            String listFilterParameterString = (String)parameter.getCustomParam(FILTER_PARAMETER);
            listFilterParameter = this.getListFilterParameter(listFilterParameterString);
        } else {
            listFilterParameter = (ListShowParameter)parameter.getCustomParam(FILTER_PARAMETER);
        }
        String primaryField = (String)parameter.getCustomParam(PRIMARY_FIELD);
        String secondField = (String)parameter.getCustomParam(SECOND_FIELD);
        String iconField = (String)parameter.getCustomParam(ICON_FIELD);
        Object modal = parameter.getCustomParam(SHOW_MODAL);
        boolean showModal = modal == null ? false : (Boolean)modal;
        int pageRow = (Integer)parameter.getCustomParam(PAGE_ROW);
        Object isShowFrequent = parameter.getCustomParam(SHOW_FREQUENT);
        boolean showFrequent = isShowFrequent == null ? false : (Boolean)isShowFrequent;
        this.showMobileList(formId, listFilterParameter, primaryField, secondField, iconField, showModal, pageRow, showFrequent);
    }

    private void initMobileList(String formId, Map<String, Object> mobParamMap) {
        String listFilterParameterStr = (String)mobParamMap.get(FILTER_PARAMETER);
        ListShowParameter listFilterParameter = this.getListFilterParameter(listFilterParameterStr);
        String primaryField = (String)mobParamMap.get(PRIMARY_FIELD);
        String secondField = (String)mobParamMap.get(SECOND_FIELD);
        String iconField = (String)mobParamMap.get(ICON_FIELD);
        Object modal = mobParamMap.get(SHOW_MODAL);
        boolean showModal = modal == null ? false : (Boolean)modal;
        int pageRow = (Integer)mobParamMap.get(PAGE_ROW);
        Object isShowFrequent = mobParamMap.get(SHOW_FREQUENT);
        boolean showFrequent = isShowFrequent == null ? false : (Boolean)isShowFrequent;
        this.showMobileList(formId, listFilterParameter, primaryField, secondField, iconField, showModal, pageRow, showFrequent);
    }

    private void showMobileList(String formId, ListShowParameter listFilterParameter, String primaryField, String secondField, String iconField, boolean showModal, int pageRow, boolean showFrequent) {
        MobileList mobileList = (MobileList)this.getControl(MOBILELISTAP);
        mobileList.setMulti(listFilterParameter.isMultiSelect());
        mobileList.setBillFormId(formId);
        mobileList.setListShowParameter(listFilterParameter);
        mobileList.setPrimaryField(primaryField);
        mobileList.setSecondField(secondField);
        mobileList.setIconField(iconField);
        mobileList.setShowModal(showModal);
        mobileList.setPageRow(pageRow);
        mobileList.setShowFrequent(showFrequent);
    }

    public void click(EventObject evt) {
        String entityNumber;
        super.click(evt);
        Control srcCtrl = (Control)evt.getSource();
        if (NEXTSTEP_1.equalsIgnoreCase(srcCtrl.getKey())) {
            this.setStep(1);
            this.opParameter = this.getConvertOpParamter();
            entityNumber = this.botpLayoutManager.getBillItemValue(this.getModel(), "radiogroupfield");
            if (StringUtils.isBlank((CharSequence)entityNumber)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6e90\u5355\u636e\u3002", (String)"ConvertOpMobFormEdit_0", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
                return;
            }
            this.getPageCache().put(SOURCE_BILL, entityNumber);
            FlexPanelAp flexPanelAp = this.createRuleFlexPanel(entityNumber);
            this.creatRadioPanel(flexPanelAp, CARDENTRYROW1);
            this.getView().setVisible(Boolean.FALSE, new String[]{ENTRYENTITY, CANCEL, NEXTSTEP_1, CREATE, UPSTEP_2});
            this.getView().setVisible(Boolean.TRUE, new String[]{ENTRYENTITY1, UPSTEP_1, NEXTSTEP_2});
        }
        if (NEXTSTEP_2.equalsIgnoreCase(srcCtrl.getKey())) {
            this.setStep(2);
            String ruleNumber = (String)this.getModel().getValue("radiogroupfield1");
            if (StringUtils.isBlank((CharSequence)ruleNumber)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8f6c\u6362\u89c4\u5219\u3002", (String)"ConvertOpMobFormEdit_1", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
                return;
            }
            this.getPageCache().put(RULE_ID, ruleNumber);
            this.opParameter = this.getConvertOpParamter();
            String sourceBill = this.getPageCache().get(SOURCE_BILL);
            if (sourceBill == null) {
                log.error("please select sourcebill...");
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6e90\u5355\u636e\u3002", (String)"ConvertOpMobFormEdit_0", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
                return;
            }
            MobileFormShowParameter mobFormShowParameter = this.doBeforeDraw(sourceBill, ruleNumber, this.opParameter);
            this.initMobileList(sourceBill, (FormShowParameter)mobFormShowParameter, false);
            this.opParameter.setDefSourceBill(sourceBill);
            this.opParameter.setDefRuleId(ruleNumber);
            String callBackActionId = (String)this.getView().getFormShowParameter().getCustomParam("callBackActionId");
            IPageCache pageCache = (IPageCache)this.getView().getParentView().getService(IPageCache.class);
            pageCache.put(callBackActionId, SerializationUtils.toJsonString((Object)this.opParameter));
            this.getView().setVisible(Boolean.TRUE, new String[]{FLEXPANELAP});
            this.getView().updateView(FLEXPANELAP);
            this.getView().setVisible(Boolean.FALSE, new String[]{ENTRYENTITY1, CANCEL, UPSTEP_1, NEXTSTEP_1, CREATE, UPSTEP_2, NEXTSTEP_2, MTOOLBARAP});
            this.getModel().updateCache();
        }
        if (UPSTEP_1.equalsIgnoreCase(srcCtrl.getKey())) {
            Container radioPanel = (Container)this.getView().getControl(CARDENTRYROW1);
            String ruleIds = this.getPageCache().get(RULEID_LIST);
            List ruleIdList = (List)SerializationUtils.fromJsonString((String)ruleIds, List.class);
            for (String ruleId : ruleIdList) {
                radioPanel.deleteControls(new String[]{ruleId});
            }
            this.setStep(0);
            this.getView().setVisible(Boolean.FALSE, new String[]{FLEXPANELAP, ENTRYENTITY1, UPSTEP_1, CREATE, UPSTEP_2, NEXTSTEP_2});
            this.getView().setVisible(Boolean.TRUE, new String[]{ENTRYENTITY, CANCEL, NEXTSTEP_1});
            this.getView().updateView(MTOOLBARAP);
            this.getView().updateView(ENTRYENTITY1);
            this.getModel().setDataChanged(true);
            this.getModel().updateCache();
        }
        if (CREATE.equalsIgnoreCase(srcCtrl.getKey())) {
            entityNumber = this.botpLayoutManager.getBillItemValue(this.getModel(), "radiogroupfield");
            String ruleNumber = (String)this.getModel().getValue("radiogroupfield1");
            log.info("\u79fb\u52a8\u9009\u5355-\u6e90\u5355\u7f16\u7801\uff1a" + entityNumber + ", \u8f6c\u6362\u89c4\u5219ID\uff1a" + ruleNumber);
        }
    }

    public void afterCreateNewData(EventObject e) {
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FlexPanelAp flexPanel = this.createTypeFlexPanel();
        this.creatRadioPanel(flexPanel, CARDENTRYROW);
        this.getModel().updateCache();
        if (this.isHideDrawForm()) {
            String defSourceBill = this.getConvertOpParamter().getDefSourceBill();
            String defRuleId = this.getConvertOpParamter().getDefRuleId();
            this.getPageCache().put(SOURCE_BILL, defSourceBill);
            this.getPageCache().put(RULE_ID, defRuleId);
            this.getView().setVisible(Boolean.FALSE, new String[]{STEPSAP, UPSTEP_1, UPSTEP_2, ENTRYENTITY, ENTRYENTITY1, NEXTSTEP_1, NEXTSTEP_2, MTOOLBARAP});
            this.getView().setVisible(Boolean.TRUE, new String[]{FLEXPANELAP});
            this.getView().updateView(FLEXPANELAP);
            MobileFormShowParameter mobFormShowParameter = this.doBeforeDraw(defSourceBill, defRuleId, this.opParameter);
            this.initMobileList(defSourceBill, (FormShowParameter)mobFormShowParameter, false);
        } else {
            this.setStep(0);
            this.getView().setVisible(Boolean.FALSE, new String[]{FLEXPANELAP, UPSTEP_1, CREATE, UPSTEP_2, NEXTSTEP_2});
            this.getView().setVisible(Boolean.TRUE, new String[]{CANCEL, NEXTSTEP_1});
        }
        if (StringUtils.isNotBlank((CharSequence)this.getConvertOpParamter().getSrcDefSourceBill())) {
            this.botpLayoutManager.setDefaultRadiGroupItem(this.getConvertOpParamter().getSrcDefSourceBill(), flexPanel.getItems(), this.getModel(), "radiogroupfield");
            this.getModel().setValue("radiogroupfield1", (Object)this.getConvertOpParamter().getSrcDefRuleId());
        }
    }

    private void creatRadioPanel(FlexPanelAp dynamicPanel, String cardentryrow) {
        Container radioPanel = (Container)this.getView().getControl(cardentryrow);
        Map runtimeMeta = dynamicPanel.createControl();
        List runtimeRadios = (List)runtimeMeta.get("items");
        radioPanel.addControls(runtimeRadios);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        MobileList mobileList = (MobileList)this.getControl(MOBILELISTAP);
        mobileList.addListSelectedListener((ListSelectedListener)this);
        this.addClickListeners(new String[]{NEXTSTEP_1, NEXTSTEP_2, CANCEL, UPSTEP_1, UPSTEP_2, CREATE});
    }

    public void pullRefesh(PullRefreshEvent pullRefreshEvent) {
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
    }

    private ConvertOpParameter getConvertOpParamter() {
        if (this.opParameter == null) {
            String opParamJson = (String)this.getView().getFormShowParameter().getCustomParam(CUSTPARAM_OPPARAM);
            if (StringUtils.isNotBlank((CharSequence)opParamJson)) {
                this.opParameter = (ConvertOpParameter)SerializationUtils.fromJsonString((String)opParamJson, ConvertOpParameter.class);
            } else {
                this.opParameter = new ConvertOpParameter();
                this.opParameter.setOpType(ConvertOpType.Push);
            }
        }
        return this.opParameter;
    }

    private boolean isHideDrawForm() {
        return (Boolean)this.getView().getFormShowParameter().getCustomParam(HIDEDRAWFORM);
    }

    private FlexPanelAp createTypeFlexPanel() {
        FlexPanelAp headPanelAp = new FlexPanelAp();
        headPanelAp.setKey(PANELRADIO1);
        ConvertOpParameter convertOpParamter = this.getConvertOpParamter();
        List convertBills = convertOpParamter.getBills();
        List<LayoutConfigItem> layoutConfigItemList = this.botpLayoutManager.queryLayoutConfig(this.opParameter.getEntityNumber(), "pushdrawlayoutconfigdata");
        Map<String, LayoutConfigItem> billLayoutConfigMapping = this.botpLayoutManager.groupLayoutConfigMapping(layoutConfigItemList);
        for (ConvertBill convertBill : convertBills) {
            String entityNumber = convertBill.getEntityNumber();
            String entityName = convertBill.getEntityName();
            if (CollectionUtils.isNotEmpty(layoutConfigItemList)) {
                List<CardEntryFieldAp> layoutItemList = this.botpLayoutManager.replaceLayoutName(convertBill.getEntityNumber(), billLayoutConfigMapping, this.opParameter, false, "radiogroupfield", this.getPageCache());
                if (CollectionUtils.isNotEmpty(layoutItemList)) {
                    headPanelAp.getItems().addAll(layoutItemList);
                    continue;
                }
                CardEntryFieldAp radioAp = this.botpLayoutManager.getRadioField(entityNumber, entityName, "radiogroupfield");
                headPanelAp.getItems().add(radioAp);
                continue;
            }
            CardEntryFieldAp radioAp = this.botpLayoutManager.getRadioField(entityNumber, entityName, "radiogroupfield");
            headPanelAp.getItems().add(radioAp);
        }
        return headPanelAp;
    }

    private FlexPanelAp createRuleFlexPanel(String entityNumber_sel) {
        FlexPanelAp headPanelAp = new FlexPanelAp();
        headPanelAp.setKey(PANELRADIO1);
        ConvertOpParameter convertOpParamter = this.getConvertOpParamter();
        List convertBills = convertOpParamter.getBills();
        ArrayList<String> ruleIdList = new ArrayList<String>(10);
        for (ConvertBill convertBill : convertBills) {
            List rules;
            String entityNumber = convertBill.getEntityNumber();
            if (!entityNumber_sel.equals(entityNumber) || (rules = convertBill.getRules()) == null || rules.size() <= 0) continue;
            for (ConvertOpRule rule : rules) {
                if (!rule.isVisibled()) continue;
                String ruleId = rule.getRuleId();
                String ruleName = rule.getRuleName();
                CardEntryFieldAp radioAp = this.botpLayoutManager.getRadioField(ruleId, ruleName, "radiogroupfield1");
                headPanelAp.getItems().add(radioAp);
                ruleIdList.add(ruleId);
                this.getModel().setItemValueByID(ruleId, (Object)0);
            }
        }
        this.getPageCache().put(RULEID_LIST, SerializationUtils.toJsonString(ruleIdList));
        return headPanelAp;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        this.getView().close();
    }

    private void setStep(int step) {
        Steps steps = (Steps)this.getControl(STEPSAP);
        HashMap<String, Object> currentStepMap = new HashMap<String, Object>();
        currentStepMap.put("currentStep", step);
        currentStepMap.put("currentStatus", "process");
        steps.setCurrentStep(currentStepMap);
    }

    private ListShowParameter getListFilterParameter(String serializeString) {
        ArrayList<IDataEntityType> dataEntityTypes = new ArrayList<IDataEntityType>(10);
        dataEntityTypes.add(OrmUtils.getDataEntityType(ListShowParameter.class));
        dataEntityTypes.add(OrmUtils.getDataEntityType(MobileListShowParameter.class));
        dataEntityTypes.add(OrmUtils.getDataEntityType(ListSelectedRowCollection.class));
        dataEntityTypes.add(OrmUtils.getDataEntityType(ListSelectedRow.class));
        DcJsonSerializer dcJsonSerializer = new DcJsonSerializer(dataEntityTypes);
        return (ListShowParameter)dcJsonSerializer.deserializeFromString(serializeString, null);
    }

    public void endSelect(EndSelectEvent evt) {
        this.getView().returnDataToParent(evt.getData());
        this.getView().close();
    }

    private MobileFormShowParameter doBeforeDraw(String sourceEntityNumber, String ruleId, ConvertOpParameter opParameter) {
        BeforeDrawArgs args = new BeforeDrawArgs();
        args.setSourceEntityNumber(sourceEntityNumber);
        args.setTargetEntityNumber(opParameter.getEntityNumber());
        args.setTargetPageId(opParameter.getTargetBillPageId());
        args.setRuleId(ruleId);
        args.setDuplicateRemove(((Boolean)this.getView().getFormShowParameter().getCustomParam("duplicateremove")).booleanValue());
        args.setDuplicateEntryRemove(((Boolean)this.getView().getFormShowParameter().getCustomParam("duplicateentryremove")).booleanValue());
        args.getCustomParams().putAll(opParameter.getCustomParams());
        ConvertOperationResult opResult = ConvertServiceHelper.beforeDraw((BeforeDrawArgs)args);
        BeforeDrawOpResult result = (BeforeDrawOpResult)opResult;
        if (!result.isSuccess()) {
            this.getView().showErrorNotification(result.getMessage());
            return null;
        }
        String filter = result.getDrawFilter();
        String sourceFormId = StringUtils.isNotBlank((CharSequence)result.getDrawSourceLayout()) ? result.getDrawSourceLayout() : sourceEntityNumber;
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)sourceFormId, (boolean)true);
        showParameter.getCustomParams().put("isIgnoreLicense", true);
        showParameter.getListFilterParameter().setQFilter(filter);
        if (result.getDrawSelectedEntity().size() > 0) {
            String selectEntity = (String)result.getDrawSelectedEntity().get(result.getDrawSelectedEntity().size() - 1);
            showParameter.getListFilterParameter().setSelectEntity(selectEntity);
            showParameter.getCustomParams().put("ismergerows", false);
        }
        if (result.getSrcMainOrgId() != null) {
            showParameter.setIsolationOrg(true);
            showParameter.setUseOrgId(result.getSrcMainOrgId().longValue());
        } else {
            showParameter.setIsolationOrg(false);
        }
        BillParam billParam = ParameterHelper.getBillParam((String)sourceEntityNumber);
        String primaryField = billParam.getMobileListF7Config().getPrimaryField();
        String secondField = billParam.getMobileListF7Config().getSecondField();
        String iconField = billParam.getMobileListF7Config().getIconField();
        boolean showModel = billParam.getMobileListF7Config().isShowModal();
        int pageRow = billParam.getMobileListF7Config().getPageRow();
        if (StringUtils.isBlank((CharSequence)primaryField)) {
            BillEntityType srcMainType = (BillEntityType)EntityMetadataCache.getDataEntityType((String)sourceEntityNumber);
            primaryField = srcMainType.getBillNo();
            secondField = srcMainType.getMainOrg();
        }
        MobileFormShowParameter para = new MobileFormShowParameter();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        para.setCaption(MOB_FORM_SHOW_PARAMETER);
        para.getOpenStyle().setShowType(ShowType.Floating);
        if (showModel) {
            para.getOpenStyle().setShowType(ShowType.Modal);
        }
        para.setCustomParam(FILTER_PARAMETER, (Object)showParameter);
        para.setCustomParam(PRIMARY_FIELD, (Object)primaryField);
        para.setCustomParam(SECOND_FIELD, (Object)secondField);
        para.setCustomParam(ICON_FIELD, (Object)iconField);
        para.setCustomParam(SHOW_MODAL, (Object)showModel);
        para.setCustomParam(PAGE_ROW, (Object)pageRow);
        paramMap.put(FILTER_PARAMETER, this.serializeListShowParameter(showParameter));
        paramMap.put(PRIMARY_FIELD, primaryField);
        paramMap.put(SECOND_FIELD, secondField);
        paramMap.put(ICON_FIELD, iconField);
        paramMap.put(SHOW_MODAL, showModel);
        paramMap.put(PAGE_ROW, pageRow);
        this.getPageCache().put(MOB_FORM_SHOW_PARAMETER, SerializationUtils.toJsonString(paramMap));
        return para;
    }

    private String serializeListShowParameter(ListShowParameter listShowParameter) {
        ArrayList<IDataEntityType> dataEntityTypes = new ArrayList<IDataEntityType>();
        dataEntityTypes.add(OrmUtils.getDataEntityType(ListShowParameter.class));
        dataEntityTypes.add(OrmUtils.getDataEntityType(MobileListShowParameter.class));
        dataEntityTypes.add(OrmUtils.getDataEntityType(ListSelectedRowCollection.class));
        dataEntityTypes.add(OrmUtils.getDataEntityType(ListSelectedRow.class));
        DcJsonSerializer dcJsonSerializer = new DcJsonSerializer(dataEntityTypes);
        return dcJsonSerializer.serializeToString((Object)listShowParameter, null);
    }
}

