/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.botp;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.SearchLinkBill;
import kd.bos.entity.botp.ctbotp.CtBotpLinkBill;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.entity.botp.runtime.BFRowComparator;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.botp.runtime.BFRowLinkDownNode;
import kd.bos.entity.botp.runtime.BFRowLinkUpNode;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.plugin.botp.util.LookUpTrackerUtil;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import org.apache.commons.collections4.MapUtils;

public class LookUpTrackerEdit
extends AbstractFormPlugin
implements TreeNodeClickListener {
    private static final Log log = LogFactory.getLog(LookUpTrackerEdit.class);
    private static final String CACHEKEY_PAGEIDS = "pageids";
    private static final String KEY_TABBILLS = "tabbills";
    private Map<Long, TableDefine> tableDefines = new HashMap<Long, TableDefine>();
    private Map<String, TableDefine> mainTableDefines = new HashMap<String, TableDefine>();
    private Map<String, String> childPageIds = new HashMap<String, String>();
    private Map<String, String> checkRightAppIds;

    private Map<String, String> getCheckRightAppIds() {
        if (this.checkRightAppIds == null) {
            String appIds = (String)this.getView().getFormShowParameter().getCustomParam("track_checkrightappids");
            this.checkRightAppIds = StringUtils.isBlank((CharSequence)appIds) ? new HashMap<String, String>() : (Map)SerializationUtils.fromJsonString((String)appIds, Map.class);
        }
        return this.checkRightAppIds;
    }

    private boolean isShowEditStatus() {
        boolean isEditStatus = false;
        String showStatusParam = (String)this.getView().getFormShowParameter().getCustomParam("botp_track_edit_status");
        if (StringUtils.isNotBlank((CharSequence)showStatusParam)) {
            isEditStatus = Boolean.parseBoolean(showStatusParam);
        }
        return isEditStatus;
    }

    private boolean isSearchEntry() {
        boolean isSearchEntry = false;
        Object searchEntry = this.getView().getFormShowParameter().getCustomParam("issearchentry");
        if (StringUtils.isNotBlank((Object)searchEntry)) {
            isSearchEntry = Boolean.parseBoolean(searchEntry.toString());
        }
        return isSearchEntry;
    }

    private List<String> getCustPlugins() {
        String custPlugParam = (String)this.getView().getFormShowParameter().getCustomParam("botp_track_cust_plugin");
        if (StringUtils.isBlank((CharSequence)custPlugParam)) {
            return new ArrayList<String>(0);
        }
        String[] custPlugClassNames = StringUtils.split((String)custPlugParam, (String)",");
        ArrayList<String> list = new ArrayList<String>(custPlugClassNames.length);
        for (String className : custPlugClassNames) {
            if (!StringUtils.isNotBlank((CharSequence)className) || list.contains(className)) continue;
            list.add(className);
        }
        return list;
    }

    public void initialize() {
        super.initialize();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.showAllList();
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String entityNumber = closedCallBackEvent.getActionId();
        String pageId = this.getPageId(entityNumber);
        if (StringUtils.isNotBlank((CharSequence)pageId)) {
            this.closePage(entityNumber);
        }
    }

    private void showAllList() {
        this.childPageIds.clear();
        if (!this.isSearchEntry()) {
            Map<Long, HashSet<Long>> mainTableIdMap = this.findMainTableIds();
            for (Map.Entry<Long, HashSet<Long>> entry : mainTableIdMap.entrySet()) {
                Long mainTableId = entry.getKey();
                HashSet<Long> billIds = entry.getValue();
                this.showList(mainTableId, billIds, null, false);
            }
            Map<String, List<CtBotpLinkBill>> ctBotpLinkMaps = this.getCtBotpLinkMaps();
            if (MapUtils.isNotEmpty(ctBotpLinkMaps)) {
                for (Map.Entry<String, List<CtBotpLinkBill>> entry : ctBotpLinkMaps.entrySet()) {
                    List<CtBotpLinkBill> ctBotpLinkBills = entry.getValue();
                    this.showCtBotpBillList(ctBotpLinkBills);
                }
            }
        } else {
            LookUpTrackerUtil lookUpTrackerUtil = new LookUpTrackerUtil(this, this.getView());
            Map<Long, SearchLinkBill> mainTableIds = lookUpTrackerUtil.findMainTableIds();
            for (Map.Entry<Long, SearchLinkBill> entry : mainTableIds.entrySet()) {
                if (entry == null || entry.getKey() == null || entry.getValue() == null) continue;
                Long mainTableId = entry.getKey();
                SearchLinkBill searchLinkBill = entry.getValue();
                this.showList(mainTableId, searchLinkBill.getBillIdList(), searchLinkBill, true);
            }
        }
        this.putPageIds(this.childPageIds);
    }

    private void showList(Long mainTableId, HashSet<Long> billIds, SearchLinkBill searchLinkBill, boolean isSearchEntry) {
        ListShowParameter showParameter;
        TableDefine tableDefine = this.loadTableDefine(mainTableId);
        if (tableDefine == null) {
            return;
        }
        String entityNumber = tableDefine.getEntityNumber();
        String pageId = this.getPageId(entityNumber);
        if (StringUtils.isNotBlank((CharSequence)pageId)) {
            return;
        }
        if (billIds == null || billIds.size() == 0) {
            return;
        }
        if (!isSearchEntry) {
            BillShowParameter showParameter2;
            String lookUpTrackerUseList = (String)this.getView().getFormShowParameter().getCustomParam("lookuptracker_use_list");
            if (billIds.size() == 1 && !Boolean.parseBoolean(lookUpTrackerUseList) && (showParameter2 = this.createBillShowParameter(entityNumber, billIds.iterator().next())) != null) {
                this.getView().showForm((FormShowParameter)showParameter2);
                this.childPageIds.put(entityNumber, showParameter2.getPageId());
                return;
            }
        }
        if ((showParameter = this.createShowParameter(entityNumber, billIds, searchLinkBill, isSearchEntry)) != null) {
            this.getView().showForm((FormShowParameter)showParameter);
            this.childPageIds.put(entityNumber, showParameter.getPageId());
        }
    }

    protected ListShowParameter createCtBotpShowParameter(String entityName, String entityNumber, HashSet<Long> billIds, String key) {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId(entityNumber);
        showParameter.getCustomParams().put("isIgnoreLicense", true);
        showParameter.getCustomParams().put("bos_call_source_type", "botp_track");
        String appId = this.getCheckRightAppIds().get(entityNumber);
        if (StringUtils.isNotBlank((CharSequence)appId)) {
            showParameter.getCustomParams().put("checkRightAppId", appId);
        }
        showParameter.getOpenStyle().setShowType(ShowType.NewTabPage);
        showParameter.getOpenStyle().setTargetKey(KEY_TABBILLS);
        showParameter.setShowTitle(false);
        String caption = String.format(ResManager.loadKDString((String)"%s(\u8de8\u79df\u6237)", (String)"LookUpTrackerEdit_3", (String)"bos-botp-formplugin", (Object[])new Object[0]), entityName);
        showParameter.setCaption(caption);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, key);
        showParameter.setCloseCallBack(closeCallBack);
        for (Long billId : billIds) {
            showParameter.addLinkQueryPkId((Object)billId);
        }
        showParameter.addCustPlugin("kd.bos.form.plugin.botp.LookUpTrackerList");
        List<String> custPlugins = this.getCustPlugins();
        if (!custPlugins.isEmpty()) {
            for (String custPlugin : custPlugins) {
                showParameter.addCustPlugin(custPlugin);
            }
        }
        showParameter.setHasRight(true);
        return showParameter;
    }

    private void showCtBotpBillList(List<CtBotpLinkBill> ctBotpLinkBills) {
        String key;
        String formId;
        String name;
        if (ctBotpLinkBills == null || ctBotpLinkBills.size() == 0) {
            return;
        }
        CtBotpLinkBill ctBotpLinkBill = ctBotpLinkBills.get(0);
        if (this.isLookUp()) {
            name = ctBotpLinkBill.getsEntityName();
            formId = "bos_ctbotp_trackup";
            key = ctBotpLinkBill.getsTenantCode() + ctBotpLinkBill.getsAccountId() + ctBotpLinkBill.getsEntityKey();
        } else if (this.isLookDown()) {
            name = ctBotpLinkBills.get(0).gettEntityName();
            formId = "bos_ctbotp_trackdown";
            key = ctBotpLinkBill.gettTenantCode() + ctBotpLinkBill.gettAccountId() + ctBotpLinkBill.gettEntityKey();
        } else {
            return;
        }
        log.info("\u67e5\u8be2\u8de8\u79df\u6237\u5173\u8054\u5173\u7cfb\uff0cfromid:" + formId + "name:" + name + "key:" + key);
        HashSet idList = (HashSet)ctBotpLinkBills.stream().map(a -> a.getId()).collect(Collectors.toSet());
        String pageId = this.getPageId(key);
        if (StringUtils.isNotBlank((CharSequence)pageId)) {
            return;
        }
        if (idList == null || idList.size() == 0) {
            return;
        }
        ListShowParameter showParameter = this.createCtBotpShowParameter(name, formId, idList, key);
        if (showParameter != null) {
            this.getView().showForm((FormShowParameter)showParameter);
            this.childPageIds.put(key, showParameter.getPageId());
        }
    }

    protected BillShowParameter createBillShowParameter(String entityNumber, Long billId) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId(entityNumber);
        showParameter.getCustomParams().put("isIgnoreLicense", true);
        showParameter.getCustomParams().put("bos_call_source_type", "botp_track");
        String appId = this.getCheckRightAppIds().get(entityNumber);
        if (StringUtils.isNotBlank((CharSequence)appId)) {
            showParameter.getCustomParams().put("checkRightAppId", appId);
        }
        showParameter.setPkId((Object)billId);
        boolean isEditStatus = this.isShowEditStatus();
        if (isEditStatus) {
            showParameter.setStatus(OperationStatus.EDIT);
        } else {
            showParameter.setStatus(OperationStatus.VIEW);
            showParameter.setShowTitle(false);
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            showParameter.setCaption(String.format(ResManager.loadKDString((String)"%1$s%2$s\u67e5\u770b", (String)"LookUpTrackerEdit_2", (String)"bos-botp-formplugin", (Object[])new Object[0]), mainType.getDisplayName().toString(), " - "));
        }
        showParameter.getOpenStyle().setShowType(ShowType.NewTabPage);
        showParameter.getOpenStyle().setTargetKey(KEY_TABBILLS);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, entityNumber);
        showParameter.setCloseCallBack(closeCallBack);
        List<String> custPlugins = this.getCustPlugins();
        if (!custPlugins.isEmpty()) {
            for (String custPlugin : custPlugins) {
                showParameter.addCustPlugin(custPlugin);
            }
        }
        showParameter.setHasRight(true);
        return showParameter;
    }

    protected ListShowParameter createShowParameter(String entityNumber, HashSet<Long> billIds, SearchLinkBill searchLinkBill, boolean isSearchEntry) {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId(entityNumber);
        showParameter.getCustomParams().put("isIgnoreLicense", true);
        showParameter.getCustomParams().put("bos_call_source_type", "botp_track");
        String appId = this.getCheckRightAppIds().get(entityNumber);
        if (StringUtils.isNotBlank((CharSequence)appId)) {
            showParameter.getCustomParams().put("checkRightAppId", appId);
        }
        showParameter.getOpenStyle().setShowType(ShowType.NewTabPage);
        showParameter.getOpenStyle().setTargetKey(KEY_TABBILLS);
        showParameter.setShowTitle(false);
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        showParameter.setCaption(mainType.getDisplayName().toString());
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, entityNumber);
        showParameter.setCloseCallBack(closeCallBack);
        if (isSearchEntry) {
            showParameter.getCustomParams().put("lookUpBillEntry", searchLinkBill);
            showParameter.getCustomParams().put("issearchentry", true);
        }
        for (Long billId : billIds) {
            showParameter.addLinkQueryPkId((Object)billId);
        }
        showParameter.addCustPlugin("kd.bos.form.plugin.botp.LookUpTrackerList");
        List<String> custPlugins = this.getCustPlugins();
        if (!custPlugins.isEmpty()) {
            for (String custPlugin : custPlugins) {
                showParameter.addCustPlugin(custPlugin);
            }
        }
        showParameter.setHasRight(true);
        return showParameter;
    }

    private Map<Long, HashSet<Long>> findMainTableIds() {
        if (this.isLookDown()) {
            return this.findLookDownMainTableIds();
        }
        if (this.isLookUp()) {
            return this.findLookUpMainTableIds();
        }
        return this.findLookAllMainTableIds();
    }

    private Map<Long, HashSet<Long>> findLookUpMainTableIds() {
        List rows = BFRowComparator.compareLinkUpNodes(this.getLinkUpNodes());
        LinkedHashMap<Long, HashSet<Long>> sourceTableIds = new LinkedHashMap<Long, HashSet<Long>>();
        for (BFRow row : rows) {
            BFRowId rowId = row.getSId();
            this.addTableBillId(sourceTableIds, rowId);
        }
        return sourceTableIds;
    }

    private Map<Long, HashSet<Long>> findLookDownMainTableIds() {
        List<BFRowLinkDownNode> linkDownNodes = this.getLinkDownNodes();
        ArrayList targetNodes = new ArrayList();
        for (BFRowLinkDownNode node : linkDownNodes) {
            targetNodes.addAll(node.findAllChildNodes());
        }
        LinkedHashMap<Long, HashSet<Long>> targetTableIds = new LinkedHashMap<Long, HashSet<Long>>();
        for (BFRowLinkDownNode targetNode : targetNodes) {
            BFRowId rowId = targetNode.getRowId();
            this.addTableBillId(targetTableIds, rowId);
        }
        return targetTableIds;
    }

    private Map<Long, HashSet<Long>> findLookAllMainTableIds() {
        List<BFRow> allRows = this.getAllBFRows();
        LinkedHashMap<Long, HashSet<Long>> allTableBillIds = new LinkedHashMap<Long, HashSet<Long>>();
        for (BFRow row : allRows) {
            BFRowId sRowId = row.getSId();
            this.addTableBillId(allTableBillIds, sRowId);
            BFRowId tRowId = row.getId();
            this.addTableBillId(allTableBillIds, tRowId);
        }
        return allTableBillIds;
    }

    public void addTableBillId(Map<Long, HashSet<Long>> allTableBillIds, BFRowId rowId) {
        Long mainTableId = rowId.getMainTableId();
        Long billId = rowId.getBillId();
        HashSet<Long> billIds = allTableBillIds.get(mainTableId);
        if (billIds == null) {
            billIds = new HashSet();
            allTableBillIds.put(mainTableId, billIds);
        }
        if (!billIds.contains(billId)) {
            billIds.add(billId);
        }
    }

    public boolean isLookDown() {
        String lookupType = (String)this.getView().getFormShowParameter().getCustomParam("lookuptype");
        return StringUtils.isBlank((CharSequence)lookupType) || "lookdown".equals(lookupType);
    }

    public boolean isLookUp() {
        String lookupType = (String)this.getView().getFormShowParameter().getCustomParam("lookuptype");
        return StringUtils.isBlank((CharSequence)lookupType) || "lookup".equals(lookupType);
    }

    private boolean isLookAll() {
        String lookupType = (String)this.getView().getFormShowParameter().getCustomParam("lookuptype");
        return StringUtils.isBlank((CharSequence)lookupType) || "lookall".equals(lookupType);
    }

    public List<BFRowLinkUpNode> getLinkUpNodes() {
        String json = (String)this.getView().getFormShowParameter().getCustomParam("linknodes");
        if (StringUtils.isBlank((CharSequence)json)) {
            return new ArrayList<BFRowLinkUpNode>();
        }
        List nodes = (List)SerializationUtils.deSerializeFromBase64((String)json);
        return nodes;
    }

    public List<BFRowLinkDownNode> getLinkDownNodes() {
        String json = (String)this.getView().getFormShowParameter().getCustomParam("linknodes");
        if (StringUtils.isBlank((CharSequence)json)) {
            return new ArrayList<BFRowLinkDownNode>();
        }
        List nodes = (List)SerializationUtils.deSerializeFromBase64((String)json);
        return nodes;
    }

    private List<CtBotpLinkBill> getCtBotpLinkBills() {
        String json = (String)this.getView().getFormShowParameter().getCustomParam("ctbotplinknodes");
        if (StringUtils.isBlank((CharSequence)json)) {
            return new ArrayList<CtBotpLinkBill>();
        }
        List ctBotpLinkBills = (List)SerializationUtils.deSerializeFromBase64((String)json);
        return ctBotpLinkBills;
    }

    private Map<String, List<CtBotpLinkBill>> getCtBotpLinkMaps() {
        HashMap<String, List<CtBotpLinkBill>> ctBotpLinkMaps;
        block6: {
            List<CtBotpLinkBill> ctBotpLinkBills;
            block5: {
                ctBotpLinkBills = this.getCtBotpLinkBills();
                if (ctBotpLinkBills == null || ctBotpLinkBills.size() == 0) {
                    return null;
                }
                ctBotpLinkMaps = new HashMap<String, List<CtBotpLinkBill>>(16);
                if (!this.isLookUp()) break block5;
                for (CtBotpLinkBill ctBotpLinkBill : ctBotpLinkBills) {
                    ArrayList<CtBotpLinkBill> ctBotpLinkBillList;
                    String key = ctBotpLinkBill.getsTenantCode() + ctBotpLinkBill.getsAccountId() + ctBotpLinkBill.getsEntityKey();
                    if (ctBotpLinkMaps.containsKey(key)) {
                        ctBotpLinkBillList = (ArrayList<CtBotpLinkBill>)ctBotpLinkMaps.get(key);
                        ctBotpLinkBillList.add(ctBotpLinkBill);
                        continue;
                    }
                    ctBotpLinkBillList = new ArrayList<CtBotpLinkBill>(16);
                    ctBotpLinkBillList.add(ctBotpLinkBill);
                    ctBotpLinkMaps.put(key, ctBotpLinkBillList);
                }
                break block6;
            }
            if (!this.isLookDown()) break block6;
            for (CtBotpLinkBill ctBotpLinkBill : ctBotpLinkBills) {
                ArrayList<CtBotpLinkBill> ctBotpLinkBillList;
                String key = ctBotpLinkBill.gettTenantCode() + ctBotpLinkBill.gettAccountId() + ctBotpLinkBill.gettEntityKey();
                if (ctBotpLinkMaps.containsKey(key)) {
                    ctBotpLinkBillList = (ArrayList<CtBotpLinkBill>)ctBotpLinkMaps.get(key);
                    ctBotpLinkBillList.add(ctBotpLinkBill);
                    continue;
                }
                ctBotpLinkBillList = new ArrayList<CtBotpLinkBill>(16);
                ctBotpLinkBillList.add(ctBotpLinkBill);
                ctBotpLinkMaps.put(key, ctBotpLinkBillList);
            }
        }
        return ctBotpLinkMaps;
    }

    private List<BFRow> getAllBFRows() {
        String json = (String)this.getView().getFormShowParameter().getCustomParam("linknodes");
        if (StringUtils.isBlank((CharSequence)json)) {
            return new ArrayList<BFRow>();
        }
        List nodes = (List)SerializationUtils.deSerializeFromBase64((String)json);
        return nodes;
    }

    private TableDefine loadMainTableDefine(String entityNumber) {
        TableDefine tableDefine = this.mainTableDefines.get(entityNumber);
        if (tableDefine == null && (tableDefine = ConvertMetaServiceHelper.loadTableDefine((String)entityNumber, (String)entityNumber)) != null) {
            this.mainTableDefines.put(entityNumber, tableDefine);
        }
        return tableDefine;
    }

    private TableDefine loadTableDefine(Long tableId) {
        TableDefine tableDefine = this.tableDefines.get(tableId);
        if (tableDefine == null && (tableDefine = ConvertMetaServiceHelper.loadTableDefine((Long)tableId)) != null) {
            this.tableDefines.put(tableId, tableDefine);
        }
        return tableDefine;
    }

    private String getPageId(String entityNumber) {
        Map<String, String> pageIds = this.getPageIds();
        return pageIds.get(entityNumber);
    }

    private void closePage(String entityNumber) {
        Map<String, String> pageIds = this.getPageIds();
        if (pageIds.containsKey(entityNumber)) {
            pageIds.remove(entityNumber);
        }
        if (pageIds.isEmpty()) {
            this.getView().close();
        } else {
            this.putPageIds(pageIds);
        }
    }

    public void putPageIds(Map<String, String> childPageIds) {
        this.getPageCache().put(CACHEKEY_PAGEIDS, SerializationUtils.toJsonString(childPageIds));
    }

    private Map<String, String> getPageIds() {
        String cacheValue = this.getPageCache().get(CACHEKEY_PAGEIDS);
        if (StringUtils.isBlank((CharSequence)cacheValue)) {
            return new HashMap<String, String>();
        }
        return (Map)SerializationUtils.fromJsonString((String)cacheValue, Map.class);
    }
}

