/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.botp;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.base.MobileBaseShowParameter;
import kd.bos.bill.MobileBillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.botp.LastBillRuleService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.ConvertBill;
import kd.bos.entity.botp.ConvertOpType;
import kd.bos.entity.botp.LastBillRuleRecord;
import kd.bos.entity.botp.runtime.AbstractConvertServiceArgs;
import kd.bos.entity.botp.runtime.ConvertOpParameter;
import kd.bos.entity.botp.runtime.ConvertOpRule;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.GetTargetOptionalOrgsArgs;
import kd.bos.entity.botp.runtime.GetTargetOptionalOrgsResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.botp.Push;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.plugin.botp.ConvertOpFormEditAbstract;
import kd.bos.form.plugin.botp.ConvertOpFormEditForThird;
import kd.bos.form.plugin.botp.layout.BotpLayoutManager;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;

public class MobConvertOpFormEdit
extends ConvertOpFormEditAbstract {
    private static final String BOS_FORM_BUSINESS = "bos-botp-formplugin";
    private static final String KEY_FRULE = "frule";
    private static final String KEY_FRELATIONORG = "frelationorg";
    private static final String KEY_SHOWREPORT = "showreport";
    private static final String KEY_OUTFORMULA = "outformula";
    private static final String KEY_OK = "btnok";
    private static final String ALLRULE = "@all";
    private static final String KEY_ACTIONID = "mobConvertOpFormEdit_actionId";
    private BotpLayoutManager botpLayoutManager = new BotpLayoutManager();
    private LastBillRuleService lastBillRuleService = new LastBillRuleService();
    private static final Log logger = LogFactory.getLog(MobConvertOpFormEdit.class);

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{KEY_OK});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.fillBillCombo();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (this.getConvertOpParamter().getOpType().compareTo((Enum)ConvertOpType.Push) != 0) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_SHOWREPORT, KEY_OUTFORMULA});
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control srcCtrl = (Control)evt.getSource();
        if (KEY_OK.equalsIgnoreCase(srcCtrl.getKey())) {
            ConvertOpParameter opParameter = this.getConvertOpParamter();
            if (opParameter.getOpType() == ConvertOpType.Push) {
                this.doPush(opParameter);
            }
            String fldValue = this.botpLayoutManager.getBillItemValue(this.getModel(), "fbill");
            if (this.lastBillRuleService.isEnabled() && !ConvertOpFormEditForThird.isThirdConvertBill(fldValue)) {
                LastBillRuleRecord lastBillRuleRecord = this.lastBillRuleService.getLastBillRuleRecord(Long.valueOf(RequestContext.get().getCurrUserId()), opParameter.getEntityNumber(), opParameter.getOpType() == ConvertOpType.Push ? "push" : "draw");
                lastBillRuleRecord.setBill(fldValue);
                lastBillRuleRecord.setRule((String)this.getModel().getValue(KEY_FRULE));
                this.lastBillRuleService.addRecord(lastBillRuleRecord);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (e.getProperty().getName().equalsIgnoreCase("fbill") && this.botpLayoutManager.billItemValueChange(e)) {
            this.fillRuleCombo(null);
            this.fillOrgCombo(null);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if (StringUtils.equals((CharSequence)e.getActionId(), (CharSequence)KEY_ACTIONID)) {
            this.getView().close();
        }
    }

    private void doPush(ConvertOpParameter opParameter) {
        String targetEntityNumber = this.botpLayoutManager.getBillItemValue(this.getModel(), "fbill");
        String ruleId = (String)this.getModel().getValue(KEY_FRULE);
        String defOrgId = (String)this.getModel().getValue(KEY_FRELATIONORG);
        Boolean showReport = (Boolean)this.getModel().getValue(KEY_SHOWREPORT);
        PushArgs args = this.buildPushArgs(opParameter, ConvertOpFormEditForThird.getRealTargetEntityNumber(targetEntityNumber), ruleId, defOrgId);
        ConvertOpFormEditForThird convertOpFormEditForThird = new ConvertOpFormEditForThird((IFormPlugin)this);
        convertOpFormEditForThird.overWriteArgsByThirdPushArgs(args, targetEntityNumber, ruleId, defOrgId);
        if (args == null) {
            return;
        }
        Push.addPushByBillOption((IFormView)this.getView(), (AbstractConvertServiceArgs)args);
        logger.info("\u4e0b\u63a8\u53c2\u6570\uff1a" + SerializationUtils.toJsonString((Object)args));
        ConvertOperationResult result = ConvertServiceHelper.push((PushArgs)args);
        if (!result.isSuccess() || result.getCachePageIds().size() + result.getTargetBillIds().size() == 0) {
            Push.showReport((IFormView)this.getView(), (AbstractConvertServiceArgs)args, (ConvertOperationResult)result);
            return;
        }
        if (result.getCachePageIds().size() + result.getTargetBillIds().size() == 1) {
            MobileBillShowParameter showParameter = this.showTargetBillParameter(this.getView(), args, result, showReport);
            this.getView().showForm((FormShowParameter)showParameter);
            return;
        }
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        showParameter.setFormId("botp_mobile_convertresult");
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_ACTIONID));
        String resultJson = SerializationUtils.toJsonString((Object)result);
        this.getPageCache().put("ConvertOperationResult", resultJson);
        showParameter.getCustomParams().put("targetentitynumber", args.getTargetEntityNumber());
        showParameter.getCustomParams().put(KEY_SHOWREPORT, String.valueOf(showReport));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private PushArgs buildPushArgs(ConvertOpParameter opParameter, String targetEntityNumber, String ruleId, String defOrgId) {
        PushArgs args = new PushArgs();
        if (StringUtils.isNotBlank((CharSequence)opParameter.getAppId())) {
            args.setAppId(opParameter.getAppId());
        } else {
            args.setAppId(this.getView().getFormShowParameter().getCheckRightAppId());
        }
        args.setSourceEntityNumber(opParameter.getEntityNumber());
        args.setTargetEntityNumber(targetEntityNumber);
        args.setHasRight(opParameter.isHasRight());
        args.addCustomParam("botp_requiredatamutex", String.valueOf(true));
        args.setAutoSave(true);
        for (ConvertBill bill : opParameter.getBills()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)targetEntityNumber, (CharSequence)bill.getEntityNumber())) continue;
            for (ConvertOpRule rule : bill.getRules()) {
                args.getRuleIds().add(rule.getRuleId());
            }
        }
        if (!ALLRULE.equals(ruleId)) {
            args.setRuleId(ruleId);
        } else if (this.getConvertOpParamter().isMustSelectRule()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8f6c\u6362\u89c4\u5219\u3002", (String)"MobConvertOpFormEdit_0", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            return null;
        }
        if (!StringUtils.isBlank((CharSequence)defOrgId) && !StringUtils.equals((CharSequence)"0", (CharSequence)defOrgId)) {
            args.setDefOrgId(Long.valueOf(defOrgId));
        }
        args.setSelectedRows((List)opParameter.getSelectedRows());
        args.setBuildConvReport(true);
        args.getCustomParams().putAll(opParameter.getCustomParams());
        if (this.getModel().getProperty(KEY_OUTFORMULA) != null) {
            Boolean outFormula = (Boolean)this.getModel().getValue(KEY_OUTFORMULA);
            args.addCustomParam("botp_outformula", String.valueOf(outFormula));
        }
        return args;
    }

    private void fillBillCombo() {
        ConvertOpParameter opParameter = this.getConvertOpParamter();
        String recordBill = null;
        if (StringUtils.isBlank((CharSequence)opParameter.getDefTargetBill()) && StringUtils.isBlank((CharSequence)opParameter.getDefSourceBill()) && this.lastBillRuleService.isEnabled()) {
            LastBillRuleRecord record = this.lastBillRuleService.getLastBillRuleRecord(Long.valueOf(RequestContext.get().getCurrUserId()), opParameter.getEntityNumber(), opParameter.getOpType() == ConvertOpType.Push ? "push" : "draw");
            recordBill = StringUtils.isNotBlank((CharSequence)record.getBill()) ? record.getBill() : null;
        }
        ConvertBill defTargetBill = null;
        ArrayList<ComboItem> billItems = new ArrayList<ComboItem>(10);
        ComboItem blankItem = new ComboItem();
        blankItem.setValue("");
        blankItem.setCaption(new LocaleString());
        billItems.add(blankItem);
        HashMap<String, Integer> entityNameCounts = new HashMap<String, Integer>(opParameter.getBills().size());
        for (ConvertBill bill : opParameter.getBills()) {
            Integer count;
            if (StringUtils.isBlank((CharSequence)bill.getEntityName())) {
                bill.setEntityName(bill.getEntityNumber());
            }
            if ((count = (Integer)entityNameCounts.get(bill.getEntityName())) == null) {
                entityNameCounts.put(bill.getEntityName(), 1);
                continue;
            }
            entityNameCounts.put(bill.getEntityName(), count + 1);
        }
        for (ConvertBill bill : opParameter.getBills()) {
            ComboItem billItem = new ComboItem();
            billItem.setValue(bill.getEntityNumber());
            ConvertOpFormEditForThird.setComboItemValue(bill, billItem);
            String thirdCaption = ConvertOpFormEditForThird.getThirdCaption(opParameter.getBills(), bill);
            if (StringUtils.isBlank((CharSequence)bill.getEntityName())) {
                billItem.setCaption(new LocaleString(Lang.get().toString(), bill.getEntityNumber() + thirdCaption));
            } else if ((Integer)entityNameCounts.get(bill.getEntityName()) > 1) {
                billItem.setCaption(new LocaleString(Lang.get().toString(), bill.getEntityName() + " (" + bill.getEntityNumber() + ")" + thirdCaption));
            } else {
                billItem.setCaption(new LocaleString(Lang.get().toString(), bill.getEntityName() + thirdCaption));
            }
            billItems.add(billItem);
            if (StringUtils.equalsIgnoreCase((CharSequence)bill.getEntityNumber(), (CharSequence)opParameter.getDefTargetBill()) || StringUtils.equalsIgnoreCase((CharSequence)bill.getEntityNumber(), (CharSequence)opParameter.getDefSourceBill())) {
                defTargetBill = bill;
            }
            if (recordBill == null || !StringUtils.equalsIgnoreCase((CharSequence)bill.getEntityNumber(), (CharSequence)recordBill)) continue;
            defTargetBill = bill;
        }
        List<ComboItem> layoutComboItemList = this.botpLayoutManager.convertLayoutComboItemList(billItems, this.opParameter, false, this.getView());
        ComboEdit billEditor = (ComboEdit)this.getView().getControl("fbill");
        billEditor.setComboItems(layoutComboItemList);
        if (opParameter.getBills().size() > 0) {
            if (defTargetBill == null) {
                defTargetBill = (ConvertBill)opParameter.getBills().get(0);
            }
            this.botpLayoutManager.setDefaultBill(defTargetBill.getEntityNumber(), layoutComboItemList, this.getModel(), "fbill");
        }
        this.fillRuleCombo(defTargetBill);
        this.fillOrgCombo(defTargetBill);
    }

    private void fillRuleCombo(ConvertBill bill) {
        ConvertBill currBill = bill;
        if (currBill == null) {
            currBill = this.getCurrConvertBill();
        }
        boolean isPush = false;
        if (this.opParameter.getOpType() == ConvertOpType.Push || this.opParameter.getOpType() == ConvertOpType.SpecPush) {
            isPush = true;
        }
        ArrayList<Object> ruleItems = new ArrayList<Object>();
        String defRuleId = "";
        boolean isDefTargetBill = false;
        if (isPush && currBill != null) {
            ComboItem blankItem = new ComboItem();
            blankItem.setValue(ALLRULE);
            blankItem.setCaption(new LocaleString(ResManager.loadKDString((String)"\u81ea\u52a8\u5339\u914d\u89c4\u5219", (String)"MobConvertOpFormEdit_2", (String)BOS_FORM_BUSINESS, (Object[])new Object[0])));
            ruleItems.add(blankItem);
            if (currBill != null) {
                isDefTargetBill = StringUtils.equalsIgnoreCase((CharSequence)currBill.getEntityNumber(), (CharSequence)this.opParameter.getDefTargetBill());
            }
        }
        if (this.opParameter.getOpType() == ConvertOpType.Draw) {
            isDefTargetBill = StringUtils.equalsIgnoreCase((CharSequence)currBill.getEntityNumber(), (CharSequence)this.opParameter.getDefSourceBill());
        }
        if (currBill != null) {
            for (ConvertOpRule rule : currBill.getRules()) {
                if (!rule.isVisibled()) continue;
                ComboItem ruleItem = new ComboItem();
                ruleItem.setValue(rule.getRuleId());
                ruleItem.setCaption(new LocaleString(rule.getRuleName()));
                ruleItems.add(ruleItem);
                if (!isDefTargetBill || !StringUtils.equalsIgnoreCase((CharSequence)rule.getRuleId(), (CharSequence)this.opParameter.getDefRuleId())) continue;
                defRuleId = rule.getRuleId();
            }
        }
        ComboEdit billEditor = (ComboEdit)this.getView().getControl(KEY_FRULE);
        billEditor.setComboItems(ruleItems);
        if (ruleItems.size() == 0) {
            this.getModel().setValue(KEY_FRULE, (Object)"");
        } else {
            if (StringUtils.isBlank((CharSequence)defRuleId)) {
                defRuleId = ((ComboItem)ruleItems.get(0)).getValue();
                this.opParameter.setDefRuleIdPara("");
            }
            if (StringUtils.isBlank((CharSequence)this.opParameter.getDefRuleIdPara()) && this.lastBillRuleService.isEnabled()) {
                LastBillRuleRecord record = this.lastBillRuleService.getLastBillRuleRecord(Long.valueOf(RequestContext.get().getCurrUserId()), this.opParameter.getEntityNumber(), this.opParameter.getOpType() == ConvertOpType.Push ? "push" : "draw");
                String fbill = this.botpLayoutManager.getBillItemValue(this.getModel(), "fbill");
                this.getModel().setValue(KEY_FRULE, (Object)(StringUtils.isNotBlank((CharSequence)record.getRule()) && StringUtils.equalsIgnoreCase((CharSequence)fbill, (CharSequence)record.getBill()) ? record.getRule() : defRuleId));
            } else {
                this.getModel().setValue(KEY_FRULE, (Object)defRuleId);
            }
        }
    }

    private void fillOrgCombo(ConvertBill bill) {
        ConvertBill currBill = bill;
        if (currBill == null) {
            currBill = this.getCurrConvertBill();
        }
        if (currBill == null) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_FRELATIONORG});
            return;
        }
        ConvertOpParameter opParameter = this.getConvertOpParamter();
        ArrayList orgIds = new ArrayList();
        if (opParameter.getOpType() == ConvertOpType.Push) {
            String targetEntityNumber = currBill.getEntityNumber();
            String ruleId = (String)this.getModel().getValue(KEY_FRULE);
            GetTargetOptionalOrgsArgs args = new GetTargetOptionalOrgsArgs();
            args.setAppId(opParameter.getAppId());
            args.setSourceEntityNumber(opParameter.getEntityNumber());
            args.setTargetEntityNumber(targetEntityNumber);
            for (ConvertOpRule rule : currBill.getRules()) {
                args.getRuleIds().add(rule.getRuleId());
            }
            if (!ALLRULE.equals(ruleId)) {
                args.setRuleId(ruleId);
            }
            args.setSelectedRows((List)opParameter.getSelectedRows());
            ConvertOpFormEditForThird convertOpFormEditForThird = new ConvertOpFormEditForThird((IFormPlugin)this);
            convertOpFormEditForThird.setThirdPushOrgsArgs(args, currBill);
            GetTargetOptionalOrgsResult orgsResult = ConvertServiceHelper.getTargetOptionalOrgs((GetTargetOptionalOrgsArgs)args);
            if (!orgsResult.isSuccess() || !orgsResult.isHasMainOrg()) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_FRELATIONORG});
            } else if (!orgsResult.isShowTargetOrgCombo()) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_FRELATIONORG});
            } else {
                orgIds.addAll(orgsResult.getOrgIds());
            }
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_FRELATIONORG});
            return;
        }
        ArrayList<ComboItem> orgItems = new ArrayList<ComboItem>();
        ComboItem blankItem = new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u81ea\u52a8\u8ba1\u7b97", (String)"MobConvertOpFormEdit_3", (String)BOS_FORM_BUSINESS, (Object[])new Object[0])), "0");
        orgItems.add(blankItem);
        if (orgIds.isEmpty()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_FRELATIONORG});
        } else {
            Object[] arrOrgIds;
            this.getView().setVisible(Boolean.valueOf(true), new String[]{KEY_FRELATIONORG});
            if (orgIds.size() > 10) {
                arrOrgIds = new Object[10];
                for (int i = 0; i < 10; ++i) {
                    arrOrgIds[i] = orgIds.get(i);
                }
            } else {
                arrOrgIds = orgIds.toArray();
            }
            DynamicObjectType orgMainType = EntityMetadataCache.getSubDataEntityType((String)"bos_org", new ArrayList());
            Map orgs = BusinessDataServiceHelper.loadFromCache((Object[])arrOrgIds, (DynamicObjectType)orgMainType);
            for (Map.Entry orgItem : orgs.entrySet()) {
                ComboItem ruleItem = new ComboItem();
                ruleItem.setValue(orgItem.getKey().toString());
                ruleItem.setCaption(new LocaleString(((DynamicObject)orgItem.getValue()).get("name").toString()));
                orgItems.add(ruleItem);
            }
        }
        ComboEdit billEditor = (ComboEdit)this.getView().getControl(KEY_FRELATIONORG);
        billEditor.setComboItems(orgItems);
        if (orgItems.size() == 0) {
            this.getModel().setValue(KEY_FRELATIONORG, (Object)"");
        } else {
            this.getModel().setValue(KEY_FRELATIONORG, (Object)blankItem.getValue());
        }
    }

    private ConvertBill getCurrConvertBill() {
        ConvertBill currBill = null;
        ConvertOpParameter opParameter = this.getConvertOpParamter();
        String fldValue = this.botpLayoutManager.getBillItemValue(this.getModel(), "fbill");
        if (opParameter == null || StringUtils.isBlank((CharSequence)fldValue)) {
            return null;
        }
        for (ConvertBill convertBill : opParameter.getBills()) {
            if (StringUtils.equals((CharSequence)fldValue, (CharSequence)convertBill.getEntityNumber())) {
                currBill = convertBill;
                break;
            }
            if (!ConvertOpFormEditForThird.isCurrConvertBill(fldValue, convertBill)) continue;
            currBill = convertBill;
            break;
        }
        return currBill;
    }

    private ConvertOpParameter getConvertOpParamter() {
        if (this.opParameter == null) {
            String opParamJson = (String)this.getView().getFormShowParameter().getCustomParam("opparam");
            if (StringUtils.isNotBlank((CharSequence)opParamJson)) {
                this.opParameter = (ConvertOpParameter)SerializationUtils.fromJsonString((String)opParamJson, ConvertOpParameter.class);
            } else {
                this.opParameter = new ConvertOpParameter();
                this.opParameter.setOpType(ConvertOpType.Push);
            }
        }
        return this.opParameter;
    }

    public MobileBillShowParameter showTargetBillParameter(IFormView view, PushArgs pushArgs, ConvertOperationResult convertResult, boolean showReport) {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)pushArgs.getTargetEntityNumber());
        boolean isBasedata = mainType instanceof BasedataEntityType;
        Object mShowParameter = null;
        mShowParameter = isBasedata ? new MobileBaseShowParameter() : new MobileBillShowParameter();
        if (StringUtils.isNotBlank((CharSequence)convertResult.getTargetMobFormId())) {
            mShowParameter.setFormId(convertResult.getTargetMobFormId());
        } else {
            mShowParameter.setFormId(pushArgs.getTargetEntityNumber() + "_mob");
        }
        mShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        mShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_ACTIONID));
        if (convertResult.getTargetBillIds().isEmpty()) {
            mShowParameter.setStatus(OperationStatus.ADDNEW);
            mShowParameter.setCachePageId((String)convertResult.getCachePageIds().get(0));
        } else {
            mShowParameter.setStatus(OperationStatus.EDIT);
            mShowParameter.setPkId(convertResult.getTargetBillIds().iterator().next());
        }
        mShowParameter.setHasRight(true);
        mShowParameter.getCustomParams().put("isIgnoreLicense", true);
        mShowParameter.addCustPlugin("kd.bos.form.plugin.botp.MobConvertTrackerEdit");
        mShowParameter.getCustomParams().put(KEY_SHOWREPORT, String.valueOf(showReport));
        if (StringUtils.isNotBlank((CharSequence)pushArgs.getAppId())) {
            mShowParameter.getCustomParams().put("checkRightAppId", pushArgs.getAppId());
        }
        String resultJson = SerializationUtils.toJsonString((Object)convertResult);
        IPageCache pageCache = (IPageCache)view.getService(IPageCache.class);
        pageCache.put("ConvertOperationResult", resultJson);
        return mShowParameter;
    }
}

